/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class ORBBuildInfo {
    public static final String version = ORBBuildInfo.getBuildVersion();
    public static final String date = ORBBuildInfo.getBuildDate();
    public static final String developmentVersion = "DEV";
    private static Attributes _attr;
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";

    public static String sanitize(String string) {
        String string2 = "";
        String string3 = string;
        int n = string.lastIndexOf(" ");
        if (n >= 0) {
            string2 = string.substring(0, n + 1);
            string = string.substring(n + 1);
        }
        if (string.length() > 6 && string.charAt(2) == '.') {
            string3 = string.charAt(0) == '0' ? string2 + string.substring(1, 4) : string2 + string.substring(0, 4);
            string3 = string3 + "." + string.substring(4, 5) + " (" + string + ")";
        }
        return string3;
    }

    private static String getBuildVersion() {
        String string = ORBBuildInfo.getAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
        return string;
    }

    private static String getBuildDate() {
        String string = ORBBuildInfo.getAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes getAttributes() {
        if (_attr == null) {
            ClassLoader classLoader = ORBBuildInfo.class.getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
                URL uRL = uRLClassLoader.findResource(MANIFEST_FILE);
                if (uRL != null) {
                    InputStream inputStream = null;
                    try {
                        inputStream = uRL.openStream();
                        Manifest manifest = new Manifest(inputStream);
                        _attr = manifest.getMainAttributes();
                    }
                    catch (IOException iOException) {
                        System.out.println(iOException.toString());
                        iOException.printStackTrace(System.out);
                        System.exit(0);
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {
                                System.out.println(iOException.toString());
                                iOException.printStackTrace(System.out);
                            }
                        }
                    }
                    if (_attr == null) {
                        System.out.println("Cannot get attributes for " + uRL.toString());
                        System.exit(0);
                    }
                } else {
                    System.out.println("Cannot get manifest for " + uRL.toString());
                    System.exit(0);
                }
            } else {
                System.out.println("Classloader is not a URLClassLoader");
                System.exit(0);
            }
        }
        return _attr;
    }
}

