/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.handler;

import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imrutility.imr.EndpointProfile;
import org.jacorb.imrutility.imr.Repository;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Debug;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TRANSIENT;

public class IMRRequestHandler {
    private Repository rep;
    private final ORB orb;
    private final Logger logger = Debug.getNamedLogger("jacorb.imr");

    public IMRRequestHandler(ORB orb) {
        this.orb = orb;
    }

    public void handle_request(ServerRequest request) {
        EndpointProfile[] forwardEndpoints;
        byte[] objKey;
        block8: {
            String[] poaName = null;
            List pnames = null;
            String pname = null;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("IMRRequestHandler: handle_request for " + request.operation());
            }
            objKey = request.objectKey();
            if (this.rep == null) {
                this.rep = ((org.jacorb.orb.ORB)this.orb).getImR();
                if (this.rep == null) {
                    throw new TRANSIENT("Unable to locate ImR", 0, CompletionStatus.COMPLETED_NO);
                }
            }
            pname = POAUtil.extractPOAName(objKey);
            pnames = POAUtil.extractScopedPOANames(pname);
            poaName = new String[pnames.size()];
            pnames.toArray(poaName);
            String implName = POAUtil.extractImplName(objKey);
            forwardEndpoints = null;
            try {
                forwardEndpoints = this.rep.locate(implName, poaName);
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block8;
                this.logger.debug("Caught exception locating " + implName + '/' + pname, ex);
            }
        }
        if (forwardEndpoints != null && forwardEndpoints.length > 0) {
            request.setLocationForward(((org.jacorb.orb.ORB)this.orb).createIOR("IDL:omg.org/CORBA/Object:1.0", objKey, forwardEndpoints));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("IMRRequestHandler: Forwarding request.");
            }
        } else {
            request.setSystemException(new TRANSIENT("IMR unable to locate target object", 0, CompletionStatus.COMPLETED_NO));
        }
        request.reply();
    }
}

