/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jacorb.ir.gui.typesystem.AbstractContainer;
import org.jacorb.ir.gui.typesystem.NodeMapper;
import org.jacorb.ir.gui.typesystem.TypeAssociator;
import org.jacorb.ir.gui.typesystem.TypeSystem;
import org.jacorb.ir.gui.typesystem.TypeSystemNode;
import org.jacorb.ir.gui.typesystem.remote.RemoteTypeSystem;
import org.jacorb.util.Debug;

class IRBrowser
extends JFrame
implements WindowListener,
MouseListener,
ListSelectionListener,
TreeSelectionListener,
ActionListener {
    JTable contentTable;
    JSplitPane splitPane;
    JTree treeView;
    JTextArea textArea;
    TypeSystem typeSystem;
    TreeModel treeModel;
    JMenuItem followTypeMenu;
    private static final String title = "IRBrowser";

    public IRBrowser() {
        try {
            this.typeSystem = new RemoteTypeSystem();
        }
        catch (Exception e) {
            System.err.println("Caught exception starting browser");
            e.printStackTrace();
            System.exit(-1);
        }
        this.initialize();
    }

    public IRBrowser(String repositoryIOR) {
        try {
            this.typeSystem = new RemoteTypeSystem(repositoryIOR);
        }
        catch (Exception e) {
            System.err.println("Caught exception starting browser");
            e.printStackTrace();
            System.exit(-1);
        }
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        NodeMapper nodeMapper = (NodeMapper)this.contentTable.getModel().getValueAt(this.contentTable.getSelectedRow(), 0);
        TypeSystemNode typeSystemNode = nodeMapper.getNode();
        this.followTypeOf(typeSystemNode);
        System.out.println("following type of " + typeSystemNode);
    }

    private void conn0(WindowEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void followTypeOf(TypeSystemNode typeSystemNode) {
        TypeSystemNode assTypeNode;
        DefaultMutableTreeNode treeNode = null;
        if (typeSystemNode instanceof TypeAssociator && (assTypeNode = ((TypeAssociator)((Object)typeSystemNode)).getAssociatedTypeSystemNode()).getModelRepresentant(this.treeModel) != null) {
            treeNode = (DefaultMutableTreeNode)assTypeNode.getModelRepresentant(this.treeModel);
        }
        if (treeNode != null) {
            Debug.output(2, "expanding Tree: " + treeNode);
            DefaultTreeModel treeModel = (DefaultTreeModel)this.treeView.getModel();
            TreePath fullTreePath = new TreePath(treeModel.getPathToRoot(treeNode));
            this.treeView.scrollPathToVisible(fullTreePath);
            this.treeView.setSelectionPath(fullTreePath);
            this.treeView.validate();
        }
    }

    private void handleException(Throwable exception) {
        Debug.output(2, exception);
    }

    private void initConnections() {
        this.addWindowListener(this);
    }

    public void initialize() {
        this.setTitle(title);
        this.splitPane = new JSplitPane(1);
        DefaultTableModel tableModel = this.typeSystem.getTableModel(null);
        this.contentTable = new JTable(tableModel);
        this.contentTable.setAutoCreateColumnsFromModel(true);
        this.contentTable.setColumnSelectionAllowed(false);
        this.contentTable.setRowSelectionAllowed(true);
        this.contentTable.setCellSelectionEnabled(false);
        this.contentTable.removeEditor();
        this.contentTable.setShowGrid(false);
        this.contentTable.setTableHeader(new JTableHeader(this.contentTable.getColumnModel()));
        this.contentTable.setAutoResizeMode(4);
        this.contentTable.setMinimumSize(new Dimension(100, 100));
        this.contentTable.getSelectionModel().addListSelectionListener(this);
        this.treeModel = this.typeSystem.getTreeModel();
        this.treeView = new JTree(this.treeModel);
        this.treeView.setRootVisible(true);
        this.treeView.setShowsRootHandles(true);
        this.treeView.setMinimumSize(new Dimension(100, 100));
        this.treeView.addTreeSelectionListener(this);
        JScrollPane tableScrollPane = JTable.createScrollPaneForTable(this.contentTable);
        JScrollPane treeScrollPane = new JScrollPane(this.treeView);
        tableScrollPane.setMinimumSize(new Dimension(100, 100));
        treeScrollPane.setMinimumSize(new Dimension(100, 100));
        tableScrollPane.setPreferredSize(new Dimension(100, 100));
        treeScrollPane.setPreferredSize(new Dimension(100, 100));
        this.textArea = new JTextArea("Hallo, hallo!");
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("sansserif", 0, 10));
        this.textArea.setRows(4);
        this.textArea.setTabSize(15);
        this.textArea.setBorder(BorderFactory.createLoweredBevelBorder());
        this.textArea.setMinimumSize(new Dimension(100, 100));
        this.textArea.setPreferredSize(new Dimension(600, 90));
        this.splitPane.setLeftComponent(new JScrollPane(this.treeView));
        this.splitPane.setRightComponent(tableScrollPane);
        this.splitPane.setDividerLocation(300);
        Container contentPane = this.getContentPane();
        this.splitPane.setBounds(0, 0, 600, 400 - this.textArea.getPreferredSize().height);
        this.textArea.setBounds(0, this.splitPane.bounds().height, 600, this.textArea.getPreferredSize().height);
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", this.splitPane);
        contentPane.add("South", this.textArea);
        contentPane.setBackground(Color.white);
        this.resize(600, 400);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Navigate");
        menuBar.add(menu);
        this.followTypeMenu = new JMenuItem("Follow Type");
        this.followTypeMenu.setEnabled(false);
        this.followTypeMenu.addActionListener(this);
        menu.add(this.followTypeMenu);
        this.setJMenuBar(menuBar);
        this.validate();
        this.treeView.expandPath(new TreePath(((DefaultMutableTreeNode)this.treeModel.getRoot()).getPath()));
        this.treeView.addMouseListener(this);
        this.contentTable.addMouseListener(this);
        this.setName(title);
        this.setName(title);
        this.initConnections();
    }

    private static void usage() {
        System.out.println("Usage: IRBrowser [ -i ior_str | -f filename ]");
        System.out.println("    Note - if no arguments, will default to using resolve_initial_reference");
        System.exit(1);
    }

    public static void main(String[] args) {
        Window test = null;
        String ior = null;
        if (args.length == 1 || args.length > 2) {
            IRBrowser.usage();
        } else if (args.length == 2 && args[0].equals("-f")) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(args[1]));
                ior = in.readLine();
                while (ior.indexOf("IOR:") != 0) {
                    ior = in.readLine();
                }
                in.close();
            }
            catch (IOException io) {
                io.printStackTrace();
                IRBrowser.usage();
            }
            test = new IRBrowser(ior);
        } else {
            test = args.length == 2 && args[0].equals("-i") ? new IRBrowser(args[1]) : new IRBrowser();
        }
        test.show();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        DefaultMutableTreeNode treeNode = null;
        if (event.getComponent() == this.contentTable && event.getClickCount() > 1 && this.contentTable.getSelectedRow() != -1) {
            TypeSystemNode assTypeNode;
            System.out.println("contentTable doubleClick");
            NodeMapper nodeMapper = (NodeMapper)this.contentTable.getModel().getValueAt(this.contentTable.getSelectedRow(), 0);
            TypeSystemNode typeSystemNode = nodeMapper.getNode();
            if (typeSystemNode instanceof AbstractContainer) {
                treeNode = (DefaultMutableTreeNode)typeSystemNode.getModelRepresentant(this.treeModel);
            }
            if (typeSystemNode instanceof TypeAssociator && (assTypeNode = ((TypeAssociator)((Object)typeSystemNode)).getAssociatedTypeSystemNode()).getModelRepresentant(this.treeModel) != null) {
                treeNode = (DefaultMutableTreeNode)assTypeNode.getModelRepresentant(this.treeModel);
            }
            if (treeNode != null) {
                System.out.println("expanding Tree: " + treeNode);
                DefaultTreeModel treeModel = (DefaultTreeModel)this.treeView.getModel();
                TreePath fullTreePath = new TreePath(treeModel.getPathToRoot(treeNode));
                this.treeView.scrollPathToVisible(fullTreePath);
                this.treeView.setSelectionPath(fullTreePath);
                this.treeView.validate();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    public void setSelectedNode(TypeSystemNode node) {
        this.setTitle("IRBrowser - " + node.getAbsoluteName());
        this.textArea.setText(node.description());
        if (node instanceof TypeAssociator) {
            this.followTypeMenu.setEnabled(true);
        } else {
            this.followTypeMenu.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        NodeMapper nodeMapper;
        TypeSystemNode node;
        if (this.contentTable.getSelectedRow() != -1 && (node = (nodeMapper = (NodeMapper)this.contentTable.getModel().getValueAt(this.contentTable.getSelectedRow(), 0)).getNode()) != null) {
            this.setSelectedNode(node);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Debug.output(4, "IRBrowser: valueChanged (Tree...)");
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        TypeSystemNode node = (TypeSystemNode)treeNode.getUserObject();
        this.contentTable.setModel(this.typeSystem.getTableModel(treeNode));
        this.contentTable.clearSelection();
        TableColumnModel tabColMod = this.contentTable.getColumnModel();
        for (int i = 0; i < this.contentTable.getColumnCount(); ++i) {
            TableColumn tabCol = tabColMod.getColumn(i);
            tabCol.setCellEditor(null);
        }
        this.setSelectedNode(node);
        this.contentTable.validate();
        this.treeView.validate();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        System.exit(0);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.conn0(e);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

