/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.DataInputStream;
import org.jacorb.orb.EncapsInfo;
import org.jacorb.orb.IORMutator;
import org.jacorb.orb.ORB;
import org.jacorb.orb.TypeCode;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.typecode.DelegatingTypeCodeReader;
import org.jacorb.orb.typecode.TypeCodeCache;
import org.jacorb.orb.typecode.TypeCodeCacheFactory;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;

public class CDRInputStream
extends InputStream {
    private Stack encaps_stack;
    private Map tcMap;
    private SortedMap repeatedTCMap;
    private int marked_pos;
    private int marked_index;
    private boolean closed;
    private int codeSet = 65537;
    private int codeSetW = 65801;
    protected int giop_minor = 2;
    private Map valueMap;
    private int currentValueIndex;
    private Map repIdMap;
    private Map codebaseMap;
    public boolean littleEndian = false;
    protected byte[] buffer = null;
    protected int pos = 0;
    protected int index = 0;
    private boolean chunkedValue = false;
    private int valueNestingLevel = 0;
    private int chunk_end_pos = -1;
    private IORMutator mutator;
    private org.omg.CORBA.ORB orb = null;
    private static final int MAX_BLOCK_SIZE = 0x7FFFFF00;
    private boolean sunInteropFix = "on".equalsIgnoreCase(Environment.getProperty("jacorb.interop.sun"));
    private int typeCodeNestingLevel = -1;
    private final TypeCodeCache typeCodeCache = TypeCodeCacheFactory.getInstance();
    private static final DelegatingTypeCodeReader typeCodeReader = new DelegatingTypeCodeReader();

    public CDRInputStream(org.omg.CORBA.ORB orb, byte[] buf) {
        this.orb = orb;
        this.buffer = buf;
        if (Environment.isMutatorEnabled()) {
            this.mutator = Environment.getIORMutator();
        }
    }

    public CDRInputStream(org.omg.CORBA.ORB orb, byte[] buf, boolean littleEndian) {
        this(orb, buf);
        this.littleEndian = littleEndian;
    }

    private Stack getEncapsStack() {
        if (this.encaps_stack == null) {
            this.encaps_stack = new Stack();
        }
        return this.encaps_stack;
    }

    private Map getValueMap() {
        if (this.valueMap == null) {
            this.valueMap = new HashMap();
        }
        return this.valueMap;
    }

    private Map getRepIdMap() {
        if (this.repIdMap == null) {
            this.repIdMap = new HashMap();
        }
        return this.repIdMap;
    }

    private Map getCodebaseMap() {
        if (this.codebaseMap == null) {
            this.codebaseMap = new HashMap();
        }
        return this.codebaseMap;
    }

    public void setGIOPMinor(int giop_minor) {
        this.giop_minor = giop_minor;
    }

    public int getGIOPMinor() {
        return this.giop_minor;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        BufferManager.getInstance().returnBuffer(this.buffer);
        this.encaps_stack = null;
        this.closed = true;
    }

    @Override
    public org.omg.CORBA.ORB orb() {
        if (this.orb == null) {
            this.orb = org.omg.CORBA.ORB.init(new String[0], null);
        }
        return this.orb;
    }

    public void setCodeSet(int codeSet, int codeSetWide) {
        this.codeSet = codeSet;
        this.codeSetW = codeSetWide;
    }

    private static final int _read4int(boolean _littleEndian, byte[] _buffer, int _pos) {
        if (_littleEndian) {
            return ((_buffer[_pos + 3] & 0xFF) << 24) + ((_buffer[_pos + 2] & 0xFF) << 16) + ((_buffer[_pos + 1] & 0xFF) << 8) + ((_buffer[_pos] & 0xFF) << 0);
        }
        return ((_buffer[_pos] & 0xFF) << 24) + ((_buffer[_pos + 1] & 0xFF) << 16) + ((_buffer[_pos + 2] & 0xFF) << 8) + ((_buffer[_pos + 3] & 0xFF) << 0);
    }

    private static final short _read2int(boolean _littleEndian, byte[] _buffer, int _pos) {
        if (_littleEndian) {
            return (short)(((_buffer[_pos + 1] & 0xFF) << 8) + ((_buffer[_pos] & 0xFF) << 0));
        }
        return (short)(((_buffer[_pos] & 0xFF) << 8) + ((_buffer[_pos + 1] & 0xFF) << 0));
    }

    private final int _read_long() {
        int result = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return result;
    }

    private final long _read_longlong() {
        if (this.littleEndian) {
            return ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
        }
        return ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
    }

    private final void handle_chunking() {
        int aligned_pos;
        int remainder = 4 - this.index % 4;
        int n = aligned_pos = remainder != 4 ? this.pos + remainder : this.pos;
        if (this.chunk_end_pos >= this.pos && this.chunk_end_pos <= aligned_pos) {
            this.chunk_end_pos = -1;
            int saved_pos = this.pos;
            int saved_index = this.index;
            int tag = this.read_long();
            if (tag < 0) {
                if (-tag > this.valueNestingLevel) {
                    throw new INTERNAL("received end tag " + tag + " with value nesting level " + this.valueNestingLevel);
                }
                this.valueNestingLevel = -tag;
                --this.valueNestingLevel;
                if (this.valueNestingLevel > 0) {
                    this.chunk_end_pos = this.pos;
                    this.handle_chunking();
                }
            } else if (tag < 0x7FFFFF00) {
                this.chunk_end_pos = this.pos + tag;
            } else {
                this.pos = saved_pos;
                this.index = saved_index;
            }
        }
    }

    protected final void skip(int distance) {
        this.pos += distance;
        this.index += distance;
    }

    public final void closeEncapsulation() {
        if (this.encaps_stack == null) {
            throw new MARSHAL("Internal Error - closeEncapsulation failed");
        }
        EncapsInfo ei = (EncapsInfo)this.encaps_stack.pop();
        this.littleEndian = ei.littleEndian;
        int start = ei.start;
        int size = ei.size;
        if (this.pos < start + size) {
            this.pos = start + size;
        }
        this.index = ei.index + size;
    }

    public final int openEncapsulation() {
        boolean old_endian = this.littleEndian;
        int size = this.read_long();
        if (Environment.getCometInteropFix() && (size < 0 || size > this.buffer.length)) {
            int temp = (size >> 24 & 0xFF) + (size >> 8 & 0xFF00) + (size << 8 & 0xFF0000) + (size << 24 & 0xFF000000);
            if (Debug.isDebugEnabled()) {
                Debug.output("Size of CDR encapsulation larger than buffer, swapping byte order");
                Debug.output("Size of CDR encapsulation was " + size + ", is now " + temp);
            }
            size = temp;
        }
        this.getEncapsStack().push(new EncapsInfo(old_endian, this.index, this.pos, size));
        this.openEncapsulatedArray();
        return size;
    }

    public final void openEncapsulatedArray() {
        this.resetIndex();
        this.littleEndian = this.read_boolean();
    }

    public byte[] getBufferCopy() {
        byte[] result = new byte[this.buffer.length];
        System.arraycopy(this.buffer, 0, result, 0, this.buffer.length);
        return result;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed!");
        }
        if (this.available() < 1) {
            return -1;
        }
        ++this.index;
        return this.buffer[this.pos++];
    }

    @Override
    public int available() {
        return this.buffer.length - this.index;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new IOException("buffer may not be null");
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IOException("buffer index out of bounds");
        }
        if (len == 0) {
            return 0;
        }
        if (this.available() < 1) {
            return -1;
        }
        if (this.closed) {
            throw new IOException("Stream already closed!");
        }
        int min = Math.min(len, this.available());
        System.arraycopy(this.buffer, this.index, b, off, min);
        this.pos += min;
        this.index += min;
        return min;
    }

    @Override
    public final Any read_any() {
        org.omg.CORBA.TypeCode _tc = this.read_TypeCode();
        Any any = this.orb.create_any();
        any.read_value(this, _tc);
        return any;
    }

    @Override
    public final boolean read_boolean() {
        this.handle_chunking();
        ++this.index;
        byte bb = this.buffer[this.pos++];
        if (bb == 0) {
            return false;
        }
        if (bb == 1) {
            return true;
        }
        if (Environment.getLaxBooleanEncoding()) {
            return true;
        }
        throw new MARSHAL("Unexpected boolean value: " + bb + " pos: " + this.pos + " index: " + this.index);
    }

    @Override
    public final void read_boolean_array(boolean[] value, int offset, int length) {
        this.handle_chunking();
        for (int j = offset; j < offset + length; ++j) {
            byte bb;
            ++this.index;
            if ((bb = this.buffer[this.pos++]) == 0) {
                value[j] = false;
                continue;
            }
            if (bb == 1) {
                value[j] = true;
                continue;
            }
            if (Environment.getLaxBooleanEncoding()) {
                value[j] = true;
                continue;
            }
            throw new MARSHAL("Unexpected boolean value: " + bb + " pos: " + this.pos + " index: " + this.index);
        }
    }

    @Override
    public final char read_char() {
        this.handle_chunking();
        ++this.index;
        return (char)(this.buffer[this.pos++] & 0xFF);
    }

    @Override
    public final void read_char_array(char[] value, int offset, int length) {
        if (value == null) {
            throw new MARSHAL("Cannot marshall result into null array.");
        }
        if (offset + length > value.length || length < 0 || offset < 0) {
            throw new MARSHAL("Cannot marshall as indices for array are out bounds.");
        }
        this.handle_chunking();
        if (Environment.getCodeSetsActive() && Environment.getMultibyteCharArray()) {
            int size = length;
            int i = this.pos;
            for (int lengthCount = 0; lengthCount < length && i < this.buffer.length; ++i, ++lengthCount) {
                short b = (short)(0xFF & this.buffer[i]);
                if ((b & 0x80) == 0) continue;
                if ((b & 0xF8) == 192) {
                    ++size;
                    ++i;
                    continue;
                }
                if ((b & 0xF8) == 224) {
                    size += 2;
                    i += 2;
                    continue;
                }
                throw new DATA_CONVERSION("Unknown length indicator when extracting char_array " + b);
            }
            char[] result = CodeSet.getBTCConverter(this.codeSet).convert(this.buffer, this.pos, size);
            for (int i2 = 0; i2 < length; ++i2) {
                value[i2 + offset] = result[i2];
            }
            this.index += length;
            this.pos += length;
        } else {
            for (int j = offset; j < offset + length; ++j) {
                ++this.index;
                value[j] = (char)(0xFF & this.buffer[this.pos++]);
            }
        }
    }

    @Override
    public final double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    @Override
    public final void read_double_array(double[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 8 - this.index % 8;
        if (remainder != 8) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j = offset; j < offset + length; ++j) {
            value[j] = Double.longBitsToDouble(this._read_longlong());
        }
    }

    @Override
    public final BigDecimal read_fixed() {
        this.handle_chunking();
        StringBuffer sb = new StringBuffer();
        byte b = this.buffer[this.pos++];
        int c = b & 0xF;
        ++this.index;
        while (true) {
            c = (b & 0xF0) >>> 4;
            sb.append(c);
            c = b & 0xF;
            if (c == 12 || c == 13) break;
            sb.append(c);
            b = this.buffer[this.pos++];
            ++this.index;
        }
        BigDecimal result = new BigDecimal(new BigInteger(sb.toString()));
        if (c == 13) {
            return result.negate();
        }
        return result;
    }

    @Override
    public final float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    @Override
    public final void read_float_array(float[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j = offset; j < offset + length; ++j) {
            value[j] = Float.intBitsToFloat(this._read_long());
        }
    }

    @Override
    public final int read_long() {
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        int result = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return result;
    }

    @Override
    public final void read_long_array(int[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j = offset; j < offset + length; ++j) {
            value[j] = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.pos += 4;
        }
        this.index += 4 * length;
    }

    @Override
    public final long read_longlong() {
        this.handle_chunking();
        int remainder = 8 - this.index % 8;
        if (remainder != 8) {
            this.index += remainder;
            this.pos += remainder;
        }
        return this._read_longlong();
    }

    @Override
    public final void read_longlong_array(long[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 8 - this.index % 8;
        if (remainder != 8) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (this.littleEndian) {
            for (int j = offset; j < offset + length; ++j) {
                value[j] = ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
            }
        } else {
            for (int j = offset; j < offset + length; ++j) {
                value[j] = ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
            }
        }
    }

    @Override
    public final Object read_Object() {
        if (!(this.orb instanceof ORB)) {
            throw new MARSHAL("Cannot use the singleton ORB to receive object references, please initialize a full ORB instead.");
        }
        this.handle_chunking();
        IOR ior = IORHelper.read(this);
        if (Environment.isMutatorEnabled()) {
            ior = this.mutator.mutateIncoming(ior);
        }
        if (ior.type_id.equals("") && ior.profiles.length == 0) {
            return null;
        }
        return ((ORB)this.orb)._getObject(ior);
    }

    @Override
    public Object read_Object(Class clz) {
        if (ObjectImpl.class.isAssignableFrom(clz)) {
            Object obj = this.read_Object();
            if (obj instanceof ObjectImpl) {
                ObjectImpl stub = null;
                try {
                    stub = (ObjectImpl)clz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new MARSHAL("Exception in stub instantiation: " + e);
                }
                catch (IllegalAccessException e) {
                    throw new MARSHAL("Exception in stub instantiation: " + e);
                }
                stub._set_delegate(((ObjectImpl)obj)._get_delegate());
                return stub;
            }
            return obj;
        }
        if (clz.isInterface() && ValueHandler.assignableFrom(clz)) {
            return (Object)ValueHandler.portableRemoteObject_narrow(this.read_Object(), clz);
        }
        return this.read_Object();
    }

    @Override
    public final byte read_octet() {
        this.handle_chunking();
        ++this.index;
        return this.buffer[this.pos++];
    }

    @Override
    public final void read_octet_array(byte[] value, int offset, int length) {
        this.handle_chunking();
        System.arraycopy(this.buffer, this.pos, value, offset, length);
        this.index += length;
        this.pos += length;
    }

    @Override
    public final Principal read_Principal() {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    @Override
    public final short read_short() {
        this.handle_chunking();
        int remainder = 2 - this.index % 2;
        if (remainder != 2) {
            this.index += remainder;
            this.pos += remainder;
        }
        short result = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
        this.pos += 2;
        this.index += 2;
        return result;
    }

    @Override
    public final void read_short_array(short[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 2 - this.index % 2;
        if (remainder != 2) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j = offset; j < offset + length; ++j) {
            value[j] = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
            this.pos += 2;
        }
        this.index += length * 2;
    }

    @Override
    public final String read_string() {
        String result = null;
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        int size = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        if (size == 0) {
            throw new MARSHAL("invalid string size " + size);
        }
        if (size == 1) {
            result = "";
        } else {
            if (this.pos + size - 1 > this.buffer.length) {
                if (Debug.isDebugEnabled()) {
                    Debug.output("Size (" + size + ") invalid for string extraction from buffer length of " + this.buffer.length + " from position " + this.pos);
                }
                throw new MARSHAL("Invalid size for string extraction");
            }
            int substring = this.buffer[this.pos + size - 1] == 0 ? size - 1 : size;
            if (Environment.getCodeSetsActive()) {
                result = new String(CodeSet.getBTCConverter(this.codeSet).convert(this.buffer, this.pos, substring));
            } else {
                char[] buf = new char[substring];
                for (int i = 0; i < substring; ++i) {
                    buf[i] = (char)(0xFF & this.buffer[this.pos + i]);
                }
                result = new String(buf, 0, substring);
            }
        }
        this.index += size;
        this.pos += size;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final org.omg.CORBA.TypeCode read_TypeCode() {
        if (this.tcMap == null) {
            this.tcMap = new HashMap();
        }
        if (this.repeatedTCMap == null) {
            this.repeatedTCMap = new TreeMap();
        }
        try {
            org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(this.tcMap, this.repeatedTCMap);
            return typeCode;
        }
        finally {
            this.repeatedTCMap.clear();
            this.tcMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final org.omg.CORBA.TypeCode read_TypeCode(Map recursiveTCMap, Map repeatedTCMap) {
        ++this.typeCodeNestingLevel;
        try {
            org.omg.CORBA.TypeCode typeCode = typeCodeReader.readTypeCode(this, recursiveTCMap, repeatedTCMap);
            return typeCode;
        }
        finally {
            --this.typeCodeNestingLevel;
        }
    }

    @Override
    public final int read_ulong() {
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        int result = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return result;
    }

    @Override
    public final void read_ulong_array(int[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j = offset; j < offset + length; ++j) {
            value[j] = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.pos += 4;
        }
        this.index += 4 * length;
    }

    @Override
    public final long read_ulonglong() {
        this.handle_chunking();
        int remainder = 8 - this.index % 8;
        if (remainder != 8) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (this.littleEndian) {
            return ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
        }
        return ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
    }

    @Override
    public final void read_ulonglong_array(long[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 8 - this.index % 8;
        if (remainder != 8) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (this.littleEndian) {
            for (int j = offset; j < offset + length; ++j) {
                value[j] = ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
            }
        } else {
            for (int j = offset; j < offset + length; ++j) {
                value[j] = ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
            }
        }
    }

    @Override
    public final short read_ushort() {
        this.handle_chunking();
        int remainder = 2 - this.index % 2;
        if (remainder != 2) {
            this.index += remainder;
            this.pos += remainder;
        }
        short result = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
        this.pos += 2;
        this.index += 2;
        return result;
    }

    @Override
    public final void read_ushort_array(short[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 2 - this.index % 2;
        if (remainder != 2) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j = offset; j < offset + length; ++j) {
            value[j] = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
            this.pos += 2;
        }
        this.index += length * 2;
    }

    @Override
    public final char read_wchar() {
        if (this.giop_minor == 0) {
            int minor = Messages.getMsgType(this.buffer) == 1 ? 6 : 5;
            throw new MARSHAL("GIOP 1.0 does not support the type wchar", minor, CompletionStatus.COMPLETED_NO);
        }
        this.handle_chunking();
        if (this.giop_minor == 2) {
            this.read_wchar_size();
            boolean wchar_little_endian = this.readBOM();
            return this.read_wchar(wchar_little_endian);
        }
        return this.read_wchar(this.littleEndian);
    }

    private final int read_wchar_size() {
        ++this.index;
        return this.buffer[this.pos++];
    }

    private final char read_wchar(boolean wchar_little_endian) {
        switch (this.codeSetW) {
            case 0x5010001: {
                if (this.giop_minor < 2) {
                    throw new MARSHAL("GIOP 1." + this.giop_minor + " only allows 2 Byte encodings for wchar, but the selected TCSW is UTF-8");
                }
                short b = (short)(0xFF & this.buffer[this.pos++]);
                ++this.index;
                if ((b & 0x80) == 0) {
                    return (char)b;
                }
                if ((b & 0xE0) == 192) {
                    ++this.index;
                    return (char)((b & 0x1F) << 6 | (short)this.buffer[this.pos++] & 0x3F);
                }
                this.index += 2;
                short b2 = (short)(0xFF & this.buffer[this.pos++]);
                return (char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | (short)this.buffer[this.pos++] & 0x3F);
            }
            case 65801: {
                char c = wchar_little_endian ? (char)(this.buffer[this.pos++] & 0xFF | this.buffer[this.pos++] << 8) : (char)(this.buffer[this.pos++] << 8 | this.buffer[this.pos++] & 0xFF);
                this.index += 2;
                return c;
            }
        }
        throw new MARSHAL("Bad CodeSet: " + this.codeSetW);
    }

    private final boolean readBOM() {
        if (this.buffer[this.pos] == -2 && this.buffer[this.pos + 1] == -1) {
            this.pos += 2;
            this.index += 2;
            return false;
        }
        if (this.buffer[this.pos] == -1 && this.buffer[this.pos + 1] == -2) {
            this.pos += 2;
            this.index += 2;
            return true;
        }
        return false;
    }

    @Override
    public final void read_wchar_array(char[] value, int offset, int length) {
        this.handle_chunking();
        for (int j = offset; j < offset + length; ++j) {
            value[j] = this.read_wchar();
        }
    }

    @Override
    public final String read_wstring() {
        if (this.giop_minor == 0) {
            int minor = Messages.getMsgType(this.buffer) == 1 ? 6 : 5;
            throw new MARSHAL("GIOP 1.0 does not support the IDL type wstring", minor, CompletionStatus.COMPLETED_NO);
        }
        String result = null;
        char[] buf = null;
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (this.giop_minor == 2) {
            int size = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.index += 4;
            this.pos += 4;
            if (size == 0) {
                return "";
            }
            buf = new char[size];
            int i = 0;
            int endPos = this.pos + size;
            boolean wchar_litte_endian = this.readBOM();
            while (this.pos < endPos) {
                buf[i++] = this.read_wchar(wchar_litte_endian);
            }
            result = new String(buf, 0, i);
        } else {
            int size = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.index += 4;
            this.pos += 4;
            buf = new char[size];
            int endPos = this.pos + size;
            if (this.codeSetW == 65801) {
                endPos += size;
            }
            int i = 0;
            while (this.pos < endPos) {
                buf[i++] = this.read_wchar(this.littleEndian);
            }
            result = i != 0 && buf[i - 1] == '\u0000' ? new String(buf, 0, i - 1) : new String(buf, 0, i);
        }
        buf = null;
        return result;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        this.marked_pos = this.pos;
        this.marked_index = this.index;
    }

    @Override
    public void reset() throws IOException {
        if (this.pos < 0) {
            throw new MARSHAL("Mark has not been set!");
        }
        this.pos = this.marked_pos;
        this.index = this.marked_index;
    }

    private final void resetIndex() {
        this.index = 0;
    }

    public final void setLittleEndian(boolean b) {
        this.littleEndian = b;
    }

    final void read_value(org.omg.CORBA.TypeCode tc, org.omg.CORBA.portable.OutputStream out) {
        if (tc == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        int kind = tc.kind().value();
        try {
            switch (kind) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    out.write_short(this.read_short());
                    break;
                }
                case 3: {
                    out.write_long(this.read_long());
                    break;
                }
                case 4: {
                    out.write_ushort(this.read_ushort());
                    break;
                }
                case 5: {
                    out.write_ulong(this.read_ulong());
                    break;
                }
                case 6: {
                    out.write_float(this.read_float());
                    break;
                }
                case 7: {
                    out.write_double(this.read_double());
                    break;
                }
                case 8: {
                    out.write_boolean(this.read_boolean());
                    break;
                }
                case 9: {
                    out.write_char(this.read_char());
                    break;
                }
                case 10: {
                    out.write_octet(this.read_octet());
                    break;
                }
                case 11: {
                    out.write_any(this.read_any());
                    break;
                }
                case 12: {
                    out.write_TypeCode(this.read_TypeCode());
                    break;
                }
                case 13: {
                    throw new NO_IMPLEMENT("Principal deprecated");
                }
                case 14: {
                    out.write_Object(this.read_Object());
                    break;
                }
                case 15: {
                    for (int i = 0; i < tc.member_count(); ++i) {
                        this.read_value(tc.member_type(i), out);
                    }
                    break;
                }
                case 16: {
                    org.omg.CORBA.TypeCode disc = tc.discriminator_type();
                    disc = TypeCode.originalType(disc);
                    int def_idx = tc.default_index();
                    int member_idx = -1;
                    block32 : switch (disc.kind().value()) {
                        case 2: {
                            short s = this.read_short();
                            out.write_short(s);
                            for (int i = 0; i < tc.member_count(); ++i) {
                                if (i == def_idx || s != tc.member_label(i).extract_short()) continue;
                                member_idx = i;
                                break block32;
                            }
                            break;
                        }
                        case 3: {
                            int s = this.read_long();
                            out.write_long(s);
                            for (int i = 0; i < tc.member_count(); ++i) {
                                if (i == def_idx || s != tc.member_label(i).extract_long()) continue;
                                member_idx = i;
                                break block32;
                            }
                            break;
                        }
                        case 4: {
                            short s = this.read_ushort();
                            out.write_ushort(s);
                            for (int i = 0; i < tc.member_count(); ++i) {
                                if (i == def_idx || s != tc.member_label(i).extract_ushort()) continue;
                                member_idx = i;
                                break block32;
                            }
                            break;
                        }
                        case 5: {
                            int s = this.read_ulong();
                            out.write_ulong(s);
                            for (int i = 0; i < tc.member_count(); ++i) {
                                if (i == def_idx || s != tc.member_label(i).extract_ulong()) continue;
                                member_idx = i;
                                break block32;
                            }
                            break;
                        }
                        case 6: 
                        case 7: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                        case 8: {
                            boolean b = this.read_boolean();
                            out.write_boolean(b);
                            for (int i = 0; i < tc.member_count(); ++i) {
                                if (i == def_idx || b != tc.member_label(i).extract_boolean()) continue;
                                member_idx = i;
                                break block32;
                            }
                            break;
                        }
                        case 9: {
                            char s = this.read_char();
                            out.write_char(s);
                            for (int i = 0; i < tc.member_count(); ++i) {
                                if (i == def_idx || s != tc.member_label(i).extract_char()) continue;
                                member_idx = i;
                                break block32;
                            }
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                        case 17: {
                            int s = this.read_long();
                            out.write_long(s);
                            for (int i = 0; i < tc.member_count(); ++i) {
                                int label;
                                if (i == def_idx || s != (label = tc.member_label(i).create_input_stream().read_long())) continue;
                                member_idx = i;
                                break block32;
                            }
                            break;
                        }
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                        case 23: {
                            long s = this.read_longlong();
                            out.write_longlong(s);
                            for (int i = 0; i < tc.member_count(); ++i) {
                                if (i == def_idx || s != tc.member_label(i).extract_longlong()) continue;
                                member_idx = i;
                                break block32;
                            }
                            break;
                        }
                        case 24: {
                            long s = this.read_ulonglong();
                            out.write_ulonglong(s);
                            for (int i = 0; i < tc.member_count(); ++i) {
                                if (i == def_idx || s != tc.member_label(i).extract_ulonglong()) continue;
                                member_idx = i;
                                break block32;
                            }
                            break;
                        }
                        default: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                    }
                    if (member_idx != -1) {
                        this.read_value(tc.member_type(member_idx), out);
                        break;
                    }
                    if (def_idx != -1) {
                        this.read_value(tc.member_type(def_idx), out);
                    }
                    break;
                }
                case 17: {
                    out.write_long(this.read_long());
                    break;
                }
                case 18: {
                    out.write_string(this.read_string());
                    break;
                }
                case 19: {
                    int len = this.read_long();
                    out.write_long(len);
                    for (int i = 0; i < len; ++i) {
                        this.read_value(tc.content_type(), out);
                    }
                    break;
                }
                case 20: {
                    int length = tc.length();
                    for (int i = 0; i < length; ++i) {
                        this.read_value(tc.content_type(), out);
                    }
                    break;
                }
                case 21: {
                    this.read_value(tc.content_type(), out);
                    break;
                }
                case 22: {
                    out.write_string(this.read_string());
                    for (int i = 0; i < tc.member_count(); ++i) {
                        this.read_value(tc.member_type(i), out);
                    }
                    break;
                }
                case 23: {
                    out.write_longlong(this.read_longlong());
                    break;
                }
                case 24: {
                    out.write_ulonglong(this.read_ulonglong());
                    break;
                }
                case 25: {
                    throw new BAD_TYPECODE("type longdouble not supported in java");
                }
                case 26: {
                    out.write_wchar(this.read_wchar());
                    break;
                }
                case 27: {
                    out.write_wstring(this.read_wstring());
                    break;
                }
                case 28: {
                    out.write_fixed(this.read_fixed());
                    break;
                }
                case 29: 
                case 30: {
                    String id = tc.id();
                    BoxedValueHelper helper = RepositoryID.getBoxedValueHelper(id);
                    if (helper == null) {
                        throw new MARSHAL("No BoxedValueHelper for id " + id);
                    }
                    Serializable value = this.read_value(helper);
                    ((OutputStream)out).write_value(value, helper);
                    break;
                }
                default: {
                    throw new MARSHAL("Cannot handle TypeCode with kind " + kind);
                }
            }
        }
        catch (BadKind ex) {
            throw new MARSHAL("When processing TypeCode with kind: " + kind + " caught " + ex);
        }
        catch (Bounds ex) {
            throw new MARSHAL("When processing TypeCode with kind: " + kind + " caught " + ex);
        }
    }

    @Override
    public Serializable read_value() {
        int tag = this.read_long();
        int start_offset = this.pos - 4;
        if (tag == -1) {
            return this.read_indirect_value();
        }
        if (tag == 0) {
            return null;
        }
        String codebase = (tag & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (tag & 8) != 0;
        int theTag = tag;
        if ((tag &= 0xFFFFFFF6) == 0x7FFFFF00) {
            throw new MARSHAL("missing value type information");
        }
        if (tag == 2147483394) {
            return this.read_typed_value(start_offset, codebase);
        }
        if (tag == 2147483398) {
            return this.read_multi_typed_value(start_offset, codebase);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(theTag) + " (offset=0x" + Integer.toHexString(start_offset) + ")");
    }

    @Override
    public Serializable read_value(String rep_id) {
        int tag = this.read_long();
        int start_offset = this.pos - 4;
        if (tag == -1) {
            return this.read_indirect_value();
        }
        if (tag == 0) {
            return null;
        }
        String codebase = (tag & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (tag & 8) != 0;
        int theTag = tag;
        if ((tag &= 0xFFFFFFF6) == 0x7FFFFF00) {
            return this.read_untyped_value(new String[]{rep_id}, start_offset, codebase);
        }
        if (tag == 2147483394) {
            return this.read_typed_value(start_offset, codebase);
        }
        if (tag == 2147483398) {
            return this.read_multi_typed_value(start_offset, codebase);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(theTag) + " (offset=0x" + Integer.toHexString(start_offset) + ")");
    }

    @Override
    public Serializable read_value(Serializable value) {
        if (value instanceof Streamable) {
            this.register_value(value);
            ((Streamable)((java.lang.Object)value))._read(this);
        } else if (value instanceof CustomValue) {
            this.register_value(value);
            ((CustomValue)value).unmarshal(new DataInputStream(this));
        } else {
            throw new BAD_PARAM("read_value is only implemented for Streamables");
        }
        return value;
    }

    @Override
    public Serializable read_value(Class clz) {
        int tag = this.read_long();
        int start_offset = this.pos - 4;
        if (tag == -1) {
            return this.read_indirect_value();
        }
        if (tag == 0) {
            return null;
        }
        String codebase = (tag & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (tag & 8) != 0;
        int theTag = tag;
        if ((tag &= 0xFFFFFFF6) == 0x7FFFFF00) {
            return this.read_untyped_value(new String[]{ValueHandler.getRMIRepositoryID(clz)}, start_offset, codebase);
        }
        if (tag == 2147483394) {
            return this.read_typed_value(start_offset, codebase);
        }
        if (tag == 2147483398) {
            return this.read_multi_typed_value(start_offset, codebase);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(theTag) + " (offset=0x" + Integer.toHexString(start_offset) + ")");
    }

    @Override
    public Serializable read_value(BoxedValueHelper factory) {
        int tag = this.read_long();
        int start_offset = this.pos - 4;
        if (tag == -1) {
            return this.read_indirect_value();
        }
        if (tag == 0) {
            return null;
        }
        String codebase = (tag & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (tag & 8) != 0;
        int theTag = tag;
        if ((tag &= 0xFFFFFFF6) == 0x7FFFFF00) {
            Serializable result = factory.read_value(this);
            if (result != null) {
                this.getValueMap().put(new Integer(start_offset), result);
            }
            return result;
        }
        if (tag == 2147483394) {
            Serializable result = this.read_typed_value(start_offset, codebase, factory);
            if (result != null) {
                this.getValueMap().put(new Integer(start_offset), result);
            }
            return result;
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(theTag) + " (offset=0x" + Integer.toHexString(start_offset) + ")");
    }

    private Serializable read_untyped_value(String[] repository_ids, int index, String codebase) {
        java.lang.Object result = null;
        if (this.chunkedValue || this.valueNestingLevel > 0) {
            ++this.valueNestingLevel;
            int chunk_size_tag = this.readChunkSizeTag();
            this.chunk_end_pos = this.pos + chunk_size_tag;
        }
        for (int r = 0; r < repository_ids.length; ++r) {
            if (repository_ids[r].equals("IDL:omg.org/CORBA/WStringValue:1.0")) {
                result = this.read_wstring();
                break;
            }
            if (repository_ids[r].startsWith("IDL:")) {
                ValueFactory factory = ((org.omg.CORBA_2_3.ORB)this.orb()).lookup_value_factory(repository_ids[r]);
                if (factory != null) {
                    this.currentValueIndex = index;
                    result = factory.read_value(this);
                    break;
                }
                if (r < repository_ids.length - 1) continue;
                throw new MARSHAL("No factory found for: " + repository_ids[0]);
            }
            String className = RepositoryID.className(repository_ids[r]);
            Class c = null;
            ClassLoader ctxcl = Thread.currentThread().getContextClassLoader();
            try {
                if (ctxcl != null) {
                    try {
                        c = ctxcl.loadClass(className);
                    }
                    catch (ClassNotFoundException cnfe) {
                        c = ValueHandler.loadClass(className, codebase, null);
                    }
                } else {
                    c = ValueHandler.loadClass(className, codebase, null);
                }
                if (IDLEntity.class.isAssignableFrom(c)) {
                    Method readMethod = null;
                    if (c != Any.class) {
                        String helperClassName = c.getName() + "Helper";
                        try {
                            ClassLoader cl = c.getClassLoader();
                            Class<?> helperClass = null;
                            helperClass = cl != null ? cl.loadClass(helperClassName) : Class.forName(helperClassName);
                            Class[] paramTypes = new Class[]{org.omg.CORBA.portable.InputStream.class};
                            readMethod = helperClass.getMethod("read", paramTypes);
                        }
                        catch (ClassNotFoundException e) {
                            throw new MARSHAL("Error loading class " + helperClassName + ": " + e);
                        }
                        catch (NoSuchMethodException e) {
                            throw new MARSHAL("No read method in helper class " + helperClassName + ": " + e);
                        }
                    }
                    if (readMethod == null) {
                        result = this.read_any();
                        continue;
                    }
                    try {
                        result = (Serializable)readMethod.invoke(null, this);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new MARSHAL("Internal error: " + e);
                    }
                    catch (InvocationTargetException e) {
                        throw new MARSHAL("Exception unmarshaling IDLEntity: " + e.getTargetException());
                    }
                }
                result = ValueHandler.readValue(this, index, c, repository_ids[r], null);
                continue;
            }
            catch (ClassNotFoundException e) {
                if (r < repository_ids.length - 1) continue;
                throw new MARSHAL("class not found: " + className);
            }
        }
        if (result != null) {
            this.getValueMap().put(new Integer(index), result);
        }
        return result;
    }

    private int readChunkSizeTag() {
        int savedPos = this.pos;
        int savedIndex = this.index;
        int chunk_size_tag = this.read_long();
        if (!this.sunInteropFix || chunk_size_tag > 0 && chunk_size_tag < 0x7FFFFF00) {
            return chunk_size_tag;
        }
        this.pos = savedPos;
        this.index = savedIndex;
        return 0x7FFFFF00;
    }

    private Serializable read_typed_value(int index, String codebase) {
        return this.read_untyped_value(new String[]{this.read_repository_id()}, index, codebase);
    }

    private Serializable read_typed_value(int index, String codebase, BoxedValueHelper factory) {
        String repId = this.read_repository_id();
        if (!factory.get_id().equals(repId)) {
            throw new MARSHAL("unexpected RepositoryID. expected: " + factory.get_id() + " got: " + repId);
        }
        return factory.read_value(this);
    }

    private Serializable read_multi_typed_value(int index, String codebase) {
        int id_count = this.read_long();
        String[] ids = new String[id_count];
        for (int i = 0; i < id_count; ++i) {
            ids[i] = this.read_repository_id();
        }
        return this.read_untyped_value(ids, index, codebase);
    }

    private String read_repository_id() {
        int tag = this.read_long();
        if (tag == -1) {
            int index = this.read_long();
            index = index + this.pos - 4;
            String repId = (String)this.getRepIdMap().get(new Integer(index));
            if (repId == null) {
                throw new MARSHAL("stale RepositoryID indirection");
            }
            return repId;
        }
        this.pos -= 4;
        this.index -= 4;
        int start_offset = this.pos;
        String repId = this.read_string();
        this.getRepIdMap().put(new Integer(start_offset), repId);
        return repId;
    }

    private String read_codebase() {
        int tag = this.read_long();
        if (tag == -1) {
            int index = this.read_long();
            index = index + this.pos - 4;
            String codebase = (String)this.getCodebaseMap().get(new Integer(index));
            if (codebase == null) {
                throw new MARSHAL("stale codebase indirection");
            }
            return codebase;
        }
        this.pos -= 4;
        this.index -= 4;
        int start_offset = this.pos;
        String codebase = this.read_string();
        this.getCodebaseMap().put(new Integer(start_offset), codebase);
        return codebase;
    }

    private Serializable read_indirect_value() {
        int index = this.read_long();
        index = index + this.pos - 4;
        java.lang.Object value = this.getValueMap().get(new Integer(index));
        if (value == null) {
            throw new IndirectionException(index);
        }
        return (Serializable)value;
    }

    @Override
    public java.lang.Object read_abstract_interface() {
        return this.read_boolean() ? this.read_Object() : this.read_value();
    }

    @Override
    public java.lang.Object read_abstract_interface(Class clz) {
        return this.read_boolean() ? this.read_Object(clz) : this.read_value(clz);
    }

    public int get_pos() {
        return this.pos;
    }

    public void register_value(Serializable value) {
        this.getValueMap().put(new Integer(this.currentValueIndex), value);
    }

    public void updateMutatorConnection(GIOPConnection connection) {
        if (Environment.isMutatorEnabled()) {
            this.mutator.updateConnection(connection.getTransport());
        }
    }

    public org.omg.CORBA.TypeCode readTypeCodeCache(String repositoryID, Integer startPosition) {
        TypeCodeCache.Pair[] result = this.typeCodeCache.getCachedTypeCodes(repositoryID);
        if (result == null) {
            return null;
        }
        if (result.length == 0) {
            return null;
        }
        for (int i = 0; i < result.length; ++i) {
            Integer position = new Integer(startPosition + result[i].position);
            this.repeatedTCMap.put(position, result[i].typeCode);
        }
        return result[0].typeCode;
    }

    public void updateTypeCodeCache(String repositoryID, Integer startPosition, int size) {
        Integer from = new Integer(startPosition);
        Integer to = new Integer(startPosition + size);
        SortedMap sortedMap = this.repeatedTCMap.subMap(from, to);
        ArrayList<TypeCodeCache.Pair> toBeCached = new ArrayList<TypeCodeCache.Pair>();
        for (Integer key : sortedMap.keySet()) {
            TypeCode value = (TypeCode)sortedMap.get(key);
            Integer offset = new Integer(key - startPosition);
            toBeCached.add(new TypeCodeCache.Pair(value, offset));
        }
        this.typeCodeCache.cacheTypeCode(repositoryID, toBeCached.toArray(new TypeCodeCache.Pair[toBeCached.size()]));
    }

    public void skipRemainingTypeCode(Integer startPosition, int size) {
        this.skip(size - (this.pos - startPosition - 4 - 4));
    }

    public String getIndentString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.typeCodeNestingLevel; ++i) {
            buffer.append("    ");
        }
        return buffer.toString();
    }

    public Logger getLogger() {
        return Debug.getNamedLogger("jacorb.orb.cdr");
    }
}

