/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.poa.Current;
import org.jacorb.util.Debug;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.PortableServer.CurrentHelper;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.portable.Delegate;

public class ServantDelegate
implements Delegate {
    private transient org.omg.CORBA.ORB orb = null;
    private transient Repository ir = null;
    private transient org.omg.PortableServer.Current _current = null;
    private transient POA poa = null;
    private static Logger logger = Debug.getNamedLogger("jacorb.orb.servantdelegate");

    ServantDelegate(ORB orb) {
        this.orb = orb;
    }

    private final void check() {
        if (this.orb == null) {
            throw new BAD_INV_ORDER("The Servant has not been associated with an ORB instance");
        }
    }

    @Override
    public final Object this_object(Servant self) {
        this.check();
        try {
            this.poa = this.poa(self);
        }
        catch (OBJ_ADAPTER e) {
            this.poa = self._default_POA();
        }
        if (this.poa == null) {
            throw new OBJ_ADAPTER("null value returned by  _default_POA() on Servant " + self);
        }
        try {
            return this.poa.servant_to_reference(self);
        }
        catch (ServantNotActive e) {
            throw new OBJ_ADAPTER(e.toString());
        }
        catch (WrongPolicy e) {
            throw new OBJ_ADAPTER(e.toString());
        }
    }

    @Override
    public final org.omg.CORBA.ORB orb(Servant self) {
        this.check();
        return this.orb;
    }

    @Override
    public final POA poa(Servant self) {
        this.check();
        if (this._current == null) {
            this._getPOACurrent();
        }
        try {
            if (((Current)this._current).get_servant() != self) {
                throw new OBJ_ADAPTER();
            }
            return this._current.get_POA();
        }
        catch (NoContext e) {
            throw new OBJ_ADAPTER(e.toString());
        }
    }

    @Override
    public final byte[] object_id(Servant self) {
        this.check();
        if (this._current == null) {
            this._getPOACurrent();
        }
        try {
            return this._current.get_object_id();
        }
        catch (NoContext e) {
            throw new OBJ_ADAPTER(e.toString());
        }
    }

    private synchronized void _getPOACurrent() {
        if (this._current == null) {
            try {
                this._current = CurrentHelper.narrow(this.orb.resolve_initial_references("POACurrent"));
            }
            catch (Exception e) {
                throw new INITIALIZE(e.toString());
            }
        }
    }

    @Override
    public POA default_POA(Servant self) {
        this.check();
        try {
            return POAHelper.narrow(this.orb(self).resolve_initial_references("RootPOA"));
        }
        catch (InvalidName e) {
            throw new INITIALIZE(e.toString());
        }
    }

    @Override
    public boolean non_existent(Servant self) {
        this.check();
        if (logger.isInfoEnabled()) {
            logger.info("ServantDelegate: non_existent: return false");
        }
        return false;
    }

    @Override
    public Object get_interface_def(Servant self) {
        this.check();
        if (this.ir == null) {
            try {
                this.ir = RepositoryHelper.narrow(this.orb.resolve_initial_references("InterfaceRepository"));
            }
            catch (Exception e) {
                throw new INITIALIZE(e.toString());
            }
        }
        return this.ir.lookup_id(((ObjectImpl)self._this_object())._ids()[0]);
    }

    @Override
    public InterfaceDef get_interface(Servant self) {
        return InterfaceDefHelper.narrow(this.get_interface_def(self));
    }

    @Override
    public boolean is_a(Servant self, String repid) {
        if (logger.isDebugEnabled()) {
            logger.debug("ServantDelegate: is a " + repid + " ?");
        }
        String[] intf = self._all_interfaces(this.poa(self), this.object_id(self));
        for (int i = 0; i < intf.length; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug("ServantDelegate: is a compares with " + intf[i]);
            }
            if (!intf[i].equals(repid)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("ServantDelegate: ! is a " + intf[i] + "!");
            }
            return true;
        }
        return repid.equals("IDL:omg.org/CORBA/Object:1.0");
    }

    public Policy _get_policy(Object self, int policy_type) {
        return null;
    }

    public DomainManager[] _get_domain_managers(Object self) {
        return null;
    }

    public OutputStream _invoke(Servant self, String method, InputStream _input, ResponseHandler handler) throws SystemException {
        OutputStream _out = null;
        if (method.equals("_get_policy")) {
            _out = handler.createReply();
            _out.write_Object(this._get_policy(_input.read_Object(), _input.read_long()));
        } else if (method.equals("_is_a")) {
            _out = handler.createReply();
            _out.write_boolean(self._is_a(_input.read_string()));
        } else if (method.equals("_interface")) {
            _out = handler.createReply();
            _out.write_Object(self._get_interface());
        } else if (method.equals("_non_existent")) {
            _out = handler.createReply();
            _out.write_boolean(self._non_existent());
        } else {
            throw new BAD_PARAM("Unknown operation: " + method);
        }
        return _out;
    }
}

