/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.dns;

import java.lang.reflect.Method;
import java.net.InetAddress;
import org.jacorb.orb.dns.DNSLookupDelegate;
import org.jacorb.orb.dns.JdkDelegateImpl;
import org.jacorb.util.Environment;

public class DNSLookup {
    private static DNSLookupDelegate delegate = null;
    private static boolean enabled = false;

    private static void createDelegate() {
        if (DNSLookup.jdk_DNS_Usable()) {
            delegate = new JdkDelegateImpl();
        } else {
            try {
                Class c = Environment.classForName("org.xbill.DNS.dns");
                c = Environment.classForName("org.jacorb.orb.dns.XbillDelegateImpl");
                delegate = (DNSLookupDelegate)c.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean jdk_DNS_Usable() {
        try {
            Method m = InetAddress.class.getMethod("getCanonicalHostName", new Class[0]);
            return m != null;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    public static String inverseLookup(String ip) {
        return delegate == null ? null : delegate.inverseLookup(ip);
    }

    public static String inverseLookup(InetAddress addr) {
        return delegate == null ? null : delegate.inverseLookup(addr);
    }

    static {
        enabled = Environment.getDnsEnable();
        if (enabled) {
            DNSLookup.createDelegate();
        }
    }
}

