/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.util.Debug;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.GIOP.ReplyStatusType_1_2;

public class NoBiDirClientRequestListener
implements RequestListener {
    @Override
    public void requestReceived(byte[] request, GIOPConnection connection) {
        Debug.output(1, "WARNING: Received a request on a non-bidir connection");
        connection.incPendingMessages();
        this.replyException(request, connection);
    }

    @Override
    public void locateRequestReceived(byte[] request, GIOPConnection connection) {
        Debug.output(1, "WARNING: Received a locate request on a non-bidir connection");
        connection.incPendingMessages();
        this.replyException(request, connection);
    }

    @Override
    public void cancelRequestReceived(byte[] request, GIOPConnection connection) {
        Debug.output(1, "WARNING: Received a cancel request on a non-bidir connection");
        connection.incPendingMessages();
        this.replyException(request, connection);
    }

    private void replyException(byte[] request, GIOPConnection connection) {
        int giop_minor = Messages.getGIOPMinor(request);
        ReplyOutputStream out = new ReplyOutputStream(Messages.getRequestId(request), ReplyStatusType_1_2.SYSTEM_EXCEPTION, giop_minor, false);
        SystemExceptionHelper.write(out, new INV_POLICY(0, CompletionStatus.COMPLETED_NO));
        try {
            connection.sendReply(out);
        }
        catch (IOException e) {
            Debug.output(1, e);
        }
    }
}

