/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ImRReadyProfile;
import org.jacorb.orb.TaggedComponentList;
import org.omg.ETF._ProfileLocalBase;
import org.omg.GIOP.Version;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;

public abstract class ProfileBase
extends _ProfileLocalBase
implements ImRReadyProfile,
Cloneable {
    protected TaggedComponentList components = null;
    protected Version version = null;
    protected byte[] objectKey = null;

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public void set_object_key(byte[] key) {
        this.objectKey = key;
    }

    @Override
    public byte[] get_object_key() {
        return this.objectKey;
    }

    @Override
    public void marshal(TaggedProfileHolder tagged_profile, TaggedComponentSeqHolder components) {
        CDROutputStream profileDataStream = new CDROutputStream();
        profileDataStream.beginEncapsulatedArray();
        byte[] addressProfile = this.getAddressProfile();
        profileDataStream.write_octet_array(addressProfile, 0, addressProfile.length);
        profileDataStream.write_long(this.objectKey.length);
        profileDataStream.write_octet_array(this.objectKey, 0, this.objectKey.length);
        switch (this.version.minor) {
            case 0: {
                break;
            }
            default: {
                int i;
                if (components == null) {
                    components = new TaggedComponentSeqHolder(new TaggedComponent[0]);
                }
                profileDataStream.write_long(this.components.size() + components.value.length);
                for (i = 0; i < this.components.asArray().length; ++i) {
                    TaggedComponentHelper.write(profileDataStream, this.components.asArray()[i]);
                }
                for (i = 0; i < components.value.length; ++i) {
                    TaggedComponentHelper.write(profileDataStream, components.value[i]);
                }
            }
        }
        tagged_profile.value = new TaggedProfile(this.tag(), profileDataStream.getBufferCopy());
    }

    @Override
    public short encapsulation() {
        return 0;
    }

    @Override
    public TaggedComponentList getComponents() {
        return this.components;
    }

    public Object getComponent(int tag, Class helper) {
        return this.components.getComponent(tag, helper);
    }

    public void addComponent(int tag, Object data, Class helper) {
        this.components.addComponent(tag, data, helper);
    }

    public void addComponent(int tag, byte[] data) {
        this.components.addComponent(tag, data);
    }

    public TaggedProfile asTaggedProfile() {
        TaggedProfileHolder result = new TaggedProfileHolder();
        this.marshal(result, null);
        return result.value;
    }

    public Object clone() throws CloneNotSupportedException {
        ProfileBase result = (ProfileBase)super.clone();
        result.version = new Version(this.version.major, this.version.minor);
        if (this.objectKey != null) {
            result.objectKey = new byte[this.objectKey.length];
            System.arraycopy(this.objectKey, 0, result.objectKey, 0, this.objectKey.length);
        }
        if (this.components != null) {
            result.components = (TaggedComponentList)this.components.clone();
        }
        return result;
    }

    @Override
    public int hash() {
        return this.hashCode();
    }
}

