/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.util.LinkedList;
import java.util.List;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.giop.ProfileBase;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.ETF.Profile;
import org.omg.GIOP.Version;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.VersionHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class IIOPProfile
extends ProfileBase {
    private static final List EMPTY_LIST = new LinkedList();
    private IIOPAddress primaryAddress = null;
    private List alternateAddresses = null;
    private SSL ssl = null;
    private boolean sslSet = false;

    public IIOPProfile(byte[] data) {
        CDRInputStream in = new CDRInputStream(null, data);
        in.openEncapsulatedArray();
        org.omg.IIOP.Version iiopVersion = VersionHelper.read(in);
        this.version = new Version(iiopVersion.major, iiopVersion.minor);
        this.primaryAddress = IIOPAddress.read(in);
        int length = in.read_ulong();
        if (in.available() < length) {
            throw new MARSHAL("Unable to extract object key. Only " + in.available() + " available and trying to assign " + length);
        }
        this.objectKey = new byte[length];
        in.read_octet_array(this.objectKey, 0, length);
        this.components = this.version.minor > 0 ? new TaggedComponentList(in) : new TaggedComponentList();
    }

    public IIOPProfile(IIOPAddress address, byte[] objectKey) {
        this.version = new Version(1, 2);
        this.primaryAddress = address;
        this.objectKey = objectKey;
        this.components = new TaggedComponentList();
        this.alternateAddresses = EMPTY_LIST;
    }

    public IIOPProfile(IIOPAddress address, byte[] objectKey, int minor) {
        this.version = new Version(1, (byte)minor);
        this.primaryAddress = address;
        this.objectKey = objectKey;
        this.components = new TaggedComponentList();
        this.alternateAddresses = EMPTY_LIST;
    }

    public IIOPProfile(String corbaloc) {
        this.version = null;
        this.primaryAddress = null;
        this.objectKey = null;
        this.components = null;
        try {
            this.decode_corbaloc(corbaloc);
        }
        catch (Exception e) {
            Debug.output(1, "could not create new IIOPProfile");
            Debug.output(3, e);
        }
        this.alternateAddresses = EMPTY_LIST;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decode_corbaloc(String addr) {
        String host = "127.0.0.1";
        int port = 2809;
        int major = 1;
        int minor = 0;
        String errorstr = "Illegal IIOP protocol format in object address format: " + addr;
        int sep = addr.indexOf(58);
        String protocol_identifier = "";
        if (sep != 0) {
            protocol_identifier = addr.substring(0, sep);
        }
        if (sep + 1 == addr.length()) {
            throw new IllegalArgumentException(errorstr);
        }
        if ((sep = (addr = addr.substring(sep + 1)).indexOf(64)) > -1) {
            String ver_str = addr.substring(0, sep);
            addr = addr.substring(sep + 1);
            sep = ver_str.indexOf(46);
            if (sep != -1) {
                try {
                    major = Integer.parseInt(ver_str.substring(0, sep));
                    minor = Integer.parseInt(ver_str.substring(sep + 1));
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(errorstr);
                }
            }
        }
        this.version = new Version((byte)major, (byte)minor);
        int ipv6SeperatorStart = -1;
        int ipv6SeperatorEnd = -1;
        ipv6SeperatorStart = addr.indexOf(91);
        if (ipv6SeperatorStart != -1 && (ipv6SeperatorEnd = addr.indexOf(93)) == -1) {
            throw new IllegalArgumentException(errorstr);
        }
        sep = addr.indexOf(58);
        if (sep != -1) {
            if (ipv6SeperatorStart != -1) {
                host = addr.substring(ipv6SeperatorStart + 1, ipv6SeperatorEnd);
                if (addr.charAt(ipv6SeperatorEnd + 1) != ':') throw new IllegalArgumentException(errorstr);
                port = (short)Integer.parseInt(addr.substring(ipv6SeperatorEnd + 2));
            } else {
                try {
                    port = (short)Integer.parseInt(addr.substring(sep + 1));
                    host = addr.substring(0, sep);
                }
                catch (NumberFormatException ill) {
                    throw new IllegalArgumentException(errorstr);
                }
            }
        }
        this.primaryAddress = new IIOPAddress(host, port);
        this.decode_extensions(protocol_identifier.toLowerCase());
    }

    private void decode_extensions(String ident) {
        this.components = new TaggedComponentList();
        if (ident.equals("ssliop")) {
            this.ssl = new SSL();
            this.ssl.port = (short)this.primaryAddress.getPort();
            String propname = "jacorb.security.ssl.corbaloc_ssliop.supported_options";
            this.ssl.target_supports = this.get_ssl_options(propname);
            propname = "jacorb.security.ssl.corbaloc_ssliop.required_options";
            this.ssl.target_requires = this.get_ssl_options(propname);
            CDROutputStream out = new CDROutputStream();
            out.beginEncapsulatedArray();
            SSLHelper.write(out, this.ssl);
            this.components.addComponent(new TaggedComponent(20, out.getBufferCopy()));
        }
    }

    private short get_ssl_options(String propname) {
        String option_str = Environment.getProperty(propname);
        short value = 32;
        if (option_str != null && !option_str.equals("")) {
            try {
                value = (short)Integer.parseInt(option_str, 16);
            }
            catch (NumberFormatException nfe) {
                Debug.output(0, "WARNING: Invalid hex property >>" + option_str + "<<");
                Debug.output(0, "Please check property \"" + propname + "\"");
            }
        }
        return value;
    }

    @Override
    public void marshal(TaggedProfileHolder tagged_profile, TaggedComponentSeqHolder components) {
        TaggedComponent[] allComponents = null;
        CDROutputStream profileDataStream = null;
        if (components == null) {
            components = new TaggedComponentSeqHolder(new TaggedComponent[0]);
        }
        switch (this.version.minor) {
            case 1: 
            case 2: {
                allComponents = new TaggedComponent[this.components.size() + components.value.length];
                System.arraycopy(this.components.asArray(), 0, allComponents, 0, this.components.size());
                System.arraycopy(components.value, 0, allComponents, this.components.size(), components.value.length);
                ProfileBody_1_1 pb1 = new ProfileBody_1_1(new org.omg.IIOP.Version(this.version.major, this.version.minor), Environment.getDnsEnable() ? this.primaryAddress.getHostname() : this.primaryAddress.getIP(), (short)this.primaryAddress.getPort(), this.objectKey, allComponents);
                profileDataStream = new CDROutputStream();
                profileDataStream.beginEncapsulatedArray();
                ProfileBody_1_1Helper.write(profileDataStream, pb1);
                tagged_profile.value = new TaggedProfile(0, profileDataStream.getBufferCopy());
                break;
            }
            case 0: {
                ProfileBody_1_0 pb0 = new ProfileBody_1_0(new org.omg.IIOP.Version(this.version.major, this.version.minor), Environment.getDnsEnable() ? this.primaryAddress.getHostname() : this.primaryAddress.getIP(), (short)this.primaryAddress.getPort(), this.objectKey);
                profileDataStream = new CDROutputStream();
                profileDataStream.beginEncapsulatedArray();
                ProfileBody_1_0Helper.write(profileDataStream, pb0);
                tagged_profile.value = new TaggedProfile(0, profileDataStream.getBufferCopy());
                break;
            }
            default: {
                throw new INTERNAL("Unknown GIOP version tag (" + this.version.minor + ") when marshalling for IIOPProfile");
            }
        }
        profileDataStream.close();
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    @Override
    public Profile copy() {
        try {
            return (Profile)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("error cloning profile: " + e);
        }
    }

    @Override
    public boolean is_match(Profile prof) {
        if (prof != null && prof instanceof IIOPProfile) {
            IIOPProfile other = (IIOPProfile)prof;
            return this.getSSLPort() == other.getSSLPort() && this.primaryAddress.equals(other.primaryAddress) && ((Object)this.getAlternateAddresses()).equals(other.getAlternateAddresses());
        }
        return false;
    }

    @Override
    public int tag() {
        return 0;
    }

    @Override
    public byte[] getAddressProfile() {
        CDROutputStream addressProfileStream = new CDROutputStream();
        addressProfileStream.beginEncapsulatedArray();
        org.omg.GIOP.VersionHelper.write(addressProfileStream, this.version);
        addressProfileStream.write_string(Environment.getDnsEnable() ? this.primaryAddress.getHostname() : this.primaryAddress.getIP());
        addressProfileStream.write_ushort((short)this.primaryAddress.getPort());
        return addressProfileStream.getBufferCopy();
    }

    public IIOPAddress getAddress() {
        return this.primaryAddress;
    }

    public void patchPrimaryAddress(String newHost, int newPort) {
        if (newHost != null) {
            this.primaryAddress = new IIOPAddress(newHost, newPort != -1 ? newPort : this.primaryAddress.getPort());
        } else if (newPort != -1) {
            this.primaryAddress = new IIOPAddress(this.primaryAddress.getIP(), newPort);
        }
    }

    public List getAlternateAddresses() {
        if (this.alternateAddresses == null) {
            this.alternateAddresses = this.components.getComponents(3, IIOPAddress.class);
        }
        return this.alternateAddresses;
    }

    public SSL getSSL() {
        if (!this.sslSet) {
            this.ssl = (SSL)this.components.getComponent(20, SSLHelper.class);
            this.sslSet = true;
        }
        return this.ssl;
    }

    public int getSSLPort() {
        if (!this.sslSet) {
            this.getSSL();
        }
        if (this.ssl == null) {
            return -1;
        }
        int port = this.ssl.port;
        if (port < 0) {
            port += 65536;
        }
        return port;
    }

    public IIOPProfile to_GIOP_1_0() {
        IIOPProfile result = new IIOPProfile(this.primaryAddress, this.objectKey);
        result.version.minor = 0;
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof Profile) {
            return this.is_match((Profile)other);
        }
        return false;
    }

    public int hashCode() {
        return this.primaryAddress.hashCode();
    }

    public String toString() {
        return this.primaryAddress.toString();
    }
}

