/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.concurrent.LinkedBlockingQueue;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.RequestAnalyserProcessor;
import org.jacorb.poa.RequestProcessor;
import org.jacorb.util.Environment;

public class SingleThreadRequestAnalyserProcessor
extends RequestAnalyserProcessor {
    private static final Object END = new Object();
    protected LinkedBlockingQueue tpcQueue = new LinkedBlockingQueue();
    protected TPCThread tpct = new TPCThread();

    public SingleThreadRequestAnalyserProcessor() {
        this.tpct.setDaemon(true);
        this.tpct.start();
    }

    @Override
    public boolean verify(ServerRequest dsi) {
        return dsi.getAnalyser() == 1;
    }

    @Override
    public void process(RequestAnalyserProcessor.ProcessorArgs pa) {
        try {
            if (Environment.getLogger().isDebugEnabled()) {
                Environment.getLogger().debug("Queueing request for processing " + pa.sr);
            }
            this.tpcQueue.put(pa);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void shutdown() {
        if (this.tpct != null) {
            this.tpct.end();
        }
    }

    protected class TPCThread
    extends Thread {
        private boolean run = true;

        protected TPCThread() {
        }

        public void end() {
            this.run = false;
            try {
                SingleThreadRequestAnalyserProcessor.this.tpcQueue.put(END);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            while (this.run) {
                try {
                    Object pr = SingleThreadRequestAnalyserProcessor.this.tpcQueue.take();
                    if (pr == END) continue;
                    RequestAnalyserProcessor.ProcessorArgs pa = (RequestAnalyserProcessor.ProcessorArgs)pr;
                    RequestProcessor tpcProcessor = pa.r.getPoolManager().getProcessor(true);
                    tpcProcessor.init(pa.r, pa.sr, pa.s, pa.sm);
                    tpcProcessor.begin();
                    while (tpcProcessor.isActive()) {
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

