/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import org.apache.avalon.framework.logger.Logger;
import org.jacorb.security.sas.GSSUPNameSpi;
import org.jacorb.security.sas.ISASContext;
import org.jacorb.util.Debug;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.GSSUP.InitialContextToken;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class GssUpContext
implements ISASContext {
    private static Logger logger = Debug.getNamedLogger("jacorb.SAS");
    private static String username = "";
    private static String password = "";
    private InitialContextToken initialContextToken = null;

    public static void setUsernamePassword(String username, String password) {
        GssUpContext.username = username;
        GssUpContext.password = password;
    }

    @Override
    public String getMechOID() {
        return "oid:2.23.130.1.1.1".substring(4);
    }

    @Override
    public byte[] createClientContext(ClientRequestInfo ri, CompoundSecMechList csmList) {
        byte[] target = csmList.mechanism_list[0].as_context_mech.target_name;
        byte[] contextToken = GSSUPNameSpi.encode(username, password, target);
        this.initialContextToken = GSSUPNameSpi.decode(contextToken);
        return contextToken;
    }

    @Override
    public String getClientPrincipal() {
        return username;
    }

    @Override
    public boolean validateContext(ServerRequestInfo ri, byte[] contextToken) {
        this.initialContextToken = GSSUPNameSpi.decode(contextToken);
        return this.initialContextToken != null;
    }

    @Override
    public String getValidatedPrincipal() {
        if (this.initialContextToken == null) {
            return null;
        }
        return new String(this.initialContextToken.username);
    }

    @Override
    public void initClient() {
    }

    @Override
    public void initTarget() {
    }
}

