/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.security.level2.CurrentImpl;
import org.jacorb.security.level2.KeyAndCert;
import org.jacorb.security.level2.ReceivedCredentialsImpl;
import org.jacorb.security.level2.SecAttributeManager;
import org.jacorb.util.Debug;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.omg.Security.AttributeType;
import org.omg.Security.ExtensibleFamily;
import org.omg.Security.SecAttribute;
import org.omg.SecurityLevel2.Current;
import org.omg.SecurityLevel2.ReceivedCredentials;

public class ServerInvocationInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    public static final String DEFAULT_NAME = "ServerInvocationInterceptor";
    private String name = null;
    private CurrentImpl current = null;
    private SecAttributeManager attrib_mgr = null;
    private AttributeType type = null;
    private Logger logger;

    public ServerInvocationInterceptor(Current current) {
        this(current, DEFAULT_NAME);
    }

    public ServerInvocationInterceptor(Current current, String name) {
        this.current = (CurrentImpl)current;
        this.name = name;
        this.attrib_mgr = SecAttributeManager.getInstance();
        this.type = new AttributeType(new ExtensibleFamily(0, 1), 2);
        this.logger = Debug.getNamedLogger("jacorb.security.jsse");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
    }

    @Override
    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        ServerRequest request = ((ServerRequestInfoImpl)ri).request;
        GIOPConnection connection = request.getConnection();
        if (connection == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("target has no connection!");
            }
            return;
        }
        if (!connection.isSSL()) {
            return;
        }
        ServerIIOPConnection transport = (ServerIIOPConnection)connection.getTransport();
        SSLSocket sslSocket = (SSLSocket)transport.getSocket();
        KeyAndCert kac = null;
        try {
            kac = new KeyAndCert(null, sslSocket.getSession().getPeerCertificates());
        }
        catch (SSLPeerUnverifiedException pue) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception " + pue.getMessage() + " in ServerInvocationInterceptor");
            }
            return;
        }
        if (kac.chain == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Client sent no certificate chain!");
            }
            return;
        }
        SecAttribute[] atts = new SecAttribute[]{this.attrib_mgr.createAttribute(kac, this.type)};
        this.current.set_received_credentials(new ReceivedCredentialsImpl(atts));
    }

    @Override
    public void send_reply(ServerRequestInfo ri) {
        this.removeAttribute();
        this.current.remove_received_credentials();
    }

    @Override
    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        this.removeAttribute();
        this.current.remove_received_credentials();
    }

    @Override
    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        this.removeAttribute();
        this.current.remove_received_credentials();
    }

    private void removeAttribute() {
        ReceivedCredentials creds = this.current.received_credentials();
        if (creds == null) {
            return;
        }
        SecAttribute[] attributes = creds.get_attributes(new AttributeType[]{this.type});
        if (attributes.length != 0) {
            this.attrib_mgr.removeAttribute(attributes[0]);
        }
    }
}

