/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.DebugManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintStream;

public class DebugConsole
implements Runnable {
    private static Thread debugConsoleThread;
    private BufferedReader reader;
    private PrintStream writer;
    private long startTime;
    private DebugManager dbm;

    public DebugConsole() {
        this(System.in, System.out);
    }

    public DebugConsole(InputStream inputStream, PrintStream printStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.writer = printStream;
        this.startTime = System.currentTimeMillis() + 500L;
        this.dbm = DebugManager.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startInstance() {
        Class<DebugConsole> clazz = DebugConsole.class;
        synchronized (DebugConsole.class) {
            if (debugConsoleThread == null) {
                debugConsoleThread = new Thread((Runnable)new DebugConsole(), "Debug Console");
                debugConsoleThread.start();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.dbm.addPrintStream(this.writer);
        String string = "";
        boolean bl = false;
        while (!bl && string != null) {
            try {
                string = this.reader.readLine();
                if (this.startTime != 0L && this.startTime >= System.currentTimeMillis()) continue;
                bl = this.dbm.exec(string);
                this.startTime = 0L;
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (Exception exception) {
                this.writer.println("Exception occurred: " + exception);
            }
        }
        this.dbm.removePrintStream(this.writer);
        Class<DebugConsole> clazz = DebugConsole.class;
        synchronized (DebugConsole.class) {
            debugConsoleThread = null;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }
}

