/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.ComparisonUtil;
import cerent.util.IPAddressTranslator;
import cerent.util.KDebug;
import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.SckfwdBid;
import cerent.util.proxy.SckfwdClient;
import cerent.util.proxy.SckfwdClientsReply;
import cerent.util.proxy.SckfwdException;
import cerent.util.proxy.SckfwdIo;
import cerent.util.proxy.SckfwdMethodReply;
import cerent.util.proxy.SckfwdReply;
import cerent.util.proxy.SckfwdRequestReply;
import cerent.util.proxy.SckfwdResetReply;
import cerent.util.proxy.SckfwdStatusReply;
import cerent.util.proxy.SckfwdTopologyReply;
import cerent.util.proxy.SckfwdUnsupportedCommandException;
import cerent.util.proxy.SckfwdWhoamiReply;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class Sckfwd {
    static final int SCKFWD_VER = 3;
    static final int SCKFWD_V5 = 5;
    static final int SCKFWD_V6 = 6;
    static final int SCKFWD_NO_AUTH = 0;
    static final int SCKFWD_GSSAPI = 1;
    static final int SCKFWD_UIDPWD = 2;
    static final int SCKFWD_CISCO_NOAUTH = 3;
    static final int SCKFWD_NONE = 255;
    static final int SCKFWD_CONNECT = 1;
    static final int SCKFWD_BIND = 2;
    static final int SCKFWD_UDP = 3;
    static final int SCKFWD_WHOAMI = 4;
    static final int SCKFWD_CLIENTS = 5;
    static final int SCKFWD_TOPOLOGY = 6;
    static final int SCKFWD_SUPPORTED = 7;
    static final int SCKFWD_RESET = 8;
    static final int SCKFWD_IPV4 = 1;
    static final int SCKFWD_NAME = 3;
    static final int SCKFWD_IPV6 = 4;
    static final int SCKFWD_SUCCEEDED = 0;
    static final int SCKFWD_FAILED = 1;
    static final int SCKFWD_DISALLOWED = 2;
    static final int SCKFWD_UNREACHABLE_NET = 3;
    static final int SCKFWD_UNREACHABLE_HOST = 4;
    static final int SCKFWD_REFUSED = 5;
    static final int SCKFWD_EXPIRED = 6;
    static final int SCKFWD_UNSUPPORTED_COMMAND = 7;
    static final int SCKFWD_UNSUPPORTED_ADDRESS = 8;
    private static final KDebug _debug = new KDebug(CtcProxyFactory.getDebug(), "Sckfwd");
    private final InetAddress _virtualHost;
    private final InetAddress _realHost;
    private final int _port;
    private SckfwdIo _io;
    private SckfwdMethodReply _authMethod;
    private SckfwdWhoamiReply _whoami;
    private ArrayList<SckfwdClient> _clients;
    private long _lastUpdated;
    private int _failures;
    private int _usage;
    private int _deltaCost;

    public Sckfwd(InetAddress inetAddress, int n) throws IOException {
        if (_debug.on()) {
            _debug.println("Enter Sckfwd for : host = " + inetAddress.getHostName() + " port = " + n);
        }
        this._lastUpdated = System.currentTimeMillis();
        this._virtualHost = inetAddress;
        InetAddress inetAddress2 = IPAddressTranslator.instance().getActualAddress(this._virtualHost);
        this._port = n;
        this._realHost = inetAddress2 == null ? this._virtualHost : inetAddress2;
        this._io = this.newSckfwdIo(3);
        try {
            this._authMethod = this.authMethod();
            this._whoami = this.whoami();
            this._clients = this.clients();
        }
        catch (IOException iOException) {
            this._io.close();
            throw iOException;
        }
        this.closeIfNotReusable();
        this._lastUpdated = System.currentTimeMillis();
        this._failures = 0;
        this._usage = 0;
        if (_debug.on()) {
            _debug.println("Exit Sckfwd: Auth method = " + this._authMethod.toString() + " whoAmI = " + this._whoami.toString() + " Clients = " + this._clients.toString());
            CtcProxyFactory.println(this.toString() + " changed");
        }
    }

    public Sckfwd(InetAddress inetAddress, int n, Collection collection) throws IOException {
        if (_debug.on()) {
            _debug.println("Enter Sckfwd for : host = " + inetAddress.getHostName() + " port = " + n + "Clients = " + collection.toString());
        }
        this._lastUpdated = System.currentTimeMillis();
        this._virtualHost = inetAddress;
        InetAddress inetAddress2 = IPAddressTranslator.instance().getActualAddress(this._virtualHost);
        this._port = n;
        this._realHost = inetAddress2 == null ? this._virtualHost : inetAddress2;
        this._io = this.newSckfwdIo(3);
        try {
            this._authMethod = this.authMethod();
            this._whoami = this.whoami();
            this._clients = this.toSckfwdClients(collection);
        }
        catch (IOException iOException) {
            this._io.close();
            throw iOException;
        }
        this.closeIfNotReusable();
        this._lastUpdated = System.currentTimeMillis();
        this._failures = 0;
        this._usage = 0;
        if (_debug.on()) {
            _debug.println(this.toString() + " changed");
            _debug.println("Exit Sckfwd: Auth method = " + this._authMethod.toString() + " whoAmI = " + this._whoami.toString() + " Clients = " + this._clients.toString());
        }
    }

    private synchronized SckfwdMethodReply authMethod() throws IOException {
        if (_debug.on()) {
            _debug.println("Enter authMethod - Convey Auth method");
        }
        int[] nArray = new int[]{0, 3};
        this._io.writeMethods(nArray);
        return new SckfwdMethodReply(this._io, nArray);
    }

    private synchronized SckfwdWhoamiReply whoami() throws IOException {
        if (_debug.on()) {
            _debug.println("Enter whoami - Convey who you are!");
        }
        this._io.writeWhoami();
        return new SckfwdWhoamiReply(this._io);
    }

    private ArrayList<SckfwdClient> toSckfwdClients(Collection collection) {
        ArrayList<SckfwdClient> arrayList = new ArrayList<SckfwdClient>();
        for (Object e : collection) {
            SckfwdClient sckfwdClient;
            if (e instanceof InetAddress) {
                sckfwdClient = new SckfwdClient(this, (InetAddress)e, CtcProxyFactory.defaultCost());
            } else if (e instanceof SckfwdClient) {
                sckfwdClient = new SckfwdClient((SckfwdClient)e);
            } else {
                throw new IllegalArgumentException("Argument to setClients() must be an InetAddress or a SckfwdClient.");
            }
            arrayList.add(sckfwdClient);
        }
        return arrayList;
    }

    private Collection<InetAddress> potentialServers(Collection<SckfwdClient> collection) {
        if (_debug.on()) {
            _debug.println("Enter potentialServers: Input list of potential servers " + collection.toString());
        }
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        HashSet<InetAddress> hashSet2 = new HashSet<InetAddress>();
        for (SckfwdClient sckfwdClient : collection) {
            if (!sckfwdClient.isPotentialServer() || sckfwdClient.getHost().equals(this._realHost)) continue;
            if (CtcProxyFactory.isIPv6Network() && sckfwdClient.getNodeId() != 0) {
                try {
                    InetAddress inetAddress = IPAddressTranslator.instance().findVirtualAddress(sckfwdClient.getNodeId());
                    InetAddress inetAddress2 = IPAddressTranslator.instance().getIPv6Address(inetAddress);
                    if (inetAddress2 == null || inetAddress2.equals(InetAddress.getByName("0:0:0:0:0:0:0:0"))) continue;
                    hashSet2.add(inetAddress2);
                }
                catch (UnknownHostException unknownHostException) {
                    _debug.println("IPv6 address lookup failed ");
                }
                continue;
            }
            hashSet.add(sckfwdClient.getHost());
        }
        if (CtcProxyFactory.isIPv6Network()) {
            if (_debug.on()) {
                _debug.println("Exit potentialServers: Purged Potential SOCKS servers (IPv6 launch): " + ((Object)hashSet2).toString());
            }
            return hashSet2;
        }
        if (_debug.on()) {
            _debug.println("Exit potentialServers: Purged Potential SOCKS servers (IPv4 launch): " + ((Object)hashSet).toString());
        }
        return hashSet;
    }

    private synchronized ArrayList<SckfwdClient> clients() throws IOException {
        ArrayList arrayList;
        SckfwdReply sckfwdReply;
        InetAddress inetAddress = null;
        if (this.hasProxiesWithCost()) {
            try {
                if (_debug.on()) {
                    _debug.println("clients: Sending getTopology ");
                }
                this._io.writeTopology();
                sckfwdReply = new SckfwdTopologyReply(this, this._io);
                arrayList = ((SckfwdTopologyReply)sckfwdReply).clients();
                this._usage = ((SckfwdTopologyReply)sckfwdReply).getUsage();
                inetAddress = ((SckfwdTopologyReply)sckfwdReply).getServer();
            }
            catch (SckfwdUnsupportedCommandException sckfwdUnsupportedCommandException) {
                if (_debug.on()) {
                    _debug.println("clients: Sending getClients ");
                }
                this._io.writeClients();
                SckfwdClientsReply sckfwdClientsReply = new SckfwdClientsReply(this, this._io);
                arrayList = sckfwdClientsReply.clients();
                inetAddress = sckfwdClientsReply.getServer();
            }
        } else {
            if (_debug.on()) {
                _debug.println("clients: Sending getClients ");
            }
            this._io.writeClients();
            sckfwdReply = new SckfwdClientsReply(this, this._io);
            arrayList = ((SckfwdClientsReply)sckfwdReply).clients();
            inetAddress = ((SckfwdClientsReply)sckfwdReply).getServer();
        }
        if (!arrayList.isEmpty()) {
            boolean bl = false;
            for (Object object : arrayList) {
                if (!((SckfwdClient)object).getHost().equals(this._realHost)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                int n = 0;
                if (this._realHost.getAddress().length == 16) {
                    Object object;
                    object = IPAddressTranslator.instance().findVirtualAddressForIPv6(this._realHost);
                    n = IPAddressTranslator.instance().getActualNodeId((InetAddress)object);
                }
                int n2 = 170;
                int n3 = 0;
                if (n != 0) {
                    for (SckfwdClient sckfwdClient : arrayList) {
                        if (sckfwdClient.getNodeId() != n) continue;
                        n2 = sckfwdClient.getFlags();
                        n3 = sckfwdClient.getCost();
                        break;
                    }
                }
                arrayList.add(new SckfwdClient(this, this._realHost, inetAddress, CtcProxyFactory.getSizeInBits(this._realHost), n3, n2, n));
            }
        }
        if (_debug.on()) {
            _debug.println("Clients of " + this);
            for (SckfwdClient sckfwdClient : arrayList) {
                _debug.println("  " + sckfwdClient);
            }
        }
        if (_debug.on()) {
            _debug.println("Discovering additional servers...");
        }
        CtcProxyFactory.discover(this.potentialServers(arrayList));
        if (_debug.on()) {
            _debug.println("Discovery complete.");
        }
        return arrayList;
    }

    private synchronized void closeIfNotReusable() {
        if (!this.proxiesReusable()) {
            block3: {
                try {
                    this._io.close();
                }
                catch (IOException iOException) {
                    if (!_debug.on()) break block3;
                    _debug.println("closeIfNotReusable: " + iOException);
                }
            }
            this._io = null;
        }
    }

    InetAddress getHost() {
        return this._virtualHost;
    }

    public InetAddress getRealHost() {
        return this._realHost;
    }

    int getPort() {
        return this._port;
    }

    InetAddress getLocalHost() {
        return this._whoami.getHost();
    }

    int getFailures() {
        return ++this._failures;
    }

    int getUsage() {
        return this._usage;
    }

    void incrementUsage() {
        ++this._usage;
    }

    void decrementUsage() {
        --this._usage;
    }

    int getDeltaCost() {
        return this._deltaCost;
    }

    void setDeltaCost(int n) {
        this._deltaCost = n;
    }

    void expire() {
        this.clearClients();
        this._lastUpdated = 0L;
    }

    boolean expired() {
        long l = System.currentTimeMillis() - this._lastUpdated;
        return l > CtcProxyFactory.timeout();
    }

    synchronized boolean validate() throws IOException {
        boolean bl = false;
        if (this.expired()) {
            ArrayList<SckfwdClient> arrayList;
            SckfwdWhoamiReply sckfwdWhoamiReply;
            try {
                if (this._io == null) {
                    this._io = this.newSckfwdIo(3);
                    this._authMethod = this.authMethod();
                }
                sckfwdWhoamiReply = this.whoami();
                arrayList = this.clients();
            }
            catch (IOException iOException) {
                if (this._io != null) {
                    this._io.close();
                    this._io = null;
                }
                throw iOException;
            }
            if (!this._whoami.equals(sckfwdWhoamiReply)) {
                this._whoami = sckfwdWhoamiReply;
            }
            if (!this._clients.equals(arrayList)) {
                this._clients = arrayList;
                bl = true;
            }
            this.closeIfNotReusable();
            this._lastUpdated = System.currentTimeMillis();
            this._failures = 0;
            if (_debug.on()) {
                _debug.println(this.toString() + (bl ? " changed" : " no change"));
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized SckfwdBid willProxyFor(InetAddress inetAddress) {
        Object object;
        String string;
        block25: {
            Object object2;
            InetAddress inetAddress2;
            InetAddress inetAddress3;
            block26: {
                boolean bl;
                block27: {
                    block28: {
                        if (_debug.on()) {
                            _debug.println("Enter willProxyFor: Sckfwd-realHost (Server) " + this._realHost.toString() + "Checking for Client :" + inetAddress.getHostName());
                        }
                        InetAddress inetAddress4 = (bl = _debug.on()) ? IPAddressTranslator.instance().getActualAddress(this.getHost().getHostAddress()) : null;
                        inetAddress3 = bl ? IPAddressTranslator.instance().getActualAddress(inetAddress.getHostAddress()) : null;
                        String string2 = string = bl ? "willProxyFor: " + inetAddress4 + " --> " + inetAddress3 + " : " : null;
                        if (this.expired()) {
                            if (bl) {
                                _debug.println(string + "expired");
                            }
                            return null;
                        }
                        InetAddress inetAddress5 = this.getHost();
                        if (CtcProxyFactory.areVirtualAndProxyInSameTopo(inetAddress5, inetAddress) || inetAddress.equals(this.getHost())) break block26;
                        inetAddress2 = CtcProxyFactory.virtualInitialServer;
                        object = CtcProxyFactory.loginEne;
                        if (inetAddress2 == null || !inetAddress2.equals(inetAddress5)) break block27;
                        if (object != null) break block28;
                        if (bl) {
                            _debug.println("login ENE always deemed in same topo as initial proxy server");
                        }
                        break block26;
                    }
                    Object object3 = object2 = IPAddressTranslator.instance().isVirtual(inetAddress) ? IPAddressTranslator.instance().getActualAddress(inetAddress) : inetAddress;
                    if (((InetAddress)object2).equals(object)) {
                        if (bl) {
                            _debug.println("login ENE always deemed in same topo as initial proxy server");
                        }
                        break block26;
                    } else {
                        if (bl) {
                            _debug.println(string + "different Topos");
                        }
                        return null;
                    }
                }
                if (bl) {
                    _debug.println(string + "different Topos");
                }
                return null;
            }
            if ((inetAddress2 = IPAddressTranslator.instance().getActualAddress(inetAddress)) == null) {
                inetAddress2 = inetAddress;
            }
            object = null;
            if (_debug.on()) {
                _debug.println(string + "Clients for the server " + inetAddress3 + " are : " + this._clients.toString());
            }
            for (SckfwdClient sckfwdClient : this._clients) {
                if (!sckfwdClient.matches(inetAddress2)) continue;
                if (object == null) {
                    object = sckfwdClient;
                } else if (sckfwdClient.getCost() < ((SckfwdClient)object).getCost()) {
                    object = sckfwdClient;
                }
                if (!_debug.on()) continue;
                _debug.println(string + "Best match was :" + ((SckfwdClient)object).toString());
            }
            try {
                if (object != null || !CtcProxyFactory.isIPv6Network()) break block25;
                object2 = null;
                int n = inetAddress.getAddress().length;
                IPAddressTranslator.instance();
                object2 = n != 16 ? IPAddressTranslator.instance().getIPv6Address(inetAddress) : inetAddress;
                int n2 = ((InetAddress)object2).getAddress().length;
                IPAddressTranslator.instance();
                if (n2 == 16) {
                    if (_debug.on()) {
                        _debug.println("willProxyFor : Input addr = " + inetAddress.getHostAddress() + " IPv6 addr = " + ((InetAddress)object2).getHostAddress());
                    }
                    for (SckfwdClient sckfwdClient : this._clients) {
                        InetAddress inetAddress6 = IPAddressTranslator.instance().findVirtualAddress(sckfwdClient.getNodeId());
                        InetAddress inetAddress7 = IPAddressTranslator.instance().getIPv6Address(inetAddress6);
                        if (!((InetAddress)object2).equals(inetAddress7)) continue;
                        if (object == null) {
                            object = sckfwdClient;
                        } else if (sckfwdClient.getCost() < ((SckfwdClient)object).getCost()) {
                            object = sckfwdClient;
                        }
                        if (!_debug.on()) continue;
                        _debug.println(string + "Best match was :" + ((SckfwdClient)object).toString());
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (!_debug.on()) break block25;
                _debug.println(string + "Could not resolve node Id to virtual address");
            }
        }
        if (object != null) {
            return new SckfwdBid(this, (SckfwdClient)object, this._usage);
        }
        if (_debug.on()) {
            _debug.println(string + "No match");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int reset(String string, String string2, InetAddress inetAddress, int n) throws IOException {
        SckfwdIo sckfwdIo = null;
        try {
            sckfwdIo = this.newSckfwdIo(3);
            int[] nArray = new int[]{2, 3};
            sckfwdIo.writeMethods(nArray);
            SckfwdMethodReply sckfwdMethodReply = new SckfwdMethodReply(sckfwdIo, nArray);
            int n2 = sckfwdIo.getVersion();
            sckfwdIo.setVersion(1);
            sckfwdIo.writeUidPwd(string, string2);
            SckfwdStatusReply sckfwdStatusReply = new SckfwdStatusReply(sckfwdIo);
            sckfwdIo.setVersion(n2);
            sckfwdIo.writeReset(inetAddress, n);
            SckfwdResetReply sckfwdResetReply = new SckfwdResetReply(sckfwdIo);
            int n3 = sckfwdResetReply.getReset();
            return n3;
        }
        finally {
            if (sckfwdIo != null) {
                sckfwdIo.close();
            }
        }
    }

    boolean proxiesReusable() {
        return this._authMethod.getVersion() == 3;
    }

    boolean hasProxiesWithCost() {
        return this._authMethod.getVersion() >= 6;
    }

    private SckfwdIo newSckfwdIo(int n) throws IOException {
        return new SckfwdIo(n, this._realHost, this._port);
    }

    SckfwdIo createIo() throws IOException {
        SckfwdIo sckfwdIo = this.newSckfwdIo(this._authMethod.getVersion());
        int[] nArray = new int[]{0, 3};
        sckfwdIo.writeMethods(nArray);
        new SckfwdMethodReply(sckfwdIo, nArray);
        return sckfwdIo;
    }

    synchronized Collection getClients() throws IOException {
        this.expire();
        this.validate();
        ArrayList<SckfwdClient> arrayList = new ArrayList<SckfwdClient>();
        for (SckfwdClient sckfwdClient : this._clients) {
            arrayList.add(new SckfwdClient(sckfwdClient));
        }
        if (_debug.on()) {
            _debug.println("Exit getClients : " + arrayList.toString());
        }
        return arrayList;
    }

    synchronized void setClients(Collection collection) throws IOException {
        this._clients = this.toSckfwdClients(collection);
        this._lastUpdated = System.currentTimeMillis();
        this._failures = 0;
        if (_debug.on()) {
            _debug.println(this.toString() + " changed");
        }
    }

    synchronized void clearClients() {
        this._clients.clear();
        this._lastUpdated = System.currentTimeMillis();
        this._failures = 0;
        if (_debug.on()) {
            _debug.println(this.toString() + " changed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SckfwdConnectHolder connect(SckfwdClient sckfwdClient, InetAddress inetAddress, int n) throws IOException {
        SckfwdConnectHolder sckfwdConnectHolder;
        block9: {
            Object object;
            if (_debug.on()) {
                _debug.println("Enter connect: client = " + sckfwdClient.toString() + " host = " + inetAddress.getHostName() + " port = " + n);
            }
            sckfwdConnectHolder = new SckfwdConnectHolder();
            InetAddress inetAddress2 = sckfwdClient.getTargetHost() != null ? sckfwdClient.getTargetHost() : inetAddress;
            int n2 = inetAddress2.getAddress().length;
            IPAddressTranslator.instance();
            if (n2 == 16) {
                object = IPAddressTranslator.instance().findVirtualAddressForIPv6(inetAddress2);
                inetAddress2 = IPAddressTranslator.instance().getPublicAddress((InetAddress)object);
            }
            try {
                if (this.proxiesReusable()) {
                    object = this;
                    synchronized (object) {
                        this._io.writeConnect(inetAddress2, n);
                        sckfwdConnectHolder._reply = new SckfwdRequestReply(this._io);
                        break block9;
                    }
                }
                sckfwdConnectHolder._sckfwdIo = this.createIo();
                sckfwdConnectHolder._sckfwdIo.writeConnect(inetAddress2, n);
                sckfwdConnectHolder._reply = new SckfwdRequestReply(sckfwdConnectHolder._sckfwdIo);
            }
            catch (SckfwdException sckfwdException) {
                if (CtcProxyFactory.debug()) {
                    CtcProxyFactory.println("connect to " + CtcProxyFactory.key(inetAddress2, n) + " failed: " + sckfwdException);
                }
                throw sckfwdException;
            }
        }
        return sckfwdConnectHolder;
    }

    synchronized SckfwdRequestReply bind(InetAddress inetAddress, int n) throws IOException {
        if (_debug.on()) {
            _debug.println("Enter bind : host = " + inetAddress.getHostName() + " port = " + n);
        }
        this._io.writeBind(this._whoami.getHost(), n);
        return new SckfwdRequestReply(this._io);
    }

    public String toString() {
        long l = System.currentTimeMillis() - this._lastUpdated;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._realHost.getHostAddress());
        stringBuffer.append(":");
        stringBuffer.append(this._port);
        if (!this._realHost.equals(this._virtualHost)) {
            stringBuffer.append("(");
            stringBuffer.append(this._virtualHost.getHostAddress());
            stringBuffer.append(")");
        }
        stringBuffer.append(" f=");
        stringBuffer.append(this._failures);
        stringBuffer.append(" u=");
        stringBuffer.append(this._usage);
        stringBuffer.append(" w=");
        stringBuffer.append(this._whoami.getHost().getHostAddress());
        stringBuffer.append(" a=");
        stringBuffer.append(l);
        stringBuffer.append(" ms");
        stringBuffer.append(" dc=");
        stringBuffer.append(this._deltaCost);
        return stringBuffer.toString();
    }

    private static List<SckfwdClient> sortByAddr(List<SckfwdClient> list) {
        ArrayList<SckfwdClient> arrayList = new ArrayList<SckfwdClient>(list);
        Collections.sort(arrayList, new Comparator<SckfwdClient>(){

            @Override
            public int compare(SckfwdClient sckfwdClient, SckfwdClient sckfwdClient2) {
                InetAddress inetAddress = sckfwdClient.getHost();
                InetAddress inetAddress2 = sckfwdClient2.getHost();
                byte[] byArray = inetAddress.getAddress();
                byte[] byArray2 = inetAddress2.getAddress();
                int n = byArray.length;
                int n2 = byArray2.length;
                int n3 = 0;
                if (n < n2) {
                    n3 = -1;
                } else if (n > n2) {
                    n3 = 1;
                } else {
                    for (int i = 0; i < n && n3 == 0; ++i) {
                        n3 = ComparisonUtil.compare(byArray[i], byArray2[i]);
                    }
                }
                return n3;
            }
        });
        return arrayList;
    }

    public String toClientString() {
        StringBuffer stringBuffer = new StringBuffer();
        List<SckfwdClient> list = Sckfwd.sortByAddr(this._clients);
        boolean bl = false;
        stringBuffer.append("{");
        for (SckfwdClient sckfwdClient : list) {
            if (!bl) {
                bl = true;
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(sckfwdClient.toString());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    class SckfwdConnectHolder {
        SckfwdRequestReply _reply;
        SckfwdIo _sckfwdIo;

        SckfwdConnectHolder() {
        }
    }
}

