/*
 * Decompiled with CFR 0.152.
 */
package cerent.version;

import cerent.launcher.CmsClassLoader;
import cerent.util.DebugManager;
import cerent.util.KDebug;
import cerent.version.IBuildInformation;
import cerent.version.Ngrp;
import cerent.version.NgrpFactory;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.INgrp;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class AbstractJarBuildInformation
implements IBuildInformation {
    private static final String JAR_COVERAGE_OUTPUT_FILE = "Emma-Output-File";
    private static final String JAR_BUILD_INFORMATION_SECTION = "Build-version";
    private static final String JAR_BUILD_INFORMATION_VERSION = "Implementation-version";
    private static final String JAR_BUILD_SPECIFICATIION_VERSION = "Specification-Version";
    private static final String JAR_VERSION_VIEW = "Version-View";
    private static final String JAR_VERSION_TSTAMP = "Version-Timestamp";
    private static final String JAR_SOURCE_TYPE = "Source-type";
    private static final String NGRP_MAJOR_RLS = "NGRP-Major-Release";
    private static final String NGRP_MAINT_RLS = "NGRP-Maintenance-Release";
    private static final String NGRP_INTERIM_VER = "NGRP-Interim-Version-Number";
    private static final String NGRP_MAJOR_REBUILD_DES = "NGRP-Major-Rebuild-Designator";
    private static final String NGRP_MAJOR_TECH_RLS_DES = "NGRP-Technology-Release-Designator";
    private static final String NGRP_REBUILD_DES = "NGRP-Rebuild-Designator";
    public static final String ELEMENT_MANIFEST = ClassLoaderEnum.ELE.manifestPrefix;
    public static final String INTERFACE_MANIFEST = ClassLoaderEnum.IF.manifestPrefix;
    public static final String LAUNCHER_MANIFEST = ClassLoaderEnum.SYSTEM.manifestPrefix;
    public static final String NETWORK_MANIFEST = ClassLoaderEnum.NET.manifestPrefix;
    private static final String UNKNOWN = "???";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    protected static HashSet<URL> nonCtcResources = new HashSet();
    protected static HashMap<String, INgrp> systemNgrps = new HashMap();
    protected static KDebug db;
    private Attributes mainattrs;
    private Attributes attrs;
    private String classPath;
    private String sourceType;
    private String branchPath;
    private long timeStamp;
    private Ngrp ngrp;
    private boolean isForCTC;
    private String specTitle;

    public AbstractJarBuildInformation(String string) {
        this.init(string, this.getClass().getClassLoader(), null);
    }

    public AbstractJarBuildInformation(String string, ClassLoader classLoader) {
        this(string, classLoader, false, null);
    }

    public AbstractJarBuildInformation(String string, ClassLoader classLoader, boolean bl, ClassLoaderEnum classLoaderEnum) {
        this.isForCTC = bl;
        this.init(string, classLoader, classLoaderEnum);
    }

    public static INgrp getSystemNgrp(String string) {
        return systemNgrps.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String string, ClassLoader classLoader, ClassLoaderEnum classLoaderEnum) {
        String string2;
        String string3;
        URL uRL;
        Object object;
        URL[] uRLArray;
        if (classLoader instanceof URLClassLoader && (uRLArray = ((URLClassLoader)(object = (URLClassLoader)classLoader)).getURLs()) != null && uRLArray.length == 1 && (uRL = uRLArray[0]).getProtocol().equals("file") && (string3 = URLDecoder.decode(string2 = uRL.getPath())).endsWith(".jar")) {
            File file = new File(string3);
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                String string4 = file.getCanonicalPath();
                this.isForCTC = this.isForCTC;
                this.init(string, jarFile, string4, classLoaderEnum);
            }
            catch (IOException iOException) {
                Exception exception = new Exception("error processing jar file: " + file, iOException);
                KDebug.printStackTrace(exception);
                this.makeEmptyBuildInformation();
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {
                        KDebug.printStackTrace(iOException);
                    }
                }
            }
            return;
        }
        object = this.getManifest(string, classLoader, classLoaderEnum);
        this._init(string, (Manifest)object, classLoaderEnum);
    }

    private void init(String string, JarFile jarFile, String string2, ClassLoaderEnum classLoaderEnum) throws IOException {
        Manifest manifest = jarFile.getManifest();
        manifest = this.checkManifest(string, manifest, string2);
        this._init(string, manifest, classLoaderEnum);
    }

    private void _init(String string, Manifest manifest, ClassLoaderEnum classLoaderEnum) {
        if (manifest != null) {
            try {
                String string2;
                if (this.attrs == null && db.on()) {
                    db.println("old ill-formed Build-version handling this as thought one didn't exist");
                }
                if (!(string2 = this.getAttribute(this.attrs, JAR_BUILD_INFORMATION_VERSION)).equals(UNKNOWN) && !string2.equals("1.0")) {
                    throw new InvalidImplVersionException(string);
                }
                string2 = this.mainattrs.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                this.sourceType = this.getAttribute(this.attrs, JAR_SOURCE_TYPE);
                this.branchPath = this.getAttribute(this.attrs, JAR_VERSION_VIEW);
                String string3 = this.getAttribute(this.attrs, JAR_VERSION_TSTAMP);
                this.timeStamp = string3.equals(UNKNOWN) ? 0L : Long.decode(string3);
                this.ngrp = this.getNgrpFromAttr(this.attrs, this.mainattrs, string2, this.classPath);
                if (db.isFinestEnabled()) {
                    db.finest("NGRP created: " + this.ngrp);
                }
                try {
                    String string4 = this.getAttribute(this.attrs, JAR_COVERAGE_OUTPUT_FILE);
                    System.setProperty("emma.coverage.out.file", string4);
                }
                catch (NgrpFactory.AttrNotPresentException attrNotPresentException) {
                }
                catch (Exception exception) {
                    db.fine(exception.getMessage());
                }
            }
            catch (InvalidImplVersionException invalidImplVersionException) {
                if (db.isFineEnabled()) {
                    KDebug.printStackTrace(invalidImplVersionException);
                }
                this.makeEmptyBuildInformation();
            }
            catch (NgrpFactory.AttrNotPresentException attrNotPresentException) {
                if (db.isFineEnabled()) {
                    KDebug.printStackTrace(attrNotPresentException);
                }
                this.makeEmptyBuildInformation();
            }
            catch (Exception exception) {
                KDebug.printStackTrace(exception);
                this.makeEmptyBuildInformation();
            }
        } else {
            this.makeEmptyBuildInformation();
        }
        if (classLoaderEnum != null && classLoaderEnum.equals((Object)ClassLoaderEnum.SYSTEM)) {
            systemNgrps.put(this.classPath, this.ngrp);
        }
    }

    private Manifest getManifest(String string, ClassLoader classLoader, ClassLoaderEnum classLoaderEnum) {
        Manifest manifest = null;
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
        URL[] uRLArray = uRLClassLoader.getURLs();
        if (db.on()) {
            db.println("Looking for manifest for " + string + " in CL: " + classLoader.getClass().getName() + " with title: '" + string + "' with " + uRLArray.length + " CL URLs");
        }
        if (db.isFinestEnabled()) {
            for (URL uRL : uRLArray) {
                db.finest("  URL: " + uRL);
            }
        }
        Object object = null;
        try {
            object = classLoader.getResources(MANIFEST_NAME);
        }
        catch (IOException iOException) {
            KDebug.printStackTrace(iOException);
        }
        if (object != null) {
            boolean bl = false;
            if (classLoaderEnum == null) {
                if (classLoader instanceof CmsClassLoader) {
                    classLoaderEnum = ((CmsClassLoader)classLoader).getClassLoaderKey().getClassLoaderEnum();
                } else if (CoreConstants.scl.equals(classLoader)) {
                    classLoaderEnum = ClassLoaderEnum.SYSTEM;
                }
            }
            boolean bl2 = bl = classLoaderEnum != null && classLoaderEnum.isCore;
            while (object.hasMoreElements() && manifest == null) {
                URL uRL = (URL)object.nextElement();
                if (bl && nonCtcResources.contains(uRL)) continue;
                manifest = this.getManifest(string, uRL, bl);
            }
        }
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getManifest(String string, URL uRL, boolean bl) {
        String string2;
        Manifest manifest;
        block53: {
            manifest = null;
            String string3 = uRL.getProtocol();
            InputStream inputStream = null;
            Object var10_7 = null;
            File file = null;
            Object var12_9 = null;
            String string4 = null;
            URL uRL2 = null;
            try {
                String string5;
                String string6;
                Object object;
                boolean bl2 = string3.equals("jar");
                if (bl2) {
                    uRL2 = uRL;
                    string4 = uRL2.toExternalForm();
                    object = null;
                    string5 = string6 = uRL2.getPath();
                    try {
                        object = new URL(string5);
                        string3 = ((URL)object).getProtocol();
                    }
                    catch (MalformedURLException malformedURLException) {
                        db.println("manifest problem with resource: " + uRL);
                        KDebug.printStackTrace(malformedURLException);
                        Manifest manifest2 = manifest;
                        if (var12_9 != null) {
                            // empty if block
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {
                                KDebug.printStackTrace(iOException);
                            }
                        }
                        return manifest2;
                    }
                    string2 = ((URL)object).getPath();
                    int n = string2.indexOf("!/");
                    if (n > 0) {
                        string2 = string2.substring(0, n);
                    }
                } else {
                    string5 = uRL.toExternalForm();
                    string6 = uRL.getPath();
                    string2 = string6;
                    if (string2.endsWith(MANIFEST_NAME)) {
                        string2 = string2.substring(0, string2.length() - MANIFEST_NAME.length());
                    }
                }
                if (db.isFinerEnabled()) {
                    db.finer("Trying CP URL: " + string5);
                }
                if (!string2.endsWith(".jar") || string3.equals("http")) {
                    manifest = new Manifest();
                    try {
                        inputStream = uRL.openStream();
                        manifest.read(inputStream);
                        break block53;
                    }
                    catch (IOException iOException) {
                        db.println("manifest problem with resource: " + uRL);
                        KDebug.printStackTrace(iOException);
                        Manifest manifest3 = manifest;
                        if (var12_9 != null) {
                            // empty if block
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException2) {
                                KDebug.printStackTrace(iOException2);
                            }
                        }
                        return manifest3;
                    }
                }
                if (!bl2 && !string3.equals("file")) break block53;
                if (this.isForCTC) {
                    String string7;
                    object = new File(string2);
                    String string8 = ((File)object).getName();
                    int n = string8.lastIndexOf(".");
                    if (n < 0) {
                        Manifest manifest4 = manifest;
                        return manifest4;
                    }
                    if (!(string8 = string8.substring(0, n)).equals(string7 = string8.toUpperCase()) && string7.indexOf("CTC") < 0) {
                        if (db.isFinestEnabled()) {
                            db.finest("skipping non-CTC jar: " + string8);
                        }
                        if (bl) {
                            nonCtcResources.add(uRL);
                        }
                        Manifest manifest5 = manifest;
                        return manifest5;
                    }
                }
                if (string4 == null) {
                    object = URLDecoder.decode(string6);
                    file = new File((String)object);
                    try {
                        string4 = "jar:" + file.toURL() + "!/" + MANIFEST_NAME;
                        uRL2 = new URL(string4);
                    }
                    catch (MalformedURLException malformedURLException) {
                        db.println("manifest problem with resource: " + uRL);
                        KDebug.printStackTrace(malformedURLException);
                        Manifest manifest6 = manifest;
                        if (var12_9 != null) {
                            // empty if block
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {
                                KDebug.printStackTrace(iOException);
                            }
                        }
                        return manifest6;
                    }
                }
                try {
                    manifest = new Manifest();
                    inputStream = uRL.openStream();
                    manifest.read(inputStream);
                    manifest = this.checkManifest(string, manifest, string2);
                }
                catch (IOException iOException) {
                    db.println("manifest problem with resource: " + uRL);
                    KDebug.printStackTrace(iOException);
                }
                catch (RuntimeException runtimeException) {
                    if (db.on()) {
                        db.println("unexpected manifest problem with resource: " + uRL);
                        KDebug.printStackTrace(runtimeException);
                    }
                }
            }
            finally {
                if (var12_9 != null) {
                    // empty if block
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        KDebug.printStackTrace(iOException);
                    }
                }
            }
        }
        manifest = this.checkManifest(string, manifest, string2);
        if (manifest == null) {
            db.fine("Manifest not found");
        }
        return manifest;
    }

    private Manifest checkManifest(String string, Manifest manifest, String string2) {
        if (manifest == null) {
            return manifest;
        }
        Manifest manifest2 = null;
        this.mainattrs = manifest.getMainAttributes();
        String string3 = this.mainattrs.getValue(Attributes.Name.SPECIFICATION_TITLE);
        if (db.isFinestEnabled()) {
            db.finest("Manifest spec title: " + string3);
        }
        if (string3 == null) {
            db.finest("No Specification-Title in manifest");
        } else {
            String string4 = string3.toLowerCase(Locale.ENGLISH);
            if (string4.indexOf("ctc ") >= 0 && (string == null || string4.indexOf(string) >= 0)) {
                if (db.on()) {
                    db.println("Manifest " + string3 + " found");
                }
                this.attrs = manifest.getAttributes(JAR_BUILD_INFORMATION_SECTION);
                this.specTitle = string3;
                this.classPath = string2;
                manifest2 = manifest;
            }
        }
        return manifest2;
    }

    public Attributes getMainAttributes() {
        return this.mainattrs;
    }

    public String getClassPath() {
        return this.classPath;
    }

    @Override
    public String getSourceType() {
        return this.sourceType;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public Date getDate() {
        return new Date(this.timeStamp * 1000L);
    }

    @Override
    public String getBranchPath() {
        return this.branchPath;
    }

    @Override
    public Ngrp getNgrp() {
        return this.ngrp;
    }

    private String getAttribute(Attributes attributes, String string) throws NgrpFactory.AttrNotPresentException {
        return NgrpFactory.getAttribute(attributes, string);
    }

    private Ngrp getNgrpFromAttr(Attributes attributes, Attributes attributes2, String string, String string2) throws NgrpFactory.AttrNotPresentException {
        return NgrpFactory.getNgrpFromAttr(this.specTitle, attributes, attributes2, string, string2);
    }

    private void makeEmptyBuildInformation() {
        if (db.isFinestEnabled()) {
            KDebug.printStackTrace(new Exception());
        }
        this.sourceType = UNKNOWN;
        this.branchPath = UNKNOWN;
        this.timeStamp = Long.MIN_VALUE;
        this.ngrp = new Ngrp(UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, null);
        this.ngrp.isEmpty = true;
    }

    static {
        DebugManager.instance();
        db = new KDebug("AbstractJarBuildInformation");
    }

    private class InvalidImplVersionException
    extends Exception {
        InvalidImplVersionException() {
            this(AbstractJarBuildInformation.UNKNOWN);
        }

        InvalidImplVersionException(String string) {
            super("The version is incorrect for the " + string + " jar file.");
        }
    }
}

