/*
 * Decompiled with CFR 0.152.
 */
package cerent.version;

import cerent.util.KDebug;
import cerent.version.VersionFormatEnum;

public class VersionFormatFactory {
    private static final KDebug db = new KDebug("VersionFormatFactory");

    private VersionFormatFactory() {
    }

    public static String parseIntoString(VersionFormatEnum versionFormatEnum, String string) {
        if (db.on()) {
            db.println("parseIntoString: enumerator=" + versionFormatEnum.value() + "   str=" + string);
        }
        String string2 = "";
        int n = versionFormatEnum.value();
        switch (n) {
            case 0: {
                string2 = VersionFormatFactory.getInternalVersionString(string);
                break;
            }
            case 1: {
                try {
                    string2 = VersionFormatFactory.getNeVersionString(string);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    VersionFormatFactory.printException(n, string);
                    throw illegalArgumentException;
                }
            }
            case 2: {
                try {
                    string2 = VersionFormatFactory.getEleVersionString(string);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    VersionFormatFactory.printException(n, string);
                    throw illegalArgumentException;
                }
            }
            case 3: {
                try {
                    string2 = VersionFormatFactory.getCachingVersionString(string);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    VersionFormatFactory.printException(n, string);
                    throw illegalArgumentException;
                }
            }
            case 4: {
                try {
                    string2 = VersionFormatFactory.getClassPathVersionString(string);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    VersionFormatFactory.printException(n, string);
                    throw illegalArgumentException;
                }
            }
            case 5: {
                try {
                    string2 = VersionFormatFactory.getDottedVersionString(string);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    VersionFormatFactory.printException(n, string);
                    throw illegalArgumentException;
                }
            }
            case 6: {
                try {
                    string2 = VersionFormatFactory.getFullVersionString(string);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    VersionFormatFactory.printException(n, string);
                    throw illegalArgumentException;
                }
            }
            case 7: {
                try {
                    string2 = VersionFormatFactory.getNeVersionString(string);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    VersionFormatFactory.printException(n, string);
                    throw illegalArgumentException;
                }
            }
            case 8: {
                string2 = VersionFormatFactory.getFileNameVersionString(string);
                break;
            }
        }
        if (db.on()) {
            db.println("parseIntoString: seq=" + string2);
        }
        if (string2 == null || string2 == "") {
            return string2;
        }
        if (string2 != null && string2 != "") {
            if (string2.length() > 6) {
                string2 = string2.substring(0, 6);
            } else {
                while (string2.length() < 6) {
                    string2 = string2 + "0";
                }
            }
            if (db.on()) {
                db.println("parseIntoString: after trim/pad, seq=" + string2);
            }
        }
        return string2;
    }

    private static String getInternalVersionString(String string) {
        String string2 = string;
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        return string2;
    }

    private static String getNeVersionString(String string) throws IllegalArgumentException {
        int n;
        int n2 = string == null ? 0 : string.length();
        int n3 = n = string == null ? -1 : string.indexOf("-");
        if (n < 0) {
            n = n2;
        }
        if (n <= 7 && string != null) {
            return VersionFormatFactory.getDottedVersionString(string.substring(0, n));
        }
        throw new IllegalArgumentException("The NE's full version string of '" + string + "' is null or contains too many characters.");
    }

    private static String getFileNameVersionString(String string) throws IllegalArgumentException {
        int n = string.lastIndexOf(95);
        int n2 = string.lastIndexOf(".jar");
        if (n2 < 0) {
            n2 = string.lastIndexOf(".JAR");
        }
        if (n < 0) {
            return null;
        }
        if (n > 0 && n2 > n && string.endsWith(".jar")) {
            String string2 = string.substring(n + 1, string.length() - 4);
            if (string.charAt(2) == '.') {
                return VersionFormatFactory.getDottedVersionString(string2);
            }
            return VersionFormatFactory.getInternalVersionString(string2);
        }
        throw new IllegalArgumentException();
    }

    private static String getEleVersionString(String string) throws IllegalArgumentException {
        int n = string.lastIndexOf(95);
        if (n > 0 && string.startsWith("ELE") && string.endsWith(".jar")) {
            String string2 = string.substring(n + 1, string.length() - 4);
            return VersionFormatFactory.getInternalVersionString(string2);
        }
        throw new IllegalArgumentException();
    }

    private static String getCachingVersionString(String string) throws IllegalArgumentException {
        int n = string.lastIndexOf(45);
        if (n > 0 && string.startsWith("ctc.launcher.ctc-jar-ele")) {
            String string2 = string.substring(n + 1, string.length());
            return VersionFormatFactory.getDottedVersionString(string2);
        }
        throw new IllegalArgumentException();
    }

    private static String getClassPathVersionString(String string) throws IllegalArgumentException {
        int n = string.lastIndexOf(45);
        if (n > 0 && string.startsWith("ctc.clurlELE")) {
            String string2 = string.substring(n + 1, string.length());
            return VersionFormatFactory.getDottedVersionString(string2);
        }
        throw new IllegalArgumentException();
    }

    private static String getDottedVersionString(String string) throws IllegalArgumentException {
        if (string.charAt(2) == '.') {
            return string.substring(0, 2) + string.substring(3, string.length());
        }
        throw new IllegalArgumentException("A period was expected in the second position of the string '" + string + "'.");
    }

    private static String getFullVersionString(String string) throws IllegalArgumentException {
        int n = string.indexOf(40);
        return string.substring(0, n - 1).trim();
    }

    private static void printException(int n, String string) {
        if (db.on()) {
            db.println("Invalid version format: (" + n + ", " + string + ")");
        }
    }
}

