/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import cerent.launcher.CmsClassLoader;
import cerent.util.IDebugDiag;
import cerent.util.KDebug;
import com.cisco.ctc.core.CLURL;
import com.cisco.ctc.core.CLURLFactory;
import com.cisco.ctc.core.CacheLocator;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.ClassLoaderException;
import com.cisco.ctc.core.ClassLoaderKey;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.CoreReflectionUtil;
import com.cisco.ctc.core.DownloadArea;
import com.cisco.ctc.core.IClassPathExtender;
import com.cisco.ctc.core.INameVersion;
import com.cisco.ctc.core.INgrp;
import com.cisco.ctc.core.NETypeEnum;
import com.cisco.ctc.core.RetryableException;
import com.cisco.ctc.core.cache.CtcCachedFile;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractClassLoaderLocatingStrategy
extends CacheLocator
implements IDebugDiag {
    public static final WeakReference[] WeakReferenceArrayTemplate = new WeakReference[0];
    protected HashMap<ClassLoaderKey, WeakReference<ClassLoader>> clmap = new HashMap();
    protected HashSet<ClassLoaderKey> clCreationLocks = new HashSet();
    protected static INgrp sclNgrp = null;
    protected static String sclFullSwVersion = null;
    private static final String staticDbName = "CLLStrategy";
    protected static final KDebug staticDb = new KDebug("CLLStrategy");

    protected AbstractClassLoaderLocatingStrategy(KDebug kDebug) {
        super(kDebug);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClassLoaderKey acquireLock(ClassLoaderKey classLoaderKey) {
        if (classLoaderKey == null) {
            throw new IllegalArgumentException("acquireLock() requires a non-null key");
        }
        ClassLoaderKey classLoaderKey2 = null;
        HashSet<ClassLoaderKey> hashSet = this.clCreationLocks;
        synchronized (hashSet) {
            if (!this.clCreationLocks.contains(classLoaderKey)) {
                classLoaderKey2 = classLoaderKey;
                this.clCreationLocks.add(classLoaderKey);
            }
        }
        return classLoaderKey2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean releaseLock(ClassLoaderKey classLoaderKey) {
        if (classLoaderKey == null) {
            throw new IllegalArgumentException("acquireLock() requires a non-null key");
        }
        boolean bl = false;
        HashSet<ClassLoaderKey> hashSet = this.clCreationLocks;
        synchronized (hashSet) {
            bl = this.clCreationLocks.remove(classLoaderKey);
            if (!bl) {
                this.db.println("for lock: " + classLoaderKey + " remove() returned false. The caller did not have the lock acquired in the first place");
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassLoader findClassLoader(ClassLoaderEnum classLoaderEnum, Comparable comparable) {
        ClassLoader classLoader = null;
        ClassLoaderKey classLoaderKey = new ClassLoaderKey(classLoaderEnum, comparable);
        HashMap<ClassLoaderKey, WeakReference<ClassLoader>> hashMap = this.clmap;
        synchronized (hashMap) {
            WeakReference<ClassLoader> weakReference = this.clmap.get(classLoaderKey);
            classLoader = weakReference == null ? null : (ClassLoader)weakReference.get();
        }
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClassLoader[] getClassLoaders(ClassLoaderEnum classLoaderEnum) {
        ClassLoader[] classLoaderArray = null;
        HashMap<ClassLoaderKey, WeakReference<ClassLoader>> hashMap = this.clmap;
        synchronized (hashMap) {
            Set<ClassLoaderKey> set = this.clmap.keySet();
            int n = 0;
            for (ClassLoaderKey object : set) {
                if (object.getClassLoaderEnum() != classLoaderEnum && classLoaderEnum != null) continue;
                ++n;
            }
            classLoaderArray = new ClassLoader[n];
            int n2 = 0;
            for (ClassLoaderKey classLoaderKey : set) {
                if (classLoaderKey.getClassLoaderEnum() != classLoaderEnum && classLoaderEnum != null) continue;
                WeakReference<ClassLoader> weakReference = this.clmap.get(classLoaderKey);
                ClassLoader classLoader = weakReference == null ? null : (ClassLoader)weakReference.get();
                classLoaderArray[n2++] = classLoader;
            }
        }
        return classLoaderArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader[] getClassLoaders() {
        ClassLoader[] classLoaderArray = null;
        WeakReference[] weakReferenceArray = null;
        HashMap<ClassLoaderKey, WeakReference<ClassLoader>> hashMap = this.clmap;
        synchronized (hashMap) {
            weakReferenceArray = this.clmap.values().toArray(WeakReferenceArrayTemplate);
            classLoaderArray = new ClassLoader[weakReferenceArray.length];
            for (int i = 0; i < weakReferenceArray.length; ++i) {
                classLoaderArray[i] = (ClassLoader)weakReferenceArray[i].get();
            }
        }
        return classLoaderArray;
    }

    protected ClassLoader findClassLoader(ClassLoaderEnum classLoaderEnum) {
        return this.findClassLoader(classLoaderEnum, null);
    }

    protected ClassLoader addClassLoader(CacheLocator.RequestState requestState, ClassLoader classLoader) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassLoaderException {
        return this.addClassLoader(requestState, classLoader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassLoader addClassLoader(CacheLocator.RequestState requestState, ClassLoader classLoader, boolean bl) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassLoaderException {
        ClassLoader classLoader2 = null;
        ClassLoaderKey classLoaderKey = classLoader instanceof CmsClassLoader ? ((CmsClassLoader)classLoader).getClassLoaderKey() : new ClassLoaderKey(requestState.clEnum, requestState.neSwVersion);
        URL[] uRLArray = this.clmap;
        synchronized (this.clmap) {
            URL[] uRLArray2 = this.clmap.get(classLoaderKey);
            ClassLoader classLoader3 = classLoader2 = uRLArray2 == null ? null : (ClassLoader)uRLArray2.get();
            if (classLoader2 == null) {
                classLoader2 = classLoader;
                if (bl) {
                    this.applyExtensions(requestState, classLoader);
                }
                this.checkCreatedClassLoader(requestState, classLoader);
                if (this.db.on()) {
                    this.db.println(this.toString() + " adding CL w/ key: " + classLoaderKey + " CL: " + classLoader);
                }
                this.clmap.put(classLoaderKey, new WeakReference<ClassLoader>(classLoader));
                this.clmap.notifyAll();
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (this.db.isFinestEnabled() && classLoader instanceof URLClassLoader) {
                this.db.println("*** ClassLoader " + classLoader + " initialized with urls:");
                for (URL uRL : uRLArray = ((URLClassLoader)classLoader).getURLs()) {
                    this.db.println("  " + uRL);
                }
            }
            return classLoader2;
        }
    }

    protected void checkCreatedClassLoader(CacheLocator.RequestState requestState, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassLoaderException, IOException {
        ClassLoader classLoader2;
        if (!this.isSystemClassLoader(classLoader) && !this.isCompatible(classLoader2 = classLoader.getParent(), classLoader, requestState.clEnum)) {
            boolean bl = this.isSystemClassLoader(classLoader2);
            cvu.throwIncompatibleException("child CL: " + classLoader + " is incompatible with parent CL: " + classLoader2 + ": " + (bl ? this.getSystemSwVersion() : ((CmsClassLoader)classLoader2).getSwVersion()));
        }
    }

    final String getSystemSwVersion() {
        if (sclFullSwVersion == null) {
            INgrp iNgrp = this.getSystemNgrp();
            sclFullSwVersion = iNgrp.getFullVersionFormat();
        }
        return sclFullSwVersion;
    }

    final INgrp getSystemNgrp() {
        if (sclNgrp == null) {
            sclNgrp = cvu.getCTCBootstrapNgrp(CoreConstants.scl, ClassLoaderEnum.SYSTEM);
        }
        return sclNgrp;
    }

    protected boolean isCompatible(ClassLoader classLoader, ClassLoader classLoader2, ClassLoaderEnum classLoaderEnum) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return cvu.isCompatible(classLoader, classLoader2, classLoaderEnum);
    }

    protected boolean isSystemClassLoader(ClassLoader classLoader) {
        return CoreConstants.scl.equals(classLoader);
    }

    protected final Comparable getManifestComparable(ClassLoader classLoader) {
        Comparable comparable = null;
        if (this.isSystemClassLoader(classLoader)) {
            String string = this.getSystemSwVersion();
            comparable = this.getManifestComparable(string);
        } else if (classLoader instanceof CmsClassLoader) {
            CmsClassLoader cmsClassLoader = (CmsClassLoader)classLoader;
            String string = cmsClassLoader.getSwVersion();
            comparable = this.getManifestComparable(string);
        }
        return comparable;
    }

    protected final INgrp getManifestNgrp(ClassLoader classLoader) {
        INgrp iNgrp = null;
        if (this.isSystemClassLoader(classLoader)) {
            if (sclNgrp == null) {
                URL[] uRLArray;
                for (URL uRL : uRLArray = CoreConstants.scl.getURLs()) {
                    String string;
                    if (!uRL.getProtocol().equals("file") || (iNgrp = cvu.getSystemNgrp(string = uRL.getPath())) == null) continue;
                    sclNgrp = iNgrp;
                    return iNgrp;
                }
            }
            iNgrp = this.getSystemNgrp();
        } else if (classLoader instanceof CmsClassLoader) {
            iNgrp = cvu.getCTCBootstrapNgrp(classLoader, null);
        }
        return iNgrp;
    }

    protected final Comparable getManifestComparable(String string) {
        return string == null ? string : cvu.createManifestFullVersionOrdinal(string);
    }

    private INgrp checkSystemClassLoaderCache(CacheLocator.RequestState requestState) throws IOException, ClassLoaderException {
        String string;
        File file;
        INgrp iNgrp = this.getManifestNgrp(CoreConstants.scl);
        Comparable comparable = iNgrp.getManifestVersionOrdinal();
        if (requestState.systemVo == null) {
            requestState.systemVo = comparable;
        }
        boolean bl = !(file = new File(string = iNgrp.getManifestClassPath())).exists();
        boolean bl2 = file.isDirectory();
        if (bl2 && !requestState.isDownloadingPermitted) {
            return iNgrp;
        }
        boolean bl3 = !bl && !bl2 && file.getName().toLowerCase(Locale.ENGLISH).startsWith("ctclauncher");
        DownloadArea downloadArea = requestState.da;
        if (downloadArea != null) {
            das.addCoreMapping(comparable, downloadArea);
        }
        if (bl || bl3) {
            this.downloadLauncherIfNeeded(requestState);
        } else {
            CtcCachedFile ctcCachedFile = cm.retrieve(NETypeEnum.NE_DONT_CARE, ClassLoaderEnum.SYSTEM, comparable);
            if (ctcCachedFile == null) {
                if (this.db.on()) {
                    this.db.println("storing CP LAUNCHER: " + string + " into cache");
                }
                cm.store(file, NETypeEnum.NE_DONT_CARE, ClassLoaderEnum.SYSTEM, comparable, false);
                iNgrp = null;
            }
        }
        return iNgrp;
    }

    protected final void checkSystemClassLoader(CacheLocator.RequestState requestState) throws IOException, ClassLoaderException {
        this.checkSystemClassLoaderCache(requestState);
        String string = this.getSystemSwVersion();
        String string2 = requestState.neFullSwVersion;
        INgrp iNgrp = this.getManifestNgrp(CoreConstants.scl);
        Comparable comparable = iNgrp.getManifestVersionOrdinal();
        if (comparable != null && comparable.compareTo(requestState.neSwVersion) == 0 && string2 == null || string2 != null && !string2.equals(string)) {
            String string3 = "warning: NE " + requestState.getActualHostName() + " (API/SW vo:" + cvu.prettyDottedString(requestState.neSwVersion) + ") full version: " + string2 + " mismatches SCL/LAUNCHER (" + CoreConstants.scl + "/vo:" + cvu.prettyDottedString(comparable) + ") full version: " + string;
            this.db.println(string3);
            CmsClassLoader.setSystemWarning(new ClassLoaderException(string3));
        }
    }

    protected final URL[] downloadLauncherIfNeeded(CacheLocator.RequestState requestState) throws IOException, ClassLoaderException {
        URL uRL = this.getBootstrapJarURLFromCache(requestState.netype, requestState.clEnum, requestState.systemVo);
        if (uRL == null) {
            uRL = this.addBootstrapJarToCache(requestState);
        }
        URL[] uRLArray = new URL[]{uRL};
        return uRLArray;
    }

    protected final String getExtenderPreference(ClassLoader classLoader) {
        ClassLoaderEnum classLoaderEnum;
        ClassLoaderEnum classLoaderEnum2 = classLoader instanceof CmsClassLoader ? ((CmsClassLoader)classLoader).getClassLoaderEnum() : (classLoaderEnum = this.isSystemClassLoader(classLoader) ? ClassLoaderEnum.SYSTEM : null);
        if (classLoaderEnum == null) {
            throw new IllegalArgumentException("clEnum was null for CL: " + classLoader);
        }
        String string = classLoaderEnum.extenderPref;
        return string;
    }

    protected final URL[] getCustomExtensionClasspaths(CacheLocator.RequestState requestState, ClassLoader classLoader) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, ClassLoaderException {
        URL[] uRLArray;
        if (this.db.isFinerEnabled()) {
            this.db.finer("entering getCustomExtensionClasspaths() for: " + classLoader);
        }
        Class<?> clazz = null;
        String string = this.getExtenderPreference(classLoader);
        String string2 = CoreConstants.prefs.getProperty("ctc", string, null);
        if (string2 != null) {
            if (this.db.on()) {
                this.db.println("Custom extender class specified for " + (Object)((Object)requestState.clEnum) + ": " + string2);
            }
            try {
                clazz = classLoader.loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.db.println("Warning: could not load custom extender class: " + string2);
            }
        }
        if (clazz == null && (string2 = CoreConstants.prefs.getProperty("ctc", "classpath.extender", null)) != null) {
            try {
                clazz = classLoader.loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                KDebug.printStackTrace(classNotFoundException);
            }
        }
        if (clazz != null) {
            IClassPathExtender iClassPathExtender = CoreReflectionUtil.getExtender(clazz);
            uRLArray = this.toURLs(requestState, iClassPathExtender.getClassPath(classLoader));
        } else {
            uRLArray = null;
        }
        return uRLArray;
    }

    public final INameVersion[] getStandardExtensionNameVersions(ClassLoader classLoader, ClassLoaderEnum classLoaderEnum) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, ClassLoaderException {
        INameVersion[] iNameVersionArray;
        Class clazz;
        if (this.db.isFinerEnabled()) {
            this.db.finer("entering getStandardExtensionNameVersions() for: " + classLoader);
        }
        if ((clazz = CoreReflectionUtil.loadStandardExtenderClass(classLoader, classLoaderEnum)) != null) {
            IClassPathExtender iClassPathExtender = CoreReflectionUtil.getExtender(clazz);
            if (this.db.isFinestEnabled()) {
                this.db.finest("about to call getClassPath for extender: " + iClassPathExtender.getClass().getName());
            }
            iNameVersionArray = iClassPathExtender.getClassPath(classLoader);
            if (this.db.isFinestEnabled()) {
                this.db.finest("getClassPath() returned: " + iNameVersionArray.length + " NVs");
            }
        } else {
            iNameVersionArray = null;
        }
        return iNameVersionArray;
    }

    protected final URL[] getStandardExtensionClasspaths(CacheLocator.RequestState requestState, ClassLoader classLoader) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, ClassLoaderException {
        if (this.db.isFinerEnabled()) {
            this.db.finer("entering getStandardExtensionClasspaths() for: " + classLoader);
        }
        INameVersion[] iNameVersionArray = this.getStandardExtensionNameVersions(classLoader, requestState.clEnum);
        URL[] uRLArray = this.toURLs(requestState, iNameVersionArray);
        return uRLArray;
    }

    protected final void applyExtensions(CacheLocator.RequestState requestState, ClassLoader classLoader) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassLoaderException {
        block8: {
            if (classLoader instanceof URLClassLoader) {
                URL[] uRLArray;
                URLClassLoader uRLClassLoader;
                block7: {
                    uRLClassLoader = (URLClassLoader)classLoader;
                    try {
                        uRLArray = this.getCustomExtensionClasspaths(requestState, classLoader);
                        AbstractClassLoaderLocatingStrategy.addURLs(uRLClassLoader, uRLArray);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!this.db.on()) break block7;
                        this.db.println("no CUSTOM CP extension class found for: " + classLoader);
                    }
                }
                try {
                    uRLArray = this.getStandardExtensionClasspaths(requestState, classLoader);
                    AbstractClassLoaderLocatingStrategy.addURLs(uRLClassLoader, uRLArray);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (this.isSystemClassLoader(classLoader)) {
                        this.db.println("The SCL " + classLoader + " must have a CP extension class even if it does nothing");
                        throw classNotFoundException;
                    }
                    if (this.db.on()) {
                        this.db.println("no STANDARD CP extension class found for: " + classLoader);
                    }
                    break block8;
                }
            }
            throw new IllegalArgumentException("cannot handle non-URLClassLoader: " + (classLoader == null ? "null" : classLoader.getClass().getName()));
        }
    }

    private static void addURLs(URLClassLoader uRLClassLoader, URL[] uRLArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (uRLArray != null) {
            for (URL uRL : uRLArray) {
                if (uRL == null) continue;
                CmsClassLoader.addURL(uRLClassLoader, uRL);
            }
        }
    }

    protected final boolean isCoreClassLoader(ClassLoader classLoader) {
        return classLoader instanceof CmsClassLoader || this.isSystemClassLoader(classLoader);
    }

    protected final ClassLoader lookupParent(ClassLoaderEnum classLoaderEnum, Comparable comparable) throws ClassLoaderException {
        ClassLoaderEnum classLoaderEnum2 = classLoaderEnum.parent;
        Comparable comparable2 = cvu.createVersionOrdinal(classLoaderEnum2, comparable);
        ClassLoader classLoader = this.findClassLoader(classLoaderEnum2, comparable2);
        if (classLoader == null) {
            throw new ClassLoaderException("Could not find parent CL: " + (Object)((Object)classLoaderEnum2) + " (vo: " + comparable2 + ")" + " for requested CL: " + (Object)((Object)classLoaderEnum));
        }
        return classLoader;
    }

    protected final void checkParentClassLoaderAgainstNe(ClassLoaderEnum classLoaderEnum, Comparable comparable, boolean bl) throws ClassLoaderException {
        if (classLoaderEnum != ClassLoaderEnum.SYSTEM) {
            ClassLoader classLoader = this.lookupParent(classLoaderEnum, comparable);
            cvu.checkParentClassLoaderAgainstNe(classLoader, comparable, bl);
        }
    }

    protected void checkParentClassLoaderAgainstNe(ClassLoaderEnum classLoaderEnum, Comparable comparable) throws ClassLoaderException {
        this.checkParentClassLoaderAgainstNe(classLoaderEnum, comparable, false);
    }

    protected ClassLoader lookupClassLoader(CacheLocator.RequestState requestState) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ClassLoader classLoader = this.findClassLoader(requestState.clEnum, requestState.neSwVersion);
        if (classLoader != null && this.db.on()) {
            this.db.println(this.toString() + " found CL: " + classLoader + " in the map");
        }
        return classLoader;
    }

    public ClassLoader locateClassLoader(String string, NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassLoaderException, RetryableException {
        return this.locateClassLoader(string, nETypeEnum, classLoaderEnum, comparable, null);
    }

    public ClassLoader locateClassLoader(String string, NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable, Comparable comparable2) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassLoaderException, RetryableException {
        if (testmode && this.db.on()) {
            this.db.println("CLL strategy testmode is on");
        }
        if (this.db.isFinerEnabled()) {
            this.db.finer("entering locateClassLoader()");
        }
        CacheLocator.RequestState requestState = this.createRequestState(string, nETypeEnum, classLoaderEnum, comparable, comparable2);
        return this.locateClassLoader(string, nETypeEnum, classLoaderEnum, comparable, comparable2, requestState);
    }

    protected ClassLoader locateClassLoader(String string, NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable, Comparable comparable2, CacheLocator.RequestState requestState) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassLoaderException, RetryableException {
        ClassLoader classLoader = this.lookupClassLoader(requestState);
        if (classLoader != null) {
            return classLoader;
        }
        if (classLoaderEnum.equals((Object)ClassLoaderEnum.SYSTEM)) {
            this.checkSystemClassLoader(requestState);
            classLoader = this.addClassLoader(requestState, CoreConstants.scl);
            return classLoader;
        }
        if (this.db.isFinerEnabled()) {
            this.db.finer("trying CLURL prefs");
        }
        CLURL cLURL = new CLURL(classLoaderEnum, nETypeEnum, comparable);
        URL[] uRLArray = CLURLFactory.instance().getClassPaths(cLURL);
        if (uRLArray != null && uRLArray.length > 0) {
            if (this.db.on()) {
                this.db.println("using clurl config to completely define the CP for: " + (Object)((Object)classLoaderEnum));
            }
            ClassLoader classLoader2 = this.lookupParent(classLoaderEnum, comparable);
            CmsClassLoader cmsClassLoader = new CmsClassLoader(classLoaderEnum, comparable, uRLArray, classLoader2);
            classLoader = this.addClassLoader(requestState, cmsClassLoader, false);
        }
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitToRetry(long l) throws InterruptedException {
        HashMap<ClassLoaderKey, WeakReference<ClassLoader>> hashMap = this.clmap;
        synchronized (hashMap) {
            this.clmap.wait(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeClassLoader(ClassLoader classLoader) {
        boolean bl = classLoader instanceof CmsClassLoader;
        if (bl) {
            CmsClassLoader cmsClassLoader = (CmsClassLoader)classLoader;
            ClassLoaderKey classLoaderKey = cmsClassLoader.getClassLoaderKey();
            HashMap<ClassLoaderKey, WeakReference<ClassLoader>> hashMap = this.clmap;
            synchronized (hashMap) {
                bl = this.clmap.remove(classLoaderKey) != null;
                this.clmap.notifyAll();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpDiag() {
        HashMap<ClassLoaderKey, WeakReference<ClassLoader>> hashMap = this.clmap;
        synchronized (hashMap) {
            ArrayList<ClassLoaderKey> arrayList = new ArrayList<ClassLoaderKey>(this.clmap.keySet());
            Collections.sort(arrayList);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ClassLoaderKey classLoaderKey = arrayList.get(i);
                WeakReference<ClassLoader> weakReference = this.clmap.get(classLoaderKey);
                ClassLoader classLoader = weakReference == null ? null : (ClassLoader)weakReference.get();
                this.db.println(Integer.toString(i) + " - CL key: " + classLoaderKey + " => " + classLoader);
            }
        }
    }
}

