/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.download;

import cerent.util.KDebug;
import cerent.util.Preferences;
import com.cisco.ctc.core.download.ITransferer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Observable;

public abstract class AbstractTransferer
extends Observable
implements ITransferer {
    public static final SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    public static final Preferences prefs = Preferences.instance();
    protected KDebug db;
    private ThreadHolder threadHolder;
    protected boolean abort;
    protected boolean aborted;
    private State state = State.INITIAL;

    protected AbstractTransferer(KDebug kDebug) {
        this(null, kDebug);
    }

    protected AbstractTransferer(ThreadHolder threadHolder, KDebug kDebug) {
        if (kDebug == null) {
            throw new IllegalArgumentException("debug instance must be non-null");
        }
        this.db = kDebug;
        this.threadHolder = threadHolder;
    }

    public ThreadHolder getThreadHolder() {
        return this.threadHolder;
    }

    @Override
    public boolean getAbort() {
        return this.abort;
    }

    @Override
    public boolean getAborted() {
        return this.aborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAbort(boolean bl) {
        if (bl && this.abort != bl) {
            this.abort = bl;
            if (this.threadHolder != null) {
                ThreadHolder threadHolder = this.threadHolder;
                synchronized (threadHolder) {
                    Thread thread;
                    Thread thread2 = this.threadHolder.unsynchronizedGetThread();
                    if (thread2 != null && !thread2.equals(thread = Thread.currentThread())) {
                        thread2.interrupt();
                    }
                }
            }
        }
    }

    protected void log(Throwable throwable) {
        KDebug.printStackTrace(throwable);
    }

    protected void log(String string, Throwable throwable) {
        this.db.println(string);
        KDebug.printStackTrace(throwable);
    }

    protected void logAndThrow(RuntimeException runtimeException) throws RuntimeException {
        KDebug.printStackTrace(runtimeException);
        throw runtimeException;
    }

    protected void logAndThrow(String string, RuntimeException runtimeException) throws RuntimeException {
        this.db.println(string);
        KDebug.printStackTrace(runtimeException);
        throw runtimeException;
    }

    protected void logAndThrow(IOException iOException) throws IOException {
        KDebug.printStackTrace(iOException);
        throw iOException;
    }

    protected void logAndThrow(String string, IOException iOException) throws IOException {
        this.db.println(string);
        KDebug.printStackTrace(iOException);
        throw iOException;
    }

    protected void log(String string) {
        this.db.println(string);
    }

    protected void logFiner(String string) {
        this.db.finer(string);
    }

    protected void logFinest(String string) {
        this.db.finest(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transfer(Object object, Object object2, Object object3) throws IOException {
        Object object4;
        Date date = new Date();
        String string = sdf.format(date);
        this.logFiner(string + " start transfer...");
        Exception exception = null;
        try {
            object4 = this.preTransferInput(object);
            OutputStream outputStream = this.preTransferOutput(object2);
            this.startTransfer((InputStream)object4, outputStream);
        }
        catch (RuntimeException runtimeException) {
            if (this.getAbort() && Thread.currentThread().isInterrupted()) {
                this.aborted = true;
            }
            this.logAndThrow(runtimeException);
        }
        catch (IOException iOException) {
            exception = iOException;
            if (this.getAbort() && Thread.currentThread().isInterrupted()) {
                this.aborted = true;
            }
            this.logAndThrow(iOException);
        }
        finally {
            try {
                this.endTransfer(object3);
            }
            catch (RuntimeException runtimeException) {
                exception = runtimeException;
                this.logAndThrow(runtimeException);
            }
            catch (IOException iOException) {
                exception = iOException;
                this.logAndThrow(iOException);
            }
            finally {
                if (exception == null) {
                    this.notify(Long.MAX_VALUE);
                }
                this.deleteObservers();
            }
        }
        object4 = new Date();
        string = sdf.format((Date)object4);
        this.logFiner(string + " end transfer..." + (((Date)object4).getTime() - date.getTime()) + " msecs");
    }

    @Override
    public final void transfer(Object object, Object object2) throws IOException {
        this.transfer(object, object2, null);
    }

    public final void preTransferInput() throws IOException {
        this.preTransferInput(null);
    }

    public final void preTransferOutput() throws IOException {
        this.preTransferOutput(null);
    }

    public final void startTransfer() throws IOException {
        this.startTransfer(null, null);
    }

    public final void endTransfer() throws IOException {
        this.startTransfer(null, null);
    }

    @Override
    public final void transfer() throws IOException {
        this.transfer(null, null);
    }

    protected final void assertState(boolean bl, String string) {
        if (!bl) {
            this.logAndThrow(new IllegalStateException(string));
        }
    }

    protected final void checkNotState(int n, State state) {
        int n2 = n & this.state.value;
        this.assertState(n2 == 0, "notState cannot overlap the curr. state: " + n2);
        this.state = state;
    }

    protected final void checkState(int n, State state) {
        int n2 = n & this.state.value;
        this.assertState(n2 == n, "Specified state:" + n + " must overlap the current state: " + (Object)((Object)this.state));
    }

    protected void checkPreTransferInputState() {
        this.checkNotState(State.END_TRANSFER.value | State.START_TRANSFER.value | State.PRE_TRANSFER_INPUT.value, State.PRE_TRANSFER_INPUT);
    }

    protected void checkPreTransferOutputState() {
        this.checkNotState(State.END_TRANSFER.value | State.START_TRANSFER.value | State.PRE_TRANSFER_OUTPUT.value, State.PRE_TRANSFER_OUTPUT);
    }

    protected void checkStartTransferState() {
        this.checkNotState(State.END_TRANSFER.value | State.START_TRANSFER.value, State.START_TRANSFER);
    }

    protected void checkEndTransferState() {
        this.checkNotState(State.END_TRANSFER.value, State.END_TRANSFER);
    }

    @Override
    public float getEstimatedCompressionRatio() {
        return 1.0f;
    }

    protected void streamCopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.streamCopy(inputStream, outputStream, 1024, 1);
    }

    protected final void streamCopy(InputStream inputStream, OutputStream outputStream, int n, int n2) throws IOException {
        if (n2 <= 0) {
            n2 = 1;
        }
        byte[] byArray = new byte[n];
        long l = 0L;
        int n3 = 0;
        int n4 = 0;
        while (!this.abort && (n3 = inputStream.read(byArray, 0, byArray.length)) > 0) {
            outputStream.write(byArray, 0, n3);
            l += (long)n3;
            if (n4 > 0 && n4 % n2 == 0) {
                this.notify(l);
            }
            ++n4;
        }
        if (this.abort && (l == 0L || n3 != 0)) {
            this.aborted = true;
        }
    }

    protected void notify(long l) {
        if (l != Long.MAX_VALUE) {
            l = this.modifyLongNotification(l);
        }
        if (this.db.isFinestEnabled()) {
            this.db.println("notifying of: " + l);
        }
        this.setChanged();
        this.notifyObservers(new Long(l));
    }

    protected long modifyLongNotification(long l) {
        return l;
    }

    @Override
    public abstract InputStream preTransferInput(Object var1) throws IOException;

    @Override
    public abstract OutputStream preTransferOutput(Object var1) throws IOException;

    @Override
    public abstract void startTransfer(InputStream var1, OutputStream var2) throws IOException;

    @Override
    public abstract void endTransfer(Object var1) throws IOException;

    public static enum State {
        INITIAL(0),
        PRE_TRANSFER_INPUT(1),
        PRE_TRANSFER_OUTPUT(2),
        START_TRANSFER(4),
        END_TRANSFER(8);

        public final int value;

        private State(int n2) {
            this.value = n2;
        }
    }

    static class ThreadHolder {
        private Thread currentThread;

        ThreadHolder() {
        }

        public Thread unsynchronizedGetThread() {
            return this.currentThread;
        }

        public void unsynchronizedSetThread(Thread thread) {
            this.currentThread = thread;
        }
    }
}

