/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.download;

import cerent.util.KDebug;
import com.cisco.ctc.core.download.AbstractTransferer;
import com.cisco.ctc.core.download.FilePack200Unpacker;
import com.cisco.ctc.core.download.GZIPFilePack200Unpacker;
import com.cisco.ctc.core.download.GZIPStreamDecompressor;
import com.cisco.ctc.core.download.ITransfererFactory;
import com.cisco.ctc.core.download.JarTransferEnum;
import com.cisco.ctc.core.download.StreamDecompressor;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumMap;
import java.util.zip.GZIPInputStream;

public class DecompressingTransfererFactory {
    private static DecompressingTransfererFactory instance = new DecompressingTransfererFactory();
    private EnumMap<JarTransferEnum.Type, ITransfererFactory> creators = new EnumMap(JarTransferEnum.Type.class);
    private static Class GZIPStreamDecompressorClass = GZIPStreamDecompressor.class;
    private static Class StreamDecompressorClass = StreamDecompressor.class;
    private static Class Pack200UnpackerClass = FilePack200Unpacker.class;
    private static Class GZIPPack200UnpackerClass = GZIPFilePack200Unpacker.class;
    static KDebug db = new KDebug("DecompressingTransfererFactory");

    private DecompressingTransfererFactory() {
    }

    public static DecompressingTransfererFactory instance() {
        return instance;
    }

    protected void log(String string) {
        db.println(string);
    }

    protected void finer(String string) {
        db.finer(string);
    }

    void registerTransfererFactory(JarTransferEnum.Type type, ITransfererFactory iTransfererFactory) {
        ITransfererFactory iTransfererFactory2 = this.creators.put(type, iTransfererFactory);
        if (iTransfererFactory2 != null && db.on()) {
            this.log("overwriting existing transferer factory: " + iTransfererFactory2 + " with" + iTransfererFactory + " for: " + (Object)((Object)type));
        }
    }

    public AbstractTransferer createDecompressor(JarTransferEnum.Type type, Object ... objectArray) {
        ITransfererFactory iTransfererFactory = this.creators.get((Object)type);
        AbstractTransferer abstractTransferer = null;
        if (iTransfererFactory != null) {
            abstractTransferer = iTransfererFactory.createTransferer(objectArray);
            if (db.isFinerEnabled()) {
                this.finer(iTransfererFactory + " created: " + abstractTransferer);
            }
        } else {
            this.log("error: no factory exists for: " + (Object)((Object)type));
        }
        return abstractTransferer;
    }

    public AbstractTransferer createDecompressor(Class clazz, Object ... objectArray) {
        AbstractTransferer abstractTransferer = null;
        if (clazz == null) {
            abstractTransferer = this.createDecompressor(JarTransferEnum.Type.NONE, objectArray);
        } else if (GZIPInputStream.class.isAssignableFrom(clazz)) {
            abstractTransferer = this.createDecompressor(JarTransferEnum.Type.GZIP_ONLY, objectArray);
        }
        return abstractTransferer;
    }

    private static StreamDecompressor createStreamDecompressor(boolean bl, Object ... objectArray) {
        Class clazz = bl ? GZIPStreamDecompressorClass : StreamDecompressorClass;
        return (StreamDecompressor)DecompressingTransfererFactory.newInstance(clazz, objectArray);
    }

    private static FilePack200Unpacker createPack200Unpacker(boolean bl, Object ... objectArray) {
        Class clazz = bl ? GZIPPack200UnpackerClass : Pack200UnpackerClass;
        return (FilePack200Unpacker)DecompressingTransfererFactory.newInstance(clazz, objectArray);
    }

    private static Object newInstance(Class clazz, Object ... objectArray) {
        Object var2_2 = null;
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class[] classArray = DecompressingTransfererFactory.getArgTypes(objectArray);
            Constructor constructor = clazz.getConstructor(classArray);
            var2_2 = constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            reflectiveOperationException = invocationTargetException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            reflectiveOperationException = noSuchMethodException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            KDebug.printStackTrace(reflectiveOperationException);
        }
        return var2_2;
    }

    private static Class[] getArgTypes(Object ... objectArray) {
        int n = objectArray == null ? 0 : objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            Class clazz = classArray[i] = object == null ? Object.class : object.getClass();
            if (!InputStream.class.isAssignableFrom(classArray[i])) continue;
            classArray[i] = InputStream.class;
        }
        return classArray;
    }

    static {
        DecompressingTransfererFactory decompressingTransfererFactory = DecompressingTransfererFactory.instance();
        decompressingTransfererFactory.registerTransfererFactory(JarTransferEnum.Type.NONE, new ITransfererFactory(){

            @Override
            public AbstractTransferer createTransferer(Object ... objectArray) {
                return DecompressingTransfererFactory.createStreamDecompressor(false, objectArray);
            }
        });
        decompressingTransfererFactory.registerTransfererFactory(JarTransferEnum.Type.JAR, new ITransfererFactory(){

            @Override
            public AbstractTransferer createTransferer(Object ... objectArray) {
                return DecompressingTransfererFactory.createStreamDecompressor(false, objectArray);
            }
        });
        decompressingTransfererFactory.registerTransfererFactory(JarTransferEnum.Type.JAR_NO_NETYPE, new ITransfererFactory(){

            @Override
            public AbstractTransferer createTransferer(Object ... objectArray) {
                return DecompressingTransfererFactory.createStreamDecompressor(false, objectArray);
            }
        });
        decompressingTransfererFactory.registerTransfererFactory(JarTransferEnum.Type.GZIP_ONLY, new ITransfererFactory(){

            @Override
            public AbstractTransferer createTransferer(Object ... objectArray) {
                return DecompressingTransfererFactory.createStreamDecompressor(true, objectArray);
            }

            public String toString() {
                return "GZIP-only stream decompressor factory";
            }
        });
        decompressingTransfererFactory.registerTransfererFactory(JarTransferEnum.Type.GZIP_ONLY_WITH_NE_TYPE, new ITransfererFactory(){

            @Override
            public AbstractTransferer createTransferer(Object ... objectArray) {
                return DecompressingTransfererFactory.createStreamDecompressor(true, objectArray);
            }

            public String toString() {
                return "GZIP-only (with NE type) stream decompressor factory";
            }
        });
        decompressingTransfererFactory.registerTransfererFactory(JarTransferEnum.Type.PACK200_ONLY, new ITransfererFactory(){

            @Override
            public AbstractTransferer createTransferer(Object ... objectArray) {
                return DecompressingTransfererFactory.createPack200Unpacker(false, objectArray);
            }
        });
        decompressingTransfererFactory.registerTransfererFactory(JarTransferEnum.Type.PACK200_AND_GZIP, new ITransfererFactory(){

            @Override
            public AbstractTransferer createTransferer(Object ... objectArray) {
                return DecompressingTransfererFactory.createPack200Unpacker(true, objectArray);
            }
        });
    }
}

