/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.download;

import cerent.util.KDebug;
import com.cisco.ctc.core.download.AbstractPacker;
import com.cisco.ctc.core.download.AbstractTransferer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;

public class FilePack200Packer
extends AbstractPacker {
    protected File file;
    protected JarInputStream jis;
    protected InputStream ownedIs;
    protected OutputStream os;
    protected static KDebug db = new KDebug("FilePack200Packer");

    public FilePack200Packer(File file) {
        this(file, db);
    }

    public FilePack200Packer(File file, KDebug kDebug) {
        super(kDebug);
        this.file = file;
    }

    public JarInputStream getJarInputStream() {
        return this.jis;
    }

    @Override
    public InputStream preTransferInput(Object object) throws IOException {
        this.checkPreTransferInputState();
        if (object instanceof JarInputStream) {
            this.jis = (JarInputStream)object;
            this.ownedIs = this.jis;
        } else if (object instanceof InputStream) {
            this.jis = new JarInputStream((InputStream)object);
            this.ownedIs = this.jis;
        } else if (object == null) {
            this.fileInSize = this.file.length();
            FileInputStream fileInputStream = new FileInputStream(this.file);
            this.jis = new JarInputStream(fileInputStream);
        } else {
            this.logAndThrow(new IllegalArgumentException("cannot handle arg: " + (object == null ? "null" : object.getClass().getName())));
        }
        return this.getJarInputStream();
    }

    @Override
    public OutputStream preTransferOutput(Object object) throws IOException {
        this.checkPreTransferOutputState();
        if (!(object instanceof File)) {
            throw new IllegalArgumentException("cannot handle arg: " + (object == null ? "null" : object.getClass().getName()));
        }
        File file = (File)object;
        this.os = new FileOutputStream(file);
        return this.os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTransfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        block21: {
            this.checkStartTransferState();
            AbstractTransferer.ThreadHolder threadHolder = this.getThreadHolder();
            try {
                Object object = threadHolder;
                synchronized (object) {
                    threadHolder.unsynchronizedSetThread(Thread.currentThread());
                }
                Object object2 = object = this.os != null ? this.os : outputStream;
                if (db.on()) {
                    db.println("Pack 200 packing..." + object.getClass().getName());
                }
                this.setRequestedSegmentLimit();
                if (this.jis != null) {
                    this.getPacker().pack(this.jis, (OutputStream)object);
                } else {
                    this.getPacker().pack(new JarFile(this.file), (OutputStream)object);
                }
            }
            catch (IOException iOException) {
                db.println("got Pack200 IO exception: " + iOException.getClass().getName());
                if (this.abort) {
                    this.aborted = true;
                    break block21;
                }
                throw iOException;
            }
            finally {
                AbstractTransferer.ThreadHolder threadHolder2 = threadHolder;
                synchronized (threadHolder2) {
                    threadHolder.unsynchronizedSetThread(null);
                }
            }
        }
    }

    @Override
    public void endTransfer(Object object) throws IOException {
        this.checkEndTransferState();
        if (this.ownedIs != null) {
            this.ownedIs.close();
        }
        this.os.close();
    }
}

