/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.launcher;

import com.cisco.ctc.core.launcher.JreProperties;
import com.cisco.ctc.core.launcher.LauncherSettingsDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class JvmSettings
extends JPanel
implements DocumentListener {
    private ExtTextField maxHeapFld = null;
    private boolean dirty = false;
    private JreProperties jp = JreProperties.instance();
    private LauncherSettingsDialog parent = null;

    public JvmSettings(LauncherSettingsDialog launcherSettingsDialog) {
        this.parent = launcherSettingsDialog;
        this.setLayout(null);
        JLabel jLabel = new JLabel("The heap size must be smaller than the total");
        jLabel.setSize(300, 20);
        jLabel.setLocation(20, 15);
        this.add(jLabel);
        JLabel jLabel2 = new JLabel("system physical memory.");
        jLabel2.setSize(300, 20);
        jLabel2.setLocation(20, 35);
        this.add(jLabel2);
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setSize(300, 5);
        jSeparator.setLocation(20, 60);
        this.add(jSeparator);
        JLabel jLabel3 = new JLabel("Maximum Java Heap Size (MB):");
        jLabel3.setSize(220, 20);
        jLabel3.setLocation(20, 90);
        this.add(jLabel3);
        this.maxHeapFld = new ExtTextField(8);
        this.maxHeapFld.setSize(100, 20);
        this.maxHeapFld.setLocation(jLabel3.getWidth(), 90);
        this.maxHeapFld.getDocument().addDocumentListener(this);
        this.add(this.maxHeapFld);
        this.load();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        this.parent.setDirty(bl);
    }

    public void load() {
        this.maxHeapFld.setText(Integer.toString(this.jp.getMaxHeap()));
        this.setDirty(false);
    }

    public int store() {
        String string = this.maxHeapFld.getText().trim();
        if (string.equals("")) {
            String string2 = "Maximum Java Heap Size cannot be empty.\nPlease enter again.";
            JOptionPane.showMessageDialog(this, string2, "Error", 0);
            return -1;
        }
        int n = Integer.parseInt(string);
        if (n < 256 || n > 2048) {
            String string3 = "Maximum Java Heap Size cannot be less than 256 or greater than 2048.\nPlease enter again.";
            JOptionPane.showMessageDialog(this, string3, "Error", 0);
            return -1;
        }
        this.jp.setMaxHeap(n);
        return 0;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty(true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    class ExtTextField
    extends JTextField {
        private static final String DIGIT_FORMAT = "0123456789";

        public ExtTextField(int n) {
            super(n);
        }

        @Override
        protected Document createDefaultModel() {
            return new DigitDocument();
        }

        class DigitDocument
        extends PlainDocument {
            DigitDocument() {
            }

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string == null) {
                    return;
                }
                boolean bl = true;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (ExtTextField.DIGIT_FORMAT.indexOf(c) != -1) continue;
                    bl = false;
                }
                if (bl) {
                    super.insertString(n, string, attributeSet);
                }
            }
        }
    }
}

