/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.launcher;

import cerent.util.KDebug;
import cerent.util.Preferences;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.launcher.Launcher;
import com.cisco.ctc.core.launcher.LauncherSettingsDialog;
import com.cisco.ctc.core.launcher.LocalLauncher;
import com.cisco.ctc.ui.CUESLoginWindow;
import com.cisco.ctc.ui.CUESSplashWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class LocalLauncherAttributesPane
extends JPanel
implements ActionListener,
DocumentListener,
KeyListener {
    public static final Dimension ATTR_PANE_DIM = new Dimension(320, 200);
    protected static final String RADIO_SELECTED_IMG = "/images/radio_button_selected.gif";
    protected static final String RADIO_DESELECTED_IMG = "/images/radio_button_deselected.gif";
    private static final String LATEST_CTC_VER = "Latest version available";
    private static final String LOGIN_NE_CTC_VER = "Same version as the login node";
    private static final String CTCSEL_PREF = "version.sel.mode";
    private static final String CTCSELVER_PREF = "version.sel.value";
    private static final String PREFIX = "ctc";
    private static final String SOTL1_PREF = "sotl1";
    private static final String NELIST_PREF = "nelist";
    private static final String NELIST_SIZE_PREF = "nelist.size";
    private static final int NELIST_MIN_SIZE = 10;
    private static final ICoreVersionUtil cvu = CoreVersionUtil.instance();
    private Preferences prefs = Preferences.instance();
    private JButton settingBtn = null;
    private JButton launchCtcBtn = null;
    private JButton cancelButton = null;
    private JRadioButton ipOptionBtn = null;
    private JRadioButton tl1OptionBtn = null;
    private JComboBox nodeCombo = null;
    private JComboBox versionCombo = null;
    private ButtonGroup optionGroup = null;
    private LocalLauncher parent = null;
    private Comparable[] ctcVersions = null;
    private Launcher.CtcVersionSelection lastSelMode = null;
    public int neListMaxSize = 0;
    protected Image chkSelImg = null;
    protected Image chkDeselImg = null;

    public LocalLauncherAttributesPane(LocalLauncher localLauncher) {
        this.parent = localLauncher;
        try {
            URL uRL = CUESSplashWindow.class.getResource(RADIO_SELECTED_IMG);
            this.chkSelImg = Toolkit.getDefaultToolkit().getImage(uRL);
            URL uRL2 = CUESSplashWindow.class.getResource(RADIO_DESELECTED_IMG);
            this.chkDeselImg = Toolkit.getDefaultToolkit().getImage(uRL2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init();
    }

    private void init() {
        this.setLayout(null);
        this.setBackground(CUESLoginWindow.GREEN_COLOR);
        this.setSize(this.getPreferredSize());
        this.optionGroup = new ButtonGroup();
        this.add(this.createConnectionModePane());
        this.add(this.createVersionSelectionPane());
        this.settingBtn = this.createButton("Setting...", this.getSettingButtonPoint().x, this.getSettingButtonPoint().y, 65, true);
        this.add(this.settingBtn);
        this.launchCtcBtn = this.createButton("Launch CTC...", this.getLaunchCtcButtonPoint().x, this.getLaunchCtcButtonPoint().y, 96, true);
        this.add(this.launchCtcBtn);
        this.cancelButton = this.createButton("Cancel", this.getCancelButtonPoint().x, this.getCancelButtonPoint().y, 55, true);
        this.add(this.cancelButton);
        this.setLocation(this.parent.getProductNameArea().width + this.parent.getPhotoDimension().width, this.parent.getProductNameArea().y);
    }

    private JPanel createConnectionModePane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setLocation(10, 5);
        jPanel.setSize(250, 95);
        jPanel.setBackground(CUESLoginWindow.GREEN_COLOR);
        jPanel.setBorder(BorderFactory.createTitledBorder(null, "Connection Mode", 0, 0, new Font("Arial", 0, 12), Color.white));
        this.ipOptionBtn = this.createOptionButton("Use IP", jPanel.getX(), jPanel.getY() + 13, true);
        jPanel.add(this.ipOptionBtn);
        jPanel.add(this.createLabel("Node"));
        this.nodeCombo = this.createComboBox(137, jPanel.getX() + 85, 41, true);
        jPanel.add(this.nodeCombo);
        this.tl1OptionBtn = this.createOptionButton("Use TL1 Tunnel", jPanel.getX(), jPanel.getY() + 60, false);
        jPanel.add(this.tl1OptionBtn);
        return jPanel;
    }

    private JPanel createVersionSelectionPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setLocation(10, 103);
        jPanel.setSize(250, 50);
        jPanel.setBackground(CUESLoginWindow.GREEN_COLOR);
        jPanel.setBorder(BorderFactory.createTitledBorder(null, "CTC Version Selection", 0, 0, new Font("Arial", 0, 12), Color.white));
        this.versionCombo = this.createComboBox(217, jPanel.getX() + 5, 18, false);
        jPanel.add(this.versionCombo);
        return jPanel;
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setLocation(45, 40);
        jLabel.setSize(40, 22);
        jLabel.setForeground(Color.white);
        jLabel.setFont(new Font("Arial", 0, 12));
        return jLabel;
    }

    private JComboBox createComboBox(int n, int n2, int n3, boolean bl) {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setSize(n, 20);
        jComboBox.setLocation(n2, n3);
        jComboBox.setEditable(bl);
        jComboBox.setFont(new Font("Arial", 0, 12));
        jComboBox.addActionListener(this);
        Component component = jComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.getDocument().addDocumentListener(this);
        }
        return jComboBox;
    }

    private JRadioButton createOptionButton(String string, int n, int n2, boolean bl) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.setSelectedIcon(new ImageIcon(this.chkSelImg));
        jRadioButton.setIcon(new ImageIcon(this.chkDeselImg));
        jRadioButton.setSize(145, 22);
        jRadioButton.setLocation(n, n2);
        jRadioButton.setSelected(bl);
        jRadioButton.setFont(new Font("Arial", 0, 12));
        jRadioButton.setFocusPainted(false);
        jRadioButton.setForeground(Color.white);
        jRadioButton.setBackground(this.getBackground());
        jRadioButton.addActionListener(this);
        this.optionGroup.add(jRadioButton);
        return jRadioButton;
    }

    protected JButton createButton(String string, int n, int n2, int n3, boolean bl) {
        JButton jButton = new JButton(string);
        jButton.setHorizontalTextPosition(10);
        jButton.setMargin(new Insets(5, 1, 5, 2));
        jButton.setFont(new Font("Arial", 0, 12));
        jButton.setEnabled(bl);
        jButton.setSize(n3, 22);
        jButton.setLocation(n, n2);
        jButton.addActionListener(this);
        return jButton;
    }

    public JButton getDefaultButton() {
        return this.launchCtcBtn;
    }

    private void prepareLaunchCTC() {
        this.savePreferences();
        this.parent.prepareLaunchCTC();
    }

    private void processVersionSelection() {
        if (this.getCtcVersionSelectionMode() == Launcher.CtcVersionSelection.SELECTED_VERSION) {
            Comparable comparable;
            Comparable comparable2 = this.getSelectedCtcVersion();
            if (comparable2.compareTo(comparable = cvu.createNeVersionOrdinal("06.00-00")) < 0) {
                this.tl1OptionBtn.setEnabled(false);
                this.ipOptionBtn.setSelected(true);
            } else {
                this.tl1OptionBtn.setEnabled(true);
            }
        } else {
            this.tl1OptionBtn.setEnabled(true);
        }
    }

    private void processCacheSetting() {
        LauncherSettingsDialog launcherSettingsDialog = new LauncherSettingsDialog(new JFrame());
        if (launcherSettingsDialog.showSettings()) {
            this.initCbCtcVersion();
        }
    }

    public void setAttributeEnabled() {
        if (this.ipOptionBtn.isSelected()) {
            if (this.parent.getLaunchThread() == null) {
                this.nodeCombo.setEnabled(true);
                String string = (String)this.nodeCombo.getSelectedItem();
                if (string != null) {
                    this.launchCtcBtn.setEnabled(string.length() > 0);
                }
            } else {
                this.nodeCombo.setEnabled(false);
                this.launchCtcBtn.setEnabled(false);
            }
            this.nodeCombo.setEnabled(true);
            this.nodeCombo.requestFocus();
        } else if (this.parent.getLaunchThread() == null) {
            this.nodeCombo.setEnabled(false);
            this.launchCtcBtn.setEnabled(true);
        }
    }

    public void loadPreferences() {
        String[] stringArray;
        boolean bl = this.prefs.getBoolean(PREFIX, SOTL1_PREF, false);
        this.tl1OptionBtn.setSelected(bl);
        this.ipOptionBtn.setSelected(!bl);
        this.neListMaxSize = this.prefs.getInt(PREFIX, NELIST_SIZE_PREF, 20);
        if (this.neListMaxSize < 10) {
            this.neListMaxSize = 10;
        }
        for (String string : stringArray = this.prefs.getPropertyArray(PREFIX, NELIST_PREF, new String[0])) {
            this.nodeCombo.addItem(string);
            if (this.nodeCombo.getItemCount() > this.neListMaxSize) break;
        }
    }

    public void initCbCtcVersion() {
        this.versionCombo.removeAllItems();
        this.versionCombo.addItem(this.convertStringToObject(LATEST_CTC_VER));
        this.versionCombo.addItem(this.convertStringToObject(LOGIN_NE_CTC_VER));
        try {
            this.ctcVersions = Launcher.instance().getJarSetManager().getJarSets();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (Comparable comparable : this.ctcVersions) {
            String string = "Version " + cvu.prettyDottedString(comparable);
            this.versionCombo.addItem(this.convertStringToObject(string));
        }
        this.lastSelMode = this.prefs.getEnumProperty(PREFIX, CTCSEL_PREF, Launcher.CtcVersionSelection.LATEST_VERSION);
        int n = 0;
        if (this.lastSelMode == Launcher.CtcVersionSelection.LOGIN_NODE_VERSION) {
            n = 1;
        } else if (this.lastSelMode == Launcher.CtcVersionSelection.SELECTED_VERSION) {
            String string = this.prefs.getProperty(PREFIX, CTCSELVER_PREF, "");
            try {
                Comparable comparable = cvu.createVersionOrdinal(ClassLoaderEnum.SYSTEM, (Comparable)((Object)string));
                for (int i = 0; i < this.ctcVersions.length; ++i) {
                    if (!comparable.equals(this.ctcVersions[i])) continue;
                    n = 2 + i;
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.versionCombo.setSelectedIndex(n);
    }

    public Launcher.CtcVersionSelection getCtcVersionSelectionMode() {
        int n = this.versionCombo.getSelectedIndex();
        if (n <= 0) {
            return Launcher.CtcVersionSelection.LATEST_VERSION;
        }
        if (n == 1) {
            return Launcher.CtcVersionSelection.LOGIN_NODE_VERSION;
        }
        return Launcher.CtcVersionSelection.SELECTED_VERSION;
    }

    public Comparable getSelectedCtcVersion() {
        int n = this.versionCombo.getSelectedIndex();
        if (n > 1) {
            return this.ctcVersions[n - 2];
        }
        return null;
    }

    public void savePreferences() {
        String string = (String)this.nodeCombo.getSelectedItem();
        int n = Math.min(this.nodeCombo.getItemCount(), this.neListMaxSize);
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.nodeCombo.getItemAt(i))) continue;
            this.nodeCombo.removeItem(string);
            break;
        }
        this.nodeCombo.insertItemAt(string, 0);
        this.nodeCombo.setSelectedItem(string);
        n = Math.min(this.nodeCombo.getItemCount(), this.neListMaxSize);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.nodeCombo.getItemAt(i);
        }
        this.prefs.setPropertyArray(PREFIX, NELIST_PREF, stringArray);
        this.prefs.setBoolean(PREFIX, SOTL1_PREF, this.tl1OptionBtn.isSelected());
        Launcher.CtcVersionSelection ctcVersionSelection = this.getCtcVersionSelectionMode();
        this.prefs.setEnumProperty(PREFIX, CTCSEL_PREF, ctcVersionSelection);
        if (ctcVersionSelection == Launcher.CtcVersionSelection.SELECTED_VERSION) {
            this.prefs.setProperty(PREFIX, CTCSELVER_PREF, cvu.toString(this.getSelectedCtcVersion()));
        } else {
            this.prefs.removeProperty(PREFIX, CTCSELVER_PREF);
        }
        try {
            this.prefs.store();
        }
        catch (IOException iOException) {
            KDebug.printStackTrace(iOException);
        }
    }

    public JRadioButton getUseIPRef() {
        return this.ipOptionBtn;
    }

    public JRadioButton getUseTL1Ref() {
        return this.tl1OptionBtn;
    }

    public JComboBox getLoginNodeRef() {
        return this.nodeCombo;
    }

    public JButton getSettingRef() {
        return this.settingBtn;
    }

    public JButton getLaunchCTCRef() {
        return this.launchCtcBtn;
    }

    public JButton getCancelRef() {
        return this.cancelButton;
    }

    @Override
    public Dimension getPreferredSize() {
        return ATTR_PANE_DIM;
    }

    protected int getAttributeFieldWidth() {
        return 12;
    }

    protected int getAttributeFieldX() {
        return this.getWidth() - 197;
    }

    protected Point getSettingButtonPoint() {
        return new Point(this.getWidth() - 308, this.getHeight() - 32);
    }

    protected Point getLaunchCtcButtonPoint() {
        return new Point(this.getWidth() - 220, this.getHeight() - 32);
    }

    protected Point getCancelButtonPoint() {
        return new Point(this.getWidth() - 117, this.getHeight() - 32);
    }

    private Object convertStringToObject(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.versionCombo) {
            this.processVersionSelection();
        } else if (object == this.settingBtn) {
            this.processCacheSetting();
        } else if (object == this.launchCtcBtn) {
            this.prepareLaunchCTC();
        } else if (object == this.cancelButton) {
            this.parent.processClosed(null);
        } else if (object instanceof JRadioButton) {
            // empty if block
        }
        this.setAttributeEnabled();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setAttributeEnabled();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setAttributeEnabled();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setAttributeEnabled();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

