/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.sot;

import cerent.util.KDebug;
import com.cisco.sot.CircularBuffer;
import com.cisco.sot.SotSocketImpl;
import com.cisco.sot.Ssh;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class SotInputStream
extends InputStream {
    private SotSocketImpl socket;
    private int windowSize;
    private int heldCredit = 0;
    private CircularBuffer cbb = null;
    private boolean closed = false;
    private Object readLock = new Object();
    private byte[] singleRead = new byte[1];
    private int lockCount = 0;
    private int timeout = 0;

    protected SotInputStream(SotSocketImpl sotSocketImpl, int n) {
        this.socket = sotSocketImpl;
        this.windowSize = n;
        this.cbb = new CircularBuffer(n, 1024);
    }

    @Override
    public int available() throws IOException {
        return this.cbb.available();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        this.closed = true;
        Object object = this.readLock;
        synchronized (object) {
            this.readLock.notifyAll();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.singleRead, 0, 1) == -1) {
            return -1;
        }
        return this.singleRead[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException, InterruptedIOException {
        if (this.closed) {
            return -1;
        }
        int n3 = 0;
        Object object = this.readLock;
        synchronized (object) {
            if (n2 > 0) {
                ++this.lockCount;
                while (this.cbb.available() == 0) {
                    try {
                        this.readLock.wait(this.timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.cbb.available() != 0) continue;
                    --this.lockCount;
                    if (this.closed) {
                        return -1;
                    }
                    throw new InterruptedIOException();
                }
                --this.lockCount;
                int n4 = n2 > this.cbb.available() ? this.cbb.available() : n2;
                this.cbb.read(byArray, n, n4);
                n3 = n4;
            }
            this.heldCredit += n3;
        }
        if (this.heldCredit >= this.windowSize / 2) {
            this.socket.getTunnel().setWritable();
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        return this.cbb.skip(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(ByteBuffer byteBuffer, int n) throws BufferOverflowException {
        Object object = this.readLock;
        synchronized (object) {
            this.cbb.write(byteBuffer, n);
            this.readLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int collectSendPdus(ByteBuffer byteBuffer) {
        if (this.heldCredit < this.windowSize / 2) {
            return 0;
        }
        int n = byteBuffer.remaining() - 9;
        if (n > 0) {
            Object object = this.readLock;
            synchronized (object) {
                Ssh.chnWndAdjRq(byteBuffer, this.socket.getLocChnId(), this.socket.getRemChnId(), this.heldCredit);
                this.heldCredit = 0;
            }
            return 1;
        }
        return -1;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public void dump(KDebug kDebug) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("    InputStream  ");
        if (this.lockCount > 0) {
            stringBuffer.append(" blocked reader=" + this.lockCount);
        }
        if ((n = this.cbb.available()) > 0) {
            stringBuffer.append(" toread=" + n);
            stringBuffer.setCharAt(0, '*');
        }
        stringBuffer.append(" heldcredit=" + this.heldCredit);
        if (this.closed) {
            stringBuffer.append("closed");
        }
        kDebug.println(stringBuffer.toString());
    }
}

