/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.sot;

import com.cisco.sot.LimitXpSocket;
import com.cisco.sot.Tl1TunnelFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

public class SotSocketFactory
extends SocketFactory {
    public static SocketFactory getDefault() {
        return new SotSocketFactory();
    }

    @Override
    public Socket createSocket() throws IOException {
        return new Socket();
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.createSocket(InetAddress.getByName(string), n);
    }

    public Socket createSocket(String string, int n, int n2) throws IOException, UnknownHostException {
        return this.createSocket(InetAddress.getByName(string), n, n2);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.createSocket(inetAddress, n, 0);
    }

    public Socket createSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        return Tl1TunnelFactory.instance().createSocket(inetAddress, n, n2);
    }

    private Socket createLimitSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException, UnknownHostException {
        if (LimitXpSocket.isNeededForThisOs()) {
            Socket socket = new Socket(inetAddress, n, inetAddress2, n2);
            return new LimitXpSocket(socket);
        }
        return new Socket(inetAddress, n, inetAddress2, n2);
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        if (inetAddress == null) {
            return this.createSocket(string, n);
        }
        return this.createLimitSocket(InetAddress.getByName(string), n, inetAddress, n2);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        if (inetAddress2 == null) {
            return this.createSocket(inetAddress, n);
        }
        return this.createLimitSocket(inetAddress, n, inetAddress2, n2);
    }
}

