/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.CircuitFactory;
import cerent.cms.idl.Circuits.CircuitInfo;
import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Circuits.sCircuitInfo;
import cerent.cms.idl.Circuits.sCircuitInfoItem;
import cerent.cms.idl.Circuits.sUniqueCktIdPart;
import cerent.cms.idl.Circuits.xCouldNotGenerateUniqueId;
import cerent.cms.idl.Circuits.xIdAlreadyPresent;
import cerent.cms.idl.Circuits.xInvalidCircuitInfoParameters;
import cerent.cms.idl.Circuits.xInvalidCircuitName;
import cerent.cms.idl.Circuits.xNoSuchCircuit;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CircuitInfoFactory;
import cerent.cms.model.CircuitModel;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.CouldNotGenerateUniqueId;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ICircuitFactoryModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IdAlreadyPresent;
import cerent.cms.model.InvalidCircuitInfoParameters;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class CircuitFactoryModelDelegate
extends Model
implements ICircuitFactoryModel {
    private CreateCircuit createCircuit;
    private CircuitList circuitList;
    private NodeModelDelegate node;
    private EventDispatcher dispatcher;
    private Map circuitMap;
    private GetCircuitIdList getCircuitIdList;
    private GetCircuitInfoItem getCircuitInfoItem;
    private static NodeSingletonFactory<CircuitFactoryModelDelegate> sfactory = new NodeSingletonFactory<CircuitFactoryModelDelegate>(CircuitFactoryModelDelegate.class);
    private static final String CF_DEBUG_KEY = "CircuitFactoryModelDelegate";

    public static CircuitFactoryModelDelegate getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private CircuitFactoryModelDelegate(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.node = nodeModelDelegate;
        this.index = 0;
        this.createCircuit = new CreateCircuit("CircuitFactoryModelDelegate.createCircuit");
        this.circuitList = new CircuitList("CircuitFactoryModelDelegate.circuitList");
        this.getCircuitIdList = new GetCircuitIdList("CircuitFactoryModelDelegate::getCircuitIdList");
        this.getCircuitInfoItem = new GetCircuitInfoItem("CircuitFactoryModelDelegate::getCircuitInfoItem");
        this.circuitMap = Collections.synchronizedMap(new HashMap());
        if (this.db == null) {
            this.db = new CfDebug(nodeModelDelegate.db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.db.on()) {
            this.db.println("CircuitFactoryModelDelegate::init");
        }
        super.init0();
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectCircuitList, 0, (Observer)this);
        }
        Map map = this.circuitMap;
        synchronized (map) {
            this.circuitMap.putAll(this.discoverCircuits());
            this.initializeCircuits();
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICircuitModel add(ICircuitModel iCircuitModel) {
        CircuitModel circuitModel = null;
        Map map = this.circuitMap;
        synchronized (map) {
            circuitModel = this.getCircuitById(iCircuitModel.getId());
            if (circuitModel != null) {
                return circuitModel;
            }
            circuitModel = (CircuitModel)iCircuitModel;
            circuitModel.init();
            this.circuitMap.put(new Integer(circuitModel.getId().getUniquePart().getUniqueId()), circuitModel);
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
        return circuitModel;
    }

    private HashMap discoverCircuits() {
        try {
            return (HashMap)this.circuitList.get();
        }
        catch (UserException userException) {
            this.db.println("UserException caught in CircuitFactoryModelDelegate::discoverCircuits");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeCircuits() {
        Map map = this.circuitMap;
        synchronized (map) {
            for (CircuitModel circuitModel : this.circuitMap.values()) {
                circuitModel.init();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println("CircuitFactoryModelDelegate::dispose");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectCircuitList, 0, (Observer)this);
            this.dispatcher = null;
        }
        Map map = this.circuitMap;
        synchronized (map) {
            for (CircuitModel circuitModel : this.circuitMap.values()) {
                try {
                    circuitModel.destroy();
                }
                catch (Exception exception) {
                    this.db.println("Exception while destroying circuits" + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            this.circuitMap.clear();
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.node = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStructure() {
        Collection collection = null;
        boolean bl = false;
        if (this.db.on()) {
            this.db.println("Update Structure Called ");
        }
        Map map = this.circuitMap;
        synchronized (map) {
            Object object;
            collection = this.getCircuitIdList();
            if (this.db.on()) {
                this.db.println("Size of new Circuits " + collection.size());
            }
            Collection collection2 = this.getAddedObjects(collection, this.circuitMap.keySet());
            Collection collection3 = this.getDeletedObjects(collection, this.circuitMap.keySet());
            Iterator iterator = collection2.iterator();
            if (this.db.on()) {
                this.db.println("No. of aded ckts " + collection2.size());
            }
            if (this.db.on()) {
                this.db.println("No of deleted ckts " + collection3.size());
            }
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                object = null;
                try {
                    object = this.getCircuitInfoItem(n);
                }
                catch (xNoSuchCircuit xNoSuchCircuit2) {
                    if (!this.db.on) continue;
                    this.db.println("Caught no Such Circuit for Circuit " + n);
                    continue;
                }
                if (this.db.on()) {
                    this.db.println("Adding new CircuitInfo " + n);
                }
                CircuitModel circuitModel = new CircuitModel(this.node, (sCircuitInfoItem)object);
                circuitModel.init();
                this.circuitMap.put(n, circuitModel);
                bl = true;
            }
            for (Integer n : collection3) {
                object = (CircuitModel)this.circuitMap.remove(n);
                if (object != null) {
                    ((CircuitModel)object).destroy();
                    continue;
                }
                this.db.println("Could not find Circuit Id to destory " + n);
            }
        }
        if (bl) {
            this.setChanged();
            this.notifyObservers(ModelUpdateType.ADDED);
        }
    }

    @Override
    public INodeModel getNodeModel() {
        if (this.db.on()) {
            this.db.println("CircuitFactoryModelDelegate::getNodeModel");
        }
        return this.getNodeModelDelegate();
    }

    protected NodeModelDelegate getNodeModelDelegate() {
        return this.node;
    }

    public ICircuitModel getCircuitModelById(ICircuitId iCircuitId) {
        return null;
    }

    public CircuitModel getCircuitById(ICircuitId iCircuitId) {
        return (CircuitModel)this.circuitMap.get(new Integer(iCircuitId.getUniquePart().getUniqueId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICircuitModel[] getCircuits() {
        Map map = this.circuitMap;
        synchronized (map) {
            return this.circuitMap.values().toArray(new ICircuitModel[0]);
        }
    }

    public ICircuitModel createCircuit(ICircuitInfo iCircuitInfo) throws InvalidCircuitInfoParameters, CouldNotGenerateUniqueId, IdAlreadyPresent, InvalidCircuitName {
        ICircuitModel iCircuitModel = null;
        if (this.db.on()) {
            this.db.println("CircuitFactoryModelDelegate::createCircuit");
        }
        try {
            ICircuitModel iCircuitModel2 = (ICircuitModel)this.createCircuit.get(iCircuitInfo);
            iCircuitModel = this.add(iCircuitModel2);
        }
        catch (xInvalidCircuitInfoParameters xInvalidCircuitInfoParameters2) {
            throw new InvalidCircuitInfoParameters((UserException)xInvalidCircuitInfoParameters2);
        }
        catch (xCouldNotGenerateUniqueId xCouldNotGenerateUniqueId2) {
            throw new CouldNotGenerateUniqueId((UserException)xCouldNotGenerateUniqueId2);
        }
        catch (xInvalidCircuitName xInvalidCircuitName2) {
            throw new InvalidCircuitName((UserException)xInvalidCircuitName2);
        }
        catch (xIdAlreadyPresent xIdAlreadyPresent2) {
            throw new IdAlreadyPresent((UserException)xIdAlreadyPresent2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            this.db.println("UserException caught in CircuitFactoryModelDelegate::createCircuit");
            SDebug.printStackTrace((Throwable)userException);
        }
        return iCircuitModel;
    }

    public ICircuitModel createCircuit(INodeModel iNodeModel, ICircuitInfo iCircuitInfo) throws InvalidCircuitInfoParameters, CouldNotGenerateUniqueId, IdAlreadyPresent, InvalidCircuitName {
        return this.createCircuit(iCircuitInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContainee(Object object, boolean bl) {
        Map map = this.circuitMap;
        synchronized (map) {
            int n = ((CircuitModel)object).getUniquePart();
            this.circuitMap.remove(new Integer(n));
        }
        if (bl) {
            this.updateStructure();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("CircuitFactoryModelDelegate::update");
        }
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            if (this.db.on()) {
                this.db.println("update(): this=" + this.toString() + ", From=" + observable + ", arg=" + EnumStrings.getStrings(eUpdateType.class)[n]);
            }
            switch (n) {
                case 2: {
                    if (this.db.on()) {
                        this.db.println("Making structural changes.");
                    }
                    this.updateStructure();
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    protected Collection getAddedObjects(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList(collection);
        arrayList.removeAll(collection2);
        return arrayList;
    }

    protected Collection getDeletedObjects(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList(collection2);
        arrayList.removeAll(collection);
        return arrayList;
    }

    private Collection getCircuitIdList() {
        try {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            sCircuitId[] sCircuitIdArray = (sCircuitId[])this.getCircuitIdList.get();
            if (this.db.on) {
                this.db.println("getCircuitIdList returned list of size " + sCircuitIdArray.length);
            }
            for (int i = 0; i < sCircuitIdArray.length; ++i) {
                arrayList.add(new Integer(sCircuitIdArray[i].uniquePart.uniqueId));
            }
            return arrayList;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private sCircuitInfoItem getCircuitInfoItem(Integer n) throws xNoSuchCircuit {
        try {
            return (sCircuitInfoItem)this.getCircuitInfoItem.get(new sCircuitId(this.node.getNodeId(), new sUniqueCktIdPart(n)));
        }
        catch (xNoSuchCircuit xNoSuchCircuit2) {
            throw xNoSuchCircuit2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public String toString() {
        return "CircuitFactory";
    }

    private CircuitFactory getCircuitFactoryRef() {
        return this.getNodeModelDelegate().getIorRepository().getCircuitFactoryRef();
    }

    public class CfDebug
    extends SDebug {
        CfDebug(KDebug kDebug) {
            super(kDebug, CircuitFactoryModelDelegate.CF_DEBUG_KEY);
        }

        public final void update() {
            CircuitFactoryModelDelegate.this.updateStructure();
        }

        public final void dumpCircuits() {
            Iterator iterator = CircuitFactoryModelDelegate.this.circuitMap.values().iterator();
            while (iterator.hasNext()) {
                try {
                    this.println("============================================");
                    CircuitModel circuitModel = (CircuitModel)iterator.next();
                    circuitModel.printString(this);
                }
                catch (Exception exception) {
                    this.println("Caught exception " + exception);
                    CfDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    private class CircuitList
    extends NonCachedValue {
        public CircuitList(String string) {
            super(CircuitFactoryModelDelegate.this.node, string);
        }

        @Override
        protected Object getValue() throws UserException {
            sCircuitInfoItem[] sCircuitInfoItemArray = CircuitFactoryModelDelegate.this.getCircuitFactoryRef().getCircuitList();
            HashMap<Integer, CircuitModel> hashMap = new HashMap<Integer, CircuitModel>(sCircuitInfoItemArray.length);
            for (int i = 0; i < sCircuitInfoItemArray.length; ++i) {
                CircuitModel circuitModel = new CircuitModel(CircuitFactoryModelDelegate.this.getNodeModelDelegate(), sCircuitInfoItemArray[i]);
                ICircuitId iCircuitId = CircuitIdFactory.getICircuitId(sCircuitInfoItemArray[i].id);
                hashMap.put(new Integer(iCircuitId.getUniquePart().getUniqueId()), circuitModel);
            }
            return hashMap;
        }

        public Object outer() {
            return CircuitFactoryModelDelegate.this;
        }
    }

    private class CreateCircuit
    extends NonCachedValue {
        public CreateCircuit(String string) {
            super(CircuitFactoryModelDelegate.this.node, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            sCircuitInfo sCircuitInfo2 = CircuitInfoFactory.getCircuitInfo((ICircuitInfo)object);
            CircuitInfo circuitInfo = CircuitFactoryModelDelegate.this.getCircuitFactoryRef().createCircuit(sCircuitInfo2);
            circuitInfo.setCircuitId();
            return new CircuitModel(CircuitFactoryModelDelegate.this.getNodeModelDelegate(), circuitInfo);
        }

        public Object outer() {
            return CircuitFactoryModelDelegate.this;
        }
    }

    class GetCircuitIdList
    extends NonCachedValue {
        public GetCircuitIdList(String string) {
            super(CircuitFactoryModelDelegate.this.node, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getCircuitFactoryRef().getCircuitIdList();
        }

        public Object outer() {
            return CircuitFactoryModelDelegate.this;
        }
    }

    class GetCircuitInfoItem
    extends NonCachedValue {
        public GetCircuitInfoItem(String string) {
            super(CircuitFactoryModelDelegate.this.node, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            return this.node.getIorRepository().getCircuitFactoryRef().getCircuitInfoItem((sCircuitId)object);
        }

        public Object outer() {
            return CircuitFactoryModelDelegate.this;
        }
    }
}

