/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IDataComm;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.KErrorMsg;
import cerent.util.TDMTerminology;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public class DataComm
implements IDataComm {
    public static final int BUF_SIZE = 1024;
    public static final int TIMER_LENGTH = 600000;
    public static final String BACKUP_STRING = "Database backup";
    public static final String RESTORE_STRING = "Database restore";
    public static final String UPGRADE_STRING = "Software upgrade";
    public static final String COMPLETE_RESTORE_STRING = "Complete Database restore";
    public static final int port = 9999;
    public static final String END = "END TRANSFER\n";
    public static final int ERROR = -1;
    public static final int STATUS_ERROR = -10000;
    public static final int NOT_ACT = -10100;
    public static final int QUALIFY = -10200;
    public static final int BAD_VOL = -10300;
    public static final int STBY_FAIL = -10400;
    public static final int BAD_REL = -10500;
    public static final int MIX_TCC = -10600;
    public static final int SYS_ERR = -10700;
    public static final int STBY_DB_FAIL = -10800;
    public static final int SW_UPG_LOAD_BAD = -10900;
    public static final int SW_UPG_COPY_BAD = -11000;
    public static final int TASK_DELETED = -11100;
    public static final int ACT_FAILURE = 2;
    public static final int RVT_FAILURE = 3;
    public static final int NO_SW = 4;
    public static final int NO_R2R1 = 5;
    public static final int FLM_SUBTASK_BUSY = 6;
    public static final int FLM_DATABASE_BUSY = 7;
    public static final int FLM_STBY_NOT_READY = 8;
    public static final int FLM_DATABASE_CRC = 9;
    public static final int FLM_NOT_FULL_ACT = 10;
    public static final int FLM_DB_RESTORE_FAILED = 11;
    public static final int BLSR_SPANS_NOT_LOCKED = 12;
    public static final int PROTECTION_SWITCH_IN_PROGRESS = 13;
    public static final int FLM_DB_INCOMPATIBLE_WITH_TCC = 14;
    public static final int PORTS_IN_OOS_DISABLED_STATE = 15;
    public static final int NO_XCON_MIXED_MODE_REVERT_TO_PRE_6_0 = 16;
    public static final int ML_VERSION_UP = 17;
    public static final int SEC_NOT_SUPPORTED = 18;
    public static final int PERM_SEC_SET_NOT_ALLOWED = 19;
    public static final int INCOMPLETE_BNR = 20;
    public static final int LANWANENABLED = 21;
    public static final int ETHCLIDISTNOTDEFAULTED = 22;
    public static final int REBOOT = -12000;
    public static final int DB_RESTORE_OK = -12100;
    public static final int SW_UPG_OK = -12200;
    public static final int NO_RED_TCC = -12300;
    public static final int SEND_NUM_FILES = -12400;
    public static final int SUCCESS = 200;
    public static final int HTTP_BUSY = 503;
    public static final int HTTP_ERROR = 500;
    public static final int UNAUTHORIZED = 401;
    public static final int INCOMPLETE_TRANSFER = 1001;
    public static final int CONNECTION_REFUSED = 1002;
    private static TDMTerminology terms;

    private static String getRingTerm() {
        return terms != null ? terms.getRingTerms(1) : "BLSR";
    }

    public static boolean isAuthorizationFailure(int n) {
        return n == 401;
    }

    public static String getAuthorizationFailureMessage(String string) {
        String string2 = "\nAn authentication failure was detected during the processing of the {0} operation.\nCTC is checking that it is still registered with the node.";
        String string3 = KErrorMsg.buildMsg((String)string2, (Object[])new Object[]{string});
        return string3;
    }

    public static String getErrorMsg(int n, String string, String string2, TDMTerminology tDMTerminology) {
        terms = tDMTerminology;
        return DataComm.getErrorMsg(n, string, string2);
    }

    public static String getErrorMsg(int n, String string, String string2) {
        switch (n) {
            default: {
                return string + ": Internal Error " + n + ".";
            }
            case -10000: {
                return "Internal status error";
            }
            case -10100: {
                return "Flash manager is not ready";
            }
            case -10200: {
                return "Cannot qualify standby code volume";
            }
            case -10300: {
                return "Standby code volume is invalid";
            }
            case -10400: {
                return "Standby controller failed to activate";
            }
            case -10500: {
                return "Release not compatible with this node";
            }
            case -10600: {
                return "Active and standby controller cards are different";
            }
            case -10700: {
                return "Internal system error";
            }
            case -10800: {
                return "Standby controller failed to save the database";
            }
            case -10900: {
                return "Standby controller failed to qualify the package";
            }
            case -11000: {
                return "Standby controller failed to load the package";
            }
            case -11100: {
                return "Transfer task stopped due to I/O inactivity";
            }
            case 2: {
                return "Unable to activate because the working software version is newer than the protect one.";
            }
            case 3: {
                return "Unable to revert because the working software version is older than the protect one.";
            }
            case 4: {
                return "There is no protect software loaded.";
            }
            case 5: {
                return "Unable to revert from R2 to R1.";
            }
            case 6: 
            case 503: {
                return "Cannot execute " + string + "; A similar task is already running.";
            }
            case 7: {
                return "The node is busy saving recent modifications.\nPlease retry this operation later.";
            }
            case 8: {
                return "The standby " + string2 + " is not ready for this operation. " + "Please\n try again when initialization completes (up to" + " 5 min).";
            }
            case 9: {
                return "Database file is corrupt.";
            }
            case 10: {
                return "Active controller is not ready";
            }
            case 11: {
                return "Database and software mismatch";
            }
            case 12: {
                return DataComm.getRingTerm() + " spans are not locked";
            }
            case 13: {
                return "Protection switch in progress";
            }
            case 14: {
                return "The security settings in the database you are\ntrying to restore is incompatible with the\ncontroller card present in the node.";
            }
            case 15: {
                return "At least one port has had the " + terms.getTermForAdminState(1) + " admin state applied.";
            }
            case 18: {
                return "You are attempting to revert to a release that does not support secure mode.\nTurn off secure mode before reverting to this release.";
            }
            case 19: {
                return "Secure mode is permanently locked. Reverting to a \nrelease that does not support secure mode is prohibited.";
            }
            case 20: {
                return "Activate / Revert operation cannot be performed as incomplete Bridge and Rolls exist.";
            }
            case 21: {
                return "Cannot perform revert operation on a node with OTU2_XP card in 10GE LAN to WAN mode\nas the earlier release does not support the 10GE LAN TO WAN feature.";
            }
            case 22: {
                return "This node contains an OTU2_XP card with either the Flow Control or the Client Distance parameter, or both, not set with default values.";
            }
            case -12000: {
                return "OK - Standby side has reset, active waiting";
            }
            case -12100: {
                return "OK - Database restored";
            }
            case -12200: {
                return "OK - Package successfully transferred";
            }
            case -12300: {
                return "OK - No standby controller, package successfully transferred";
            }
            case -12400: {
                return "OK - Transferring package to standby controller";
            }
            case 1001: {
                return "Expected and actual bytes transferred do not match!";
            }
            case 1002: {
                return "Connection refused by server";
            }
            case 16: {
                return "Reversion to a release prior to R6.xx is not allowed when there are cross-connects in mixed mode.";
            }
            case 17: 
        }
        return "Software activation is in progress";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long findGZIPRealLength(String string) throws IOException {
        GZIPInputStream gZIPInputStream = null;
        try {
            gZIPInputStream = new GZIPInputStream(new FileInputStream(string));
            int n = 0;
            int n2 = 0;
            byte[] byArray = new byte[1024];
            while ((n2 = gZIPInputStream.read(byArray)) != -1) {
                n += n2;
            }
            long l = n;
            return l;
        }
        finally {
            if (gZIPInputStream != null) {
                gZIPInputStream.close();
            }
        }
    }

    static String getSession(NodeModelDelegate nodeModelDelegate) {
        byte[] byArray = nodeModelDelegate.getSecurityTicket();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("|");
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF);
            if (string.length() < 2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
        }
        stringBuffer.append("|");
        return stringBuffer.toString();
    }

    private DataComm() {
    }
}

