/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.OpticsTopology.eApcAdminStatus;
import cerent.cms.idl.OpticsTopology.sAPCLastModification;
import cerent.cms.idl.OpticsTopology.sApcDomainItem;
import cerent.cms.idl.OpticsTopology.sApcInstanceInfo;
import cerent.cms.idl.OpticsTopology.xCannotPerform;
import cerent.cms.idl.OpticsTopology.xNoConditionsToRun;
import cerent.cms.idl.OpticsTopology.xNotSupportedRequest;
import cerent.cms.model.APCLastModification;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.ApcDomainItem;
import cerent.cms.model.Busy;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.DwdmApcModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IAPCLastModification;
import cerent.cms.model.IApcDomainItem;
import cerent.cms.model.IDwdmApcModel;
import cerent.cms.model.IDwdmApcModels;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoConditionsToRun;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.NotSupportedRequest;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.MaintApcPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import org.omg.CORBA.UserException;

public class DwdmApcModels
extends Model
implements IDwdmApcModels {
    private NodeModelDelegate nmd;
    private GetAllAPCLastModif allApcLastModif;
    private GetApcInstances apcInstances;
    private RunAPCCorrSkipOverride runAPCCorrSkip;
    private boolean inited = false;
    private static NodeSingletonFactory<DwdmApcModels> sfactory = new NodeSingletonFactory<DwdmApcModels>(DwdmApcModels.class);
    private TreeMap<Integer, DwdmApcModel> objModels = new TreeMap();
    private TreeMap<Integer, DwdmApcModel> internalModels = new TreeMap();
    private EventDispatcher dispatcher;

    private DwdmApcModels(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.setDebug(nodeModelDelegate.getChildDebug(DwdmApcModels.class, DwdmApcModelsDebug.class, this));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.allApcLastModif = new GetAllAPCLastModif(this.nmd, "DwdmApcModels::GetAllApcLastModif");
        this.runAPCCorrSkip = new RunAPCCorrSkipOverride(this.nmd, "DwdmApcModels::RunAPCCorrSkipOverride");
        this.apcInstances = new GetApcInstances(this.nmd, "DwdmApcModels::GetApcInstances");
    }

    public static DwdmApcModels getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    @Override
    protected void updateLocal() {
        super.updateLocal();
    }

    private void delDwdmApcModels() {
        if (this.db.on) {
            this.db.println(this.getClass() + "::delDwdmApcModels");
        }
        for (DwdmApcModel dwdmApcModel : this.objModels.values()) {
            dwdmApcModel.dispose();
        }
        for (DwdmApcModel dwdmApcModel : this.internalModels.values()) {
            dwdmApcModel.dispose();
        }
        this.objModels.clear();
        this.internalModels.clear();
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        int n;
        if (this.db.on()) {
            this.db.println("Got update from " + observable + " arg=" + object);
        }
        boolean bl = false;
        if (object instanceof IObjectMessageInfo) {
            n = ((IObjectMessageInfo)object).getUpdateType();
            bl = ((IObjectMessageInfo)object).getObjectType() == 94;
        } else {
            n = (Integer)object;
        }
        if (n == 2) {
            int n2 = ((IObjectMessageInfo)object).getIndex();
            this.addModel(n2);
            this.updateLocal();
            this.setChanged();
            this.notifyObservers(ModelUpdateType.ADDED);
        } else if (n == 1) {
            if (bl) {
                if (this.db.on) {
                    this.db.println(this.getClass() + " - update all models");
                }
                this.delDwdmApcModels();
                this.reloadModel();
            }
            this.updateLocal();
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    private DwdmApcModel dwdmApcModelFactory(int n) {
        return new DwdmApcModel(this.nmd, n);
    }

    public void init() {
        super.init0();
        if (!this.inited) {
            this.dispatcher = this.nmd.getDispatcher();
            if (this.dispatcher != null) {
                this.dispatcher.addObserver(ObjectType.ObjectApcDomain, (Observer)this);
                this.dispatcher.addObserver(ObjectType.ObjectApcModifiedList, (Observer)this);
            }
            this.reloadModel();
            this.inited = true;
        }
    }

    public DwdmApcModel getDwdmApcModel(int n) throws WrongNodeSide {
        if (this.objModels != null) {
            DwdmApcModel dwdmApcModel = this.objModels.get(n);
            if (dwdmApcModel == null) {
                dwdmApcModel = this.internalModels.get(n);
            }
            return dwdmApcModel;
        }
        throw new WrongNodeSide("Invalid SideId specified 0x" + Integer.toHexString(n));
    }

    @Override
    public void dispose() {
        if (this.db.on) {
            this.db.println(this.getClass() + "::dispose()");
        }
        if (this.objModels != null) {
            this.delDwdmApcModels();
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectApcDomain, 0, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectApcModifiedList, (Observer)this);
        }
        this.inited = false;
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.db.on) {
            this.db.println(this.getClass() + "::destroy()");
        }
        super.destroy();
        Iterator<DwdmApcModel> iterator = this.objModels.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().destroy();
        }
        iterator = this.internalModels.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().destroy();
        }
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public IDwdmApcModel[] getAllDwdmApcModel() {
        if (this.objModels != null) {
            return this.objModels.values().toArray(new IDwdmApcModel[0]);
        }
        return null;
    }

    public IApcDomainItem[] getNetApcDomain(int n) throws CannotPerform, WrongNodeSide, FeatureUnsupported, Busy {
        sApcDomainItem[] sApcDomainItemArray = this.getApcDomain(n);
        IApcDomainItem[] iApcDomainItemArray = new IApcDomainItem[sApcDomainItemArray.length];
        for (int i = 0; i < sApcDomainItemArray.length; ++i) {
            sApcDomainItem sApcDomainItem2 = sApcDomainItemArray[i];
            iApcDomainItemArray[i] = new ApcDomainItem(sApcDomainItem2.nodeId, sApcDomainItem2.sideIn, sApcDomainItem2.sideOut);
        }
        return iApcDomainItemArray;
    }

    public sApcDomainItem[] getApcDomain(int n) throws CannotPerform, WrongNodeSide, FeatureUnsupported {
        DwdmApcModel dwdmApcModel = this.getDwdmApcModel(n);
        return dwdmApcModel.getApcDomain();
    }

    public IAPCLastModification[] getAllApcLastModif() {
        IAPCLastModification[] iAPCLastModificationArray = null;
        try {
            sAPCLastModification[] sAPCLastModificationArray = (sAPCLastModification[])this.allApcLastModif.get();
            iAPCLastModificationArray = new APCLastModification[sAPCLastModificationArray.length];
            for (int i = 0; i < sAPCLastModificationArray.length; ++i) {
                iAPCLastModificationArray[i] = new APCLastModification(sAPCLastModificationArray[i]);
            }
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getAllApcLastModif", userException);
        }
        return iAPCLastModificationArray;
    }

    public sApcInstanceInfo[] getApcInstances() {
        sApcInstanceInfo[] sApcInstanceInfoArray = null;
        try {
            sApcInstanceInfoArray = (sApcInstanceInfo[])this.apcInstances.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getApcInstances", userException);
        }
        return sApcInstanceInfoArray;
    }

    public Pane getApcPlugin(TabbedView tabbedView, short s) {
        return new MaintApcPane("APC", tabbedView, this, this.convertSideId(s), true);
    }

    private void reloadModel() {
        sApcInstanceInfo[] sApcInstanceInfoArray = this.getApcInstances();
        for (int i = 0; i < sApcInstanceInfoArray.length; ++i) {
            this.addModel(sApcInstanceInfoArray[i].side);
        }
    }

    private void addModel(int n) {
        if (this.db.on) {
            this.db.println(this.getClass() + "::addmodel() for 0x" + Integer.toHexString(n));
        }
        if (!this.objModels.containsKey(n)) {
            int n2;
            DwdmApcModel dwdmApcModel = this.dwdmApcModelFactory(n);
            dwdmApcModel.init();
            this.objModels.put(n, dwdmApcModel);
            if (DwdmSide.getSideRole(n) == 1 && !this.internalModels.containsKey(n2 = DwdmSide.getSideLabelFromId(n))) {
                if (this.db.on) {
                    this.db.println(this.getClass() + "::addInternalModel() for 0x" + Integer.toHexString(n2));
                }
                dwdmApcModel = this.dwdmApcModelFactory(n2);
                dwdmApcModel.init();
                this.internalModels.put(n2, dwdmApcModel);
            }
        }
    }

    public IAPCLastModification[] getSideAPCLastModif(int n) throws WrongNodeSide {
        DwdmApcModel dwdmApcModel = this.getDwdmApcModel(n);
        return dwdmApcModel.getSideAPCLastModif();
    }

    private int convertSideId(short s) {
        int n = DwdmSide.getSideLabelFromId(s);
        int n2 = DwdmSide.getSideRole(s);
        return DwdmSide.getSideId(n, n2);
    }

    public void runApc(short s) throws Busy, CannotPerform, WrongNodeSide {
        this.runApc(this.convertSideId(s));
    }

    public void runApc(int n) throws Busy, CannotPerform, WrongNodeSide {
        DwdmApcModel dwdmApcModel = this.getDwdmApcModel(n);
        dwdmApcModel.runApc();
    }

    public void setApcAdminState(eApcAdminStatus eApcAdminStatus2, short s) throws WrongNodeSide {
        this.setApcAdminState(eApcAdminStatus2, this.convertSideId(s));
    }

    public void setApcAdminState(eApcAdminStatus eApcAdminStatus2, int n) throws WrongNodeSide {
        DwdmApcModel dwdmApcModel = this.getDwdmApcModel(n);
        dwdmApcModel.setApcAdminState(eApcAdminStatus2);
    }

    public void setApcAdminState(int n, short s) throws WrongNodeSide {
        DwdmApcModel dwdmApcModel = this.getDwdmApcModel(this.convertSideId(s));
        dwdmApcModel.setApcAdminState(n);
    }

    public int getApcState(short s) throws WrongNodeSide {
        return this.getApcState(this.convertSideId(s));
    }

    public int getApcState(int n) throws WrongNodeSide {
        DwdmApcModel dwdmApcModel = this.getDwdmApcModel(n);
        return dwdmApcModel.getApcState();
    }

    public int getApcAdminState(short s) throws WrongNodeSide {
        return this.getApcAdminState(this.convertSideId(s));
    }

    public int getApcAdminState(int n) throws WrongNodeSide {
        DwdmApcModel dwdmApcModel = this.getDwdmApcModel(n);
        return dwdmApcModel.getApcAdminState();
    }

    public int getApcProgressState(int n) throws WrongNodeSide {
        DwdmApcModel dwdmApcModel = this.getDwdmApcModel(n);
        return dwdmApcModel.getApcProgressState();
    }

    public void deleteApcModel(int n) {
        int n2;
        if (this.db.on) {
            this.db.println(this.getClass() + "::deleteApcModel() for 0x" + Integer.toHexString(n));
        }
        if (this.objModels.containsKey(n)) {
            this.objModels.get(n).dispose();
            this.objModels.remove(n);
        }
        if (DwdmSide.getSideRole(n) == 1 && this.internalModels.containsKey(n2 = DwdmSide.getSideLabelFromId(n))) {
            if (this.db.on) {
                this.db.println(this.getClass() + "::deleteInternalApcModel() for 0x" + Integer.toHexString(n2));
            }
            this.internalModels.get(n2).dispose();
            this.internalModels.remove(n2);
        }
    }

    public void runAPCCorrSkipOverride(int n, int n2) throws CannotPerform, NoConditionsToRun, NotSupportedRequest, AbstractCmsIOException {
        try {
            this.runAPCCorrSkip.set(new Integer[]{n, n2});
        }
        catch (xCannotPerform xCannotPerform2) {
            throw new CannotPerform((UserException)xCannotPerform2);
        }
        catch (xNoConditionsToRun xNoConditionsToRun2) {
            throw new NoConditionsToRun((UserException)xNoConditionsToRun2);
        }
        catch (xNotSupportedRequest xNotSupportedRequest2) {
            throw new NotSupportedRequest((UserException)xNotSupportedRequest2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "runAPCCorrSkipOverride", userException);
        }
    }

    public class DwdmApcModelsDebug
    extends SDebug {
        public DwdmApcModelsDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            DwdmApcModel dwdmApcModel;
            Iterator iterator;
            TreeMap treeMap;
            DwdmApcModels.this.db.println("Apc Model(s) :");
            if (DwdmApcModels.this.objModels != null) {
                treeMap = DwdmApcModels.this.objModels;
                synchronized (treeMap) {
                    iterator = DwdmApcModels.this.objModels.values().iterator();
                    try {
                        while (iterator.hasNext()) {
                            dwdmApcModel = (DwdmApcModel)iterator.next();
                            DwdmApcModels.this.db.println("  Apc Model Side " + dwdmApcModel.getSide() + " - Admin State " + dwdmApcModel.getApcAdminState() + " - State " + dwdmApcModel.getApcState());
                        }
                    }
                    catch (WrongNodeSide wrongNodeSide) {
                        DwdmApcModels.this.db.println("Wrong Node Side");
                    }
                }
            }
            if (DwdmApcModels.this.internalModels != null) {
                DwdmApcModels.this.db.println("Apc Internal Model(s) :");
                treeMap = DwdmApcModels.this.internalModels;
                synchronized (treeMap) {
                    iterator = DwdmApcModels.this.internalModels.values().iterator();
                    try {
                        while (iterator.hasNext()) {
                            dwdmApcModel = (DwdmApcModel)iterator.next();
                            DwdmApcModels.this.db.println("  Apc Model Side " + dwdmApcModel.getSide() + " - Admin State " + dwdmApcModel.getApcAdminState() + " - State " + dwdmApcModel.getApcState());
                        }
                    }
                    catch (WrongNodeSide wrongNodeSide) {
                        DwdmApcModels.this.db.println("Wrong Node Side");
                    }
                }
            }
            DwdmApcModels.this.db.println("");
        }
    }

    private class GetAllAPCLastModif
    extends NonCachedValue {
        public GetAllAPCLastModif(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() {
            if (DwdmApcModels.this.db.on) {
                DwdmApcModels.this.db.println(this.getClass() + "::getValue");
            }
            return this.node.getIorRepository().getDwdmOpticalSetupRef().getAllAPCLastModif();
        }
    }

    private class GetApcInstances
    extends NonCachedValue {
        public GetApcInstances(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() {
            if (DwdmApcModels.this.db.on) {
                DwdmApcModels.this.db.println(this.getClass() + "::getValue");
            }
            return this.node.getIorRepository().getDwdmOpticalSetupRef().getApcInstances();
        }
    }

    private class RunAPCCorrSkipOverride
    extends NonCachedValue {
        public RunAPCCorrSkipOverride(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xCannotPerform, xNoConditionsToRun, xNotSupportedRequest {
            Integer[] integerArray = (Integer[])object;
            int n = integerArray[0];
            int n2 = integerArray[1];
            this.node.getIorRepository().getDwdmOpticalSetupRef().runAPCCorrSkipOverride(n, n2);
        }
    }
}

