/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.eReach;
import cerent.cms.idl.Dwdm.Client;
import cerent.cms.idl.Dwdm.General;
import cerent.cms.idl.Dwdm.Trunk;
import cerent.cms.idl.Dwdm.eClientOpticsVariant;
import cerent.cms.idl.Dwdm.eDwdmFecMode;
import cerent.cms.idl.Dwdm.eMappingType;
import cerent.cms.idl.Dwdm.eMonitorType;
import cerent.cms.idl.Dwdm.eTraceFormat;
import cerent.cms.idl.Dwdm.eTraceMode;
import cerent.cms.idl.Dwdm.sDwdmCardConfig;
import cerent.cms.idl.Dwdm.sDwdmFECPmStats;
import cerent.cms.idl.Dwdm.sFECPmThresholds;
import cerent.cms.idl.Dwdm.sLaserThresholds;
import cerent.cms.idl.Dwdm.sOTNLinePmStats;
import cerent.cms.idl.Dwdm.sOTNThresholds;
import cerent.cms.idl.Dwdm.sProactiveProtectionConfig;
import cerent.cms.idl.Dwdm.sTrunkLineAttributes;
import cerent.cms.idl.Dwdm.tTraceArrayHolder;
import cerent.cms.idl.Dwdm.xDetailedConfigError;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.eProvDataError;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.IGenericTraceLine;
import cerent.cms.model.IOTULineModel;
import cerent.cms.model.IOpticsProvExtModel;
import cerent.cms.model.ISupportsOpticsProvExtModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OpticsProvExtModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.util.EMC;
import cerent.util.SDebug;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.UserException;

public class DwdmOTULineModel
extends AbstractDwdmLineModel
implements ISupportsOpticsProvExtModel,
IOTULineModel {
    protected int index;
    private OpticsProvExtModel opticsProvExtModel;
    private FECMode fecMode;
    private SfBerLevel sfBerLevel;
    private SdBerLevel sdBerLevel;
    private OTNStatus otnStatus;
    private MappingType mappingType;
    private OTNData otnData;
    private CardConfig dwdmCardConfig;
    private CurrentPayloadLabel currentPayloadLabel;
    private OTNStats otnStats;
    private FECStats fecStats;
    private OTNThresholds otnThresholds;
    private FECThresholds fecThresholds;
    private SendTTI sendTTI;
    private ExpectedTTI expectedTTI;
    private ReceivedTTI receivedTTI;
    private TTIMode ttiMode;
    private TTIFormat ttiFormat;
    private ProactiveProtectionConfig proactiveProtectionConfig;
    private eMonitorType monitoringLevel = eMonitorType.MON_SECTION;

    public DwdmOTULineModel(NodeModelDelegate nodeModelDelegate, int n) {
        this(nodeModelDelegate, n, (sInterface)null);
    }

    public DwdmOTULineModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2) {
        super(nodeModelDelegate, n, sInterface2);
        this.index = n;
        this.opticsProvExtModel = new OpticsProvExtModel(this);
        this.fecMode = new FECMode("DwdmTrkLineModel::fecMode", nodeModelDelegate);
        this.sfBerLevel = new SfBerLevel(nodeModelDelegate, "DwdmTrkLineModel::sfBer");
        this.sdBerLevel = new SdBerLevel(nodeModelDelegate, "DwdmTrkLineModel::sdBer");
        this.otnStatus = new OTNStatus("DwdmTrkLineModel::otnStatus", nodeModelDelegate);
        this.mappingType = new MappingType("DwdmTrkLineModel::mappingType", nodeModelDelegate);
        this.otnData = new OTNData("DwdmTrkLineModel::otnData", nodeModelDelegate);
        this.dwdmCardConfig = new CardConfig("dwdmCardConfig", nodeModelDelegate);
        this.currentPayloadLabel = new CurrentPayloadLabel(nodeModelDelegate, "currentPayloadLabel");
        this.otnStats = new OTNStats("DwdmTrkLineModel::otnStats", nodeModelDelegate);
        this.fecStats = new FECStats("DwdmTrkLineModel::fecStats", nodeModelDelegate);
        this.otnThresholds = new OTNThresholds("DwdmTrkLineModel::otnThresholds", nodeModelDelegate);
        this.fecThresholds = new FECThresholds("DwdmTrkLineModel::fecThresholds", nodeModelDelegate);
        this.sendTTI = new SendTTI(nodeModelDelegate, "DwdmTrkLineModel::sendTTI");
        this.expectedTTI = new ExpectedTTI(nodeModelDelegate, "DwdmTrkLineModel::expectedTTI");
        this.receivedTTI = new ReceivedTTI(nodeModelDelegate, "DwdmTrkLineModel::receivedTTI");
        this.ttiMode = new TTIMode(nodeModelDelegate, "DwdmTrkLineModel::ttiMode");
        this.ttiFormat = new TTIFormat(nodeModelDelegate, "DwdmTrkLineModel::ttiFormat");
        this.proactiveProtectionConfig = new ProactiveProtectionConfig("DwdmTrkLineModel::proactiveProtectionConfig", nodeModelDelegate);
    }

    public void setAttributes(sTrunkLineAttributes sTrunkLineAttributes2, long l) {
        super.setAttributes(sTrunkLineAttributes2.general.base, l);
    }

    @Override
    public IOpticsProvExtModel getOpticsProvExtModel() {
        return this.opticsProvExtModel;
    }

    @Override
    public void dispose() {
        this.opticsProvExtModel.dispose();
        this.sdBerLevel.dispose();
        this.sfBerLevel.dispose();
        this.mappingType.dispose();
        this.otnData.dispose();
        this.fecMode.dispose();
        this.otnStatus.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        this.opticsProvExtModel.destroy();
        super.destroy();
    }

    @Override
    cerent.cms.idl.If.General getIfRef() {
        return ((NodeModelDelegate)this.getNodeModel()).getIorRepository().getIfRef();
    }

    @Override
    public eDwdmFecMode getFECMode() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eDwdmFecMode)this.fecMode.getValue();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getFECMode", userException);
        }
    }

    @Override
    public short getOTNSfBerLevel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Short)this.sfBerLevel.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNSfBerLevel", userException);
        }
    }

    @Override
    public short getOTNSdBerLevel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Short)this.sdBerLevel.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNSdBerLevel", userException);
        }
    }

    @Override
    public void setOTNSdBerLevel(short s) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            this.sdBerLevel.set(new Short(s));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setOTNSdBerLevel", userException);
        }
    }

    @Override
    public boolean getOTNStatus() throws NoSuchInterface, WrongInterfaceType {
        boolean bl = false;
        try {
            bl = (Boolean)this.otnStatus.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNStatus", userException);
        }
        return bl;
    }

    @Override
    public eMappingType getMappingType() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eMappingType)this.mappingType.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getMappingType", userException);
        }
    }

    @Override
    public void setOTNData(boolean bl, eDwdmFecMode eDwdmFecMode2, eMappingType eMappingType2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, ProvisionError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eDwdmFecMode2, eMappingType2};
            this.otnData.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_INVALID_OTN_FAPS_MODE, new Object[]{xProvisionError2.dataError});
        }
        catch (UserException userException) {
            throw this.doUnknown("setOTNData", userException);
        }
    }

    @Override
    public void setDwdmCardConfig(sDwdmCardConfig sDwdmCardConfig2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        try {
            this.dwdmCardConfig.set(sDwdmCardConfig2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (UserException userException) {
            throw this.doUnknown("setDwdmCardConfig", userException);
        }
    }

    @Override
    public sDwdmCardConfig getDwdmCardConfig() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sDwdmCardConfig)this.dwdmCardConfig.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getDwdmCardConfig", userException);
        }
    }

    public int getNoFixedStuffValue() throws NoSuchInterface, WrongInterfaceType {
        if (this.getMappingType() == eMappingType.MAP_SYNCH) {
            return 2;
        }
        if (this.getMappingType() == eMappingType.MAP_NO_OPU2_FIXED_STUFF) {
            return 4;
        }
        return 0;
    }

    private Trunk getDwdmOTURef() {
        return this.getNodeModelDelegate().getIorRepository().getDwdmTrkRef();
    }

    @Override
    public void setOTNStatus(boolean bl) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, AbstractCmsNoSuchEntityException, ProvisionError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), this.getFECMode(), this.getMappingType()};
            this.otnStatus.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_INVALID_OTN_FAPS_MODE, new Object[]{xProvisionError2.dataError});
        }
        catch (UserException userException) {
            throw this.doUnknown("setOTNStatus", userException);
        }
    }

    @Override
    public int getFECModeValue() throws NoSuchInterface, WrongInterfaceType {
        return this.getFECMode().value();
    }

    @Override
    public void setFECModeValue(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, AbstractCmsNoSuchEntityException {
        this.setFECMode(eDwdmFecMode.from_int(n));
    }

    @Override
    public void setFECMode(eDwdmFecMode eDwdmFecMode2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, AbstractCmsNoSuchEntityException {
        try {
            Object[] objectArray = new Object[]{new Boolean(this.getOTNStatus()), eDwdmFecMode2, this.getMappingType()};
            this.fecMode.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (UserException userException) {
            throw this.doUnknown("setFECMode", userException);
        }
    }

    @Override
    public void setOTNData(boolean bl, int n, int n2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, ProvisionError {
        this.setOTNData(bl, eDwdmFecMode.from_int(n), eMappingType.from_int(n2));
    }

    @Override
    public void clearOTNStats(boolean bl, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2};
            this.otnStats.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearOTNStats", userException);
        }
    }

    @Override
    public sOTNLinePmStats getOTNStats(boolean bl, eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, new Short(s)};
            return (sOTNLinePmStats)this.otnStats.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNStats", userException);
        }
    }

    @Override
    public void clearFECStats(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            this.fecStats.set(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearFECStats", userException);
        }
    }

    @Override
    public sDwdmFECPmStats getFECStats(eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{eIntervalType2, new Short(s)};
            return (sDwdmFECPmStats)this.fecStats.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getFECStats", userException);
        }
    }

    @Override
    public sOTNThresholds getOTNThresholds(boolean bl, eIntervalType eIntervalType2, eMonitorType eMonitorType2) throws NoSuchInterface, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, eMonitorType2};
            return (sOTNThresholds)this.otnThresholds.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNThresholds", userException);
        }
    }

    @Override
    public void setOTNThresholds(sOTNThresholds sOTNThresholds2, boolean bl, eIntervalType eIntervalType2, eMonitorType eMonitorType2) throws NoSuchInterface, WrongInterfaceType, ConfigError, xProvisionError {
        try {
            Object[] objectArray = new Object[]{sOTNThresholds2, new Boolean(bl), eIntervalType2, eMonitorType2};
            this.otnThresholds.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setOTNThresholds", userException);
        }
    }

    @Override
    public sFECPmThresholds getFECThresholds(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sFECPmThresholds)this.fecThresholds.get(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getFECThresholds", userException);
        }
    }

    @Override
    public void setFECThresholds(sFECPmThresholds sFECPmThresholds2, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, ConfigError, EMCProvisionError {
        try {
            Object[] objectArray = new Object[]{sFECPmThresholds2, eIntervalType2};
            this.fecThresholds.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setFECThresholds", userException);
        }
    }

    public int getTraceMode() throws NoSuchInterface, WrongInterfaceType {
        try {
            eTraceMode eTraceMode2 = (eTraceMode)this.ttiMode.get(this.monitoringLevel);
            return eTraceMode2.value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getTraceMode", userException);
        }
    }

    @Override
    public int getTTIMode(eMonitorType eMonitorType2) throws NoSuchInterface, WrongInterfaceType {
        try {
            eTraceMode eTraceMode2 = (eTraceMode)this.ttiMode.get(eMonitorType2);
            return eTraceMode2.value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getTTIMode", userException);
        }
    }

    @Override
    public eTraceMode getTraceModeEnum() throws NoSuchInterface, WrongInterfaceType {
        return eTraceMode.from_int(this.getTraceMode());
    }

    public void setTraceMode(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{this.monitoringLevel, eTraceMode.from_int(n)};
            this.ttiMode.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setTTIMode", userException);
        }
    }

    @Override
    public void setTraceModeEnum(eTraceMode eTraceMode2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        this.setTraceMode(eTraceMode2.value());
    }

    public void setTraceFormat(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{this.monitoringLevel, eTraceFormat.from_int(n)};
            this.ttiFormat.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setTraceFormat", userException);
        }
    }

    @Override
    public void setTraceFormatEnum(eTraceFormat eTraceFormat2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        this.setTraceFormat(eTraceFormat2.value());
    }

    public int getTraceFormat() throws NoSuchInterface, WrongInterfaceType {
        int n = -1;
        try {
            n = ((eTraceFormat)this.ttiFormat.get(this.monitoringLevel)).value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getTraceFormat", userException);
        }
        return n;
    }

    @Override
    public eTraceFormat getTraceFormatEnum() throws NoSuchInterface, WrongInterfaceType {
        return eTraceFormat.from_int(this.getTraceFormat());
    }

    @Override
    public void setSendTrace(String string) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{this.monitoringLevel, string};
            this.sendTTI.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSendTrace()", userException);
        }
    }

    @Override
    public char[] getSendTraceAsCharArray() throws NoSuchInterface, WrongInterfaceType {
        IGenericTraceLine.Trace trace = this.getSendTraceAsTrace();
        return trace.getTrace();
    }

    @Override
    public IGenericTraceLine.Trace getSendTraceAsTrace() throws NoSuchInterface, WrongInterfaceType {
        try {
            return new IGenericTraceLine.Trace(((String)this.sendTTI.get(this.monitoringLevel)).toCharArray(), true);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSendTraceAsTrace()", userException);
        }
    }

    @Override
    public void setExpectedTrace(String string) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{this.monitoringLevel, string};
            this.expectedTTI.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setExpectedTrace()", userException);
        }
    }

    @Override
    public IGenericTraceLine.Trace getExpectedTraceAsTrace() throws NoSuchInterface, WrongInterfaceType {
        try {
            return new IGenericTraceLine.Trace((char[])this.expectedTTI.get(this.monitoringLevel), true);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getExpectedTraceAsTrace()", userException);
        }
    }

    @Override
    public IGenericTraceLine.Trace getReceivedTraceAsTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            return new IGenericTraceLine.Trace((char[])this.receivedTTI.get(this.monitoringLevel), true);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getReceivedTraceAsTrace()", userException);
        }
    }

    @Override
    public void setMonitoringLevel(int n) {
        this.monitoringLevel = eMonitorType.from_int(n);
    }

    @Override
    public void setMonitoringLevelEnum(eMonitorType eMonitorType2) {
        this.setMonitoringLevel(eMonitorType2.value());
    }

    @Override
    public int getMonitoringLevel() {
        return this.monitoringLevel.value();
    }

    @Override
    public eMonitorType getMonitoringLevelEnum() {
        return eMonitorType.from_int(this.getMonitoringLevel());
    }

    public boolean canRequestReceivedTrace() {
        boolean bl = false;
        try {
            eEqState eEqState2 = this.getModuleModel().getState();
            switch (eEqState2.value()) {
                case 4: 
                case 5: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    @Override
    public String getSendTrace() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("Attempted an operation that is deprecated");
    }

    @Override
    public char[] getExpectedTrace() throws NoSuchInterface, WrongInterfaceType {
        IGenericTraceLine.Trace trace = this.getExpectedTraceAsTrace();
        return trace.getTrace();
    }

    @Override
    public char[] getReceivedTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        IGenericTraceLine.Trace trace = this.getReceivedTraceAsTrace();
        return trace.getTrace();
    }

    @Override
    public void setTTIFormat(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        throw new NoSuchInterface("method is no longer supported");
    }

    @Override
    public int getTTIFormat() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("method is no longer supported");
    }

    @Override
    public int getTTIMode() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("method is no longer supported");
    }

    public String getSendTTI() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("method is no longer supported");
    }

    public void setSendTTI(String string) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        throw new NoSuchInterface("method is no longer supported");
    }

    @Override
    public void setTTIMode(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        throw new NoSuchInterface("method is no longer supported");
    }

    public void setExpectedTTI(String string) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        throw new NoSuchInterface("method is no longer supported");
    }

    public char[] getExpectedTTI() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("method is no longer supported");
    }

    public char[] getReceivedTTI() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        throw new NoSuchInterface("method is no longer supported");
    }

    @Override
    public sProactiveProtectionConfig getProactiveProtectionConfig() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sProactiveProtectionConfig)this.proactiveProtectionConfig.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getProactiveProtectionConfig", userException);
        }
    }

    @Override
    public void setProactiveProtectionConfig(sProactiveProtectionConfig sProactiveProtectionConfig2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.proactiveProtectionConfig.set(sProactiveProtectionConfig2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            if (xProvisionError2.dataError == eProvDataError.INVALID_CARD_MODE) {
                throw new ProvisionError(EMC.EID_FRR_INVALID_CARD_MODE, new Object[]{xProvisionError2.dataError});
            }
            if (xProvisionError2.dataError == eProvDataError.INVALID_PAYLOAD) {
                throw new ProvisionError(EMC.EID_FRR_INVALID_PAYLOAD, new Object[]{xProvisionError2.dataError});
            }
            if (xProvisionError2.dataError == eProvDataError.INVALID_TRIGGER_WINDOW) {
                throw new ProvisionError(EMC.EID_FRR_INVALID_TRIGGER_WINDOW, new Object[]{xProvisionError2.dataError});
            }
            if (xProvisionError2.dataError == eProvDataError.INVALID_REVERT_WINDOW) {
                throw new ProvisionError(EMC.EID_FRR_INVALID_REVERT_WINDOW, new Object[]{xProvisionError2.dataError});
            }
            if (xProvisionError2.dataError == eProvDataError.INCOMPATIBLE_THRESHOLD_VALUE) {
                throw new ProvisionError(EMC.EID_FRR_INCOMPATIBLE_THRESHOLD, new Object[]{xProvisionError2.dataError});
            }
            throw new ProvisionError(EMC.EID_FRR_INVALID_PORT_MODE, new Object[]{xProvisionError2.dataError});
        }
        catch (UserException userException) {
            throw this.doUnknown("getProactiveProtectionConfig", userException);
        }
    }

    public boolean supportsAutoTrace() throws AbstractCmsNoSuchEntityException {
        return this.getModuleModel().supportsAutoTrace();
    }

    public byte getCurrentPayloadLabel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Byte)this.currentPayloadLabel.get(this.monitoringLevel);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getCurrentPayloadLabel", userException);
        }
    }

    @Override
    public boolean isLineTerminated() {
        return false;
    }

    @Override
    public boolean isSectionTerminated() {
        return false;
    }

    @Override
    public sLaserThresholds getDefaultOpticsThresholds(eIntervalType eIntervalType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        eEqType eEqType3 = ((PortModel)this.getPortModel()).getEqTypeEnum();
        eClientOpticsVariant eClientOpticsVariant2 = eClientOpticsVariant.DEFAULT_CLIENT_OPTICS;
        eReach eReach2 = eReach.from_int(0);
        IOpticsProvExtModel iOpticsProvExtModel = this.getOpticsProvExtModel();
        eReach2 = iOpticsProvExtModel.getLineReach();
        if (this.db.on()) {
            this.db.println(" get Client Defaults:\n\t eqType  = " + eEqType2.value() + "\n\t portType = " + eEqType3.value() + "\n\t thrVar = " + eClientOpticsVariant2.value() + "\n\t reach = " + eReach2.value() + "\n\t intervalType = " + eIntervalType2.value());
        }
        if (eReach2.value() == 0) {
            if (this.db.on()) {
                this.db.println(" get Client Defaults: Reach not set, returning null");
            }
            return null;
        }
        if (eReach2.value() == 51 || eReach2.value() == 49) {
            eDwdmFecMode eDwdmFecMode2 = this.getFECMode();
            return neDefaultsModel.getDefClientOpticsThrFEC(eEqType2, eEqType3, eClientOpticsVariant2, eReach2, eDwdmFecMode2, eIntervalType2);
        }
        return neDefaultsModel.getDefClientOpticsThr(eEqType2, eEqType3, eClientOpticsVariant2, eReach2, eIntervalType2);
    }

    @Override
    protected General getDwdmRef() {
        return this.getDwdmOTURef();
    }

    private Trunk getDwdmTrkRef() {
        return this.getNodeModelDelegate().getIorRepository().getDwdmTrkRef();
    }

    private Client getDwdmCliRef() {
        return this.getNodeModelDelegate().getIorRepository().getDwdmCliRef();
    }

    @Override
    protected boolean isTrunk() {
        return false;
    }

    @Override
    public sFECPmThresholds getDefaultFECThresholds(eIntervalType eIntervalType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        eEqType eEqType3 = eEqType.OC768_PORT;
        eDwdmFecMode eDwdmFecMode2 = this.getFECMode();
        return neDefaultsModel.getDefFecThr(eEqType2, eEqType3, eIntervalType2, eDwdmFecMode2);
    }

    @Override
    public sOTNThresholds getDefaultOTNThresholds(boolean bl, eIntervalType eIntervalType2, eMonitorType eMonitorType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        eEqType eEqType3 = eEqType.DWDM_TRUNK_PORT;
        return neDefaultsModel.getDefOtnThr(eEqType2, eEqType3, bl, eIntervalType2, eMonitorType2);
    }

    @Override
    protected void updateLocal(long l) {
        this.otnStatus.update();
        this.sdBerLevel.update();
        this.sfBerLevel.update();
        this.fecMode.update();
        this.mappingType.update();
        this.otnData.update();
        super.updateLocal(l);
    }

    private class CardConfig
    extends CachedValue {
        public CardConfig(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return DwdmOTULineModel.this.getDwdmOTURef().getDwdmCardConfig(DwdmOTULineModel.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws xDetailedConfigError, xWrongInterfaceType, xNoSuchInterface {
            DwdmOTULineModel.this.getDwdmOTURef().setDwdmCardConfig(DwdmOTULineModel.this.getIndex(), (sDwdmCardConfig)object);
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    private class CurrentPayloadLabel
    extends NonCachedValue {
        public CurrentPayloadLabel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            return new Byte(DwdmOTULineModel.this.getDwdmOTURef().getCurrentPayloadLabel(DwdmOTULineModel.this.getIndex(), (eMonitorType)object));
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    class ExpectedTTI
    extends NonCachedValue {
        public ExpectedTTI(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            tTraceArrayHolder tTraceArrayHolder2 = new tTraceArrayHolder();
            DwdmOTULineModel.this.getDwdmOTURef().getExpectedTTITrace(DwdmOTULineModel.this.getIndex(), (eMonitorType)object, tTraceArrayHolder2);
            return tTraceArrayHolder2.value;
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            eMonitorType eMonitorType2 = (eMonitorType)objectArray[0];
            String string = (String)objectArray[1];
            DwdmOTULineModel.this.getDwdmOTURef().setExpectedTTITrace(DwdmOTULineModel.this.getIndex(), eMonitorType2, string);
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    private class FECMode
    extends CachedValue {
        public FECMode(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return DwdmOTULineModel.this.getDwdmOTURef().getFECMode(DwdmOTULineModel.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xDetailedConfigError, xNoSuchInterface, xProvisionError {
            Object[] objectArray = (Object[])object;
            DwdmOTULineModel.this.getDwdmOTURef().enableOTN(DwdmOTULineModel.this.getIndex(), (Boolean)objectArray[0], (eDwdmFecMode)objectArray[1], (eMappingType)objectArray[2]);
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    private class FECStats
    extends NonCachedValue {
        public FECStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xInternalCommError, xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            DwdmOTULineModel.this.getDwdmOTURef().clearFECStats(DwdmOTULineModel.this.getIndex(), true, (eIntervalType)object);
        }

        @Override
        protected Object getValue(Object object) throws xInternalCommError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            short s = (Short)objectArray[1];
            sDwdmFECPmStats sDwdmFECPmStats2 = DwdmOTULineModel.this.getDwdmOTURef().getFECStats(DwdmOTULineModel.this.getIndex(), (eIntervalType)objectArray[0], s);
            return sDwdmFECPmStats2;
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    private class FECThresholds
    extends NonCachedValue {
        public FECThresholds(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            sFECPmThresholds sFECPmThresholds2 = DwdmOTULineModel.this.getDwdmOTURef().getFECThresholds(DwdmOTULineModel.this.getIndex(), (eIntervalType)object);
            return sFECPmThresholds2;
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            Object[] objectArray = (Object[])object;
            DwdmOTULineModel.this.getDwdmOTURef().setFECThresholds(DwdmOTULineModel.this.getIndex(), (sFECPmThresholds)objectArray[0], (eIntervalType)objectArray[1]);
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    private class MappingType
    extends CachedValue {
        public MappingType(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return DwdmOTULineModel.this.getDwdmOTURef().getMappingType(DwdmOTULineModel.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xDetailedConfigError, xNoSuchInterface, xProvisionError {
            Object[] objectArray = (Object[])object;
            DwdmOTULineModel.this.getDwdmOTURef().enableOTN(DwdmOTULineModel.this.getIndex(), (Boolean)objectArray[0], (eDwdmFecMode)objectArray[1], (eMappingType)objectArray[2]);
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    private class OTNData
    extends CachedValue {
        public OTNData(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xDetailedConfigError, xNoSuchInterface, xProvisionError {
            Object[] objectArray = (Object[])object;
            DwdmOTULineModel.this.getDwdmOTURef().enableOTN(DwdmOTULineModel.this.getIndex(), (Boolean)objectArray[0], (eDwdmFecMode)objectArray[1], (eMappingType)objectArray[2]);
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    private class OTNStats
    extends NonCachedValue {
        public OTNStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xInternalCommError, xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            Object[] objectArray = (Object[])object;
            boolean bl = (Boolean)objectArray[0];
            DwdmOTULineModel.this.getDwdmOTURef().clearOTNStats(DwdmOTULineModel.this.getIndex(), bl, (eIntervalType)objectArray[1]);
        }

        @Override
        protected Object getValue(Object object) throws xInternalCommError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            boolean bl = (Boolean)objectArray[0];
            short s = (Short)objectArray[2];
            sOTNLinePmStats sOTNLinePmStats2 = DwdmOTULineModel.this.getDwdmOTURef().getOTNStats(DwdmOTULineModel.this.getIndex(), bl, (eIntervalType)objectArray[1], s);
            return sOTNLinePmStats2;
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    private class OTNStatus
    extends CachedValue {
        public OTNStatus(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Boolean(DwdmOTULineModel.this.getDwdmOTURef().getOTNStatus(DwdmOTULineModel.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xDetailedConfigError, xNoSuchInterface, xProvisionError {
            Object[] objectArray = (Object[])object;
            DwdmOTULineModel.this.getDwdmOTURef().enableOTN(DwdmOTULineModel.this.getIndex(), (Boolean)objectArray[0], (eDwdmFecMode)objectArray[1], (eMappingType)objectArray[2]);
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    private class OTNThresholds
    extends NonCachedValue {
        public OTNThresholds(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            boolean bl = (Boolean)objectArray[0];
            sOTNThresholds sOTNThresholds2 = DwdmOTULineModel.this.getDwdmOTURef().getOTNThresholds(DwdmOTULineModel.this.getIndex(), bl, (eIntervalType)objectArray[1], (eMonitorType)objectArray[2]);
            return sOTNThresholds2;
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            Object[] objectArray = (Object[])object;
            boolean bl = (Boolean)objectArray[1];
            DwdmOTULineModel.this.getDwdmOTURef().setOTNThresholds(DwdmOTULineModel.this.getIndex(), (sOTNThresholds)objectArray[0], bl, (eIntervalType)objectArray[2], (eMonitorType)objectArray[3]);
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    private class ProactiveProtectionConfig
    extends NonCachedValue {
        public ProactiveProtectionConfig(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            sProactiveProtectionConfig sProactiveProtectionConfig2 = DwdmOTULineModel.this.getDwdmOTURef().getProactiveProtectionConfig(DwdmOTULineModel.this.getIndex());
            return sProactiveProtectionConfig2;
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            sProactiveProtectionConfig sProactiveProtectionConfig2 = (sProactiveProtectionConfig)object;
            DwdmOTULineModel.this.getDwdmOTURef().setProactiveProtectionConfig(DwdmOTULineModel.this.getIndex(), sProactiveProtectionConfig2);
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    class ReceivedTTI
    extends NonCachedValue {
        public ReceivedTTI(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xInternalCommError, xWrongInterfaceType, xNoSuchInterface {
            tTraceArrayHolder tTraceArrayHolder2 = new tTraceArrayHolder();
            DwdmOTULineModel.this.getDwdmOTURef().getReceivedTTITrace(DwdmOTULineModel.this.getIndex(), (eMonitorType)object, tTraceArrayHolder2);
            return tTraceArrayHolder2.value;
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    private class SdBerLevel
    extends CachedValue {
        public SdBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Short(DwdmOTULineModel.this.getDwdmOTURef().getLineDeclareSdBerLevel(DwdmOTULineModel.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            DwdmOTULineModel.this.getDwdmOTURef().setLineDeclareSdBerLevel(DwdmOTULineModel.this.getIndex(), (Short)object);
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    private class SendTTI
    extends NonCachedValue {
        public SendTTI(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            StringHolder stringHolder = new StringHolder();
            DwdmOTULineModel.this.getDwdmOTURef().getSendTTITrace(DwdmOTULineModel.this.getIndex(), (eMonitorType)object, stringHolder);
            return stringHolder.value;
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            eMonitorType eMonitorType2 = (eMonitorType)objectArray[0];
            String string = (String)objectArray[1];
            DwdmOTULineModel.this.getDwdmOTURef().setSendTTITrace(DwdmOTULineModel.this.getIndex(), eMonitorType2, string);
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    private class SfBerLevel
    extends CachedValue {
        public SfBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Short(DwdmOTULineModel.this.getDwdmOTURef().getLineDeclareSfBerLevel(DwdmOTULineModel.this.getIndex()));
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    class TTIFormat
    extends NonCachedValue {
        public TTIFormat(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            return DwdmOTULineModel.this.getDwdmOTURef().getTTITraceFormat(DwdmOTULineModel.this.getIndex(), (eMonitorType)object);
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            eMonitorType eMonitorType2 = (eMonitorType)objectArray[0];
            eTraceFormat eTraceFormat2 = (eTraceFormat)objectArray[1];
            DwdmOTULineModel.this.getDwdmOTURef().setTTITraceFormat(DwdmOTULineModel.this.getIndex(), eMonitorType2, eTraceFormat2);
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }

    class TTIMode
    extends NonCachedValue {
        public TTIMode(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            eTraceMode eTraceMode2 = DwdmOTULineModel.this.getDwdmOTURef().getTTITraceMode(DwdmOTULineModel.this.getIndex(), (eMonitorType)object);
            return eTraceMode2;
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            eMonitorType eMonitorType2 = (eMonitorType)objectArray[0];
            eTraceMode eTraceMode2 = (eTraceMode)objectArray[1];
            DwdmOTULineModel.this.getDwdmOTURef().setTTITraceMode(DwdmOTULineModel.this.getIndex(), eMonitorType2, eTraceMode2);
        }

        public Object outer() {
            return DwdmOTULineModel.this;
        }
    }
}

