/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.fv.IFvDwdmTrkLineModel;
import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Dwdm.General;
import cerent.cms.idl.Dwdm.Trunk;
import cerent.cms.idl.Dwdm.eDataRate;
import cerent.cms.idl.Dwdm.eDwdmDpsk;
import cerent.cms.idl.Dwdm.eDwdmFecMode;
import cerent.cms.idl.Dwdm.eDwdmProactiveProtection;
import cerent.cms.idl.Dwdm.eMappingType;
import cerent.cms.idl.Dwdm.eMonitorType;
import cerent.cms.idl.Dwdm.eRevertThreshold;
import cerent.cms.idl.Dwdm.eTraceFormat;
import cerent.cms.idl.Dwdm.eTraceMode;
import cerent.cms.idl.Dwdm.eTriggerThreshold;
import cerent.cms.idl.Dwdm.eTrunkOpticsVariant;
import cerent.cms.idl.Dwdm.sDwdmFECPmStats;
import cerent.cms.idl.Dwdm.sDwdmLineConfig;
import cerent.cms.idl.Dwdm.sFECPmThresholds;
import cerent.cms.idl.Dwdm.sLaserThresholds;
import cerent.cms.idl.Dwdm.sOTNLinePmStats;
import cerent.cms.idl.Dwdm.sOTNThresholds;
import cerent.cms.idl.Dwdm.sProactiveProtectionConfig;
import cerent.cms.idl.Dwdm.sTrunkLineAttributes;
import cerent.cms.idl.Dwdm.tTraceArrayHolder;
import cerent.cms.idl.Dwdm.xDetailedConfigError;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.eProvDataError;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IDwdmTrkLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IGenericTraceLine;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IOTULineModel;
import cerent.cms.model.IOpticsProvExtModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.ISupportsOpticsProvExtModel;
import cerent.cms.model.ISupportsRMON;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OhCircuitType;
import cerent.cms.model.OpticsProvExtModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RmonModel;
import cerent.cms.model.UnprotectedLineModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.util.EMC;
import cerent.util.SDebug;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.UserException;

public class DwdmTrkLineModel
extends AbstractDwdmLineModel
implements IOTULineModel,
IDwdmTrkLineModel,
IGenericTraceLine,
ISupportsRMON,
ISupportsOpticsProvExtModel,
IFvDwdmTrkLineModel {
    private OpticsProvExtModel opticsProvExtModel;
    private TunableWlList tunableWlList;
    private RegenPeer regenPeer;
    private RegenPeerLine regenPeerLine;
    private OTNStatus otnStatus;
    private FTFLStatus ftflStatus;
    private OTNStats otnStats;
    private FECStats fecStats;
    private OTNThresholds otnThresholds;
    private FECThresholds fecThresholds;
    private CurrentPayloadLabel currentPayloadLabel;
    private SendTTI sendTTI;
    private ExpectedTTI expectedTTI;
    private ReceivedTTI receivedTTI;
    private TTIMode ttiMode;
    private TTIFormat ttiFormat;
    private SdBerLevel sdBerLevel;
    private SfBerLevel sfBerLevel;
    private FECMode fecMode;
    private MappingType mappingType;
    private OTNData otnData;
    private RmonModel rmonModel;
    private MlseModule mlseModule;
    private ProactiveProtectionConfig proactiveProtectionConfig;
    private RxWavelength rxWavelength;
    private DpskVal dpskVal;
    private eMonitorType monitoringLevel = eMonitorType.MON_SECTION;

    public DwdmTrkLineModel(NodeModelDelegate nodeModelDelegate, int n) {
        this(nodeModelDelegate, n, (sInterface)null);
    }

    public DwdmTrkLineModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2) {
        super(nodeModelDelegate, n, sInterface2);
        this.index = n;
        this.rmonModel = new RmonModel(nodeModelDelegate, this, false);
        this.opticsProvExtModel = new OpticsProvExtModel(this);
        this.tunableWlList = new TunableWlList("DwdmTrkLineModel::tunableWlList", nodeModelDelegate);
        this.regenPeer = new RegenPeer("DwdmTrkLineModel::regenPeer", nodeModelDelegate);
        this.regenPeerLine = new RegenPeerLine("DwdmTrkLineModel::regenPeerLine", nodeModelDelegate);
        this.otnStatus = new OTNStatus("DwdmTrkLineModel::otnStatus", nodeModelDelegate);
        this.ftflStatus = new FTFLStatus("DwdmTrkLineModel::ftflStatus", nodeModelDelegate);
        this.otnStats = new OTNStats("DwdmTrkLineModel::otnStats", nodeModelDelegate);
        this.fecStats = new FECStats("DwdmTrkLineModel::fecStats", nodeModelDelegate);
        this.otnThresholds = new OTNThresholds("DwdmTrkLineModel::otnThresholds", nodeModelDelegate);
        this.fecThresholds = new FECThresholds("DwdmTrkLineModel::fecThresholds", nodeModelDelegate);
        this.currentPayloadLabel = new CurrentPayloadLabel(nodeModelDelegate, "DwdmTrkLineModel::currentPayloadLabel");
        this.sendTTI = new SendTTI(nodeModelDelegate, "DwdmTrkLineModel::sendTTI");
        this.expectedTTI = new ExpectedTTI(nodeModelDelegate, "DwdmTrkLineModel::expectedTTI");
        this.receivedTTI = new ReceivedTTI(nodeModelDelegate, "DwdmTrkLineModel::receivedTTI");
        this.ttiMode = new TTIMode(nodeModelDelegate, "DwdmTrkLineModel::ttiMode");
        this.ttiFormat = new TTIFormat(nodeModelDelegate, "DwdmTrkLineModel::ttiFormat");
        this.sdBerLevel = new SdBerLevel(nodeModelDelegate, "DwdmTrkLineModel::sdBer");
        this.sfBerLevel = new SfBerLevel(nodeModelDelegate, "DwdmTrkLineModel::sfBer");
        this.fecMode = new FECMode("DwdmTrkLineModel::fecMode", nodeModelDelegate);
        this.mappingType = new MappingType("DwdmTrkLineModel::mappingType", nodeModelDelegate);
        this.otnData = new OTNData("DwdmTrkLineModel::otnData", nodeModelDelegate);
        this.mlseModule = new MlseModule("DwdmTrkLineModel::mlseModule", nodeModelDelegate);
        this.proactiveProtectionConfig = new ProactiveProtectionConfig("DwdmTrkLineModel::proactiveProtectionConfig", nodeModelDelegate);
        this.rxWavelength = new RxWavelength("DwdmTrkLineModel::rxWavelength", nodeModelDelegate);
        this.dpskVal = new DpskVal(nodeModelDelegate, "DwdmTrkLineModel::dpskVal");
    }

    public boolean isPluggableTrk() {
        boolean bl = false;
        try {
            bl = ((DwdmModuleModel)this.getModuleModel()).hasPluggableTrunk();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println("Calling " + this.getClass().getName() + ".dispose(), index: 0x" + Integer.toHexString(this.getIndex()) + "/" + this.getIndex());
        }
        this.tunableWlList.dispose();
        this.regenPeer.dispose();
        this.regenPeerLine.dispose();
        this.otnStatus.dispose();
        this.ftflStatus.dispose();
        this.sdBerLevel.dispose();
        this.sfBerLevel.dispose();
        this.fecMode.dispose();
        this.mappingType.dispose();
        this.otnData.dispose();
        this.mlseModule.dispose();
        this.opticsProvExtModel.dispose();
        this.rmonModel.dispose();
        this.rxWavelength.dispose();
        this.dpskVal.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.db.on()) {
            this.db.println("Calling " + this.getClass().getName() + ".destroy(), index: 0x" + Integer.toHexString(this.getIndex()) + "/" + this.getIndex());
        }
        this.opticsProvExtModel.destroy();
        this.rmonModel.destroy();
        super.destroy();
    }

    @Override
    protected void updateLocal(long l) {
        this.tunableWlList.update();
        this.regenPeer.update();
        this.regenPeerLine.update();
        this.otnStatus.update();
        this.ftflStatus.update();
        this.sdBerLevel.update();
        this.sfBerLevel.update();
        this.fecMode.update();
        this.mappingType.update();
        this.otnData.update();
        this.mlseModule.update();
        this.rxWavelength.update();
        this.dpskVal.update();
        super.updateLocal(l);
    }

    public boolean isInterlink() {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = this.getDataRateEnum() == eDataRate.INTERNAL_LINK;
            }
            catch (Exception exception) {
                if (!this.db.on()) break block2;
                this.db.println("Cannot determine data rate for " + this.toString());
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return bl;
    }

    public void setWavelengthEnum(eWavelength eWavelength2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, UnsupportedOperation, ConfigError, ProvisionError {
        this.opticsProvExtModel.setLineWavelength(eWavelength2);
    }

    public void setWaveLength(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, ProvisionError {
        try {
            this.setWavelengthEnum(eWavelength.from_int(n));
        }
        catch (UnsupportedOperation unsupportedOperation) {
            throw new WrongInterfaceType(unsupportedOperation.getUserException());
        }
        catch (ConfigError configError) {
            throw new DetailedConfigError(configError.getUserException());
        }
    }

    public eWavelength getWavelengthEnum() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        return this.opticsProvExtModel.getLineWavelength();
    }

    public boolean isWavelengthSupported() throws NoSuchInterface, WrongInterfaceType {
        return true;
    }

    @Override
    public int getExpectedWaveLength() throws NoSuchInterface, WrongInterfaceType {
        return this.getWavelength();
    }

    public int getActualWaveLength() throws NoSuchInterface, WrongInterfaceType {
        return this.getWavelength();
    }

    public int getWavelength() throws NoSuchInterface, WrongInterfaceType {
        int n = 0;
        try {
            n = this.getWavelengthEnum().value();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            throw new WrongInterfaceType(unsupportedOperation.getUserException());
        }
        return n;
    }

    public int[] getTunableWavelengthList() throws NoSuchInterface, WrongInterfaceType {
        eWavelength[] eWavelengthArray = this.getTunableWls();
        if (eWavelengthArray == null) {
            if (this.db.on()) {
                this.db.println("Got void tunable wavelengths list");
            }
            return null;
        }
        int[] nArray = new int[eWavelengthArray.length];
        if (this.db.on()) {
            this.db.println("Got " + eWavelengthArray.length + " tunable wavelengths");
        }
        for (int i = 0; i < eWavelengthArray.length; ++i) {
            nArray[i] = eWavelengthArray[i].value();
            if (!this.db.on()) continue;
            this.db.print(i + 1 + ") " + nArray[i] + "; ");
            if (i != eWavelengthArray.length - 1) continue;
            this.db.println("");
        }
        return nArray;
    }

    public eWavelength[] getTunableWls() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eWavelength[])this.tunableWlList.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getTunableWls", userException);
        }
    }

    public void setRegenPeer(int n, int n2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            EntityTableModel entityTableModel = this.node.getEntityTableModel();
            IEntityModel iEntityModel = entityTableModel.getEntityModelBySlot(n, n2);
            this.regenPeer.set(new Integer(iEntityModel.getIndex()));
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            throw new NoSuchInterface(abstractCmsNoSuchEntityException.getMessage());
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setRegenPeer", userException);
        }
    }

    public IEntityModel getRegenPeer() throws NoSuchInterface, WrongInterfaceType {
        IEntityModel iEntityModel = null;
        try {
            EntityTableModel entityTableModel = this.node.getEntityTableModel();
            int n = (Integer)this.regenPeer.get();
            if (n > 0) {
                iEntityModel = entityTableModel.getEntityModelByIndex(n);
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            throw new NoSuchInterface(abstractCmsNoSuchEntityException.getMessage());
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getRegenPeer", userException);
        }
        return iEntityModel;
    }

    public IEntityModel getRegenPeerLine() throws NoSuchInterface, WrongInterfaceType {
        IEntityModel iEntityModel = null;
        try {
            EntityTableModel entityTableModel = this.node.getEntityTableModel();
            int n = (Integer)this.regenPeerLine.get();
            if (n > 0) {
                iEntityModel = entityTableModel.getEntityModelByIndex(n);
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            throw new NoSuchInterface(abstractCmsNoSuchEntityException.getMessage());
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getRegenPeerLine", userException);
        }
        return iEntityModel;
    }

    @Override
    public void setOTNStatus(boolean bl) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, AbstractCmsNoSuchEntityException, ProvisionError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), this.getFECMode(), this.getMappingType()};
            this.otnStatus.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_INVALID_OTN_FAPS_MODE, new Object[]{xProvisionError2.dataError});
        }
        catch (UserException userException) {
            throw this.doUnknown("setOTNStatus", userException);
        }
    }

    @Override
    public boolean getOTNStatus() throws NoSuchInterface, WrongInterfaceType {
        boolean bl = false;
        try {
            bl = (Boolean)this.otnStatus.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNStatus", userException);
        }
        return bl;
    }

    public void setFTFLStatus(boolean bl) throws NoSuchInterface, WrongInterfaceType {
        try {
            this.ftflStatus.set(new Boolean(bl));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setFTFLStatus", userException);
        }
    }

    public boolean getFTFLStatus() throws NoSuchInterface, WrongInterfaceType {
        boolean bl = false;
        try {
            bl = (Boolean)this.ftflStatus.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getFTFLStatus", userException);
        }
        return bl;
    }

    @Override
    public eDwdmFecMode getFECMode() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eDwdmFecMode)this.fecMode.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getFECMode", userException);
        }
    }

    @Override
    public int getFECModeValue() throws NoSuchInterface, WrongInterfaceType {
        return this.getFECMode().value();
    }

    @Override
    public void setFECModeValue(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, AbstractCmsNoSuchEntityException {
        this.setFECMode(eDwdmFecMode.from_int(n));
    }

    @Override
    public void setFECMode(eDwdmFecMode eDwdmFecMode2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, AbstractCmsNoSuchEntityException {
        try {
            Object[] objectArray = new Object[]{new Boolean(this.getOTNStatus()), eDwdmFecMode2, this.getMappingType()};
            this.fecMode.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (UserException userException) {
            throw this.doUnknown("setFECMode", userException);
        }
    }

    @Override
    public void setOTNData(boolean bl, int n, int n2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, ProvisionError {
        this.setOTNData(bl, eDwdmFecMode.from_int(n), eMappingType.from_int(n2));
    }

    @Override
    public void setOTNData(boolean bl, eDwdmFecMode eDwdmFecMode2, eMappingType eMappingType2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, ProvisionError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eDwdmFecMode2, eMappingType2};
            this.otnData.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError(EMC.EID_INVALID_OTN_FAPS_MODE, new Object[]{xProvisionError2.dataError});
        }
        catch (UserException userException) {
            throw this.doUnknown("setOTNData", userException);
        }
    }

    @Override
    public eMappingType getMappingType() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eMappingType)this.mappingType.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getMappingType", userException);
        }
    }

    public int getMappingTypeValue() throws NoSuchInterface, WrongInterfaceType {
        return this.getMappingType().value();
    }

    public void setMappingType(eMappingType eMappingType2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        try {
            Object[] objectArray = new Object[]{new Boolean(this.getOTNStatus()), this.getFECMode(), eMappingType2};
            this.mappingType.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (UserException userException) {
            throw this.doUnknown("setMappingType", userException);
        }
    }

    public void setMappingType(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        this.setMappingType(eMappingType.from_int(n));
    }

    @Override
    public void clearOTNStats(boolean bl, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2};
            this.otnStats.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearOTNStats", userException);
        }
    }

    @Override
    public sOTNLinePmStats getOTNStats(boolean bl, eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, new Short(s)};
            return (sOTNLinePmStats)this.otnStats.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNStats", userException);
        }
    }

    @Override
    public void clearFECStats(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            this.fecStats.set(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearFECStats", userException);
        }
    }

    @Override
    public sDwdmFECPmStats getFECStats(eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{eIntervalType2, new Short(s)};
            return (sDwdmFECPmStats)this.fecStats.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getFECStats", userException);
        }
    }

    @Override
    public sOTNThresholds getOTNThresholds(boolean bl, eIntervalType eIntervalType2, eMonitorType eMonitorType2) throws NoSuchInterface, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, eMonitorType2};
            return (sOTNThresholds)this.otnThresholds.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNThresholds", userException);
        }
    }

    @Override
    public void setOTNThresholds(sOTNThresholds sOTNThresholds2, boolean bl, eIntervalType eIntervalType2, eMonitorType eMonitorType2) throws NoSuchInterface, WrongInterfaceType, ConfigError, xProvisionError {
        try {
            Object[] objectArray = new Object[]{sOTNThresholds2, new Boolean(bl), eIntervalType2, eMonitorType2};
            this.otnThresholds.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setOTNThresholds", userException);
        }
    }

    @Override
    public sFECPmThresholds getFECThresholds(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sFECPmThresholds)this.fecThresholds.get(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getFECThresholds", userException);
        }
    }

    @Override
    public void setFECThresholds(sFECPmThresholds sFECPmThresholds2, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, ConfigError, EMCProvisionError {
        try {
            Object[] objectArray = new Object[]{sFECPmThresholds2, eIntervalType2};
            this.fecThresholds.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setFECThresholds", userException);
        }
    }

    public void setAttributes(sTrunkLineAttributes sTrunkLineAttributes2, long l) {
        super.setAttributes(sTrunkLineAttributes2.general, l);
    }

    public int getTraceMode() throws NoSuchInterface, WrongInterfaceType {
        try {
            eTraceMode eTraceMode2 = (eTraceMode)this.ttiMode.get(this.monitoringLevel);
            return eTraceMode2.value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getTraceMode", userException);
        }
    }

    @Override
    public int getTTIMode(eMonitorType eMonitorType2) throws NoSuchInterface, WrongInterfaceType {
        try {
            eTraceMode eTraceMode2 = (eTraceMode)this.ttiMode.get(eMonitorType2);
            return eTraceMode2.value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getTTIMode", userException);
        }
    }

    @Override
    public eTraceMode getTraceModeEnum() throws NoSuchInterface, WrongInterfaceType {
        return eTraceMode.from_int(this.getTraceMode());
    }

    public void setTraceMode(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{this.monitoringLevel, eTraceMode.from_int(n)};
            this.ttiMode.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setTTIMode", userException);
        }
    }

    @Override
    public void setTraceModeEnum(eTraceMode eTraceMode2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        this.setTraceMode(eTraceMode2.value());
    }

    public byte getCurrentPayloadLabel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Byte)this.currentPayloadLabel.get(this.monitoringLevel);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getCurrentPayloadLabel", userException);
        }
    }

    public void setTraceFormat(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{this.monitoringLevel, eTraceFormat.from_int(n)};
            this.ttiFormat.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setTraceFormat", userException);
        }
    }

    @Override
    public void setTraceFormatEnum(eTraceFormat eTraceFormat2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        this.setTraceFormat(eTraceFormat2.value());
    }

    public int getTraceFormat() throws NoSuchInterface, WrongInterfaceType {
        int n = -1;
        try {
            n = ((eTraceFormat)this.ttiFormat.get(this.monitoringLevel)).value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getTraceFormat", userException);
        }
        return n;
    }

    @Override
    public eTraceFormat getTraceFormatEnum() throws NoSuchInterface, WrongInterfaceType {
        return eTraceFormat.from_int(this.getTraceFormat());
    }

    @Override
    public void setSendTrace(String string) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{this.monitoringLevel, string};
            this.sendTTI.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSendTrace()", userException);
        }
    }

    @Override
    public char[] getSendTraceAsCharArray() throws NoSuchInterface, WrongInterfaceType {
        IGenericTraceLine.Trace trace = this.getSendTraceAsTrace();
        return trace.getTrace();
    }

    @Override
    public IGenericTraceLine.Trace getSendTraceAsTrace() throws NoSuchInterface, WrongInterfaceType {
        try {
            return new IGenericTraceLine.Trace(((String)this.sendTTI.get(this.monitoringLevel)).toCharArray(), true);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSendTraceAsTrace()", userException);
        }
    }

    @Override
    public void setExpectedTrace(String string) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{this.monitoringLevel, string};
            this.expectedTTI.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setExpectedTrace()", userException);
        }
    }

    @Override
    public IGenericTraceLine.Trace getExpectedTraceAsTrace() throws NoSuchInterface, WrongInterfaceType {
        try {
            return new IGenericTraceLine.Trace((char[])this.expectedTTI.get(this.monitoringLevel), true);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getExpectedTraceAsTrace()", userException);
        }
    }

    @Override
    public IGenericTraceLine.Trace getReceivedTraceAsTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            return new IGenericTraceLine.Trace((char[])this.receivedTTI.get(this.monitoringLevel), true);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getReceivedTraceAsTrace()", userException);
        }
    }

    @Override
    public void setMonitoringLevel(int n) {
        this.monitoringLevel = eMonitorType.from_int(n);
    }

    @Override
    public void setMonitoringLevelEnum(eMonitorType eMonitorType2) {
        this.setMonitoringLevel(eMonitorType2.value());
    }

    @Override
    public int getMonitoringLevel() {
        return this.monitoringLevel.value();
    }

    @Override
    public eMonitorType getMonitoringLevelEnum() {
        return eMonitorType.from_int(this.getMonitoringLevel());
    }

    @Override
    protected General getDwdmRef() {
        return this.getDwdmTrkRef();
    }

    private Trunk getDwdmTrkRef() {
        return this.getNodeModelDelegate().getIorRepository().getDwdmTrkRef();
    }

    @Override
    public short getOTNSdBerLevel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Short)this.sdBerLevel.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNSdBerLevel", userException);
        }
    }

    @Override
    public void setOTNSdBerLevel(short s) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            this.sdBerLevel.set(new Short(s));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setOTNSdBerLevel", userException);
        }
    }

    @Override
    public short getOTNSfBerLevel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Short)this.sfBerLevel.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNSfBerLevel", userException);
        }
    }

    public boolean canRequestReceivedTrace() {
        boolean bl = false;
        try {
            eEqState eEqState2 = this.getModuleModel().getState();
            switch (eEqState2.value()) {
                case 4: 
                case 5: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    @Override
    public String getSendTrace() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("Attempted an operation that is deprecated");
    }

    @Override
    public char[] getExpectedTrace() throws NoSuchInterface, WrongInterfaceType {
        IGenericTraceLine.Trace trace = this.getExpectedTraceAsTrace();
        return trace.getTrace();
    }

    @Override
    public char[] getReceivedTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        IGenericTraceLine.Trace trace = this.getReceivedTraceAsTrace();
        return trace.getTrace();
    }

    @Override
    public void setTTIFormat(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        throw new NoSuchInterface("method is no longer supported");
    }

    @Override
    public int getTTIFormat() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("method is no longer supported");
    }

    @Override
    public int getTTIMode() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("method is no longer supported");
    }

    public String getSendTTI() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("method is no longer supported");
    }

    public void setSendTTI(String string) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        throw new NoSuchInterface("method is no longer supported");
    }

    @Override
    public void setTTIMode(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        throw new NoSuchInterface("method is no longer supported");
    }

    public void setExpectedTTI(String string) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        throw new NoSuchInterface("method is no longer supported");
    }

    public char[] getExpectedTTI() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("method is no longer supported");
    }

    public char[] getReceivedTTI() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        throw new NoSuchInterface("method is no longer supported");
    }

    @Override
    public IRmonModel getRmonModel() {
        block10: {
            try {
                int n = this.getDataRate();
                switch (this.getModuleModel().getEqType()) {
                    case 118: 
                    case 181: 
                    case 274: 
                    case 275: 
                    case 293: {
                        if (n != 9) break;
                        return this.rmonModel;
                    }
                    case 120: 
                    case 121: {
                        if (n != 8 && n != 10 && n != 18 && n != 21) break;
                        return this.rmonModel;
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) break block10;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return null;
    }

    @Override
    protected boolean isTrunk() {
        return true;
    }

    @Override
    protected void updateStructure(long l) throws NoSuchInterface {
        this.setChanged();
        super.updateStructure(l);
    }

    public boolean supportsAutoTrace() throws AbstractCmsNoSuchEntityException {
        return this.getModuleModel().supportsAutoTrace();
    }

    @Override
    public boolean supportsTxPower() {
        block5: {
            try {
                switch (this.getModuleModel().getEqType()) {
                    case 120: 
                    case 121: 
                    case 183: 
                    case 184: {
                        return false;
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block5;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return true;
    }

    @Override
    public boolean supportOHCircuitTypes(OhCircuitType ohCircuitType) throws AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType {
        if (this.getModuleModel().getEqType() == 273) {
            return false;
        }
        if (ohCircuitType.equals((Object)OhCircuitType.EOW_CIRCUIT_OBJ)) {
            switch (this.getModuleModel().getEqType()) {
                case 119: 
                case 182: 
                case 276: {
                    return false;
                }
            }
        }
        return super.supportOHCircuitTypes(ohCircuitType);
    }

    @Override
    public List getConnectionsList() {
        int n;
        try {
            n = this.getPortModel().getEntityIndex();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                this.db.println("Cannot get PortModel for " + this + ": " + abstractCmsNoSuchEntityException.getMessage());
            }
            return new LinkedList();
        }
        List list = ((ConnectionModelsDelegate)this.node.getConnectionModels()).getOchConnectionModels(n);
        if (this.db.on()) {
            this.db.println("ConnectionsList: " + list.size() + "(size), " + list);
        }
        return list;
    }

    @Override
    public IOpticsProvExtModel getOpticsProvExtModel() {
        return this.opticsProvExtModel;
    }

    @Override
    public sLaserThresholds getDefaultOpticsThresholds(eIntervalType eIntervalType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        eDwdmFecMode eDwdmFecMode2 = this.getFECMode();
        eTrunkOpticsVariant eTrunkOpticsVariant2 = eTrunkOpticsVariant.DEFAULT_TRUNK_OPTICS;
        if (this.db.isInfoEnabled()) {
            this.db.info(" get Trunk defaults:\n\t eqType  = " + eEqType2.value() + "\n\t dwdmFecMode = " + eDwdmFecMode2.value() + "\n\t thrVar = " + eTrunkOpticsVariant2.value() + "\n\t intervalType = " + eIntervalType2.value());
        }
        return neDefaultsModel.getDefTrunkOpticsThr(eEqType2, this.opticsProvExtModel.getLineReach(), eDwdmFecMode2, eTrunkOpticsVariant2, eIntervalType2);
    }

    @Override
    public boolean supportsAutoALS() {
        try {
            return this.getOTNStatus() || super.supportsAutoALS();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return false;
    }

    public int getNoFixedStuffValue() throws NoSuchInterface, WrongInterfaceType {
        if (this.getMappingType() == eMappingType.MAP_SYNCH) {
            return 2;
        }
        if (this.getMappingType() == eMappingType.MAP_NO_OPU2_FIXED_STUFF) {
            return 4;
        }
        return 0;
    }

    @Override
    public sFECPmThresholds getDefaultFECThresholds(eIntervalType eIntervalType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        eEqType eEqType3 = DwdmTrkLineModel.getEqTypeFromDataRate(this.getDataRate());
        eDwdmFecMode eDwdmFecMode2 = this.getFECMode();
        return neDefaultsModel.getDefFecThr(eEqType2, eEqType3, eIntervalType2, eDwdmFecMode2);
    }

    @Override
    public sOTNThresholds getDefaultOTNThresholds(boolean bl, eIntervalType eIntervalType2, eMonitorType eMonitorType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefOtnThr(eEqType2, eEqType3, bl, eIntervalType2, eMonitorType2);
    }

    public boolean isMlseEnabled() throws NoSuchInterface, WrongInterfaceType, EMCProvisionError {
        boolean bl = false;
        try {
            bl = (Boolean)this.mlseModule.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getOTNSfBerLevel", userException);
        }
        return bl;
    }

    public void enableMlse(boolean bl) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.mlseModule.set(new Boolean(bl));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("enableMlse", userException);
        }
    }

    @Override
    public sProactiveProtectionConfig getProactiveProtectionConfig() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sProactiveProtectionConfig)this.proactiveProtectionConfig.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getProactiveProtectionConfig", userException);
        }
    }

    @Override
    public void setProactiveProtectionConfig(sProactiveProtectionConfig sProactiveProtectionConfig2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.proactiveProtectionConfig.set(sProactiveProtectionConfig2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            if (xProvisionError2.dataError == eProvDataError.INVALID_CARD_MODE) {
                throw new ProvisionError(EMC.EID_FRR_INVALID_CARD_MODE, new Object[]{xProvisionError2.dataError});
            }
            if (xProvisionError2.dataError == eProvDataError.INVALID_PAYLOAD) {
                throw new ProvisionError(EMC.EID_FRR_INVALID_PAYLOAD, new Object[]{xProvisionError2.dataError});
            }
            if (xProvisionError2.dataError == eProvDataError.INVALID_TRIGGER_WINDOW) {
                throw new ProvisionError(EMC.EID_FRR_INVALID_TRIGGER_WINDOW, new Object[]{xProvisionError2.dataError});
            }
            if (xProvisionError2.dataError == eProvDataError.INVALID_REVERT_WINDOW) {
                throw new ProvisionError(EMC.EID_FRR_INVALID_REVERT_WINDOW, new Object[]{xProvisionError2.dataError});
            }
            if (xProvisionError2.dataError == eProvDataError.INCOMPATIBLE_THRESHOLD_VALUE) {
                throw new ProvisionError(EMC.EID_FRR_INCOMPATIBLE_THRESHOLD, new Object[]{xProvisionError2.dataError});
            }
            throw new ProvisionError(EMC.EID_FRR_INVALID_PORT_MODE, new Object[]{xProvisionError2.dataError});
        }
        catch (UserException userException) {
            throw this.doUnknown("getProactiveProtectionConfig", userException);
        }
    }

    public Object[] getTriggerThresholdsList() {
        IModuleModel iModuleModel = null;
        try {
            iModuleModel = this.getPortModel().getModuleModel();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            return new Object[0];
        }
        if (iModuleModel != null) {
            Attribute[] attributeArray = ElementDefaults.getAttributeMap((IModel)iModuleModel).getAttributeArray("declFRRTriggerThreshold");
            Object[] objectArray = this.convertAttrArrayToObjectArray(attributeArray);
            return objectArray;
        }
        return new Object[0];
    }

    public Object[] getRevertThresholdsList() {
        IModuleModel iModuleModel = null;
        try {
            iModuleModel = this.getPortModel().getModuleModel();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            return null;
        }
        if (iModuleModel != null) {
            Attribute[] attributeArray = ElementDefaults.getAttributeMap((IModel)iModuleModel).getAttributeArray("declFRRRevertThreshold");
            Object[] objectArray = this.convertAttrArrayToObjectArray(attributeArray);
            return objectArray;
        }
        return null;
    }

    public int getTriggerThreshold() throws NoSuchInterface, WrongInterfaceType {
        return this.getProactiveProtectionConfig().triggerThreshold.value();
    }

    public int getRevertThreshold() throws NoSuchInterface, WrongInterfaceType {
        return this.getProactiveProtectionConfig().revertThreshold.value();
    }

    public int getTriggerWindow() throws NoSuchInterface, WrongInterfaceType {
        return this.getProactiveProtectionConfig().triggerWindow;
    }

    public int getRevertWindow() throws NoSuchInterface, WrongInterfaceType {
        return this.getProactiveProtectionConfig().revertWindow;
    }

    public void setFrrAttributes(int n, int n2, int n3, int n4) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        sProactiveProtectionConfig sProactiveProtectionConfig2 = new sProactiveProtectionConfig();
        sProactiveProtectionConfig2.triggerThreshold = eTriggerThreshold.from_int(n);
        sProactiveProtectionConfig2.triggerWindow = n3;
        sProactiveProtectionConfig2.revertThreshold = eRevertThreshold.from_int(n2);
        sProactiveProtectionConfig2.revertWindow = n4;
        this.setProactiveProtectionConfig(sProactiveProtectionConfig2);
    }

    private Object[] convertAttrArrayToObjectArray(Attribute[] attributeArray) {
        Object[] objectArray = new Object[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            objectArray[i] = attributeArray[i].getKey();
        }
        return objectArray;
    }

    public int getProactiveProtection() throws NoSuchInterface, WrongInterfaceType {
        return this.getDwdmLineConfig().proactiveProtection.value();
    }

    public void setProactiveProtection(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        sDwdmLineConfig sDwdmLineConfig2 = this.getDwdmLineConfig();
        sDwdmLineConfig2.proactiveProtection = eDwdmProactiveProtection.from_int(n);
        this.setDwdmLineConfig(sDwdmLineConfig2);
    }

    public void setRxWavelength(eWavelength eWavelength2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, ProvisionError {
        try {
            this.rxWavelength.set(eWavelength2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (xDetailedConfigError xDetailedConfigError2) {
            throw new DetailedConfigError(xDetailedConfigError2.message, xDetailedConfigError2.dataElement.value(), xDetailedConfigError2.dataError.value());
        }
        catch (UserException userException) {
            throw this.doUnknown("setRxWavelength", userException);
        }
    }

    public eWavelength getRxWavelength() throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, EMCProvisionError {
        try {
            eWavelength eWavelength2 = (eWavelength)this.rxWavelength.get();
            return eWavelength2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getRxWavelength", userException);
        }
    }

    public void setDpskVal(eDwdmDpsk eDwdmDpsk2) throws WrongInterfaceType, UnsupportedOperation {
        try {
            this.dpskVal.set(eDwdmDpsk2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setDpskVal", userException);
        }
    }

    public int getDpskVal() throws NoSuchInterface, WrongInterfaceType {
        try {
            eDwdmDpsk eDwdmDpsk2 = (eDwdmDpsk)this.dpskVal.get();
            return eDwdmDpsk2.value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getDpskVal", userException);
        }
    }

    @Override
    public int[] getCurrentPmPower() throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, InternalCommError {
        int[] nArray = new int[]{this.getOpticsCurrentValues().rxPower, this.getOpticsCurrentValues().txPower};
        return nArray;
    }

    @Override
    public int getActualPower() throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, InternalCommError {
        return this.getCurrentPmPower()[0];
    }

    @Override
    public boolean isCurrentlyActive() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        block6: {
            try {
                ModuleModel moduleModel = this.getModuleModel();
                if (moduleModel != null && moduleModel.isPreProvisioned()) {
                    ElementModel elementModel = this.getElementModel();
                    if (elementModel instanceof UnprotectedLineModel) {
                        return true;
                    }
                    return this.isWorkingLine();
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) break block6;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        return super.isCurrentlyActive();
    }

    private class CurrentPayloadLabel
    extends NonCachedValue {
        public CurrentPayloadLabel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            return new Byte(DwdmTrkLineModel.this.getDwdmTrkRef().getCurrentPayloadLabel(DwdmTrkLineModel.this.getIndex(), (eMonitorType)object));
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    class DpskVal
    extends CachedValue {
        public DpskVal(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            eDwdmDpsk eDwdmDpsk2 = DwdmTrkLineModel.this.getDwdmTrkRef().getDpskVal(DwdmTrkLineModel.this.getIndex());
            return eDwdmDpsk2;
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xUnsupportedOperation, xInUse {
            DwdmTrkLineModel.this.getDwdmTrkRef().setDpskVal(DwdmTrkLineModel.this.getIndex(), (eDwdmDpsk)object);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    class ExpectedTTI
    extends NonCachedValue {
        public ExpectedTTI(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            tTraceArrayHolder tTraceArrayHolder2 = new tTraceArrayHolder();
            DwdmTrkLineModel.this.getDwdmTrkRef().getExpectedTTITrace(DwdmTrkLineModel.this.getIndex(), (eMonitorType)object, tTraceArrayHolder2);
            return tTraceArrayHolder2.value;
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            eMonitorType eMonitorType2 = (eMonitorType)objectArray[0];
            String string = (String)objectArray[1];
            DwdmTrkLineModel.this.getDwdmTrkRef().setExpectedTTITrace(DwdmTrkLineModel.this.getIndex(), eMonitorType2, string);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class FECMode
    extends CachedValue {
        public FECMode(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return DwdmTrkLineModel.this.getDwdmTrkRef().getFECMode(DwdmTrkLineModel.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xDetailedConfigError, xNoSuchInterface, xProvisionError {
            Object[] objectArray = (Object[])object;
            DwdmTrkLineModel.this.getDwdmTrkRef().enableOTN(DwdmTrkLineModel.this.getIndex(), (Boolean)objectArray[0], (eDwdmFecMode)objectArray[1], (eMappingType)objectArray[2]);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class FECStats
    extends NonCachedValue {
        public FECStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xInternalCommError, xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            DwdmTrkLineModel.this.getDwdmTrkRef().clearFECStats(DwdmTrkLineModel.this.getIndex(), true, (eIntervalType)object);
        }

        @Override
        protected Object getValue(Object object) throws xInternalCommError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            short s = (Short)objectArray[1];
            sDwdmFECPmStats sDwdmFECPmStats2 = DwdmTrkLineModel.this.getDwdmTrkRef().getFECStats(DwdmTrkLineModel.this.getIndex(), (eIntervalType)objectArray[0], s);
            return sDwdmFECPmStats2;
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class FECThresholds
    extends NonCachedValue {
        public FECThresholds(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            sFECPmThresholds sFECPmThresholds2 = DwdmTrkLineModel.this.getDwdmTrkRef().getFECThresholds(DwdmTrkLineModel.this.getIndex(), (eIntervalType)object);
            return sFECPmThresholds2;
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            Object[] objectArray = (Object[])object;
            DwdmTrkLineModel.this.getDwdmTrkRef().setFECThresholds(DwdmTrkLineModel.this.getIndex(), (sFECPmThresholds)objectArray[0], (eIntervalType)objectArray[1]);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class FTFLStatus
    extends CachedValue {
        public FTFLStatus(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Boolean(DwdmTrkLineModel.this.getDwdmTrkRef().getFTFLStatus(DwdmTrkLineModel.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            DwdmTrkLineModel.this.getDwdmTrkRef().enableFTFL(DwdmTrkLineModel.this.getIndex(), (Boolean)object);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class MappingType
    extends CachedValue {
        public MappingType(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return DwdmTrkLineModel.this.getDwdmTrkRef().getMappingType(DwdmTrkLineModel.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xDetailedConfigError, xNoSuchInterface, xProvisionError {
            Object[] objectArray = (Object[])object;
            DwdmTrkLineModel.this.getDwdmTrkRef().enableOTN(DwdmTrkLineModel.this.getIndex(), (Boolean)objectArray[0], (eDwdmFecMode)objectArray[1], (eMappingType)objectArray[2]);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class MlseModule
    extends CachedValue {
        public MlseModule(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            return new Boolean(DwdmTrkLineModel.this.getDwdmTrkRef().isMlseEnabled(DwdmTrkLineModel.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xDetailedConfigError, xNoSuchInterface, xProvisionError {
            Boolean bl = (Boolean)object;
            DwdmTrkLineModel.this.getDwdmTrkRef().enableMlse(DwdmTrkLineModel.this.getIndex(), bl);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class OTNData
    extends CachedValue {
        public OTNData(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xDetailedConfigError, xNoSuchInterface, xProvisionError {
            Object[] objectArray = (Object[])object;
            DwdmTrkLineModel.this.getDwdmTrkRef().enableOTN(DwdmTrkLineModel.this.getIndex(), (Boolean)objectArray[0], (eDwdmFecMode)objectArray[1], (eMappingType)objectArray[2]);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class OTNStats
    extends NonCachedValue {
        public OTNStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xInternalCommError, xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            Object[] objectArray = (Object[])object;
            boolean bl = (Boolean)objectArray[0];
            DwdmTrkLineModel.this.getDwdmTrkRef().clearOTNStats(DwdmTrkLineModel.this.getIndex(), bl, (eIntervalType)objectArray[1]);
        }

        @Override
        protected Object getValue(Object object) throws xInternalCommError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            boolean bl = (Boolean)objectArray[0];
            short s = (Short)objectArray[2];
            sOTNLinePmStats sOTNLinePmStats2 = DwdmTrkLineModel.this.getDwdmTrkRef().getOTNStats(DwdmTrkLineModel.this.getIndex(), bl, (eIntervalType)objectArray[1], s);
            return sOTNLinePmStats2;
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class OTNStatus
    extends CachedValue {
        public OTNStatus(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Boolean(DwdmTrkLineModel.this.getDwdmTrkRef().getOTNStatus(DwdmTrkLineModel.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xDetailedConfigError, xNoSuchInterface, xProvisionError {
            Object[] objectArray = (Object[])object;
            DwdmTrkLineModel.this.getDwdmTrkRef().enableOTN(DwdmTrkLineModel.this.getIndex(), (Boolean)objectArray[0], (eDwdmFecMode)objectArray[1], (eMappingType)objectArray[2]);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class OTNThresholds
    extends NonCachedValue {
        public OTNThresholds(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            boolean bl = (Boolean)objectArray[0];
            sOTNThresholds sOTNThresholds2 = DwdmTrkLineModel.this.getDwdmTrkRef().getOTNThresholds(DwdmTrkLineModel.this.getIndex(), bl, (eIntervalType)objectArray[1], (eMonitorType)objectArray[2]);
            return sOTNThresholds2;
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            Object[] objectArray = (Object[])object;
            boolean bl = (Boolean)objectArray[1];
            DwdmTrkLineModel.this.getDwdmTrkRef().setOTNThresholds(DwdmTrkLineModel.this.getIndex(), (sOTNThresholds)objectArray[0], bl, (eIntervalType)objectArray[2], (eMonitorType)objectArray[3]);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class ProactiveProtectionConfig
    extends NonCachedValue {
        public ProactiveProtectionConfig(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            sProactiveProtectionConfig sProactiveProtectionConfig2 = DwdmTrkLineModel.this.getDwdmTrkRef().getProactiveProtectionConfig(DwdmTrkLineModel.this.getIndex());
            return sProactiveProtectionConfig2;
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            sProactiveProtectionConfig sProactiveProtectionConfig2 = (sProactiveProtectionConfig)object;
            DwdmTrkLineModel.this.getDwdmTrkRef().setProactiveProtectionConfig(DwdmTrkLineModel.this.getIndex(), sProactiveProtectionConfig2);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    class ReceivedTTI
    extends NonCachedValue {
        public ReceivedTTI(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xInternalCommError, xWrongInterfaceType, xNoSuchInterface {
            tTraceArrayHolder tTraceArrayHolder2 = new tTraceArrayHolder();
            DwdmTrkLineModel.this.getDwdmTrkRef().getReceivedTTITrace(DwdmTrkLineModel.this.getIndex(), (eMonitorType)object, tTraceArrayHolder2);
            return tTraceArrayHolder2.value;
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class RegenPeer
    extends CachedValue {
        public RegenPeer(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Integer(DwdmTrkLineModel.this.getDwdmTrkRef().getRegenPeerCard(DwdmTrkLineModel.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            DwdmTrkLineModel.this.getDwdmTrkRef().setRegenPeerCard(DwdmTrkLineModel.this.getIndex(), (Integer)object);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class RegenPeerLine
    extends CachedValue {
        public RegenPeerLine(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Integer(DwdmTrkLineModel.this.getDwdmTrkRef().getRegenPeerLine(DwdmTrkLineModel.this.getIndex()));
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class RxWavelength
    extends CachedValue {
        public RxWavelength(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            return DwdmTrkLineModel.this.getDwdmTrkRef().getTrunkRxWavelength(DwdmTrkLineModel.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            DwdmTrkLineModel.this.getDwdmTrkRef().setTrunkRxWavelength(DwdmTrkLineModel.this.getIndex(), (eWavelength)object);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class SdBerLevel
    extends CachedValue {
        public SdBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Short(DwdmTrkLineModel.this.getDwdmTrkRef().getLineDeclareSdBerLevel(DwdmTrkLineModel.this.getIndex()));
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            DwdmTrkLineModel.this.getDwdmTrkRef().setLineDeclareSdBerLevel(DwdmTrkLineModel.this.getIndex(), (Short)object);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class SendTTI
    extends NonCachedValue {
        public SendTTI(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            StringHolder stringHolder = new StringHolder();
            DwdmTrkLineModel.this.getDwdmTrkRef().getSendTTITrace(DwdmTrkLineModel.this.getIndex(), (eMonitorType)object, stringHolder);
            return stringHolder.value;
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            eMonitorType eMonitorType2 = (eMonitorType)objectArray[0];
            String string = (String)objectArray[1];
            DwdmTrkLineModel.this.getDwdmTrkRef().setSendTTITrace(DwdmTrkLineModel.this.getIndex(), eMonitorType2, string);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class SfBerLevel
    extends CachedValue {
        public SfBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Short(DwdmTrkLineModel.this.getDwdmTrkRef().getLineDeclareSfBerLevel(DwdmTrkLineModel.this.getIndex()));
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    class TTIFormat
    extends NonCachedValue {
        public TTIFormat(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            return DwdmTrkLineModel.this.getDwdmTrkRef().getTTITraceFormat(DwdmTrkLineModel.this.getIndex(), (eMonitorType)object);
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            eMonitorType eMonitorType2 = (eMonitorType)objectArray[0];
            eTraceFormat eTraceFormat2 = (eTraceFormat)objectArray[1];
            DwdmTrkLineModel.this.getDwdmTrkRef().setTTITraceFormat(DwdmTrkLineModel.this.getIndex(), eMonitorType2, eTraceFormat2);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    class TTIMode
    extends NonCachedValue {
        public TTIMode(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            eTraceMode eTraceMode2 = DwdmTrkLineModel.this.getDwdmTrkRef().getTTITraceMode(DwdmTrkLineModel.this.getIndex(), (eMonitorType)object);
            return eTraceMode2;
        }

        @Override
        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            eMonitorType eMonitorType2 = (eMonitorType)objectArray[0];
            eTraceMode eTraceMode2 = (eTraceMode)objectArray[1];
            DwdmTrkLineModel.this.getDwdmTrkRef().setTTITraceMode(DwdmTrkLineModel.this.getIndex(), eMonitorType2, eTraceMode2);
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }

    private class TunableWlList
    extends CachedValue {
        public TunableWlList(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface, xUnsupportedOperation {
            int n = DwdmTrkLineModel.this.getIndex();
            if (DwdmTrkLineModel.this.db.on()) {
                DwdmTrkLineModel.this.db.println("TunableWlList.getValue() - before request for ObjIdx: 0x" + Integer.toHexString(n));
            }
            eWavelength[] eWavelengthArray = DwdmTrkLineModel.this.getIfRef().getWavelengthList(n);
            if (DwdmTrkLineModel.this.db.on()) {
                DwdmTrkLineModel.this.db.println("TunableWlList.getValue() - got Wl list");
            }
            return eWavelengthArray;
        }

        public Object outer() {
            return DwdmTrkLineModel.this;
        }
    }
}

