/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Dwdm.sOpticsCurrentValues;
import cerent.cms.idl.Dwdm.sOpticsPmStats;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EtherMediaModel;
import cerent.cms.model.IOpticsChannelModel;
import cerent.cms.model.IOpticsPmModel;
import cerent.cms.model.IOpticsProvExtModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.ISupportsOpticsProvExtModel;
import cerent.cms.model.ISupportsRMON;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.MfgDataHelper;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsProvExtModel;
import cerent.cms.model.PoolModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RmonModel;
import cerent.cms.model.TNCModuleModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2ChannelGroupModel;
import cerent.util.SDebug;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.UserException;

public class EtherLineModel
extends EtherMediaModel
implements ISupportsRMON,
IOpticsPmModel,
ISupportsOpticsProvExtModel,
IOpticsChannelModel {
    private RmonModel rmonModel;
    private OpticsProvExtModel opticsProvExtModel;
    private PreServiceAlarmSuppress preServiceAlarmSuppress;

    public EtherLineModel(NodeModelDelegate nodeModelDelegate, int n) {
        this(nodeModelDelegate, n, nodeModelDelegate.getChildDebug(EtherLineModel.class));
    }

    public EtherLineModel(NodeModelDelegate nodeModelDelegate, int n, SDebug sDebug) {
        super(nodeModelDelegate, n, sDebug);
        boolean bl = true;
        try {
            if (this.getModuleModel() instanceof DwdmModuleModel || this.getModuleModel() instanceof TNCModuleModel || this instanceof XPL2ChannelGroupModel) {
                bl = false;
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            // empty catch block
        }
        this.opticsProvExtModel = new OpticsProvExtModel(this);
        this.rmonModel = new RmonModel((NodeModelDelegate)this.getNodeModel(), this, bl);
        this.preServiceAlarmSuppress = new PreServiceAlarmSuppress(nodeModelDelegate, "EtherLineModel.preServiceAlarmSuppress");
    }

    @Override
    public List getConnectionsList() {
        PoolModel poolModel = (PoolModel)this.getNodeModelDelegate().getPoolModels().getPoolModel(this.getIndex());
        if (poolModel != null) {
            return poolModel.getConnectionsList();
        }
        return new LinkedList();
    }

    @Override
    public IRmonModel getRmonModel() {
        return this.rmonModel;
    }

    @Override
    public IOpticsProvExtModel getOpticsProvExtModel() {
        return this.opticsProvExtModel;
    }

    @Override
    protected void updateLocal(long l) {
        if (this.db.on()) {
            this.db.println("EtherLineModel::updateLocal(sequenceNum)");
        }
        this.preServiceAlarmSuppress.update();
        this.setChanged();
        super.updateLocal(l);
    }

    public boolean isWavelengthSupported() throws NoSuchInterface, WrongInterfaceType {
        boolean bl = this.opticsProvExtModel.isLineWavelengthSupported();
        if (!bl) {
            bl = this.getWlenFromMfgData() != null;
        }
        return bl;
    }

    public int getActualWaveLength() throws NoSuchInterface, WrongInterfaceType {
        if (this.opticsProvExtModel.isLineWavelengthSupported()) {
            try {
                return this.opticsProvExtModel.getLineWavelength().value();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                throw new NoSuchInterface(unsupportedOperation.getMessage());
            }
        }
        eWavelength eWavelength2 = this.getWlenFromMfgData();
        if (eWavelength2 != null) {
            return eWavelength2.value();
        }
        throw new NoSuchInterface("The method getActualWaveLength() is not supported.");
    }

    public void setWaveLength(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, ProvisionError {
        try {
            this.opticsProvExtModel.setLineWavelength(eWavelength.from_int(n));
        }
        catch (ConfigError configError) {
            throw new DetailedConfigError(configError.getUserException());
        }
        catch (UnsupportedOperation unsupportedOperation) {
            throw new WrongInterfaceType(unsupportedOperation.getUserException());
        }
    }

    @Override
    public int getExpectedWaveLength() throws NoSuchInterface, WrongInterfaceType {
        return this.getActualWaveLength();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private eWavelength getWlenFromMfgData() {
        MfgDataHelper mfgDataHelper;
        try {
            mfgDataHelper = this.getModuleModel().getMfgDataHelper();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
            return null;
        }
        Map map = mfgDataHelper.getExtraInfoMap();
        String string = (String)map.get("WL");
        if (string != null) {
            double d = Double.parseDouble(string);
            long l = (long)d;
            long l2 = (long)((d - (double)l) * 1000.0) + 5L;
            d = (double)l + (double)(l2 /= 10L) / 100.0;
            String string2 = "" + d;
            string2 = string2.replaceAll("\\.", "_");
            string2 = string2.replaceAll(",", "_");
            String string3 = "WV_" + string2;
            try {
                Field field = eWavelength.class.getField(string3);
                eWavelength eWavelength2 = (eWavelength)field.get(null);
                if (!this.db.on()) return eWavelength2;
                this.db.println("Found lambda from mfg data: " + string + " == " + eWavelength2.value());
                return eWavelength2;
            }
            catch (Throwable throwable) {
                if (!this.db.on()) return null;
                if (this.db.on()) {
                    this.db.println("Cannot translate lambda found in mfg data: " + string + ": " + throwable.getMessage());
                }
                SDebug.printStackTrace((Throwable)throwable);
                return null;
            }
        } else {
            if (!this.db.on()) return null;
            Iterator iterator = map.keySet().iterator();
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                stringBuffer.append("\n\t" + string4 + " ==> " + map.get(string4));
            }
            this.db.println("Cannot find lambda in mfg data. Map contains:" + stringBuffer.toString());
        }
        return null;
    }

    public Boolean getPreServiceAlarmSuppress() throws EMCProvisionError {
        Boolean bl;
        try {
            bl = (Boolean)this.preServiceAlarmSuppress.get();
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getPreServiceAlarmSuppress", userException);
        }
        return bl;
    }

    public void setPreServiceAlarmSuppress(Boolean bl) throws EMCProvisionError {
        try {
            this.preServiceAlarmSuppress.set(bl);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setPreServiceAlarmSuppress", userException);
        }
    }

    @Override
    public sOpticsCurrentValues getOpticsCurrentValues() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        return null;
    }

    @Override
    public sOpticsPmStats getOpticsStats(eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        return null;
    }

    @Override
    public void clearOpticsStats(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
    }

    @Override
    public void dispose() {
        this.rmonModel.dispose();
        this.opticsProvExtModel.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        this.rmonModel.destroy();
        this.opticsProvExtModel.destroy();
        super.destroy();
    }

    @Override
    public int[] getCurrentPmPower() throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, InternalCommError {
        int[] nArray = new int[]{this.getOpticsCurrentValuesForTNC().rxPower, this.getOpticsCurrentValuesForTNC().txPower};
        return nArray;
    }

    private class PreServiceAlarmSuppress
    extends CachedValue {
        public PreServiceAlarmSuppress(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xProvisionError, UserException {
            boolean bl = (Boolean)object;
            EtherLineModel.this.getEtherMediaRef().setPreServiceAlarmSuppress(EtherLineModel.this.getIndex(), bl);
        }

        @Override
        protected Object getValue() throws xProvisionError, UserException {
            return new Boolean(EtherLineModel.this.getEtherMediaRef().getPreServiceAlarmSuppress(EtherLineModel.this.getIndex()));
        }

        public Object outer() {
            return EtherLineModel.this;
        }
    }
}

