/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Rmon.sAlarmAdminInfo;
import cerent.cms.idl.Rmon.sAlarmRunTimeInfo;
import cerent.cms.idl.Rmon.xNoSuchAlarm;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EtherBridgeModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class EtherThresholdModel
extends Model {
    private NodeModelDelegate nmd;
    private short alarmIndex;
    private AlarmDelete alarmDelete;
    private AlarmAdminInfo alarmAdminInfo;
    private AlarmRunTimeInfo alarmRunTimeInfo;
    private EventDispatcher dispatcher;
    Short key;

    public void delete() throws xNoSuchAlarm {
        try {
            this.alarmDelete.set(null);
        }
        catch (xNoSuchAlarm xNoSuchAlarm2) {
            throw xNoSuchAlarm2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public sAlarmAdminInfo getAlarmAdminInfo() throws xNoSuchAlarm {
        try {
            return (sAlarmAdminInfo)this.alarmAdminInfo.get();
        }
        catch (xNoSuchAlarm xNoSuchAlarm2) {
            throw xNoSuchAlarm2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public sAlarmRunTimeInfo getAlarmRunTimeInfo() throws xNoSuchAlarm {
        try {
            return (sAlarmRunTimeInfo)this.alarmRunTimeInfo.get();
        }
        catch (xNoSuchAlarm xNoSuchAlarm2) {
            throw xNoSuchAlarm2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public EtherThresholdModel(NodeModelDelegate nodeModelDelegate, short s, sAlarmAdminInfo sAlarmAdminInfo2, sAlarmRunTimeInfo sAlarmRunTimeInfo2) {
        super(nodeModelDelegate.getChildDebug(EtherThresholdModel.class));
        this.nmd = nodeModelDelegate;
        this.alarmIndex = s;
        this.alarmDelete = new AlarmDelete(nodeModelDelegate, "EtherBridgeModel::deleteAlarm");
        this.alarmAdminInfo = new AlarmAdminInfo(nodeModelDelegate, "EtherBridgeModel::alarmAdminInfo", sAlarmAdminInfo2);
        this.alarmRunTimeInfo = new AlarmRunTimeInfo(nodeModelDelegate, "EtherBridgeModel::alarmRunTimeInfo");
        if (sAlarmRunTimeInfo2 != null) {
            this.alarmRunTimeInfo.setValueExternally(sAlarmRunTimeInfo2);
        }
        this.index = this.alarmIndex;
        this.dispatcher = null;
    }

    public void init() {
        super.init0();
        if (this.db.on()) {
            this.db.println("EtherThresholdModel::init()");
        }
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectRmonAlarm, (int)this.alarmIndex, (Observer)this);
        }
        this.key = new Short(this.getThresholdIndex());
    }

    @Override
    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectRmonAlarm, (int)this.alarmIndex, (Observer)this);
            this.dispatcher = null;
        }
        super.dispose();
    }

    public short getThresholdIndex() {
        if (this.db.on()) {
            this.db.println("EtherThresholdModel::getThresholdIndex()");
        }
        return this.alarmIndex;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println("Object deleted.");
                    }
                    ((EtherBridgeModel)this.nmd.getEtherBridgeModel()).getEtherPmModel().removeEtherThreshold(this);
                    this.destroy();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println("Making local changes.");
                    }
                    this.updateLocal();
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    @Override
    protected void updateLocal() {
        this.alarmAdminInfo.update();
        this.alarmRunTimeInfo.update();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    class AlarmAdminInfo
    extends CachedValue {
        public AlarmAdminInfo(NodeModelDelegate nodeModelDelegate, String string, Object object) {
            super(nodeModelDelegate, string, object);
        }

        @Override
        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getEtherPmRef().getAlarmAdminInfo(EtherThresholdModel.this.alarmIndex);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return EtherThresholdModel.this;
        }
    }

    class AlarmDelete
    extends NonCachedValue {
        public AlarmDelete(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            this.node.getIorRepository().getEtherPmRef().deleteAlarm(EtherThresholdModel.this.alarmIndex);
        }

        public Object outer() {
            return EtherThresholdModel.this;
        }
    }

    class AlarmRunTimeInfo
    extends CachedValue {
        public AlarmRunTimeInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getEtherPmRef().getAlarmRunTimeInfo(EtherThresholdModel.this.alarmIndex);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return EtherThresholdModel.this;
        }
    }
}

