/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sIpFtpHost;
import cerent.cms.idl.Node.eNodeUpdate;
import cerent.cms.idl.Node.xFtpHostAlreadyExists;
import cerent.cms.idl.Node.xMaxFtpHosts;
import cerent.cms.model.CachedValue;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FtpHostAlreadyExistsException;
import cerent.cms.model.INodeModel;
import cerent.cms.model.MaxFtpHostsException;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class FtpHostsModel
extends Model {
    private NodeModelDelegate nmdRef;
    protected CachedValue getFtpHostsObj;
    protected NonCachedValue addFtpHostObj;
    protected NonCachedValue deleteFtpHostObj;
    protected NonCachedValue updateFtpHostObj;
    private eNodeUpdate updateTypeObj;
    private EventDispatcher dispatcher;

    protected FtpHostsModel(NodeModelDelegate nodeModelDelegate, SDebug sDebug, eNodeUpdate eNodeUpdate2) {
        super(sDebug);
        this.index = 0;
        this.nmdRef = nodeModelDelegate;
        this.updateTypeObj = eNodeUpdate2;
        this.dispatcher = null;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmdRef;
    }

    private NodeModelDelegate getNode() {
        return this.nmdRef;
    }

    public void init() {
        if (this.dispatcher == null) {
            this.dispatcher = this.getNode().getDispatcher();
        }
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSystem, this.updateTypeObj.value(), (Observer)this);
        }
        this.getFtpHostsObj.init();
        super.init0();
    }

    @Override
    protected void updateLocal() {
        this.getFtpHostsObj.update();
        this.setChanged();
        super.updateLocal();
    }

    @Override
    public void update(Observable observable, Object object) {
        IObjectMessageInfo iObjectMessageInfo = (IObjectMessageInfo)object;
        switch (iObjectMessageInfo.getUpdateType()) {
            case 0: 
            case 1: 
            case 2: {
                this.updateLocal();
                break;
            }
        }
    }

    @Override
    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSystem, this.updateTypeObj.value(), (Observer)this);
            this.dispatcher = null;
        }
        this.getFtpHostsObj.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public sIpFtpHost[] getFtpHosts() {
        try {
            return (sIpFtpHost[])this.getFtpHostsObj.get();
        }
        catch (UserException userException) {
            this.getNode();
            throw NodeModelDelegate.doUnknown(this.db, "getFtpHosts", userException);
        }
    }

    public void addFtpHost(sIpFtpHost sIpFtpHost2) throws FtpHostAlreadyExistsException, MaxFtpHostsException {
        try {
            this.addFtpHostObj.set(sIpFtpHost2);
            this.getFtpHostsObj.update();
        }
        catch (xFtpHostAlreadyExists xFtpHostAlreadyExists2) {
            throw new FtpHostAlreadyExistsException((UserException)xFtpHostAlreadyExists2);
        }
        catch (xMaxFtpHosts xMaxFtpHosts2) {
            throw new MaxFtpHostsException((UserException)xMaxFtpHosts2);
        }
        catch (UserException userException) {
            this.getNode();
            throw NodeModelDelegate.doUnknown(this.db, "addFtpHost", userException);
        }
    }

    public void deleteFtpHost(sIpFtpHost sIpFtpHost2) {
        try {
            this.deleteFtpHostObj.set(sIpFtpHost2);
            this.getFtpHostsObj.update();
        }
        catch (UserException userException) {
            this.getNode();
            throw NodeModelDelegate.doUnknown(this.db, "deleteFtpHost", userException);
        }
    }

    public void updateFtpHost(sIpFtpHost sIpFtpHost2) {
        try {
            this.updateFtpHostObj.set(sIpFtpHost2);
            this.getFtpHostsObj.update();
        }
        catch (UserException userException) {
            this.getNode();
            throw NodeModelDelegate.doUnknown(this.db, "updateFtpHost", userException);
        }
    }
}

