/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.IosConfig.General;
import cerent.cms.idl.IosConfig.eIosConfigRoute;
import cerent.cms.idl.IosConfig.sSourceOriginProperties;
import cerent.cms.idl.IosConfig.xIosConfigTooBig;
import cerent.cms.idl.IosConfig.xNoIosConfig;
import cerent.cms.idl.IosConfig.xSoftwareError;
import cerent.cms.idl.IosConfig.xUpdateInProgress;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IorRepository;
import cerent.cms.model.IosConfigTooBig;
import cerent.cms.model.IosModuleModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoIosConfig;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SoftwareError;
import cerent.cms.model.UpdateInProgress;
import cerent.util.SDebug;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class IosConfigModel
extends Model {
    private INodeModel nodeModel;
    private SourceOriginProperties sourceOriginProperties;
    private IosConfig iosConfig;
    private IosConfigMerged iosConfigMerged;
    private EventDispatcher dispatcher;
    public static final short MAX_NAME_LENGTH = 64;

    public IosConfigModel(NodeModelDelegate nodeModelDelegate, int n) {
        super(nodeModelDelegate.getChildDebug(IosConfigModel.class));
        if (this.db.on) {
            this.db.println("Creating a new IosConfigModel for entityIndex=" + n);
        }
        this.index = n;
        this.nodeModel = nodeModelDelegate;
        this.dispatcher = nodeModelDelegate.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(50, this.index, (Observer)this);
            if (this.db.on) {
                this.db.println("ADDED observer for index: " + this.index);
            }
        } else if (this.db.on) {
            this.db.println("Could not register with EventDispatcher for IosConfig changes.");
        }
        this.sourceOriginProperties = new SourceOriginProperties(nodeModelDelegate, "IosConfigModel::sourceOriginProperties");
        this.iosConfig = new IosConfig(nodeModelDelegate, "IosConfigModel::iosConfig");
        this.iosConfigMerged = new IosConfigMerged(nodeModelDelegate, "IosConfigModel::iosConfigMerged");
        this.init0();
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    public String getSourceOriginTimestamp() {
        sSourceOriginProperties sSourceOriginProperties2 = this.getSourceOriginProperties();
        int n = sSourceOriginProperties2.timeStamp;
        EventUtilities eventUtilities = EventUtilities.getInstance((NodeModelDelegate)this.nodeModel);
        return eventUtilities.convertSecondsToFormattedTimeZoneString(n);
    }

    public String getSourceOriginConfigRoute() {
        sSourceOriginProperties sSourceOriginProperties2 = this.getSourceOriginProperties();
        String string = null;
        switch (sSourceOriginProperties2.route.value()) {
            case 0: {
                string = "TL1";
                break;
            }
            case 1: {
                string = "CTC";
                break;
            }
            case 2: {
                string = "CLI";
                break;
            }
            case 3: {
                string = this.getControlCardName();
                break;
            }
            case 4: {
                string = "CTM";
                break;
            }
            default: {
                string = "UNKNOWN:" + sSourceOriginProperties2.route;
            }
        }
        return string;
    }

    public String getControlCardName() {
        try {
            return ((NodeModelDelegate)this.nodeModel).getPlatform().getControlCardName();
        }
        catch (Exception exception) {
            if (this.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "Unknown";
        }
    }

    public String getSourceOriginHostName() {
        sSourceOriginProperties sSourceOriginProperties2 = this.getSourceOriginProperties();
        return sSourceOriginProperties2.host;
    }

    public String getSourceOriginDirectory() {
        sSourceOriginProperties sSourceOriginProperties2 = this.getSourceOriginProperties();
        return sSourceOriginProperties2.directory;
    }

    public String getSourceOriginFileName() {
        sSourceOriginProperties sSourceOriginProperties2 = this.getSourceOriginProperties();
        return sSourceOriginProperties2.file;
    }

    public sSourceOriginProperties getSourceOriginProperties() {
        if (this.db.on()) {
            this.db.println("getSourceOriginProperties");
        }
        sSourceOriginProperties sSourceOriginProperties2 = new sSourceOriginProperties(0, eIosConfigRoute.TCC, "NONE", "NONE", "NONE");
        try {
            sSourceOriginProperties2 = (sSourceOriginProperties)this.sourceOriginProperties.get();
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            if (this.db.on) {
                this.db.println("xNoSuchEquipment caught in getSourceOriginProperties(): " + (Object)((Object)xNoSuchEquipment2));
            }
        }
        catch (xNoIosConfig xNoIosConfig2) {
            if (this.db.on) {
                this.db.println("xNoIosConfig caught in getSourceOriginProperties(): " + (Object)((Object)xNoIosConfig2));
            }
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            if (this.db.on) {
                this.db.println("xNotSupportedOnEquipment caught in getSourceOriginProperties(): " + (Object)((Object)xNotSupportedOnEquipment2));
            }
        }
        catch (UserException userException) {
            throw this.doUnknown("getSourceOriginProperties", userException);
        }
        return sSourceOriginProperties2;
    }

    public String retrieveIosConfig() throws IosConfigTooBig, SoftwareError, UpdateInProgress, NoIosConfig {
        return this._retrieveIosConfig();
    }

    public String retrieveIosConfig0() throws IosConfigTooBig, SoftwareError, UpdateInProgress, NoIosConfig {
        return this._retrieveIosConfig();
    }

    protected String _retrieveIosConfig() throws IosConfigTooBig, SoftwareError, UpdateInProgress, NoIosConfig {
        String string = "<< No IOS Config file found! >>";
        this.db.fine("getIosConfig");
        try {
            string = (String)this.iosConfig.get();
        }
        catch (xNoIosConfig xNoIosConfig2) {
            if (this.db.isSevereEnabled()) {
                SDebug.printStackTrace((Throwable)((Object)xNoIosConfig2));
            }
            throw new NoIosConfig((UserException)xNoIosConfig2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            this.db.println("Exception caught in getIosConfig(): " + (Object)((Object)xNoSuchEquipment2));
            SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            throw new SoftwareError((UserException)xNoSuchEquipment2);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            this.db.println("Exception caught in getIosConfig(): " + (Object)((Object)xNotSupportedOnEquipment2));
            SDebug.printStackTrace((Throwable)((Object)xNotSupportedOnEquipment2));
            throw new SoftwareError((UserException)xNotSupportedOnEquipment2);
        }
        catch (xSoftwareError xSoftwareError2) {
            this.db.println("Exception caught in getIosConfig(): " + (Object)((Object)xSoftwareError2));
            throw new SoftwareError((UserException)xSoftwareError2);
        }
        catch (xUpdateInProgress xUpdateInProgress2) {
            this.db.println("Exception caught in getIosConfig(): " + (Object)((Object)xUpdateInProgress2));
            throw new UpdateInProgress((UserException)xUpdateInProgress2);
        }
        catch (UserException userException) {
            this.db.println("Exception caught in getIosConfig(): " + (Object)((Object)userException));
            throw this.doUnknown("getIosConfig", userException);
        }
        return string;
    }

    public void saveIosConfig(String string, String string2, String string3, String string4, int n, eIosConfigRoute eIosConfigRoute2) throws IosConfigTooBig, SoftwareError, UpdateInProgress, CmsNodeUpgradingException {
        block8: {
            if (this.db.on) {
                this.db.println("saveIosConfig()");
            }
            try {
                SaveIosConfigParameters saveIosConfigParameters = new SaveIosConfigParameters(string, string2, string3, string4, n, eIosConfigRoute2);
                this.iosConfig.set(saveIosConfigParameters);
            }
            catch (xIosConfigTooBig xIosConfigTooBig2) {
                this.db.println("Exception caught in saveIosConfig(): " + (Object)((Object)xIosConfigTooBig2));
                throw new IosConfigTooBig((UserException)xIosConfigTooBig2);
            }
            catch (xNoSuchEquipment xNoSuchEquipment2) {
                this.db.println("Exception caught in saveIosConfig(): " + (Object)((Object)xNoSuchEquipment2));
                SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
                throw new SoftwareError((UserException)xNoSuchEquipment2);
            }
            catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
                this.db.println("Exception caught in saveIosConfig(): " + (Object)((Object)xNotSupportedOnEquipment2));
                SDebug.printStackTrace((Throwable)((Object)xNotSupportedOnEquipment2));
                throw new SoftwareError((UserException)xNotSupportedOnEquipment2);
            }
            catch (xSoftwareError xSoftwareError2) {
                this.db.println("Exception caught in saveIosConfig(): " + (Object)((Object)xSoftwareError2));
                throw new SoftwareError((UserException)xSoftwareError2);
            }
            catch (xUpdateInProgress xUpdateInProgress2) {
                this.db.println("Exception caught in saveIosConfig(): " + (Object)((Object)xUpdateInProgress2));
                throw new UpdateInProgress((UserException)xUpdateInProgress2);
            }
            catch (Exception exception) {
                this.db.println("Exception caught in saveIosConfig(): " + exception);
                SDebug.printStackTrace((Throwable)exception);
                if (!(exception instanceof CmsNodeUpgradingException)) break block8;
                this.db.println("CmsNodeUpgradingException caught in Model : " + exception);
                throw (CmsNodeUpgradingException)exception;
            }
        }
    }

    public void saveIosConfig(String string, String string2, String string3, String string4, int n) throws IosConfigTooBig, SoftwareError, UpdateInProgress {
        this.saveIosConfig(string, string2, string3, string4, n, eIosConfigRoute.CTC);
    }

    public void saveIosConfigCTM(String string, String string2, String string3, String string4, int n) throws IosConfigTooBig, SoftwareError, UpdateInProgress {
        this.saveIosConfig(string, string2, string3, string4, n, eIosConfigRoute.CTM);
    }

    public boolean isIosConfigMerged() {
        boolean bl = false;
        if (this.db.on) {
            this.db.println("isIosConfigMerged");
        }
        try {
            bl = (Boolean)this.iosConfigMerged.get();
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            this.db.println("Exception caught in isIosConfigMerged(): " + (Object)((Object)xNoSuchEquipment2));
            SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            this.db.println("Exception caught in isIosConfigMerged(): " + (Object)((Object)xNotSupportedOnEquipment2));
            SDebug.printStackTrace((Throwable)((Object)xNotSupportedOnEquipment2));
        }
        catch (UserException userException) {
            this.db.println("Exception caught in isIosConfigMerged(): " + (Object)((Object)userException));
            throw this.doUnknown("isIosConfigMerged", userException);
        }
        return bl;
    }

    public void mergeIosConfig() {
        if (this.db.on) {
            this.db.println("mergeIosConfig");
        }
        try {
            this.iosConfigMerged.set();
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            this.db.println("Exception caught in mergeIosConfig(): " + (Object)((Object)xNoSuchEquipment2));
            SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            this.db.println("Exception caught in mergeIosConfig(): " + (Object)((Object)xNotSupportedOnEquipment2));
            SDebug.printStackTrace((Throwable)((Object)xNotSupportedOnEquipment2));
        }
        catch (UserException userException) {
            this.db.println("Exception caught in mergeIosConfig(): " + (Object)((Object)userException));
            throw this.doUnknown("mergeIosConfig", userException);
        }
    }

    @Override
    public void destroy() {
        this.dispose();
        if (this.db.on()) {
            this.db.println("EtherMediaModel::destroy()");
        }
        super.destroy();
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(50, this.index, (Observer)this);
            if (this.db.on) {
                this.db.println("DELETED observer for slot: " + this.index);
            }
        } else {
            this.db.println("Could not unregister with EventDispatcher for IosConfig changes.");
        }
        this.sourceOriginProperties.dispose();
        this.iosConfig.dispose();
        this.sourceOriginProperties = null;
        this.iosConfigMerged = null;
        this.iosConfig = null;
    }

    @Override
    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("IosConfigModel::updateLocal()");
        }
        this.setChanged();
        this.iosConfig.update();
        this.sourceOriginProperties.update();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.db.on) {
            this.db.println("Got an update in IosConfigModel(from=" + observable + ", arg=" + object + ")");
        }
        this.updateLocal();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    protected General getIosConfigRef() {
        if (this.db.on) {
            this.db.finest("------------------------------------------ nodeModel is: " + this.nodeModel);
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.nodeModel;
        IorRepository iorRepository = nodeModelDelegate.getIorRepository();
        if (this.db.on) {
            this.db.finest("   iorr is: " + iorRepository + "\n\n");
        }
        return iorRepository.getIosConfigRef();
    }

    protected UNKNOWN doUnknown(String string, UserException userException) {
        this.db.println("Caught unexpected exception in " + string);
        SDebug.printStackTrace((Throwable)userException);
        return new UNKNOWN("Caught unexpected exception in " + string + " : " + (Object)((Object)userException));
    }

    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) {
        EntityTableModel entityTableModel = nodeModelDelegate.getEntityTableModel();
        IEntityModel iEntityModel = null;
        try {
            iEntityModel = entityTableModel.getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            // empty catch block
        }
        if (iEntityModel instanceof IosModuleModel) {
            ((IosModuleModel)iEntityModel).getIosConfig();
        }
    }

    private class IosConfig
    extends CachedValue {
        public IosConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            IosConfigModel.this.db.finest("++++++++++++++ inside getValue() for IosConfig ++++++++++++");
            return IosConfigModel.this.getIosConfigRef().retrieveIosConfig(IosConfigModel.this.index);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            int n = 0;
            if (object instanceof SaveIosConfigParameters) {
                SaveIosConfigParameters saveIosConfigParameters = (SaveIosConfigParameters)object;
                String string = saveIosConfigParameters.getIosConfigFileContents();
                String string2 = saveIosConfigParameters.getIosConfigFileDirectoryName();
                String string3 = saveIosConfigParameters.getIosConfigFileFileName();
                String string4 = saveIosConfigParameters.getIosConfigFileHostName();
                n = saveIosConfigParameters.getTimeInSeconds();
                eIosConfigRoute eIosConfigRoute2 = saveIosConfigParameters.iosConfigRoute;
                Date date = new Date((long)n * 1000L);
                if (IosConfigModel.this.db.on) {
                    IosConfigModel.this.db.finest("\n CORBA all to saveIosConfig:");
                    IosConfigModel.this.db.finest("time (in seconds): " + n);
                    IosConfigModel.this.db.finest("hostname: " + string4);
                    IosConfigModel.this.db.finest("dirName: " + string2);
                    IosConfigModel.this.db.finest("fileName: " + string3);
                    IosConfigModel.this.db.finest("route: " + eIosConfigRoute2);
                }
                sSourceOriginProperties sSourceOriginProperties2 = new sSourceOriginProperties(n, eIosConfigRoute2, string4, string2, string3);
                IosConfigModel.this.getIosConfigRef().saveIosConfig(IosConfigModel.this.index, string, sSourceOriginProperties2);
            } else {
                if (IosConfigModel.this.db.on) {
                    IosConfigModel.this.db.finest("The non SaveIosConfigParameters version was called!");
                }
                sSourceOriginProperties sSourceOriginProperties3 = new sSourceOriginProperties(n, eIosConfigRoute.CTC, "host", "directory", "fileName");
                IosConfigModel.this.getIosConfigRef().saveIosConfig(IosConfigModel.this.index, (String)object, sSourceOriginProperties3);
            }
        }

        public Object outer() {
            return IosConfigModel.this;
        }
    }

    private class IosConfigMerged
    extends CachedValue {
        public IosConfigMerged(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            return new Boolean(true);
        }

        public Object outer() {
            return IosConfigModel.this;
        }
    }

    private class SaveIosConfigParameters {
        private String iosConfigFileContents = "<<file contents>>";
        private String iosConfigFileHostName = "<<host name>>";
        private String iosConfigFileDirectoryName = "<<directory>>";
        private String iosConfigFileFileName = "<<file name>>";
        private int timeInSeconds = 0;
        public final eIosConfigRoute iosConfigRoute;

        public SaveIosConfigParameters(String string, String string2, String string3, String string4, int n, eIosConfigRoute eIosConfigRoute2) {
            this.iosConfigFileContents = string;
            this.iosConfigFileHostName = string2;
            this.iosConfigFileDirectoryName = string3;
            this.iosConfigFileFileName = string4;
            this.timeInSeconds = n;
            this.iosConfigRoute = eIosConfigRoute2;
        }

        public void setIosConfigFileContents(String string) {
            this.iosConfigFileContents = string;
        }

        public String getIosConfigFileContents() {
            return this.iosConfigFileContents;
        }

        public void setIosConfigFileHostName(String string) {
            this.iosConfigFileHostName = string;
        }

        public String getIosConfigFileHostName() {
            return this.iosConfigFileHostName;
        }

        public void setIosConfigFileDirectoryName(String string) {
            this.iosConfigFileDirectoryName = string;
        }

        public String getIosConfigFileDirectoryName() {
            return this.iosConfigFileDirectoryName;
        }

        public void setIosConfigFileFileName(String string) {
            this.iosConfigFileFileName = string;
        }

        public String getIosConfigFileFileName() {
            return this.iosConfigFileFileName;
        }

        public void setTimeInSeconds(int n) {
            this.timeInSeconds = n;
        }

        public int getTimeInSeconds() {
            return this.timeInSeconds;
        }
    }

    private class SourceOriginProperties
    extends CachedValue {
        public SourceOriginProperties(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            IosConfigModel.this.db.finest("++++++++++++++ inside getValue() for SourceOriginProperties ++++++++++++");
            sSourceOriginProperties sSourceOriginProperties2 = IosConfigModel.this.getIosConfigRef().getSourceOriginProperties(IosConfigModel.this.index);
            return sSourceOriginProperties2;
        }

        public Object outer() {
            return IosConfigModel.this;
        }
    }
}

