/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetTopology.VtVcatTerm;
import cerent.cms.idl.SonetTopology.sVtVcatTermItem;
import cerent.cms.idl.SonetTopology.xNoSuchVcat;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractVcatTermsMap;
import cerent.cms.model.LoVcatTermModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchVcat;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.VcatTermModel;
import cerent.cms.model.VcatTermModelsDelegate;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class LoVcatTermsMap
extends AbstractVcatTermsMap
implements Observer {
    private static final String MY_DEBUG_KEY = "LoVcatTermsMap";
    GetVtVcatTerms getVtVcatTerms;
    GetVtVcatTermItemFromPort getVtVcatTermItemFromPort;

    public LoVcatTermsMap(VcatTermModelsDelegate vcatTermModelsDelegate) {
        super(vcatTermModelsDelegate);
        this.db = new LoVcatTermDebug(this.node.db);
        this.getVtVcatTerms = new GetVtVcatTerms(this.node, "LoVcatTermsMap.getVtVcatTerms");
        this.getVtVcatTermItemFromPort = new GetVtVcatTermItemFromPort(this.node, "LoVcatTermsMap.getVtVcatTermItemFromPort");
    }

    @Override
    protected ObjectType getObjectType() {
        return ObjectType.ObjectVtVcatTermList;
    }

    @Override
    protected boolean updateStructure() {
        return this.updateVtStructure();
    }

    protected LoVcatTermModel add(VtVcatTerm vtVcatTerm, int n) {
        sVtVcatTermItem sVtVcatTermItem2 = null;
        try {
            sVtVcatTermItem2 = this.getVtVcatTermItemFromPort(new Integer(n));
        }
        catch (NoSuchVcat noSuchVcat) {
            this.db.println("Exception occured in add-vtVcatTerm " + (Object)((Object)noSuchVcat));
            this.db.println("Unabe to find vcat on port:" + Integer.toHexString(n));
            this.printStackTrace((Exception)((Object)noSuchVcat));
            return null;
        }
        return this.add(sVtVcatTermItem2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LoVcatTermModel add(sVtVcatTermItem sVtVcatTermItem2) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        LoVcatTermModel loVcatTermModel = null;
        if (sVtVcatTermItem2 == null) {
            return null;
        }
        LoVcatTermsMap loVcatTermsMap = this;
        synchronized (loVcatTermsMap) {
            block9: {
                loVcatTermModel = (LoVcatTermModel)this.findVcatTermModelInCache(sVtVcatTermItem2.objIndex);
                if (loVcatTermModel == null) {
                    try {
                        loVcatTermModel = new LoVcatTermModel(this.node, sVtVcatTermItem2, this);
                        loVcatTermModel.init();
                        this.vcatTermModels.put(new Integer(sVtVcatTermItem2.objIndex), loVcatTermModel);
                        this.setChanged();
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (this.db.on()) {
                            this.db.println("Exception occured in add-vtVcatTerm " + (Object)((Object)abstractCmsIOException));
                            this.printStackTrace((Exception)((Object)abstractCmsIOException));
                        }
                        if (loVcatTermModel == null) break block9;
                        loVcatTermModel.dispose();
                        loVcatTermModel = null;
                    }
                }
            }
        }
        this.notifyObservers(ModelUpdateType.ADDED);
        return loVcatTermModel;
    }

    @Override
    protected synchronized void discover(Map map) {
        sVtVcatTermItem[] sVtVcatTermItemArray = this.getVtVcatTerms();
        if (sVtVcatTermItemArray == null) {
            this.db.println("Error in getting VtVcatTerms (null) VcatTermModels::discoverVtVcatTerms");
            return;
        }
        for (int i = 0; i < sVtVcatTermItemArray.length; ++i) {
            if (sVtVcatTermItemArray[i] == null) continue;
            Integer n = new Integer(sVtVcatTermItemArray[i].objIndex);
            if (map.get(n) != null) {
                String string = ((LoVcatTermModel)map.get(n)).getVcatName();
                this.db.println("Error in Node DB: duplication of VCG indexes !! circuit name1 = " + string + " circuit name2 = " + sVtVcatTermItemArray[i].name + " index = " + n);
                this.db.println(string + "will be reported as PARTIAL by NCP");
            }
            map.put(n, new LoVcatTermModel(this.node, sVtVcatTermItemArray[i], this));
        }
    }

    private Map getVtVcatTermsMap() {
        sVtVcatTermItem[] sVtVcatTermItemArray = this.getVtVcatTerms();
        if (sVtVcatTermItemArray == null) {
            this.db.println("Error in getting VtVcatTerms (null) VcatTermModels::discoverVtVcatTerms");
            return null;
        }
        HashMap<Integer, sVtVcatTermItem> hashMap = new HashMap<Integer, sVtVcatTermItem>();
        for (int i = 0; i < sVtVcatTermItemArray.length; ++i) {
            if (sVtVcatTermItemArray[i] == null) continue;
            Integer n = new Integer(sVtVcatTermItemArray[i].objIndex);
            hashMap.put(n, sVtVcatTermItemArray[i]);
        }
        return hashMap;
    }

    private sVtVcatTermItem[] getVtVcatTerms() {
        sVtVcatTermItem[] sVtVcatTermItemArray;
        try {
            sVtVcatTermItemArray = (sVtVcatTermItem[])this.getVtVcatTerms.get();
        }
        catch (UserException userException) {
            this.db.println("Error in getting VtVcatTerms " + (Object)((Object)userException));
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
        return sVtVcatTermItemArray;
    }

    private synchronized boolean updateVtStructure() {
        Object object;
        Object object2;
        if (this.db.on()) {
            this.db.println("Entry:: VcatTermModels::updateVtStructure");
        }
        boolean bl = false;
        Map map = this.getVtVcatTermsMap();
        if (map == null) {
            this.db.println("Could not find VtVcatTerm Indexes returning ..");
            return false;
        }
        Collection collection = LoVcatTermsMap.getAddedObjects(map.keySet(), this.vcatTermModels.keySet());
        Iterator iterator = collection.iterator();
        if (collection.size() > 0) {
            if (this.db.on()) {
                this.db.println("New vt found # " + collection.size());
            }
            while (iterator.hasNext()) {
                object2 = (Integer)iterator.next();
                if (this.db.on) {
                    this.db.println("Adding Vt # " + object2 + " to List");
                }
                object = (sVtVcatTermItem)map.get(object2);
                LoVcatTermModel loVcatTermModel = new LoVcatTermModel(this.node, (sVtVcatTermItem)object, this);
                loVcatTermModel.init();
                this.vcatTermModels.put(object2, loVcatTermModel);
            }
            bl = true;
        }
        if ((object2 = LoVcatTermsMap.getDeletedObjects(map.keySet(), this.vcatTermModels.keySet())).size() > 0) {
            iterator = object2.iterator();
            bl = true;
            if (this.db.on()) {
                this.db.println("Vt Deleted found # " + object2.size());
            }
            while (iterator.hasNext()) {
                object = (LoVcatTermModel)this.vcatTermModels.get(iterator.next());
                ((VcatTermModel)object).delete();
            }
        }
        if (this.db.on()) {
            this.db.println("Exit:: VcatTermModels::updateVtStructure");
        }
        return bl;
    }

    protected sVtVcatTermItem getVtVcatTermItemFromPort(Integer n) throws NoSuchVcat {
        try {
            return (sVtVcatTermItem)this.getVtVcatTermItemFromPort.get(n);
        }
        catch (xNoSuchVcat xNoSuchVcat2) {
            throw new NoSuchVcat((UserException)xNoSuchVcat2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private class GetVtVcatTermItemFromPort
    extends NonCachedValue {
        public GetVtVcatTermItemFromPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            return LoVcatTermsMap.this.getSonetFactoryRef().getVtVcatTerm((Integer)object);
        }

        public Object outer() {
            return LoVcatTermsMap.this;
        }
    }

    private class GetVtVcatTerms
    extends NonCachedValue {
        public GetVtVcatTerms(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return LoVcatTermsMap.this.getSonetFactoryRef().getAllVtVcatTerms();
        }

        public Object outer() {
            return LoVcatTermsMap.this;
        }
    }

    public class LoVcatTermDebug
    extends SDebug {
        LoVcatTermDebug(SDebug sDebug) {
            super((KDebug)sDebug, LoVcatTermsMap.MY_DEBUG_KEY);
        }

        public final void update() {
            LoVcatTermsMap.this.updateVtStructure();
        }

        public final void printVcatTerms() {
            LoVcatTermsMap.this.db.println("Printing List of LO VcatTerms \n");
            LoVcatTermsMap.this.printVcatTermsMapString(this);
        }
    }
}

