/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.sMfgData_2_01;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.MfgPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;

public class ML2EtherPortModel
extends MfgPortModel {
    private int eqType;

    public ML2EtherPortModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2);
        this.index = n;
    }

    @Override
    public void init() {
        super.init();
        this.eqType = this.getParent().getEqType();
    }

    public ML2EtherLineModel getLineModel() {
        return (ML2EtherLineModel)this.getInterfaceModel();
    }

    @Override
    public String toString() {
        return "ML2Map" + super.toString();
    }

    @Override
    public boolean isInLoopback() {
        return this.getLineModel().getLoopbackAsInt() != 0;
    }

    @Override
    public boolean supportsMonitorCircuits() {
        return false;
    }

    @Override
    public int getServiceStateType() throws NoSuchInterface {
        try {
            return this.getLineModel().getLinkStatus() ? 100 : 101;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            return 101;
        }
    }

    @Override
    public boolean supportsSplitRouting() {
        return true;
    }

    public boolean isInMapperMode() {
        try {
            return ((ML2ModuleModel)this.getModuleModel()).isInMapperMode();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return true;
        }
    }

    @Override
    public int getPort() {
        int n = this.getPositionInParent();
        if (this.eqType == 163 || this.eqType == 187) {
            n -= 14;
        } else if (this.eqType == 164) {
            n -= 15;
        } else if (this.eqType == 229) {
            n -= 4;
        } else if (this.eqType == 283 || this.eqType == 284) {
            n -= 32;
        } else if (this.eqType == 285) {
            n -= 33;
        }
        return n;
    }

    @Override
    public boolean hasMfgData() {
        return this.eqType == 229 || this.eqType == 283 || this.eqType == 284 || this.eqType == 285;
    }

    @Override
    public sMfgData_2_01 getMfgData() {
        if (this.hasMfgData()) {
            return super.getMfgData();
        }
        return null;
    }
}

