/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Epos.RPR;
import cerent.cms.idl.Epos.sRPRSpanStateInfo;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.EtherMedia.xProvisioningError;
import cerent.cms.model.CachedValue;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ML2PosLineModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class ML2PosPortModel
extends PortModel {
    private ML2RPRSpanStateInfo ml2RPRSpanStateInfo;

    public ML2PosPortModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2);
        this.index = n;
        this.ml2RPRSpanStateInfo = new ML2RPRSpanStateInfo(nodeModelDelegate, "ML2PosPortModel::ML2RPRSpanStateInfo");
    }

    @Override
    public void init() {
        super.init();
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectInterface, this.getEntityIndex(), (Observer)this);
        }
        this.ml2RPRSpanStateInfo.init();
    }

    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println("ML2PosPortModel:: dispose() " + this + ": deleteObserver() for object");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectInterface, this.getEntityIndex(), (Observer)this);
        }
        super.dispose();
    }

    public ML2PosLineModel getLineModel() {
        return (ML2PosLineModel)this.getInterfaceModel();
    }

    @Override
    public String toString() {
        return "ML2" + super.toString();
    }

    @Override
    public int getServiceStateType() throws NoSuchInterface {
        boolean bl = false;
        try {
            bl = this.inRPRMode() ? this.getRPRSpanStateInfo().adminState : this.getLineModel().getML2PosPortInfo().linkUp;
            return bl ? 100 : 101;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            return 101;
        }
        catch (ProvisionError provisionError) {
            return 101;
        }
    }

    @Override
    public boolean supportsMonitorCircuits() {
        return false;
    }

    @Override
    public boolean supportsSplitRouting() {
        return true;
    }

    @Override
    public boolean maybeSetAdminState(int n, int n2, int n3) throws NoSuchInterface, LoopbackActive, UnsupportedOperation, SyncProvError, InvalidState, ProvisionError {
        this.db.info("ML2EtherPortModel" + this + ".maybeSetAdminState(): targetState:" + n + ", policy:" + n2 + ", circuitSize:" + n3);
        if (!this.isInMapperMode()) {
            return false;
        }
        if (this.getAdminState() == n) {
            return true;
        }
        if (n2 == 2) {
            InterfaceModel interfaceModel;
            boolean bl = false;
            if (n != -1 && (interfaceModel = (InterfaceModel)this.getInterfaceModel()) != null) {
                this.db.info("maybeSetAdminState: passing on to NE");
                interfaceModel.setAdminState(n);
                bl = true;
            }
            return bl;
        }
        return super.maybeSetAdminState(n, n2, n3);
    }

    public boolean isInMapperMode() {
        try {
            return ((ML2ModuleModel)this.getModuleModel()).isInMapperMode();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return true;
        }
    }

    @Override
    public int getPort() {
        IEntityModel iEntityModel = this.getParent();
        int n = this.getPositionInParent();
        if (iEntityModel.getEqType() == 164 || iEntityModel.getEqType() == 285) {
            --n;
        }
        return n;
    }

    @Override
    public int getPayloadType() {
        int n = 0;
        IModuleModel iModuleModel = this.getModuleModel();
        n = iModuleModel != null && (iModuleModel.getEqType() == 283 || iModuleModel.getEqType() == 284 || iModuleModel.getEqType() == 285) ? 19 : super.getPayloadType();
        return n;
    }

    public sRPRSpanStateInfo getRPRSpanStateInfo() throws ProvisionError {
        if (this.db.on()) {
            this.db.println("ML2PosPortModel::getML2RPRSpanStateInfo");
        }
        try {
            return (sRPRSpanStateInfo)this.ml2RPRSpanStateInfo.get();
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError((UserException)xProvisioningError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getRPRSpanStateInfo", userException);
        }
    }

    protected RPR getRPRRef() {
        return this.getNodeModelDelegate().getIorRepository().getRPRRef();
    }

    protected void updateLocal(long l) {
        this.ml2RPRSpanStateInfo.update();
        super.updateLocal();
    }

    @Override
    protected void updateLocal() {
        this.ml2RPRSpanStateInfo.update();
        super.updateLocal();
    }

    private class ML2RPRSpanStateInfo
    extends CachedValue {
        public ML2RPRSpanStateInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return ML2PosPortModel.this.getRPRRef().getRPRSpanStateInfo(ML2PosPortModel.this.getIndex());
        }

        public Object outer() {
            return ML2PosPortModel.this;
        }
    }
}

