/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.OpticsTopology.xBusy;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IOptLinkModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchPatchCord;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OptLinkModel;
import cerent.cms.model.OpticalPatchCordModel;
import cerent.cms.model.WrongPortType;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.omg.CORBA.UserException;

public class MPOLinkModel
extends Model
implements IOptLinkModel {
    private final OpticalPatchCordModel optPatchCord;
    private List<OptLinkModel> children = new ArrayList<OptLinkModel>();
    private final MPOKey from;
    private final MPOKey to;
    private final EntityCellRenderer ecr = new EntityCellRenderer();

    public MPOLinkModel(OptLinkModel optLinkModel, OpticalPatchCordModel opticalPatchCordModel) throws NoSuchEquipment, WrongPortType, AbstractCmsNoSuchEntityException {
        super(((NodeModelDelegate)optLinkModel.getNodeModel()).getChildDebug(OptLinkModel.class));
        this.optPatchCord = opticalPatchCordModel;
        this.addChild(optLinkModel);
        this.from = new MPOKey(optLinkModel.getFromModel());
        this.to = new MPOKey(optLinkModel.getToModel());
    }

    public static boolean isPartOfMPO(OptLinkModel optLinkModel) {
        boolean bl = false;
        try {
            IPortModel iPortModel = optLinkModel.getFromModel();
            if (iPortModel instanceof IOpticsPortModel) {
                boolean bl2 = bl = ((IOpticsPortModel)iPortModel).getMPO() > 0;
            }
            if (bl) {
                iPortModel = optLinkModel.getToModel();
                bl = iPortModel instanceof IOpticsPortModel ? ((IOpticsPortModel)iPortModel).getMPO() > 0 : false;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    public boolean canBePartOfThisMPO(OptLinkModel optLinkModel) {
        try {
            IPortModel iPortModel = optLinkModel.getFromModel();
            if (this.from.same(iPortModel) || this.to.same(iPortModel)) {
                iPortModel = optLinkModel.getToModel();
                return this.from.same(iPortModel) || this.to.same(iPortModel);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return false;
    }

    public void addChild(OptLinkModel optLinkModel) {
        this.children.add(optLinkModel);
        optLinkModel.setParentMPO(this);
    }

    public void removeChild(OptLinkModel optLinkModel) {
        int n = this.children.indexOf(optLinkModel);
        if (n >= 0) {
            this.children.remove(n);
            optLinkModel.setParentMPO(null);
            if (this.children.size() < 1) {
                this.setChanged();
                this.notifyObservers(ModelUpdateType.DELETED);
                this.optPatchCord.removeMPO(this);
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        int n = object instanceof IObjectMessageInfo ? ((IObjectMessageInfo)object).getUpdateType() : ((Integer)object).intValue();
        if (n == 1) {
            if (this.db.on()) {
                this.db.println("Object Changed:" + this);
            }
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    public void delete() throws FeatureUnsupported, NoSuchEquipment, Busy, NoSuchPatchCord {
        for (OptLinkModel optLinkModel : this.children) {
            try {
                if (!optLinkModel.inUse()) continue;
                throw new Busy((UserException)new xBusy());
            }
            catch (NoSuchInterface noSuchInterface) {
                throw new NoSuchEquipment(noSuchInterface.getUserException());
            }
        }
        for (OptLinkModel optLinkModel : this.children) {
            optLinkModel.delete();
        }
    }

    public int getFrom() {
        return this.children.get(0).getFrom();
    }

    public IPortModel getFromModel() throws AbstractCmsNoSuchEntityException {
        return this.children.get(0).getFromModel();
    }

    public String getFromPortName(boolean bl) throws AbstractCmsNoSuchEntityException {
        return this.from.getString(bl);
    }

    public int getTo() {
        return this.children.get(0).getTo();
    }

    public IPortModel getToModel() throws AbstractCmsNoSuchEntityException {
        return this.children.get(0).getToModel();
    }

    public String getToPortName(boolean bl) throws AbstractCmsNoSuchEntityException {
        return this.to.getString(bl);
    }

    public int getType() {
        return 7;
    }

    public String getTypeString() {
        return "MPO";
    }

    public int getWaveLength() {
        return this.children.get(0).getWaveLength();
    }

    public String getWaveLengthString() {
        return this.children.get(0).getWaveLengthString();
    }

    public List<IOptLinkModel> getChildren() {
        ArrayList<IOptLinkModel> arrayList = new ArrayList<IOptLinkModel>();
        for (OptLinkModel optLinkModel : this.children) {
            arrayList.add(optLinkModel);
        }
        return arrayList;
    }

    public String getPrettyString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[MPO ");
        stringBuilder.append(this.from.getString(true));
        stringBuilder.append(" -> ");
        stringBuilder.append(this.to.getString(true));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n\t" + this.getPrettyString());
        for (OptLinkModel optLinkModel : this.children) {
            stringBuilder.append("\n\t\t");
            stringBuilder.append(optLinkModel.toString());
        }
        return stringBuilder.toString();
    }

    class MPOKey {
        final IModuleModel mm;
        final int mpo;
        final String mpoString;

        MPOKey(IPortModel iPortModel) throws NoSuchEquipment, WrongPortType {
            this.mm = iPortModel.getModuleModel();
            this.mpo = ((IOpticsPortModel)iPortModel).getMPO();
            this.mpoString = ((IOpticsPortModel)iPortModel).getMPOString();
        }

        boolean same(IPortModel iPortModel) {
            if (this.mm == iPortModel.getModuleModel() && iPortModel instanceof IOpticsPortModel) {
                try {
                    return this.mpo == ((IOpticsPortModel)iPortModel).getMPO();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            return false;
        }

        String getString(boolean bl) {
            if (!bl) {
                return MPOLinkModel.this.ecr.getString(this.mm, "shelf ") + ", " + this.mpoString;
            }
            return this.mpoString;
        }
    }
}

