/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123PortModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.List;

public class MicModuleModel
extends ModuleModel
implements IModuleModel {
    ModuleModel activeXtcCard = null;

    public MicModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(MicModuleModel.class));
    }

    public ModuleModel getActiveXtcCard() {
        if (this.activeXtcCard != null) {
            return this.activeXtcCard;
        }
        try {
            this.setupActiveXtcCard();
        }
        catch (Exception exception) {
            if (this.db.on()) {
                this.db.println("failed to setup active XTC");
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
        return this.activeXtcCard;
    }

    protected void setupActiveXtcCard() throws Exception {
        List list = ((EntityModel)((Object)this.getChassis())).getDescendantsOfType(eEqType.XTC_SLOT);
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext() && this.activeXtcCard == null) {
            List list2 = ((EntityModel)iterator.next()).getChildrenOfType(eClass.E_MODULE);
            for (ModuleModel moduleModel : list2) {
                if (moduleModel.getState().value() != 5) continue;
                this.activeXtcCard = moduleModel;
                continue block0;
            }
        }
        if (this.activeXtcCard == null) {
            if (this.db.on()) {
                this.db.println("Couldn't find Active Xtc Card");
            }
            throw new Exception("An active XTC card cannot be found.");
        }
    }

    public Ds123LineModel[] getDs1Lines() {
        return this.getDs123Lines(eEqType.DS1_VT_MAPPED);
    }

    public Ds123LineModel[] getDs3Lines() {
        return this.getDs123Lines(eEqType.DS3);
    }

    public EnvAlarmModel[] getAlarmInput() {
        List list = this.getEnvModels(eEqType.ENVIRONMENT_ALARM);
        if (this.db.on()) {
            this.db.println("MicCardTabbedView getAlarmInput=" + list.size());
        }
        return list.toArray(new EnvAlarmModel[0]);
    }

    public EnvControlModel[] getControlOutput() {
        List list = this.getEnvModels(eEqType.ENVIRONMENT_CONTROL);
        if (this.db.on()) {
            this.db.println("MicCardTabbedView getControlOutput=" + list.size());
        }
        return list.toArray(new EnvControlModel[0]);
    }

    protected Ds123LineModel[] getDs123Lines(eEqType eEqType2) {
        Ds123PortModel[] ds123PortModelArray = this.getActiveXtcCard().getChildrenOfType(eEqType2).toArray(new Ds123PortModel[0]);
        Ds123LineModel[] ds123LineModelArray = new Ds123LineModel[ds123PortModelArray.length];
        for (int i = 0; i < ds123PortModelArray.length; ++i) {
            ds123LineModelArray[i] = ds123PortModelArray[i].getDs123LineModel();
        }
        return ds123LineModelArray;
    }

    protected List getEnvModels(eEqType eEqType2) {
        List list = this.getActiveXtcCard().getDescendantsOfType(eEqType2);
        return list;
    }

    @Override
    public String toString() {
        return "Mic" + super.toString();
    }
}

