/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IValue;
import cerent.cms.model.IfModelTypeSignature;
import cerent.cms.model.ModelAttributes;
import cerent.cms.model.ModelObserver;
import cerent.cms.model.ModelReflectionUtil;
import cerent.cms.model.ModelReplacement;
import cerent.cms.model.ModelTypeSignatureMap;
import cerent.cms.model.ModelUpdateType;
import cerent.launcher.CtcHttpRetriever;
import cerent.util.AnnotatedException;
import cerent.util.ConcurrentReaderMap;
import cerent.util.GlobalCollection;
import cerent.util.IMetrics;
import cerent.util.InetUtil;
import cerent.util.IntHolder;
import cerent.util.LogLevel;
import cerent.util.LongHolder;
import cerent.util.PerformanceMetrics;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.id.AbstractModelIdentity;
import com.cisco.ctc.RemoteEleConstants;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;

public abstract class Model
extends CmsObservable
implements Observer,
IModel,
Serializable {
    public static final short UNINITIALIZED = 0;
    public static final short DIRTY = 1;
    public static final short CLEAN = 2;
    private static final String PROP_CTC = "ctc";
    private static final String PROP_CTC_MODE = "mode";
    protected SDebug db = null;
    private static int serial = 0;
    public static final int SINGLETON_INDEX = 0;
    protected int index;
    private boolean inInstanceMap;
    private boolean modelInited;
    protected static ConcurrentReaderMap attributeCollection = new ConcurrentReaderMap();
    protected static final boolean isAddonMode = RemoteEleConstants.MODE.requiresAddon;
    protected static ModelTypeSignatureMap ifTypesSignatureMap = new ModelTypeSignatureMap();
    protected static final String transientModelInstancesName = "Model";
    protected static final String persistentModelInstancesName = "PersistentModel";
    protected boolean doCleanupPersistentInstances;
    protected static Debug sdb = new Debug("STATIC_MODEL");

    protected Model(SDebug sDebug, boolean bl) {
        this.db = sDebug;
        this.index = Model.allocateIndex();
        this.modelInited = false;
        this.doCleanupPersistentInstances = false;
        Model.addModelAttributes(this);
        if (bl && isAddonMode) {
            Model.registerIfTypesSignature(this);
        }
    }

    protected Model(SDebug sDebug) {
        this(sDebug, true);
    }

    protected static ModelAttributes addModelAttributes(Object object) {
        Class<?> clazz = object.getClass();
        ModelAttributes modelAttributes = (ModelAttributes)attributeCollection.get(clazz);
        if (modelAttributes == null) {
            modelAttributes = new ModelAttributes(clazz);
            attributeCollection.put(clazz, (Object)modelAttributes);
        }
        return modelAttributes;
    }

    protected static ModelAttributes getModelAttributes(Object object) {
        Class<?> clazz = object.getClass();
        ModelAttributes modelAttributes = null;
        if (attributeCollection != null) {
            modelAttributes = (ModelAttributes)attributeCollection.get(clazz);
        }
        return modelAttributes;
    }

    public static final ModelAttributes dumpModelAttributes(Class clazz, SDebug sDebug) {
        ModelAttributes modelAttributes = (ModelAttributes)attributeCollection.get((Object)clazz);
        if (modelAttributes == null) {
            sDebug.display("no model attributes for: " + clazz.getName());
        } else {
            sDebug.display(modelAttributes.size() + " model attributes for: " + clazz.getName());
            Iterator iterator = modelAttributes.getAttributeNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                sDebug.display("\t" + string);
            }
        }
        return modelAttributes;
    }

    private static void registerIfTypesSignature(Model model) {
        try {
            if (model.doRegisterSignature()) {
                ifTypesSignatureMap.register(model.getClass());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            sdb.println("registerIfTypesSignature error: " + illegalArgumentException);
            Debug.printStackTrace((Throwable)illegalArgumentException);
        }
    }

    public static Class getModelTypeBySignature(IfModelTypeSignature ifModelTypeSignature) {
        Class clazz = null;
        if (ifModelTypeSignature != null && (clazz = ifModelTypeSignature.getDupClass(Model.class)) == null) {
            clazz = ifTypesSignatureMap.get(ifModelTypeSignature);
        }
        return clazz;
    }

    public static IfModelTypeSignature getSignature(Class clazz) {
        return ifTypesSignatureMap.get(clazz);
    }

    public IfModelTypeSignature getSignature() {
        return Model.getSignature(this.getClass());
    }

    public boolean doRegisterSignature() {
        return true;
    }

    public static final void dumpCounts(INodeModel iNodeModel, SDebug sDebug) {
        LongHolder longHolder;
        Class clazz;
        IdentityHashMap identityHashMap = new IdentityHashMap();
        TreeMap<Class, LongHolder> treeMap = new TreeMap<Class, LongHolder>(ClassByNameComparator.instance());
        Map map = (Map)GlobalCollection.get((Object)transientModelInstancesName);
        Map map2 = (Map)map.get(iNodeModel);
        Collection collection = map2.values();
        for (Object object : collection) {
            if (identityHashMap.get(object) != null) continue;
            identityHashMap.put(object, object);
            clazz = object.getClass();
            longHolder = (LongHolder)treeMap.get(clazz);
            if (longHolder == null) {
                treeMap.put(clazz, new LongHolder(1L));
                continue;
            }
            longHolder.setValue(longHolder.longValue() + 1L);
        }
        collection = treeMap.keySet();
        Iterator iterator = collection.iterator();
        long l = 0L;
        while (iterator.hasNext()) {
            Object object;
            clazz = (Class)iterator.next();
            longHolder = (LongHolder)treeMap.get(clazz);
            object = (ModelAttributes)attributeCollection.get((Object)clazz);
            l += longHolder.longValue();
            sDebug.display(clazz.getName() + " " + longHolder.longValue() + " " + ((ModelAttributes)object).size());
        }
        sDebug.display("all " + l);
    }

    private static synchronized int allocateIndex() {
        return serial++;
    }

    public static void addNode(INodeModel iNodeModel) {
    }

    public static synchronized void removeNode(INodeModel iNodeModel) {
    }

    @Override
    public abstract void update(Observable var1, Object var2);

    protected final void init0() {
        this.init0(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init0(boolean bl) {
        Map<String, Model> map;
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel != null) {
            String string = bl ? persistentModelInstancesName : transientModelInstancesName;
            Map map2 = (Map)GlobalCollection.get((Object)string);
            if (map2 == null) {
                map2 = Collections.synchronizedMap(new HashMap());
                GlobalCollection.put((Object)string, map2);
            }
            map = (Map)map2.get(iNodeModel);
            String[] stringArray = this.getInstanceNames();
            if (map == null) {
                map = Collections.synchronizedMap(new TreeMap());
                map2.put((Model)iNodeModel, map);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                map.put(stringArray[i], this);
            }
            this.inInstanceMap = true;
        }
        try {
            ModelObserver.getInstance(this.getNodeModel()).modelGettingInited(this);
        }
        catch (CTCUserException cTCUserException) {
            this.db.println("ERROR:" + cTCUserException.getMessage() + " in " + this.getClass().getName());
            this.db.println("This class not being added to ModelObserver. Please check super.init0()");
        }
        map = this;
        synchronized (map) {
            this.modelInited = true;
        }
    }

    public void dispose() {
        try {
            this.removeModelInstances(transientModelInstancesName);
            if (this.doCleanupPersistentInstances) {
                this.removeModelInstances(persistentModelInstancesName);
            }
        }
        catch (Exception exception) {
            this.db.println("Exception during dispose : " + exception);
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeModelInstances(String string) {
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel != null) {
            String[] stringArray = this.getInstanceNames();
            Map map = (Map)GlobalCollection.get((Object)string);
            if (map != null) {
                Map map2 = (Map)map.get((Model)iNodeModel);
                Model model = this;
                synchronized (model) {
                    this.modelInited = false;
                }
                if (map2 != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        map2.remove(stringArray[i]);
                    }
                } else if (this.db.on() && !string.equals(persistentModelInstancesName)) {
                    this.db.println("GlobalCollection[" + string + "][" + iNodeModel + "] is null for " + stringArray[0]);
                }
                if (map2 != null && map2.isEmpty()) {
                    map.remove((Model)iNodeModel);
                }
            } else if (this.db.on() && !string.equals(persistentModelInstancesName)) {
                this.db.println("GlobalCollection[" + string + "] is null for " + stringArray[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        CmsObservable.listObservers(this, this.getObservers());
        Model model = this;
        synchronized (model) {
            this.doCleanupPersistentInstances = true;
            this.dispose();
            this.doCleanupPersistentInstances = false;
        }
        this.deleteObservers();
    }

    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal called");
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public INodeModel getNodeModel() {
        return null;
    }

    private Model() {
    }

    public int getIndex() {
        return this.index;
    }

    public SDebug getDebug() {
        return this.db;
    }

    protected void setDebug(SDebug sDebug) {
        if (this.db == null && sDebug != null) {
            this.db = sDebug;
        }
    }

    public synchronized boolean isInited() {
        return this.modelInited;
    }

    public boolean isLazyInited() {
        return true;
    }

    public String getInstanceName() {
        return Model.createInstanceName(this.getClass(), this.getIndex());
    }

    public String[] getInstanceNames() {
        Class<?> clazz = this.getClass();
        int n = this.getIndex();
        LinkedList<String> linkedList = new LinkedList<String>();
        while (!clazz.getName().equals("cerent.cms.model.Model")) {
            linkedList.add(Model.createInstanceName(clazz, n));
            clazz = clazz.getSuperclass();
        }
        return linkedList.toArray(new String[0]);
    }

    public static String createInstanceName(Class clazz, int n) {
        return Model.createInstanceName(clazz.getName(), n);
    }

    public static String createInstanceName(String string, int n) {
        String string2 = "00000000";
        String string3 = Integer.toHexString(n);
        int n2 = string3.length();
        String string4 = string.substring(string.lastIndexOf(".") + 1);
        return string4 + "/" + string2.substring(n2) + string3;
    }

    public static Model getInstance(INodeModel iNodeModel, AbstractModelIdentity abstractModelIdentity) {
        String string = Model.createInstanceName(abstractModelIdentity.getModelType(), abstractModelIdentity.getIndex());
        return Model.getInstance(iNodeModel, string);
    }

    public static Model getInstance(INodeModel iNodeModel, String string) {
        Model model = Model.getInstance(iNodeModel, string, transientModelInstancesName);
        if (model == null) {
            model = Model.getInstance(iNodeModel, string, persistentModelInstancesName);
        }
        return model;
    }

    protected static Model getInstance(INodeModel iNodeModel, String string, String string2) {
        Map map;
        Map map2 = (Map)GlobalCollection.get((Object)string2);
        if (map2 == null) {
            return null;
        }
        Object var4_4 = null;
        if (map2 != null && (map = (Map)map2.get(iNodeModel)) != null) {
            var4_4 = map.get(string);
        }
        return var4_4;
    }

    public static Iterator getInstanceIterator(INodeModel iNodeModel) {
        Map map = (Map)GlobalCollection.get((Object)transientModelInstancesName);
        Map map2 = (Map)map.get(iNodeModel);
        return map2.keySet().iterator();
    }

    public static Iterator getModelsIterator() {
        Map map = (Map)GlobalCollection.get((Object)transientModelInstancesName);
        return map.keySet().iterator();
    }

    public Iterator getAttributeNames() {
        Object var1_1 = null;
        ModelAttributes modelAttributes = Model.getModelAttributes(this);
        return modelAttributes == null ? null : modelAttributes.getAttributeNames();
    }

    public String getImplementationClassName() {
        return this.getClass().getName();
    }

    public Object getAttributeByName(String string) {
        Object object = null;
        ModelAttributes modelAttributes = Model.getModelAttributes(this);
        if (modelAttributes != null) {
            object = modelAttributes.getAttributeByName(this, string);
        }
        return object;
    }

    public String getFQAttributeName(String string) {
        String string2 = "";
        ModelAttributes modelAttributes = Model.getModelAttributes(this);
        if (modelAttributes != null) {
            string2 = modelAttributes.getFQAttributeName(this, string);
        }
        return string2;
    }

    public static TDMTerminology getTDMTerminology(IModel iModel) throws AnnotatedException {
        try {
            return iModel.getNodeModel().getTDMTerminology();
        }
        catch (Exception exception) {
            throw new AnnotatedException("The TDM terminology cannot be determined.", exception);
        }
    }

    public static IFramingType getFramingType(INodeModel iNodeModel) throws AnnotatedException {
        try {
            return iNodeModel.getNodeModel().getFramingTypeObj();
        }
        catch (Exception exception) {
            throw new AnnotatedException("The framing type cannot be determined.", exception);
        }
    }

    public static Field[] getAttrFields(Class clazz) {
        Field[] fieldArray = ModelReflectionUtil.getMatchingFields(clazz, 8, 0, true);
        return fieldArray;
    }

    public Object getAttrFieldValue(Field field) {
        Object object = null;
        field.setAccessible(true);
        try {
            object = field.get(this);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return object;
    }

    public void flushHint() {
    }

    protected Exception destroyModel(IModel iModel) {
        try {
            if (iModel != null) {
                iModel.destroy();
            }
        }
        catch (Exception exception) {
            this.db.println("Unexpected exception occurred while trying to destroy " + iModel);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return exception;
        }
        return null;
    }

    protected Exception disposeModel(IModel iModel) {
        try {
            if (iModel != null) {
                iModel.dispose();
            }
        }
        catch (Exception exception) {
            this.db.println("Unexpected exception occurred while trying to dispose " + iModel);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return exception;
        }
        return null;
    }

    protected Exception updateCV(IValue iValue) {
        try {
            if (iValue != null) {
                iValue.update();
            }
        }
        catch (Exception exception) {
            this.db.println("Unexpected exception occurred while trying to update " + iValue);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return exception;
        }
        return null;
    }

    protected Exception disposeCV(IValue iValue) {
        try {
            if (iValue != null) {
                iValue.dispose();
            }
        }
        catch (Exception exception) {
            this.db.println("Unexpected exception occurred while trying to dispose " + iValue);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return exception;
        }
        return null;
    }

    public SDebug getChildDebug(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return this.db.getChildDebug(string);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (sdb.isFinerEnabled()) {
            sdb.finer("entering writeObject()");
        }
        objectOutputStream.defaultWriteObject();
        if (sdb.isFinerEnabled()) {
            sdb.finer("exiting writeObject()");
        }
    }

    public Object writeReplace() throws ObjectStreamException {
        if (sdb.isFinerEnabled()) {
            sdb.finer("entering writeReplace() for an instance of: " + this.getClass().getName());
        }
        IMetrics iMetrics = PerformanceMetrics.getInstance().getMetrics("Model.writeReplace", IMetrics.modelReplacementDb, LogLevel.FINER);
        ModelReplacement modelReplacement = null;
        int n = 0;
        int n2 = -1;
        try {
            INodeModel iNodeModel = this.getNodeModel();
            if (iNodeModel != null) {
                String string = iNodeModel.getHostName();
                n2 = iNodeModel.getNodeId();
                try {
                    n = this.hostToIpAddr(string);
                }
                catch (UnknownHostException unknownHostException) {
                    if (sdb.on()) {
                        sdb.println("UNABLE TO OBTAIN IP ADDRESS FOR: " + string);
                        Debug.printStackTrace((Throwable)unknownHostException);
                    }
                    n = 0;
                }
            } else if (sdb.on()) {
                this.db.println("getNodeModel() returned null for instance of type: " + this.getClass().getName() + " (probably a bug)");
            }
            int n3 = 0;
            int n4 = this.getReadResolveModelEnum();
            String string = this.getApiVersion(iNodeModel);
            int n5 = this.getIndex();
            IfModelTypeSignature ifModelTypeSignature = this.getSignature();
            modelReplacement = new ModelReplacement();
            modelReplacement.setModelReplacement(this.getClass(), n3, n4, n2, n5, string, ifModelTypeSignature, n);
            if (sdb.isFinestEnabled()) {
                sdb.finest("created mr: " + modelReplacement);
            }
            if (sdb.isFinerEnabled()) {
                sdb.finer("exiting writeReplace()");
            }
        }
        catch (RuntimeException runtimeException) {
            if (sdb.on()) {
                sdb.println("Model.writeReplace got unexpected exception: " + runtimeException);
                Debug.printStackTrace((Throwable)runtimeException);
            }
            throw runtimeException;
        }
        finally {
            iMetrics.stop();
        }
        return modelReplacement;
    }

    private String getApiVersion(INodeModel iNodeModel) throws AbstractCmsIOException {
        try {
            return CtcHttpRetriever.version((String)CtcHttpRetriever.getApiVersion((String)iNodeModel.getHostName()));
        }
        catch (Exception exception) {
            throw new CommonCmsCommFailException(iNodeModel.getHostName() + " " + exception);
        }
    }

    protected int getReadResolveModelEnum() {
        int n = 0;
        return n;
    }

    private int hostToIpAddr(String string) throws UnknownHostException {
        int n = InetUtil.parseDottedString(string);
        return n;
    }

    private void dumpLingeringModels(String string) {
        HashMap<Serializable, IntHolder> hashMap = new HashMap<Serializable, IntHolder>();
        Map map = (Map)GlobalCollection.get((Object)string);
        if (map != null) {
            Map map2 = (Map)map.get(this);
            if (map2 != null) {
                Object object;
                Serializable serializable;
                Iterator iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    serializable = iterator.next().getValue().getClass();
                    object = (IntHolder)hashMap.get(serializable);
                    if (object == null) {
                        hashMap.put(serializable, new IntHolder(1));
                        continue;
                    }
                    object.setValue(object.intValue() + 1);
                }
                iterator = hashMap.entrySet().iterator();
                if (iterator.hasNext()) {
                    serializable = new StringBuffer();
                    ((StringBuffer)serializable).append("lingering " + string + "s:");
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        ((StringBuffer)serializable).append("\n  ");
                        ((StringBuffer)serializable).append(((IntHolder)object.getValue()).intValue());
                        ((StringBuffer)serializable).append('*');
                        ((StringBuffer)serializable).append(((Class)object.getKey()).getName());
                    }
                    this.db.println(((StringBuffer)serializable).toString());
                } else {
                    this.db.println("No lingering " + string + "s");
                }
            } else {
                this.db.println("No " + string + " entry for this model");
            }
        } else {
            this.db.println("No global collection for " + string);
        }
    }

    void dumpLingeringModels() {
        this.dumpLingeringModels(transientModelInstancesName);
        this.dumpLingeringModels(persistentModelInstancesName);
    }

    static class ClassByNameComparator
    implements Comparator {
        private static ClassByNameComparator inst = new ClassByNameComparator();

        public static ClassByNameComparator instance() {
            return inst;
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }

        private ClassByNameComparator() {
        }
    }

    public class CommonCmsCommFailException
    extends AbstractCmsCommFailException {
        public CommonCmsCommFailException(String string) {
            super(string);
        }
    }

    public static class Debug
    extends SDebug {
        private boolean isTimingEnabled;
        private int numTimings = 0;
        private long cumTiming = 0L;

        public Debug(String string) {
            super(string);
        }

        public final void dumpModelTypeSignatureMap() {
            ifTypesSignatureMap.dump(this);
        }

        public boolean isTimingEnabled() {
            return this.isTimingEnabled;
        }

        public final void enableTiming() {
            if (!this.isTimingEnabled) {
                this.numTimings = 0;
                this.cumTiming = 0L;
            }
            this.isTimingEnabled = true;
        }

        public final void disableTiming() {
            this.isTimingEnabled = false;
        }

        public void reportTiming(String string, long l, long l2) {
            ++this.numTimings;
            long l3 = l2 - l;
            this.println(string + " in: " + l3 + " msecs");
            this.cumTiming += l3;
        }

        public final void showTimingSummary() {
            this.println("" + this.numTimings + " events in " + this.cumTiming + " msec total elapsed time");
        }

        public final void loadMRClass() throws Exception {
            Class.forName("cerent.cms.model.ModelReplacement");
        }

        public final void showTiming() {
            this.println(Boolean.toString(this.isTimingEnabled));
        }

        public final void showCL() throws Exception {
            this.println("" + Model.class.getClassLoader());
        }
    }
}

