/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.fv.IFvOptLinkModel;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.Optics.eBand;
import cerent.cms.idl.Optics.xFeatureUnsupported;
import cerent.cms.idl.OpticsTopology.eConnectionType;
import cerent.cms.idl.OpticsTopology.eCreationType;
import cerent.cms.idl.OpticsTopology.sOpticalPatchCord;
import cerent.cms.idl.OpticsTopology.xNoSuchPatchCord;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOptLinkModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.MPOLinkModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchPatchCord;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticalPatchCordModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.Wavelength;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class OptLinkModel
extends Model
implements IFvOptLinkModel,
IOptLinkModel {
    private final NodeModelDelegate nmd;
    private final sOpticalPatchCord optlnk;
    private final OpticalPatchCordModel optPatchCord;
    private EventDispatcher dispatcher;
    private GetPatchCordByIndex getPatchCordByIndex;
    private final EntityCellRenderer ecr = new EntityCellRenderer();
    private MPOLinkModel parentMPO = null;

    public OptLinkModel(OpticalPatchCordModel opticalPatchCordModel, sOpticalPatchCord sOpticalPatchCord2) {
        super(((NodeModelDelegate)opticalPatchCordModel.getNodeModel()).getChildDebug(OptLinkModel.class));
        this.nmd = (NodeModelDelegate)opticalPatchCordModel.getNodeModel();
        this.optPatchCord = opticalPatchCordModel;
        this.optlnk = sOpticalPatchCord2;
        this.getPatchCordByIndex = new GetPatchCordByIndex(this.nmd, "OptLinkModel::GetPatchCordByIndex");
    }

    public void init() {
        block4: {
            super.init0();
            this.dispatcher = this.nmd.getDispatcher();
            if (this.dispatcher != null) {
                this.dispatcher.addObserver(ObjectType.ObjectOpticalPatchCord, this.optlnk.index, (Observer)this);
                try {
                    this.getFromModel().addObserver((Observer)this);
                    this.getToModel().addObserver((Observer)this);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) break block4;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        if (this.db.on()) {
            this.db.println("Object created. Index:" + this.optlnk.index);
        }
    }

    @Override
    public int getIndex() {
        return this.optlnk.index;
    }

    public int getFrom() {
        return this.optlnk.from;
    }

    public void setFrom(int n) {
    }

    public int getFromOpticsSideId() throws AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType, InternalCommError {
        PortModel portModel = this.getFromPortModel();
        if (!(portModel instanceof OpticsPortModel)) {
            throw new NoSuchInterface("wrong Interface");
        }
        return ((OpticsPortModel)portModel).getSide();
    }

    public IPortModel getFromModel() throws AbstractCmsNoSuchEntityException {
        int n = this.getFrom();
        return (IPortModel)this.nmd.getEntityTableModel().getEntityModelByIndex(n);
    }

    public PortModel getFromPortModel() throws AbstractCmsNoSuchEntityException {
        int n = this.getFrom();
        return (PortModel)this.nmd.getEntityTableModel().getEntityModelByIndex(n);
    }

    public String getFromPortName(boolean bl) throws AbstractCmsNoSuchEntityException {
        if (bl) {
            return this.ecr.getPortString((IEntityModel)this.getFromModel(), false);
        }
        return this.ecr.getFullPortString((IEntityModel)this.getFromModel(), false);
    }

    public int getTo() {
        return this.optlnk.to;
    }

    public void setTo(int n) {
    }

    public IPortModel getToModel() throws AbstractCmsNoSuchEntityException {
        int n = this.getTo();
        return (IPortModel)this.nmd.getEntityTableModel().getEntityModelByIndex(n);
    }

    public int getToOpticsSideId() throws AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType, InternalCommError {
        PortModel portModel = this.getToPortModel();
        if (!(portModel instanceof OpticsPortModel)) {
            throw new NoSuchInterface("wrong Interface");
        }
        return ((OpticsPortModel)portModel).getSide();
    }

    public PortModel getToPortModel() throws AbstractCmsNoSuchEntityException {
        int n = this.getTo();
        return (PortModel)this.nmd.getEntityTableModel().getEntityModelByIndex(n);
    }

    public String getToPortName(boolean bl) throws AbstractCmsNoSuchEntityException {
        if (bl) {
            return this.ecr.getPortString((IEntityModel)this.getToModel(), false);
        }
        return this.ecr.getFullPortString((IEntityModel)this.getToModel(), false);
    }

    public eConnectionType getTypeEnum() {
        return this.optlnk.type;
    }

    public int getType() {
        return this.optlnk.type.value();
    }

    public String getTypeString() {
        return EnumStrings.getString(eConnectionType.class, (int)this.getType());
    }

    public eCreationType getCreationType() {
        return eCreationType.from_int(this.optlnk.creationType.value());
    }

    public eBand getBandId() throws FeatureUnsupported, NoSuchPatchCord {
        return eBand.from_int(this.optlnk.bandId.value());
    }

    public eWavelength getLambda() throws FeatureUnsupported, NoSuchPatchCord {
        return eWavelength.from_int(this.optlnk.lambda.value());
    }

    public int getWaveLength() {
        try {
            return this.getLambda().value();
        }
        catch (FeatureUnsupported featureUnsupported) {
            SDebug.printStackTrace((Throwable)featureUnsupported);
        }
        catch (NoSuchPatchCord noSuchPatchCord) {
            SDebug.printStackTrace((Throwable)noSuchPatchCord);
        }
        return 0;
    }

    public String getWaveLengthString() {
        int n = this.getWaveLength();
        if (n != 174) {
            return Wavelength.getWavelengthStringFromWavelength(n);
        }
        return "N/A";
    }

    protected sOpticalPatchCord getOptLink() {
        return this.optlnk;
    }

    public void delete() throws FeatureUnsupported, NoSuchEquipment, Busy, NoSuchPatchCord {
        this.optPatchCord.deleteOpticalLink(this.getTo(), this.getFrom());
    }

    public List<IOptLinkModel> getChildren() {
        return new ArrayList<IOptLinkModel>();
    }

    public boolean inUse() throws FeatureUnsupported, NoSuchInterface, NoSuchPatchCord {
        return this.optPatchCord.opticalLinkInUse(this.getTo(), this.getFrom());
    }

    public void setParentMPO(MPOLinkModel mPOLinkModel) {
        this.parentMPO = mPOLinkModel;
    }

    public MPOLinkModel getParentMPO() {
        return this.parentMPO;
    }

    protected OpticalPatchCordModel getOpticalPatchCordModel() {
        return this.optPatchCord;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    @Override
    public void update(Observable observable, Object object) {
        int n = object instanceof IObjectMessageInfo ? ((IObjectMessageInfo)object).getUpdateType() : ((Integer)object).intValue();
        switch (n) {
            case 0: {
                if (this.db.on()) {
                    this.db.println("Object deleted. Index:" + this.optlnk.index);
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.DELETED);
                this.optPatchCord.removeLink(this.optlnk.index);
                break;
            }
            case 1: {
                if (this.db.on()) {
                    this.db.println("Object Changed. Index:" + this.optlnk.index);
                }
                this.getPatchCordByIndex.update();
                if (this.parentMPO != null) {
                    this.parentMPO.update(observable, object);
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.CHANGED);
                break;
            }
        }
    }

    @Override
    public void dispose() {
        block4: {
            if (this.dispatcher != null) {
                this.dispatcher.deleteObserver(ObjectType.ObjectOpticalPatchCord, this.optlnk.index, (Observer)this);
                this.dispatcher = null;
                try {
                    this.getFromModel().deleteObserver((Observer)this);
                    this.getToModel().deleteObserver((Observer)this);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) break block4;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        this.getPatchCordByIndex.dispose();
        if (this.parentMPO != null) {
            this.parentMPO.removeChild(this);
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public sOpticalPatchCord getOptLinkByIndex() throws FeatureUnsupported, NoSuchPatchCord {
        try {
            return (sOpticalPatchCord)this.getPatchCordByIndex.get(this.optlnk.index);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchPatchCord xNoSuchPatchCord2) {
            throw new NoSuchPatchCord((UserException)xNoSuchPatchCord2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "addOpticalLink", userException);
        }
    }

    public String toString() {
        return "[IPC 0x" + Integer.toHexString(this.getFrom()) + " -> 0x" + Integer.toHexString(this.getTo()) + "]" + (this.parentMPO != null ? " in MPO" : "");
    }

    private class GetPatchCordByIndex
    extends CachedValue {
        public GetPatchCordByIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xFeatureUnsupported, xNoSuchInterface, xNoSuchPatchCord {
            return OptLinkModel.this.nmd.getIorRepository().getOpticalPatchCordRef().getByIndex((Integer)object);
        }

        public Object outer() {
            return OptLinkModel.this;
        }
    }
}

