/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PassiveUnitPolicy {
    public static final short RU_USER_DEFINED = 0;
    public static final int SLOTS_USER_DEFINED = 0;
    private static final SDebug db = new PassiveUnitPolicyDebug("PassiveUnitPolicy");
    private static final Map<String, Detail> byName = new HashMap<String, Detail>();
    private static final Map<eEqType, List<Detail>> byEqType = new HashMap<eEqType, List<Detail>>();

    public static eEqType[] getAllPassiveUnits() {
        return byEqType.keySet().toArray(new eEqType[0]);
    }

    public static eEqType[] getManageablePassiveUnits() {
        HashSet<eEqType> hashSet = new HashSet<eEqType>(byEqType.keySet());
        hashSet.remove(eEqType.MECH_UNIT);
        return hashSet.toArray(new eEqType[0]);
    }

    public static boolean isPassiveUnit(String string) {
        Detail detail = byName.get(string);
        return detail != null;
    }

    public static int getNumberOfSlots(String string) {
        Detail detail = byName.get(string);
        return detail != null ? detail.nOfSlots : 0;
    }

    public static int getNumberOfSlots(eEqType eEqType2) {
        List<Detail> list = byEqType.get(eEqType2);
        if (list != null && list.size() == 1) {
            return list.get(0).nOfSlots;
        }
        return 0;
    }

    public static int getSlotsOccupied(String string) {
        Detail detail = byName.get(string);
        return detail != null ? 1 : 0;
    }

    public static short getRUOccupied(NodeModelDelegate nodeModelDelegate, String string) {
        Detail detail = byName.get(string);
        return detail != null ? detail.getRUSize(nodeModelDelegate.isSdh()) : (short)0;
    }

    public static short getRUOccupied(NodeModelDelegate nodeModelDelegate, eEqType eEqType2) {
        List<Detail> list = byEqType.get(eEqType2);
        if (list != null && list.size() == 1) {
            return list.get(0).getRUSize(nodeModelDelegate.isSdh());
        }
        return 0;
    }

    public static eEqType getEqType(String string) {
        Detail detail = byName.get(string);
        return detail != null ? detail.eq : eEqType.UNKNOWN;
    }

    public static boolean isPassiveContainer(eEqType eEqType2) {
        List<Detail> list = byEqType.get(eEqType2);
        if (list != null && list.size() == 1) {
            return list.get(0).contains != null;
        }
        return false;
    }

    public static boolean isPassiveInnerUnit(eEqType eEqType2) {
        List<Detail> list = byEqType.get(eEqType2);
        if (list != null && list.size() == 1) {
            return list.get(0).containers.size() >= 1;
        }
        return false;
    }

    public static Map<String, Object> getMapOfValidUnits(INodeModel iNodeModel, short s) {
        return PassiveUnitPolicy.getMapOfValidUnits(iNodeModel, s, 0, null);
    }

    public static Map<String, Object> getMapOfValidUnits(INodeModel iNodeModel, short s, int n, eEqType eEqType2) {
        boolean bl = ((NodeModelDelegate)iNodeModel).isSdh();
        return PassiveUnitPolicy.getMapOfValidUnits(bl, s, n, eEqType2);
    }

    public static Map<String, Object> getMapOfValidUnits(boolean bl, short s, int n, eEqType eEqType2) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (Detail detail : byName.values()) {
            if (detail.containers.size() == 0) {
                if (!(!detail.sameInnerEq(eEqType2) || detail.getRUSize(bl) != 0 && detail.getRUSize(bl) > s || n != 0 && detail.nOfSlots != n)) {
                    if (detail.family != null) {
                        db.info("Add " + detail.name + " to family " + detail.family);
                        TreeMap<String, eEqType> treeMap2 = (TreeMap<String, eEqType>)treeMap.get(detail.family);
                        if (treeMap2 == null) {
                            db.info("Add family " + detail.family);
                            treeMap2 = new TreeMap<String, eEqType>();
                            treeMap.put(detail.family, treeMap2);
                        }
                        treeMap2.put(detail.name, detail.eq);
                        continue;
                    }
                    db.info("Add " + detail.name);
                    treeMap.put(detail.name, detail.eq);
                    continue;
                }
                db.info("Discarded " + detail.name);
                continue;
            }
            db.info("Inner unit discarded " + detail.name);
        }
        return treeMap;
    }

    public static List<String> getListOfValidUpgradeType(eEqType eEqType2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Detail> list = byEqType.get(eEqType2);
        if (list != null) {
            for (Detail detail : list) {
                for (Detail detail2 : detail.upgrades) {
                    db.info("Add " + detail.name);
                    arrayList.add(detail2.name);
                }
            }
        }
        return arrayList;
    }

    private static String toEqString(eEqType eEqType2) {
        return EqTypeHelper.eqTypeToName((TDMTerminology)TDMTerminology.getDefault(), (int)eEqType2.value());
    }

    private PassiveUnitPolicy() {
    }

    static {
        new Detail(eEqType.PASSIVE_DCU, 1, 2);
        new Detail(eEqType.PASSIVE_PP_4_SMR, 1);
        new Detail(eEqType.PASSIVE_PP_MESH_8, 2);
        Detail detail = new Detail(eEqType.PASSIVE_PP_MESH_4, 2);
        detail.addUpgradable(new eEqType[]{eEqType.PASSIVE_PP_MESH_8});
        new Detail(eEqType.PASSIVE_MD_40_EVEN, 2);
        new Detail(eEqType.PASSIVE_MD_40_ODD, 2);
        detail = new Detail(eEqType.PASSIVE_MD_ID_50, 2);
        detail.addContainers(new eEqType[]{eEqType.PASSIVE_MD_40_EVEN, eEqType.PASSIVE_MD_40_ODD});
        new Detail(eEqType.PASSIVE_15216_ID_50, 1, 4);
        new Detail("PDP", "MECH UNIT", eEqType.MECH_UNIT, 1);
        new Detail("EAP", "MECH UNIT", eEqType.MECH_UNIT, 1);
        new Detail("ETH SWITCH", "MECH UNIT", eEqType.MECH_UNIT, 1);
        new Detail("FL 1", "MECH UNIT", eEqType.MECH_UNIT, 1, 4);
        new Detail("FL 2", "MECH UNIT", eEqType.MECH_UNIT, 2, 8);
        new Detail("AIR RAMP", "MECH UNIT", eEqType.MECH_UNIT, 2, 1);
        new Detail("FIBER STORAGE", "MECH UNIT", eEqType.MECH_UNIT, 1);
        new Detail("ALIEN SHELF", "MECH UNIT", eEqType.MECH_UNIT, 0, 1);
        new Detail("PP2-64-LC", "MECH UNIT", eEqType.MECH_UNIT, 2);
        new Detail("PP-64-LC", "MECH UNIT", eEqType.MECH_UNIT, 1);
        new Detail("PP-80-LC", "MECH UNIT", eEqType.MECH_UNIT, 2);
    }

    private static class Detail {
        private final String name;
        private final String family;
        private final eEqType eq;
        private final short ANSI_RUsize;
        private final short ETSI_RUsize;
        private final int nOfSlots;
        private final List<Detail> containers = new ArrayList<Detail>();
        private final List<Detail> upgrades = new ArrayList<Detail>();
        private Detail contains = null;

        private Detail(eEqType eEqType2, short s) {
            this(eEqType2, s, 1);
        }

        private Detail(eEqType eEqType2, short s, int n) {
            this(PassiveUnitPolicy.toEqString(eEqType2), null, eEqType2, s, s, n);
        }

        private Detail(String string, String string2, eEqType eEqType2, short s) {
            this(string, string2, eEqType2, s, s, 1);
        }

        private Detail(String string, String string2, eEqType eEqType2, short s, short s2) {
            this(string, string2, eEqType2, s, s2, 1);
        }

        private Detail(String string, String string2, eEqType eEqType2, short s, int n) {
            this(string, string2, eEqType2, s, s, n);
        }

        private Detail(String string, String string2, eEqType eEqType2, short s, short s2, int n) {
            this.name = string;
            this.family = string2;
            this.eq = eEqType2;
            this.ANSI_RUsize = s;
            this.ETSI_RUsize = s2;
            this.nOfSlots = n;
            byName.put(string, this);
            ArrayList<Detail> arrayList = (ArrayList<Detail>)byEqType.get(eEqType2);
            if (arrayList == null) {
                arrayList = new ArrayList<Detail>();
                byEqType.put(eEqType2, arrayList);
            }
            arrayList.add(this);
        }

        void addContainers(eEqType[] eEqTypeArray) {
            for (eEqType eEqType2 : eEqTypeArray) {
                List list = (List)byEqType.get(eEqType2);
                for (Detail detail : list) {
                    detail.contains = this;
                    this.containers.add(detail);
                }
            }
        }

        void addUpgradable(eEqType[] eEqTypeArray) {
            for (eEqType eEqType2 : eEqTypeArray) {
                List list = (List)byEqType.get(eEqType2);
                for (Detail detail : list) {
                    this.upgrades.add(detail);
                }
            }
        }

        boolean sameInnerEq(eEqType eEqType2) {
            if (this.contains != null) {
                return eEqType2 == null || this.contains.eq == eEqType2;
            }
            return eEqType2 == null;
        }

        short getRUSize(boolean bl) {
            return bl ? this.ETSI_RUsize : this.ANSI_RUsize;
        }

        public String toString() {
            return this.name + "(" + this.eq.value() + ") " + "(" + this.family + ") " + this.ANSI_RUsize + "/" + this.ETSI_RUsize + "," + this.nOfSlots;
        }
    }

    public static class PassiveUnitPolicyDebug
    extends SDebug {
        public PassiveUnitPolicyDebug(String string) {
            super(string);
        }

        public final void dump() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n  PassiveUnitPolicy eqType(s) contents:");
            for (eEqType object : PassiveUnitPolicy.getAllPassiveUnits()) {
                stringBuilder.append("\n    ");
                stringBuilder.append(PassiveUnitPolicy.toEqString(object));
                stringBuilder.append("(");
                stringBuilder.append(object.value());
                stringBuilder.append(")");
            }
            stringBuilder.append("\n  PassiveUnitPolicy Manageable eqType(s) contents:");
            for (eEqType eEqType2 : PassiveUnitPolicy.getManageablePassiveUnits()) {
                stringBuilder.append("\n    ");
                stringBuilder.append(PassiveUnitPolicy.toEqString(eEqType2));
                stringBuilder.append("(");
                stringBuilder.append(eEqType2.value());
                stringBuilder.append(")");
            }
            stringBuilder.append("\n  PassiveUnitPolicy byName contents:");
            for (Detail detail : byName.values()) {
                stringBuilder.append("\n    ");
                stringBuilder.append(detail.toString());
                if (detail.contains != null) {
                    stringBuilder.append("\n       Container of: [");
                    stringBuilder.append(detail.contains.name);
                    stringBuilder.append("]");
                }
                if (detail.containers.size() > 0) {
                    stringBuilder.append("\n       Contained by: [");
                    for (Detail detail2 : detail.containers) {
                        stringBuilder.append(detail2.name);
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append("]");
                }
                if (detail.upgrades.size() <= 0) continue;
                stringBuilder.append("\n       Upgradable by: [");
                for (Detail detail3 : detail.upgrades) {
                    stringBuilder.append(detail3.name);
                    stringBuilder.append(" ");
                }
                stringBuilder.append("]");
            }
            this.dumpValidUnits(stringBuilder, false, (short)1, null);
            this.dumpValidUnits(stringBuilder, false, (short)2, null);
            this.dumpValidUnits(stringBuilder, false, (short)5, null);
            this.dumpValidUnits(stringBuilder, false, (short)2, eEqType.PASSIVE_MD_ID_50);
            this.dumpValidUnits(stringBuilder, true, (short)1, null);
            this.dumpValidUnits(stringBuilder, true, (short)2, null);
            this.dumpValidUnits(stringBuilder, true, (short)5, null);
            this.dumpValidUnits(stringBuilder, true, (short)2, eEqType.PASSIVE_MD_ID_50);
            db.println(stringBuilder.toString());
        }

        private void dumpValidUnits(StringBuilder stringBuilder, boolean bl, short s, eEqType eEqType2) {
            stringBuilder.append("\n  [" + (bl ? "SDH" : "SONET") + "] Map of valid units with RUsize " + s + ":" + (eEqType2 != null ? " (" + PassiveUnitPolicy.toEqString(eEqType2) + ")" : ""));
            Map<String, Object> map = PassiveUnitPolicy.getMapOfValidUnits(bl, s, 0, eEqType2);
            for (String string : map.keySet()) {
                stringBuilder.append("\n      [");
                stringBuilder.append(string);
                Object object = map.get(string);
                if (object instanceof Map) {
                    this.dumpMap(stringBuilder, (Map)object);
                }
                stringBuilder.append("]");
            }
        }

        private void dumpMap(StringBuilder stringBuilder, Map<String, Object> map) {
            stringBuilder.append(" -> {");
            for (String string : map.keySet()) {
                stringBuilder.append(string);
                stringBuilder.append(",");
            }
            stringBuilder.append("}");
        }
    }
}

