/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractPersistableModelState;
import cerent.cms.model.DeletionToken;
import cerent.cms.model.ICORBAStreamable;
import cerent.cms.model.IModelPersistenceConstants;
import cerent.cms.model.IModelPersistenceStrategy;
import cerent.cms.model.IModelStateFactory;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IStreamer;
import cerent.cms.model.LRUManager;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PersistenceException;
import cerent.cms.model.ReflectionUtil;
import cerent.cms.model.SequenceNumberLRUMap;
import cerent.cms.model.StateBatchInfo;
import cerent.cms.model.persistence.CORBAStreamer;
import cerent.util.ISequenceNumberConstants;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.TimeLRUMap;
import cerent.util.id.INetwideModelIdentity;
import cerent.util.id.ModelIdentityFactory;
import cerent.util.id.NetwideModelIdentity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public abstract class PersistableModel
extends Model
implements IModelStateFactory {
    private static final String PREFS_LRU_MANAGER = "ctc.model.persist.lrumanager";
    private static final String PREFS_LRU_MANAGER_SELFSTART = "selfstart";
    private static final Field[] FieldArrayTemplate = new Field[0];
    public static final int MOST_SPECIFIC_CLASS_COOKIE = -1;
    public static final long UNINITIALIZED_SEQ_NUM = -1L;
    public static final Long UNINITIALIZED_SEQ_NUM_OBJ = ISequenceNumberConstants.UNINITIALIZED_SEQ_NUM_OBJ;
    protected static final int NE_DELETED_STATE_BIT_INDEX = 0;
    protected byte state = 0;

    protected PersistableModel(SDebug sDebug) {
        super(sDebug);
    }

    protected static int getLowestStateBitIndexAvailable() {
        return 1;
    }

    protected static final int getHighestStateBitIndexAvailable() {
        return 7;
    }

    protected boolean isStateBit(int n, int n2) {
        this.checkStateBitIndex(n, n2);
        return this._isStateBit(n);
    }

    protected void setStateBit(int n, int n2, boolean bl) {
        this.checkStateBitIndex(n, n2);
        this._setStateBit(n, bl);
    }

    protected final void checkStateBitIndex(int n, int n2) {
        int n3 = PersistableModel.getHighestStateBitIndexAvailable();
        if (n < n2 || n > n3) {
            throw new ArrayIndexOutOfBoundsException("The bit index must be between " + n2 + " and " + n3 + ".");
        }
    }

    private boolean _isStateBit(int n) {
        return (this.state & 1 << n) != 0;
    }

    private void _setStateBit(int n, boolean bl) {
        this.state = bl ? (byte)(this.state | 1 << n) : (byte)(this.state & ~(1 << n));
    }

    protected abstract AbstractPersistableModelState getAttrs(int var1, int var2);

    protected abstract void setAttrs(int var1, AbstractPersistableModelState var2);

    protected abstract int getModelType(AbstractPersistableModelState var1);

    protected abstract AbstractPersistableModelState createInitialStateValue(int var1, int var2);

    protected abstract LRUManager.LRUObjectHandler getHandler();

    protected boolean canBePersisted(int n) {
        return true;
    }

    private AbstractPersistableModelState _createInitialState(int n, int n2) {
        AbstractPersistableModelState abstractPersistableModelState = this.createInitialStateValue(n, n2);
        this._linkState(n, n2, abstractPersistableModelState);
        this.indicateAccess(n);
        AbstractPersistableModelState abstractPersistableModelState2 = this.getAttrs(n, n2);
        return abstractPersistableModelState2;
    }

    private AbstractPersistableModelState _createInitialState(int n) {
        return this._createInitialState(n, -1);
    }

    @Override
    public ICORBAStreamable createInitialState(int n) {
        return this._createInitialState(n);
    }

    protected final NodeModelDelegate getNmd() {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getNodeModel();
        return nodeModelDelegate;
    }

    abstract IModelPersistenceStrategy getPersistenceStrategy();

    private void indicateAccess(int n) {
        AbstractPersistableModelState abstractPersistableModelState = this.getAttrs(n, -1);
        this.indicateAccess(abstractPersistableModelState);
    }

    protected final void indicateAccess(AbstractPersistableModelState abstractPersistableModelState, long l) {
        this.indicateAccess(abstractPersistableModelState, l, false);
    }

    protected final void indicateWriteAccess(AbstractPersistableModelState abstractPersistableModelState, long l) {
        abstractPersistableModelState.setPersistenceNeeded();
        this.indicateAccess(abstractPersistableModelState, l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void indicateAccess(AbstractPersistableModelState abstractPersistableModelState, long l, boolean bl) {
        LRUManager lRUManager;
        if (abstractPersistableModelState != null && (lRUManager = this.getLRUManager()) != null) {
            TimeLRUMap timeLRUMap = null;
            Object object = lRUManager.getInternalLock();
            synchronized (object) {
                timeLRUMap = lRUManager.getLRU();
            }
            abstractPersistableModelState.indicateAccess(timeLRUMap, l, bl);
        }
    }

    private void indicateAccess(AbstractPersistableModelState abstractPersistableModelState) {
        this.indicateAccess(abstractPersistableModelState, -1L);
    }

    protected final INetwideModelIdentity getNetwideModelIdentity(int n) throws AbstractCmsNoSuchEntityException {
        if (n == -1) {
            return null;
        }
        INodeModel iNodeModel = this.getNodeModel();
        int n2 = iNodeModel.getNodeId();
        int n3 = this.getIndex();
        NetwideModelIdentity netwideModelIdentity = ModelIdentityFactory.instance().createNetwideModelIdentity(n2, n, n3);
        return netwideModelIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractPersistableModelState retrieveAttrs(int n, int n2, boolean bl) {
        AbstractPersistableModelState abstractPersistableModelState;
        int n3;
        block30: {
            n3 = 0;
            abstractPersistableModelState = this.getAttrs(n, n2);
            try {
                if (abstractPersistableModelState == null) {
                    PersistableModel persistableModel = this;
                    synchronized (persistableModel) {
                        if (bl) {
                            INetwideModelIdentity iNetwideModelIdentity;
                            n3 = 1;
                            IModelPersistenceStrategy iModelPersistenceStrategy = this.getPersistenceStrategy();
                            INetwideModelIdentity iNetwideModelIdentity2 = iNetwideModelIdentity = this.doesGetReallyPersisted(iModelPersistenceStrategy, n) ? this.getNetwideModelIdentity(n) : null;
                            if (iNetwideModelIdentity == null && this.db.on()) {
                                this.db.println("id was null for modelType: " + n + " - " + this.displayid());
                            }
                            try {
                                abstractPersistableModelState = AbstractPersistableModelState._retrieve(iModelPersistenceStrategy, iNetwideModelIdentity, this);
                                if (abstractPersistableModelState == null) {
                                    n3 = 2;
                                    if (this.db.on()) {
                                        this.db.println("creating new in-memory model state for " + this.displayid());
                                    }
                                    abstractPersistableModelState = this.createInitialStateValue(n, n2);
                                    if (this.db.on()) {
                                        this.db.println("createInitialStateValue " + n + " - " + n2 + ": " + abstractPersistableModelState);
                                    }
                                } else {
                                    n3 = 3;
                                }
                                this._linkState(n, n2, abstractPersistableModelState);
                            }
                            catch (PersistenceException persistenceException) {
                                n3 = 4;
                                abstractPersistableModelState = this.createInitialStateValue(n, n2);
                                this._linkState(n, n2, abstractPersistableModelState);
                            }
                        }
                        break block30;
                    }
                }
                n3 = 6;
                this.indicateAccess(abstractPersistableModelState);
                if (!IModelPersistenceConstants.DO_ENCODE_DECODE_TEST) break block30;
                n3 = 7;
                this.db.println(this.displayid() + " encode/decode test being run (only failures are printed-out)...");
                ByteArrayInputStream byteArrayInputStream = this.encode(abstractPersistableModelState);
                try {
                    AbstractPersistableModelState abstractPersistableModelState2 = (AbstractPersistableModelState)this.decode(byteArrayInputStream, n);
                    abstractPersistableModelState.setModel(this);
                    abstractPersistableModelState2.setModel(this);
                    String string = abstractPersistableModelState.compare(abstractPersistableModelState2, true);
                    if (string != null) {
                        this.db.println("encode/decode test failed for " + abstractPersistableModelState.displayid() + " with: " + string);
                    } else {
                        abstractPersistableModelState = abstractPersistableModelState2;
                        this._linkState(n, n2, abstractPersistableModelState);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                }
                finally {
                    if (byteArrayInputStream != null) {
                        try {
                            ((InputStream)byteArrayInputStream).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (PersistenceException persistenceException) {
                this.db.println("retrieveAttrs failed: " + (Object)((Object)persistenceException));
                SDebug.printStackTrace((Throwable)((Object)persistenceException));
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.println("retrieveAttrs failed: " + (Object)((Object)abstractCmsNoSuchEntityException));
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (this.db.on()) {
            this.db.println("retrieveAttrs(" + n3 + "): modelType: " + n + " cookie: " + n2);
        }
        return abstractPersistableModelState;
    }

    protected AbstractPersistableModelState retrieveAttrs(int n, int n2) {
        return this.retrieveAttrs(n, n2, true);
    }

    protected boolean doesGetReallyPersisted(IModelPersistenceStrategy iModelPersistenceStrategy, int n) {
        return true;
    }

    final synchronized void flush(int n, long l) {
        block12: {
            if (this.wasNeDeleted()) {
                return;
            }
            AbstractPersistableModelState abstractPersistableModelState = this.getAttrs(n, -1);
            boolean bl = false;
            boolean bl2 = false;
            try {
                if (abstractPersistableModelState != null && n != -1 && (bl2 = this.canBePersisted(n))) {
                    INetwideModelIdentity iNetwideModelIdentity;
                    IModelPersistenceStrategy iModelPersistenceStrategy = this.getPersistenceStrategy();
                    bl = abstractPersistableModelState.save(iModelPersistenceStrategy, iNetwideModelIdentity = this.getNetwideModelIdentity(n), l);
                    if (bl) {
                        if (this.db.on()) {
                            this.db.println(this.displayid() + " and " + abstractPersistableModelState.displayid() + " have been disassociated");
                        }
                        this._linkState(n, -1, null);
                    } else if (this.db.on()) {
                        this.db.println("save NOT done on: " + n + "/" + l + " " + abstractPersistableModelState + " " + bl2);
                    }
                } else if (this.db.on()) {
                    this.db.println("flush NOT done on: " + n + "/" + l + " " + abstractPersistableModelState + " " + bl2);
                }
            }
            catch (PersistenceException persistenceException) {
                if (this.db.on()) {
                    this.db.println("flush persistence failed: " + (Object)((Object)persistenceException));
                    SDebug.printStackTrace((Throwable)((Object)persistenceException));
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block12;
                this.db.println("flush failed -- non existent model: " + (Object)((Object)abstractCmsNoSuchEntityException));
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
    }

    static final void batchFlush(StateBatchInfo[] stateBatchInfoArray) {
        if (stateBatchInfoArray == null) {
            return;
        }
        PersistableModel.batchFlushWithLocking(stateBatchInfoArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean batchFlushWithLocking(StateBatchInfo[] stateBatchInfoArray, int n) {
        boolean bl;
        StateBatchInfo stateBatchInfo = stateBatchInfoArray[n];
        int n2 = stateBatchInfo.modelType;
        Long l = stateBatchInfo.seqNum;
        PersistableModel persistableModel = stateBatchInfo.model;
        if (persistableModel == null) {
            boolean bl2 = PersistableModel._batchFlushWithLocking(stateBatchInfoArray, n);
            return bl2;
        }
        PersistableModel persistableModel2 = persistableModel;
        synchronized (persistableModel2) {
            boolean bl3;
            if (persistableModel.wasNeDeleted()) {
                stateBatchInfo.doSkip = true;
                boolean bl4 = PersistableModel._batchFlushWithLocking(stateBatchInfoArray, n);
                return bl4;
            }
            IModelPersistenceStrategy iModelPersistenceStrategy = persistableModel.getPersistenceStrategy();
            AbstractPersistableModelState abstractPersistableModelState = persistableModel.getAttrs(n2, -1);
            if (abstractPersistableModelState == null || n2 == -1 || !(bl3 = persistableModel.canBePersisted(n2))) {
                stateBatchInfo.doSkip = true;
            }
            stateBatchInfo.state = abstractPersistableModelState;
            try {
                INetwideModelIdentity iNetwideModelIdentity;
                stateBatchInfo.id = iNetwideModelIdentity = persistableModel.getNetwideModelIdentity(n2);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (persistableModel.db.on()) {
                    persistableModel.db.println("flush failed -- non existent model (" + persistableModel + "): " + (Object)((Object)abstractCmsNoSuchEntityException));
                    SDebug cfr_ignored_0 = persistableModel.db;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                stateBatchInfo.doSkip = true;
            }
            bl = PersistableModel._batchFlushWithLocking(stateBatchInfoArray, n);
            if (bl && !stateBatchInfo.doSkip) {
                persistableModel._linkState(n2, -1, null);
            } else if (persistableModel != null && persistableModel.db.on()) {
                persistableModel.db.println("save NOT done on: " + n2 + "/" + l + " " + abstractPersistableModelState);
            }
        }
        return bl;
    }

    private static final boolean _batchFlushWithLocking(StateBatchInfo[] stateBatchInfoArray, int n) {
        boolean bl = false;
        StateBatchInfo stateBatchInfo = stateBatchInfoArray[n];
        if (n == stateBatchInfoArray.length - 1) {
            try {
                bl = AbstractPersistableModelState.batchSave(stateBatchInfoArray);
            }
            catch (PersistenceException persistenceException) {
                PersistableModel persistableModel = stateBatchInfo.model;
                if (persistableModel != null && persistableModel.db.on()) {
                    persistableModel.db.println("flush persistence failed: " + (Object)((Object)persistenceException));
                    SDebug cfr_ignored_0 = persistableModel.db;
                    SDebug.printStackTrace((Throwable)((Object)persistenceException));
                }
            }
        } else {
            bl = PersistableModel.batchFlushWithLocking(stateBatchInfoArray, n + 1);
        }
        return bl;
    }

    private LRUManager _getLRUManager() {
        LRUManager lRUManager = LRUManager.getInstance(this.getNmd(), this.getHandler(), SequenceNumberLRUMap.class);
        return lRUManager;
    }

    private LRUManager getLRUManager() {
        LRUManager lRUManager = null;
        IModelPersistenceStrategy iModelPersistenceStrategy = this.getPersistenceStrategy();
        if (!iModelPersistenceStrategy.doesGetReallyPersisted(AbstractPersistableModelState.class)) {
            return null;
        }
        lRUManager = this._getLRUManager();
        boolean bl = Preferences.instance().getBoolean(PREFS_LRU_MANAGER, PREFS_LRU_MANAGER_SELFSTART, false);
        if (bl && lRUManager != null) {
            lRUManager.startWork();
        }
        return lRUManager;
    }

    private final void stopLRUManager() {
        LRUManager lRUManager;
        if (this.db.on()) {
            this.db.println("stopLRUManager called");
            SDebug.printStackTrace((Throwable)new Exception());
        }
        if ((lRUManager = this._getLRUManager()) != null) {
            lRUManager.finishWork();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromLRUManager(AbstractPersistableModelState abstractPersistableModelState) {
        LRUManager lRUManager = this._getLRUManager();
        if (lRUManager != null) {
            Object object = lRUManager.getInternalLock();
            synchronized (object) {
                TimeLRUMap timeLRUMap = lRUManager.getLRU();
                if (timeLRUMap != null) {
                    timeLRUMap.removeObj(abstractPersistableModelState);
                }
            }
        }
    }

    final void linkState(int n, AbstractPersistableModelState abstractPersistableModelState) {
        this.setAttrs(n, abstractPersistableModelState);
    }

    protected final void _linkState(int n, int n2, AbstractPersistableModelState abstractPersistableModelState) {
        AbstractPersistableModelState abstractPersistableModelState2;
        if (n == -1 && n2 == -1) {
            if (abstractPersistableModelState != null) {
                n = this.getModelType(abstractPersistableModelState);
            }
            if (n == -1) {
                this.setAttrs(n, null);
                return;
            }
        }
        if (abstractPersistableModelState == (abstractPersistableModelState2 = this.getAttrs(n, n2))) {
            return;
        }
        if (abstractPersistableModelState2 != null) {
            abstractPersistableModelState2.linkModel(null);
        }
        if (abstractPersistableModelState != null) {
            abstractPersistableModelState.linkModel(this);
        }
        this.setAttrs(n, abstractPersistableModelState);
    }

    protected void delete(int n) {
        block6: {
            NodeModelDelegate nodeModelDelegate = this.getNmd();
            if (!nodeModelDelegate.isDestroyed()) {
                try {
                    IModelPersistenceStrategy iModelPersistenceStrategy = this.getPersistenceStrategy();
                    if (iModelPersistenceStrategy.doesGetReallyPersisted(this)) {
                        INetwideModelIdentity iNetwideModelIdentity = this.getNetwideModelIdentity(n);
                        iModelPersistenceStrategy.delete(iNetwideModelIdentity);
                    }
                }
                catch (PersistenceException persistenceException) {
                    if (this.db.on()) {
                        this.db.println("DB delete failed w/ error: " + (Object)((Object)persistenceException));
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) break block6;
                    this.db.println("DB delete failed w/ error: " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteAllState(Class clazz, long l) {
        block11: {
            this._setStateBit(0, true);
            TimeLRUMap timeLRUMap = null;
            if (l == -1L) {
                return;
            }
            try {
                Object object;
                Object object2;
                LRUManager lRUManager = this._getLRUManager();
                if (lRUManager != null) {
                    object2 = lRUManager.getInternalLock();
                    synchronized (object2) {
                        timeLRUMap = lRUManager.getLRU();
                        if (timeLRUMap != null && (object = this.createDeletionToken(l)) != null) {
                            timeLRUMap.touch(object);
                        }
                    }
                }
                if (timeLRUMap == null && (object2 = this.getPersistenceStrategy()).doesGetReallyPersisted(clazz)) {
                    object = this.getNetwideModelIdentity(0);
                    object2.deleteIndex((INetwideModelIdentity)object, l);
                }
            }
            catch (PersistenceException persistenceException) {
                if (this.db.on()) {
                    this.db.println("DB delete failed w/ error: " + (Object)((Object)persistenceException));
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block11;
                this.db.println("DB delete failed w/ error: " + (Object)((Object)abstractCmsNoSuchEntityException));
            }
        }
    }

    protected abstract DeletionToken createDeletionToken(long var1);

    protected final void dispose(int n) {
        this._dispose(n);
        super.dispose();
    }

    private void _dispose(int n) {
        AbstractPersistableModelState abstractPersistableModelState;
        AbstractPersistableModelState abstractPersistableModelState2 = abstractPersistableModelState = n == -1 ? null : this.retrieveAttrs(n, -1, false);
        if (abstractPersistableModelState != null) {
            abstractPersistableModelState.dispose();
        }
    }

    protected final void destroy(int n) {
        this._destroy(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _destroy(int n) {
        LRUManager lRUManager;
        NodeModelDelegate nodeModelDelegate = this.getNmd();
        if (nodeModelDelegate == null || nodeModelDelegate.isDestroyed()) {
            this.stopLRUManager();
        }
        if ((lRUManager = this.getLRUManager()) != null) {
            TimeLRUMap timeLRUMap = null;
            Object object = lRUManager.getInternalLock();
            synchronized (object) {
                timeLRUMap = lRUManager.getLRU();
            }
            if (timeLRUMap == null || !timeLRUMap.isQueued(this)) {
                this._linkState(n, -1, null);
            }
        } else {
            this._linkState(n, -1, null);
        }
    }

    protected final String displayid() {
        String string = this.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1) + " " + this.getIndex();
        return string2;
    }

    private IStreamer getStreamer() {
        CORBAStreamer cORBAStreamer = CORBAStreamer.instance();
        return cORBAStreamer;
    }

    private ByteArrayInputStream encode(Object object) throws PersistenceException {
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        IStreamer iStreamer = this.getStreamer();
        try {
            byteArrayOutputStream = iStreamer.write(object);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.db.display(this.displayid() + " encode length is: " + byArray.length);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (IOException iOException) {
            throw new PersistenceException("The encode failed.", iOException);
        }
        catch (ClassCastException classCastException) {
            throw new PersistenceException("The encode failed.", classCastException);
        }
        finally {
            PersistableModel.close(byteArrayOutputStream);
        }
        return byteArrayInputStream;
    }

    private Object decode(InputStream inputStream, int n) throws PersistenceException, AbstractCmsNoSuchEntityException {
        Object object = null;
        try {
            IStreamer iStreamer = this.getStreamer();
            INetwideModelIdentity iNetwideModelIdentity = this.getNetwideModelIdentity(n);
            object = iStreamer.read(inputStream, (Object)this, iNetwideModelIdentity);
        }
        catch (IOException iOException) {
            throw new PersistenceException("decode failed", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PersistenceException("decode failed", classNotFoundException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new PersistenceException("decode failed", iOException);
                }
            }
        }
        return object;
    }

    private static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                SDebug.printStackTrace((Throwable)iOException);
            }
        }
    }

    private static void close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                SDebug.printStackTrace((Throwable)iOException);
            }
        }
    }

    protected static final List _getAttrFields(Class clazz) {
        Field[] fieldArray = ReflectionUtil.getNCVs(clazz);
        ArrayList<Field> arrayList = new ArrayList<Field>(fieldArray.length);
        for (int i = 0; i < fieldArray.length; ++i) {
            arrayList.add(fieldArray[i]);
        }
        return arrayList;
    }

    protected static final void _addAttrFields(List list, Field[] fieldArray) {
        int n = fieldArray == null ? 0 : fieldArray.length;
        for (int i = 0; i < n; ++i) {
            list.add(fieldArray[i]);
        }
    }

    protected static final Field[] addAttrFields(List list, Field[] fieldArray) {
        PersistableModel._addAttrFields(list, fieldArray);
        return list.toArray(FieldArrayTemplate);
    }

    @Override
    public Object getAttrFieldValue(Field field) {
        Object object = null;
        field.setAccessible(true);
        try {
            object = field.get(this);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return object;
    }

    protected static final Field[] getAttrNcvFields(Class clazz) {
        return AbstractPersistableModelState.getNcvFields(clazz);
    }

    public boolean wasNeDeleted() {
        return this._isStateBit(0);
    }

    protected void updateLocal(long l) {
        super.updateLocal();
    }

    abstract void allAttributesIndicateWriteAccess(long var1);

    public void dumpAccessCounts(AbstractPersistableModelState abstractPersistableModelState) {
    }
}

