/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.OpticsTopology.sPptItem;
import cerent.cms.idl.OpticsTopology.sPptNode;
import cerent.cms.idl.OpticsTopology.sPptParams;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IPptData;
import cerent.cms.model.IPptListener;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.util.KDebug;
import cerent.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.omg.CORBA.UserException;

public final class PptManager
implements Observer {
    private IPptListener recipient;
    private KDebug db;
    private int pptId;
    private NodeModelDelegate node;
    private AtomicBoolean started = new AtomicBoolean(false);

    public PptManager(NodeModelDelegate nodeModelDelegate, KDebug kDebug) {
        this.node = nodeModelDelegate;
        this.db = kDebug;
    }

    public boolean startPpt(int n, List<Pair<IIpAddr, Integer>> list, IPptListener iPptListener) {
        Object object;
        if (!this.started.compareAndSet(false, true)) {
            return false;
        }
        this.recipient = iPptListener;
        try {
            object = new GetId(this.node).get();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.db.on()) {
                this.db.print("PptManager: AbstractCmsIOException");
            }
            return false;
        }
        catch (UserException userException) {
            if (this.db.on()) {
                this.db.print("PptManager: UserException");
            }
            return false;
        }
        if (!(object instanceof Integer)) {
            return false;
        }
        this.pptId = (Integer)object;
        this.node.getDispatcher().addObserver(ObjectType.ObjectPptResult, this.pptId, (Observer)this);
        ArrayList<sPptNode> arrayList = new ArrayList<sPptNode>(list.size());
        for (Pair<IIpAddr, Integer> pair : list) {
            arrayList.add(new sPptNode(IpAddrFactory.getIpAddr((IIpAddr)pair.getFirst()), (Integer)pair.getSecond()));
        }
        sPptParams sPptParams2 = new sPptParams(arrayList.toArray(new sPptNode[0]), eWavelength.from_int(n));
        try {
            new Start(this.node, sPptParams2, this.pptId).get();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.db.on()) {
                this.db.print("PptManager: AbstractCmsIOException");
            }
            return false;
        }
        catch (UserException userException) {
            if (this.db.on()) {
                this.db.print("PptManager: UserException");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable observable, Object object) {
        if (this.recipient != null) {
            this.node.getDispatcher().deleteObserver(ObjectType.ObjectPptResult, this.pptId, (Observer)this);
        }
        ArrayList<PptData> arrayList = new ArrayList<PptData>();
        try {
            sPptItem[] sPptItemArray;
            Object object2 = new GetResult(this.node, this.pptId).get();
            if (!(object2 instanceof sPptItem[])) {
                return;
            }
            for (sPptItem sPptItem2 : sPptItemArray = (sPptItem[])object2) {
                int n = sPptItem2.evList.length;
                long[] lArray = new long[n];
                long[] lArray2 = new long[n];
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    lArray[i] = sPptItem2.evList[i].power;
                    lArray2[i] = sPptItem2.evList[i].threshold;
                    nArray[i] = sPptItem2.evList[i].portId;
                }
                arrayList.add(new PptData(IpAddrFactory.getIIpAddr(sPptItem2.ipAddr), nArray, lArray, lArray2));
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.db.on()) {
                this.db.print("PptManager: AbstractCmsIOException");
            }
        }
        catch (UserException userException) {
            if (this.db.on()) {
                this.db.print("PptManager: UserException");
            }
        }
        finally {
            this.recipient.onPptResult(arrayList);
            this.started.set(false);
        }
    }

    private static class GetId
    extends NonCachedValue {
        public GetId(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected Object getValue() {
            return new Integer(this.node.getIorRepository().getOchncCircuitsRef().getNextPptId());
        }
    }

    private static class GetResult
    extends NonCachedValue {
        private int pptId;

        public GetResult(NodeModelDelegate nodeModelDelegate, int n) {
            super(nodeModelDelegate);
            this.pptId = n;
        }

        @Override
        protected Object getValue() {
            return this.node.getIorRepository().getOchncCircuitsRef().getPptResult(this.pptId);
        }
    }

    private static class PptData
    implements IPptData {
        private IIpAddr nodeIp;
        private int[] interfaceIds;
        private long[] values;
        private long[] thresholds;

        public PptData(IIpAddr iIpAddr, int[] nArray, long[] lArray, long[] lArray2) {
            this.nodeIp = iIpAddr;
            this.interfaceIds = nArray;
            this.values = lArray;
            this.thresholds = lArray2;
        }

        public int[] getInterfaceIds() {
            return this.interfaceIds;
        }

        public long[] getPowerValues() {
            return this.values;
        }

        public long[] getThresholds() {
            return this.thresholds;
        }

        public IIpAddr getNodeIp() {
            return this.nodeIp;
        }
    }

    private static class Start
    extends NonCachedValue {
        private int pptId;
        private sPptParams params;

        public Start(NodeModelDelegate nodeModelDelegate, sPptParams sPptParams2, int n) {
            super(nodeModelDelegate);
            this.params = sPptParams2;
            this.pptId = n;
        }

        @Override
        protected Object getValue() {
            this.node.getIorRepository().getOchncCircuitsRef().startPpt(this.params, this.pptId);
            return null;
        }
    }
}

