/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.OpticsTopology.sSpanLossInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.ISideModels;
import cerent.cms.model.ISpanCheckModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.RamanModuleModel;
import cerent.cms.model.RamanOpticsLineModel;
import cerent.cms.model.RamanSpanCheckModel;
import cerent.cms.model.SpanCheckModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class SpanCheckModels
extends Model {
    private NodeModelDelegate nmd;
    private boolean inited = false;
    private static NodeSingletonFactory<SpanCheckModels> sfactory = new NodeSingletonFactory<SpanCheckModels>(SpanCheckModels.class);
    private HashMap<Integer, SpanCheckModel> objModels = new HashMap();
    private ArrayList<RamanSpanCheckModel> ramanObjModels = new ArrayList();
    private sSpanLossInfo[] spanLossList;
    private SpanLossInfo spanLossInfoRef;
    private EventDispatcher dispatcher;
    private RamanThread ramanThread = null;
    private boolean ramanThreadRunning = false;

    private SpanCheckModels(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.setDebug(nodeModelDelegate.getChildDebug(SpanCheckModels.class, SpanCheckModelsDebug.class, this));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.spanLossInfoRef = new SpanLossInfo(this.nmd, "SpanCheckModels::SpanLossInfo");
    }

    public static SpanCheckModels getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    @Override
    protected void updateLocal() {
        super.updateLocal();
    }

    public void delSpanCheckModel(int n) {
        Object object;
        if (this.objModels.containsKey(n)) {
            object = this.objModels.get(n);
            this.objModels.remove(n);
            ((SpanCheckModel)object).dispose();
        }
        object = this.ramanObjModels.iterator();
        RamanSpanCheckModel[] ramanSpanCheckModelArray = this.ramanObjModels.toArray(new RamanSpanCheckModel[0]);
        for (int i = 0; i < ramanSpanCheckModelArray.length; ++i) {
            int n2 = ramanSpanCheckModelArray[i].getSideId();
            if (n != n2) continue;
            this.ramanObjModels.remove(ramanSpanCheckModelArray[i]);
            this.ramanThreadRunning = false;
        }
    }

    private void delAllSpanCheckModel() {
        for (SpanCheckModel spanCheckModel : this.objModels.values()) {
            spanCheckModel.dispose();
        }
        this.objModels.clear();
        this.ramanObjModels.clear();
        this.ramanThreadRunning = false;
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        int n;
        if (this.db.on()) {
            this.db.println("Got update from " + observable + " arg=" + object);
        }
        if ((n = object instanceof IObjectMessageInfo ? ((IObjectMessageInfo)object).getUpdateType() : ((Integer)object).intValue()) == 1) {
            this.reloadModel();
            this.updateLocal();
            this.setChanged();
            if (this.db.on()) {
                this.db.println("notifyObservers CHANGED ");
            }
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    public void init() {
        super.init0();
        if (!this.inited) {
            this.dispatcher = this.nmd.getDispatcher();
            if (this.dispatcher != null) {
                this.dispatcher.addObserver(ObjectType.ObjectSpanCheckList, (Observer)this);
            }
            this.reloadModel();
            this.inited = true;
        }
    }

    public String[] getSpanLoss(int n) {
        return this.getSpanLossBySide(n);
    }

    private String[] getSpanLossBySide(int n) {
        if (this.objModels.containsKey(n)) {
            return this.objModels.get(n).getSpanLoss();
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.objModels != null && this.objModels.size() > 0) {
            this.delAllSpanCheckModel();
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSpanCheckList, (Observer)this);
        }
        this.inited = false;
        super.dispose();
    }

    @Override
    public void destroy() {
        int n;
        super.destroy();
        SpanCheckModel spanCheckModel = null;
        for (n = 0; n < this.objModels.size(); ++n) {
            spanCheckModel = this.objModels.get(n);
            spanCheckModel.destroy();
        }
        for (n = 0; n < this.ramanObjModels.size(); ++n) {
            RamanSpanCheckModel ramanSpanCheckModel = this.ramanObjModels.get(n);
            ramanSpanCheckModel.destroy();
        }
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public ISpanCheckModel[] getSpanCheckModel() {
        ISpanCheckModel[] iSpanCheckModelArray;
        if (this.ramanObjModels.size() > 0) {
            Collection<SpanCheckModel> collection = this.objModels.values();
            ArrayList<SpanCheckModel> arrayList = new ArrayList<SpanCheckModel>(collection);
            for (int i = 0; i < this.ramanObjModels.size(); ++i) {
                arrayList.add(this.ramanObjModels.get(i));
            }
            iSpanCheckModelArray = arrayList.toArray(new ISpanCheckModel[0]);
        } else if (this.objModels != null) {
            iSpanCheckModelArray = this.objModels.values().toArray(new ISpanCheckModel[0]);
            if (iSpanCheckModelArray.length == 2 && this.db.on()) {
                this.db.println("remove");
            }
        } else {
            return null;
        }
        return iSpanCheckModelArray;
    }

    private void addModel(sSpanLossInfo sSpanLossInfo2) {
        if (this.objModels != null) {
            SpanCheckModel spanCheckModel = new SpanCheckModel(this.nmd, sSpanLossInfo2);
            spanCheckModel.init();
            this.objModels.put(new Integer(sSpanLossInfo2.side), spanCheckModel);
        }
    }

    private void reloadModel() {
        this.spanLossList = this.getAllSpanLossInfo();
        for (int i = 0; i < this.spanLossList.length; ++i) {
            if (this.objModels.containsKey(new Integer(this.spanLossList[i].side))) continue;
            this.addModel(this.spanLossList[i]);
        }
        this.addRamanModel();
    }

    private void addRamanModel() {
        if (!this.ramanThreadRunning) {
            this.ramanThread = new RamanThread();
            this.ramanThread.start();
        }
    }

    private sSpanLossInfo[] getAllSpanLossInfo() {
        try {
            return (sSpanLossInfo[])this.spanLossInfoRef.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getAllSpanLossInfo", userException);
        }
    }

    public void ramanChanges() {
        this.reloadModel();
        this.updateLocal();
        this.setChanged();
        if (this.db.on()) {
            this.db.println("notifyObservers CHANGED ");
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    private class RamanThread
    implements Runnable {
        Thread thread = new Thread((Runnable)this, "RamanThread");

        public void start() {
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitResponse(long l) {
            RamanThread ramanThread = this;
            synchronized (ramanThread) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void run() {
            SpanCheckModels.this.ramanThreadRunning = true;
            this.waitResponse(10000L);
            SpanCheckModels.this.ramanObjModels.clear();
            ISideModels iSideModels = SpanCheckModels.this.nmd.getSideModels();
            if (iSideModels == null) {
                return;
            }
            ISideModel[] iSideModelArray = iSideModels.getSides();
            IEntityTableModel iEntityTableModel = SpanCheckModels.this.nmd.getEntityTable();
            for (int i = 0; i < iSideModelArray.length; ++i) {
                int n = iSideModelArray[i].getLineIn();
                try {
                    if (!(iEntityTableModel.getEntityModelByIndex(n).getParent() instanceof RamanModuleModel)) continue;
                    RamanModuleModel ramanModuleModel = (RamanModuleModel)iEntityTableModel.getEntityModelByIndex(n).getParent();
                    RamanSpanCheckModel ramanSpanCheckModel = new RamanSpanCheckModel(SpanCheckModels.this.nmd, null, iSideModelArray[i]);
                    Integer n2 = new Integer(SpanCheckModels.this.getIndex());
                    SpanCheckModels.this.ramanObjModels.add(ramanSpanCheckModel);
                    ramanSpanCheckModel.init((ISpanCheckModel)SpanCheckModels.this.objModels.get(iSideModelArray[i].getId()), false);
                    if (!RamanSpanCheckModel.hasFC((RamanOpticsLineModel)ramanModuleModel.getOpticsRamanLineModels(true)[0])) continue;
                    ramanSpanCheckModel = new RamanSpanCheckModel(SpanCheckModels.this.nmd, null, iSideModelArray[i]);
                    n2 = new Integer(SpanCheckModels.this.getIndex());
                    SpanCheckModels.this.ramanObjModels.add(ramanSpanCheckModel);
                    ramanSpanCheckModel.init((ISpanCheckModel)SpanCheckModels.this.objModels.get(iSideModelArray[i].getId()), true);
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    // empty catch block
                }
            }
            SpanCheckModels.this.ramanThreadRunning = false;
        }
    }

    public class SpanCheckModelsDebug
    extends SDebug {
        public SpanCheckModelsDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            SpanCheckModels.this.db.println("Span Check Model(s) :");
            if (SpanCheckModels.this.objModels != null) {
                HashMap hashMap = SpanCheckModels.this.objModels;
                synchronized (hashMap) {
                    for (SpanCheckModel spanCheckModel : SpanCheckModels.this.objModels.values()) {
                        SpanCheckModels.this.db.println("  Span Check Side " + spanCheckModel.getSide() + " - index " + spanCheckModel.getIndex() + " - Expected Span Loss " + spanCheckModel.getExpectedSpanLoss() + " - Misured Span Loss " + spanCheckModel.getMeasuredSpanLoss() + " - MIN Expected Span Loss " + spanCheckModel.getMinExpectedSpanLoss() + " - MAX Expected Span Loss " + spanCheckModel.getMaxExpectedSpanLoss());
                    }
                }
            }
            SpanCheckModels.this.db.println("Span Check Model(s) :");
            SpanCheckModels.this.db.println("");
        }
    }

    private class SpanLossInfo
    extends NonCachedValue {
        public SpanLossInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            if (SpanCheckModels.this.db.on) {
                SpanCheckModels.this.db.println(this.getClass() + "::getValue");
            }
            return this.node.getIorRepository().getDwdmOpticalSetupRef().getSpanLoss();
        }
    }
}

