/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetTopology.SonetFactory;
import cerent.cms.idl.SonetTopology.eTestAccessMode;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.TapModels;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;

public abstract class TapModel
extends Model {
    TapModels container;
    NodeModelDelegate node;
    short tapNumber;
    private EventDispatcher dispatcher;

    public TapModel(TapModels tapModels, NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        super(sDebug);
        this.container = tapModels;
        this.node = nodeModelDelegate;
        this.dispatcher = null;
    }

    public abstract short getTapNumber();

    public abstract eTestAccessMode getTapMode();

    public SonetFactory getSonetFactoryRef() {
        return this.node.getIorRepository().getSonetFactoryRef();
    }

    @Override
    public INodeModel getNodeModel() {
        return this.node;
    }

    @Override
    protected void updateLocal() {
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public void init() {
        super.init0();
        if (this.db.on) {
            this.db.println("Adding observer for " + this);
        }
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(this.getObjectType(), (int)this.getTapNumber(), (Observer)this);
        }
    }

    protected void delete() {
        this.container.delete(this);
        this.dispose();
    }

    @Override
    public void dispose() {
        if (this.db.on) {
            this.db.println("Dispose called ");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(this.getObjectType(), (int)this.getTapNumber(), (Observer)this);
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public TapModels getContainer() {
        return this.container;
    }

    public ObjectType getObjectType() {
        return ObjectType.ObjectTap;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + "::update():    this DELETED");
                    }
                    this.delete();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println("Connection Model update():    this CHANGED");
                    }
                    this.updateLocal();
                    break;
                }
                case 2: {
                    if (!this.db.on()) break;
                    this.db.println("TapModel update():    STRUCTURE CHANGED");
                    break;
                }
                default: {
                    if (!this.db.on()) break;
                    this.db.println("TapModel update():    UNKNOWN NE UPDATE TYPE" + n);
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof TapModel) {
            return this.getTapNumber() == ((TapModel)object).getTapNumber();
        }
        return false;
    }

    public int hashCode() {
        return this.tapNumber;
    }

    public abstract ITdmPortModel getPort() throws AbstractCmsNoSuchEntityException;
}

