/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.HoTapModels;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.LoTapModels;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.TapModel;
import cerent.cms.model.TapModels;
import cerent.cms.model.TdmPortModel;
import cerent.util.SDebug;

public class TapModelCollection
extends CmsObservable {
    HoTapModels hoTapModels;
    LoTapModels loTapModels;
    NodeModelDelegate node;
    private SDebug db;
    private static NodeSingletonFactory<TapModelCollection> sfactory = new NodeSingletonFactory<TapModelCollection>(TapModelCollection.class);

    public static TapModelCollection getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private TapModelCollection(NodeModelDelegate nodeModelDelegate) {
        this.node = nodeModelDelegate;
        this.db = nodeModelDelegate.getChildDebug(TapModelCollection.class);
        this.hoTapModels = new HoTapModels(this);
        this.loTapModels = new LoTapModels(this);
    }

    public void init() {
        if (this.db.on) {
            this.db.println("TapModelCollection init() entry");
        }
        this.hoTapModels.init();
        if (!this.node.getPlatform().suppressVtIface()) {
            this.loTapModels.init();
        }
        if (this.db.on) {
            this.db.println("TapModelCollection eint() exit");
        }
    }

    public NodeModelDelegate getNodeModel() {
        return this.node;
    }

    public HoTapModels getHoTapModels() {
        return this.hoTapModels;
    }

    public LoTapModels getLoTapModels() {
        return this.loTapModels;
    }

    public void dispose() {
        if (this.db.on) {
            this.db.println("TapModelCollection dispose entry");
        }
        this.loTapModels.dispose();
        this.hoTapModels.dispose();
        if (this.db.on) {
            this.db.println("TapModelCollection dispose exit");
        }
    }

    @Override
    public void destroy() {
        if (this.db.on) {
            this.db.println("TapModelCollection destroy entry");
        }
        this.loTapModels.destroy();
        this.hoTapModels.destroy();
    }

    public boolean hasTap(TdmPortModel tdmPortModel) {
        boolean bl = false;
        if (this.hasTap(this.hoTapModels, tdmPortModel)) {
            bl = true;
        } else if (this.hasTap(this.loTapModels, tdmPortModel)) {
            bl = true;
        }
        return bl;
    }

    private boolean hasTap(TapModels tapModels, TdmPortModel tdmPortModel) {
        boolean bl = false;
        TapModel[] tapModelArray = tapModels.getTapModels();
        for (int i = 0; i < tapModelArray.length; ++i) {
            TapModel tapModel = tapModelArray[i];
            try {
                ITdmPortModel iTdmPortModel = tapModel.getPort();
                if (iTdmPortModel == null || tdmPortModel == null || iTdmPortModel.getIndex() != tdmPortModel.getIndex()) continue;
                bl = true;
                break;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                bl = false;
            }
        }
        return bl;
    }
}

