/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.xInvalidRange;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.OSI.TarpConfig;
import cerent.cms.idl.OSI.eMatLevel;
import cerent.cms.idl.OSI.eTarpTimer;
import cerent.cms.idl.OSI.sMatEntry;
import cerent.cms.idl.OSI.sTarpConfig;
import cerent.cms.idl.OSI.sTarpRoute;
import cerent.cms.idl.OSI.xDuplicateMAT;
import cerent.cms.idl.OSI.xDuplicateTDC;
import cerent.cms.idl.OSI.xMaxMatEntries;
import cerent.cms.idl.OSI.xMaxOutstandingTarpRequests;
import cerent.cms.idl.OSI.xMaxTdcEntries;
import cerent.cms.idl.OSI.xNoSuchMatEntry;
import cerent.cms.idl.OSI.xNoSuchTdcEntry;
import cerent.cms.idl.OSI.xTarpRequestInitiated;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DuplicateMAT;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidRange;
import cerent.cms.model.MaxMAT;
import cerent.cms.model.MaxOutstandingTarpRequests;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchMatEntry;
import cerent.cms.model.NoSuchTdcEntry;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class TarpModel
extends Model {
    private NodeModelDelegate nodeModel;
    private TarpAdjacencyTable adjacencyTable;
    private TarpBody tarpBody;
    private TarpFU tarpFU;
    private L1Propagation l1propagation;
    private L2Propagation l2propagation;
    private Origination origination;
    private L1DataCache l1DataCache;
    private L2DataCache l2DataCache;
    private LDB lDB;
    private MAT1 mAT1;
    private MAT2 mAT2;
    private EnhancedMode enhancedMode;
    private Type4PDU type4PDU;
    private LDBEntryTimer lDBEntryTimer;
    private LDBFlushTimer lDBFlushTimer;
    private T1Timer t1Timer;
    private T2Timer t2Timer;
    private T3Timer t3Timer;
    private T4Timer t4Timer;
    private FlushTdc flushTdc;
    private AddTdcEntry addTdcEntry;
    private TarpDataCache dataCache;
    private RemTdcEntry remTdcEntry;
    private ResolveTid resolveTid;
    private AddMatEntry addMatEntry;
    private RemMatEntry remMatEntry;
    private EventDispatcher dispatcher;
    private static NodeSingletonFactory<TarpModel> sfactory = new NodeSingletonFactory<TarpModel>(TarpModel.class);

    public static TarpModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private TarpModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(TarpModel.class));
        this.nodeModel = nodeModelDelegate;
        this.tarpBody = new TarpBody(nodeModelDelegate, "TarpModel::tarpBody");
        this.tarpFU = new TarpFU(nodeModelDelegate);
        this.l1propagation = new L1Propagation(nodeModelDelegate);
        this.l2propagation = new L2Propagation(nodeModelDelegate);
        this.origination = new Origination(nodeModelDelegate);
        this.l1DataCache = new L1DataCache(nodeModelDelegate);
        this.l2DataCache = new L2DataCache(nodeModelDelegate);
        this.lDB = new LDB(nodeModelDelegate);
        this.mAT1 = new MAT1(nodeModelDelegate);
        this.mAT2 = new MAT2(nodeModelDelegate);
        this.enhancedMode = new EnhancedMode(nodeModelDelegate);
        this.type4PDU = new Type4PDU(nodeModelDelegate);
        this.lDBEntryTimer = new LDBEntryTimer(nodeModelDelegate);
        this.lDBFlushTimer = new LDBFlushTimer(nodeModelDelegate);
        this.t1Timer = new T1Timer(nodeModelDelegate);
        this.t2Timer = new T2Timer(nodeModelDelegate);
        this.t3Timer = new T3Timer(nodeModelDelegate);
        this.t4Timer = new T4Timer(nodeModelDelegate);
        this.dataCache = new TarpDataCache(nodeModelDelegate);
        this.adjacencyTable = new TarpAdjacencyTable(nodeModelDelegate, "TarpModel::adjacencyTable");
        this.addMatEntry = new AddMatEntry(nodeModelDelegate);
        this.remMatEntry = new RemMatEntry(nodeModelDelegate);
        this.flushTdc = new FlushTdc(nodeModelDelegate);
        this.addTdcEntry = new AddTdcEntry(nodeModelDelegate);
        this.remTdcEntry = new RemTdcEntry(nodeModelDelegate);
        this.resolveTid = new ResolveTid(nodeModelDelegate);
    }

    public void registerWithDefaults(NeDefaultsModel neDefaultsModel) {
        neDefaultsModel.addNonCachedValue(this.l1propagation);
        neDefaultsModel.addNonCachedValue(this.l2propagation);
        neDefaultsModel.addNonCachedValue(this.origination);
        neDefaultsModel.addNonCachedValue(this.l1DataCache);
        neDefaultsModel.addNonCachedValue(this.l2DataCache);
        neDefaultsModel.addNonCachedValue(this.lDB);
        neDefaultsModel.addNonCachedValue(this.mAT1);
        neDefaultsModel.addNonCachedValue(this.mAT2);
        neDefaultsModel.addNonCachedValue(this.enhancedMode);
        neDefaultsModel.addNonCachedValue(this.type4PDU);
        neDefaultsModel.addNonCachedValue(this.lDBEntryTimer);
        neDefaultsModel.addNonCachedValue(this.lDBFlushTimer);
        neDefaultsModel.addNonCachedValue(this.t1Timer);
        neDefaultsModel.addNonCachedValue(this.t2Timer);
        neDefaultsModel.addNonCachedValue(this.t3Timer);
        neDefaultsModel.addNonCachedValue(this.t4Timer);
    }

    @Override
    public INodeModel getNodeModel() {
        return this.getNodeModelDelegate();
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nodeModel;
    }

    private TarpConfig getTarpRef() {
        return this.nodeModel.getIorRepository().getTARPRef();
    }

    public void init() {
        super.init0();
        this.adjacencyTable.init();
        this.dispatcher = this.nodeModel.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectTarpConfig, 1, (Observer)this);
        }
    }

    public sTarpConfig getTarpBody() {
        try {
            return (sTarpConfig)this.tarpBody.get();
        }
        catch (UserException userException) {
            return null;
        }
    }

    public sMatEntry[] getTarpAdjacencyTable() {
        try {
            return (sMatEntry[])this.adjacencyTable.get();
        }
        catch (UserException userException) {
            return null;
        }
    }

    public void addMatEntry(int n, byte[] byArray) throws InternalCommError, MaxMAT, DuplicateMAT {
        this.addMatEntryEnum(eMatLevel.from_int(n), byArray);
    }

    public void addMatEntryEnum(eMatLevel eMatLevel2, byte[] byArray) throws InternalCommError, MaxMAT, DuplicateMAT {
        try {
            Object[] objectArray = new Object[]{eMatLevel2, byArray};
            this.addMatEntry.set(objectArray);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xMaxMatEntries xMaxMatEntries2) {
            throw new MaxMAT((UserException)xMaxMatEntries2);
        }
        catch (xDuplicateMAT xDuplicateMAT2) {
            throw new DuplicateMAT((UserException)xDuplicateMAT2);
        }
        catch (UserException userException) {
            // empty catch block
        }
    }

    public void remMatEntry(int n, byte[] byArray) throws InternalCommError, NoSuchMatEntry {
        this.remMatEntryEnum(eMatLevel.from_int(n), byArray);
    }

    public void remMatEntryEnum(eMatLevel eMatLevel2, byte[] byArray) throws InternalCommError, NoSuchMatEntry {
        try {
            Object[] objectArray = new Object[]{eMatLevel2, byArray};
            this.remMatEntry.set(objectArray);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xNoSuchMatEntry xNoSuchMatEntry2) {
            throw new NoSuchMatEntry((UserException)xNoSuchMatEntry2);
        }
        catch (UserException userException) {
            // empty catch block
        }
    }

    public sTarpRoute[] getTarpDataCache() {
        try {
            return (sTarpRoute[])this.dataCache.get();
        }
        catch (UserException userException) {
            return null;
        }
    }

    public void flushTdc() throws InternalCommError {
        try {
            this.flushTdc.set();
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            // empty catch block
        }
    }

    public void addTdcEntry(String string, byte[] byArray) throws InternalCommError, xMaxTdcEntries, xDuplicateTDC {
        try {
            Object[] objectArray = new Object[]{string, byArray};
            this.addTdcEntry.set(objectArray);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xMaxTdcEntries xMaxTdcEntries2) {
            throw xMaxTdcEntries2;
        }
        catch (xDuplicateTDC xDuplicateTDC2) {
            throw xDuplicateTDC2;
        }
        catch (UserException userException) {
            // empty catch block
        }
    }

    public void remTdcEntry(String string) throws NoSuchTdcEntry, InternalCommError {
        try {
            this.remTdcEntry.set(string);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xNoSuchTdcEntry xNoSuchTdcEntry2) {
            throw new NoSuchTdcEntry((UserException)xNoSuchTdcEntry2);
        }
        catch (UserException userException) {
            // empty catch block
        }
    }

    public boolean resolveTid(String string) throws InternalCommError, MaxOutstandingTarpRequests {
        try {
            this.resolveTid.set(string);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xMaxOutstandingTarpRequests xMaxOutstandingTarpRequests2) {
            throw new MaxOutstandingTarpRequests((UserException)xMaxOutstandingTarpRequests2);
        }
        catch (xTarpRequestInitiated xTarpRequestInitiated2) {
            return true;
        }
        catch (UserException userException) {
            // empty catch block
        }
        return false;
    }

    public void setTarpFU(short s) throws Exception {
        try {
            this.tarpFU.set(new Short(s));
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setType4PDU(short s) {
        try {
            this.type4PDU.set(new Short(s));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setLDBEntryTimer(short s) throws InvalidRange {
        try {
            this.lDBEntryTimer.set(new Short(s));
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (UserException userException) {
            // empty catch block
        }
    }

    public void setLDBFlushTimer(short s) throws InvalidRange {
        try {
            this.lDBFlushTimer.set(new Short(s));
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (UserException userException) {
            // empty catch block
        }
    }

    public void setT1Timer(int n) throws InvalidRange {
        try {
            this.t1Timer.set(new Short((short)n));
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (UserException userException) {
            // empty catch block
        }
    }

    public void setT2Timer(int n) throws InvalidRange {
        try {
            this.t2Timer.set(new Short((short)n));
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (UserException userException) {
            // empty catch block
        }
    }

    public void setT3Timer(int n) throws InvalidRange {
        try {
            this.t3Timer.set(new Short((short)n));
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (UserException userException) {
            // empty catch block
        }
    }

    public void setT4Timer(int n) throws InvalidRange {
        try {
            this.t4Timer.set(new Short((short)n));
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (UserException userException) {
            // empty catch block
        }
    }

    public short boolToFU(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        int n = 0 | (bl ? 1 : 0) | (bl2 ? 2 : 0) | (bl3 ? 4 : 0) | (bl4 ? 8 : 0) | (bl5 ? 16 : 0) | (bl6 ? 32 : 0) | (bl7 ? 64 : 0) | (bl8 ? 128 : 0) | (bl9 ? 256 : 0);
        this.db.fine("FU Combination: " + Integer.toBinaryString(n));
        return (short)n;
    }

    @Override
    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectTarpConfig, 1, (Observer)this);
        }
        this.adjacencyTable.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            switch (((ObjectMessageInfo)object).getUpdateType()) {
                case 1: {
                    this.adjacencyTable.update();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
            }
        }
    }

    class AddMatEntry
    extends NonCachedValue {
        public AddMatEntry(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected void setValue(Object object) throws UserException, xInternalCommError, xMaxMatEntries {
            Object[] objectArray = (Object[])object;
            TarpModel.this.getTarpRef().addMatEntry((eMatLevel)objectArray[0], (byte[])objectArray[1]);
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class AddTdcEntry
    extends NonCachedValue {
        public AddTdcEntry(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected void setValue(Object object) throws UserException, xInternalCommError, xMaxTdcEntries {
            Object[] objectArray = (Object[])object;
            TarpModel.this.getTarpRef().addTdcEntry((String)objectArray[0], (byte[])objectArray[1]);
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class EnhancedMode
    extends TarpFUMediator {
        public EnhancedMode(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, (short)256);
        }
    }

    class FlushTdc
    extends NonCachedValue {
        public FlushTdc(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected void setValue() throws UserException, xInternalCommError {
            TarpModel.this.getTarpRef().flushTdc();
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class L1DataCache
    extends TarpFUMediator {
        public L1DataCache(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, (short)8);
        }
    }

    class L1Propagation
    extends TarpFUMediator {
        public L1Propagation(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, (short)1);
        }
    }

    class L2DataCache
    extends TarpFUMediator {
        public L2DataCache(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, (short)16);
        }
    }

    class L2Propagation
    extends TarpFUMediator {
        public L2Propagation(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, (short)2);
        }
    }

    class LDB
    extends TarpFUMediator {
        public LDB(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, (short)32);
        }
    }

    class LDBEntryTimer
    extends NonCachedValue {
        public LDBEntryTimer(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            TarpModel.this.getTarpRef().setLdbEntryTimer((Short)object);
        }

        @Override
        protected Object getValue() throws UserException {
            Short s = null;
            sTarpConfig sTarpConfig2 = (sTarpConfig)TarpModel.this.tarpBody.get();
            if (sTarpConfig2 != null) {
                s = new Short(sTarpConfig2.ldbEntryTimer);
            }
            return s;
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class LDBFlushTimer
    extends NonCachedValue {
        public LDBFlushTimer(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            TarpModel.this.getTarpRef().setLdbFlushTimer((Short)object);
        }

        @Override
        protected Object getValue() throws UserException {
            Short s = null;
            sTarpConfig sTarpConfig2 = (sTarpConfig)TarpModel.this.tarpBody.get();
            if (sTarpConfig2 != null) {
                s = new Short(sTarpConfig2.ldbFlushTimer);
            }
            return s;
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class MAT1
    extends TarpFUMediator {
        public MAT1(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, (short)64);
        }
    }

    class MAT2
    extends TarpFUMediator {
        public MAT2(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, (short)128);
        }
    }

    class Origination
    extends TarpFUMediator {
        public Origination(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, (short)4);
        }
    }

    class RemMatEntry
    extends NonCachedValue {
        public RemMatEntry(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected void setValue(Object object) throws UserException, xInternalCommError, xNoSuchMatEntry {
            Object[] objectArray = (Object[])object;
            TarpModel.this.getTarpRef().remMatEntry((eMatLevel)objectArray[0], (byte[])objectArray[1]);
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class RemTdcEntry
    extends NonCachedValue {
        public RemTdcEntry(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected void setValue(Object object) throws UserException, xNoSuchTdcEntry, xInternalCommError {
            TarpModel.this.getTarpRef().remTdcEntry((String)object);
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class ResolveTid
    extends NonCachedValue {
        public ResolveTid(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected void setValue(Object object) throws UserException, xInternalCommError, xTarpRequestInitiated, xMaxOutstandingTarpRequests {
            TarpModel.this.getTarpRef().resolveTid((String)object);
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class T1Timer
    extends NonCachedValue {
        public T1Timer(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            TarpModel.this.getTarpRef().setTarpTimer(eTarpTimer.TARP_T1, (Short)object);
        }

        @Override
        protected Object getValue() throws UserException {
            Short s = null;
            sTarpConfig sTarpConfig2 = (sTarpConfig)TarpModel.this.tarpBody.get();
            if (sTarpConfig2 != null) {
                s = new Short(sTarpConfig2.timers[0]);
            }
            return s;
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class T2Timer
    extends NonCachedValue {
        public T2Timer(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            TarpModel.this.getTarpRef().setTarpTimer(eTarpTimer.TARP_T2, (Short)object);
        }

        @Override
        protected Object getValue() throws UserException {
            Short s = null;
            sTarpConfig sTarpConfig2 = (sTarpConfig)TarpModel.this.tarpBody.get();
            if (sTarpConfig2 != null) {
                s = new Short(sTarpConfig2.timers[1]);
            }
            return s;
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class T3Timer
    extends NonCachedValue {
        public T3Timer(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            TarpModel.this.getTarpRef().setTarpTimer(eTarpTimer.TARP_T3, (Short)object);
        }

        @Override
        protected Object getValue() throws UserException {
            Short s = null;
            sTarpConfig sTarpConfig2 = (sTarpConfig)TarpModel.this.tarpBody.get();
            if (sTarpConfig2 != null) {
                s = new Short(sTarpConfig2.timers[2]);
            }
            return s;
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class T4Timer
    extends NonCachedValue {
        public T4Timer(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            TarpModel.this.getTarpRef().setTarpTimer(eTarpTimer.TARP_T4, (Short)object);
        }

        @Override
        protected Object getValue() throws UserException {
            Short s = null;
            sTarpConfig sTarpConfig2 = (sTarpConfig)TarpModel.this.tarpBody.get();
            if (sTarpConfig2 != null) {
                s = new Short(sTarpConfig2.timers[3]);
            }
            return s;
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class TarpAdjacencyTable
    extends CachedValue {
        public TarpAdjacencyTable(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return TarpModel.this.getTarpRef().getManualAdjacencyTable();
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class TarpBody
    extends NonCachedValue {
        public TarpBody(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return TarpModel.this.getTarpRef().getConfig();
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class TarpDataCache
    extends NonCachedValue {
        public TarpDataCache(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected Object getValue() throws UserException {
            return TarpModel.this.getTarpRef().getTarpDataCache();
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class TarpFU
    extends NonCachedValue {
        public TarpFU(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            short s = (Short)object;
            TarpModel.this.getTarpRef().setTarpFu(s);
        }

        @Override
        protected Object getValue() throws UserException {
            Short s = null;
            sTarpConfig sTarpConfig2 = (sTarpConfig)TarpModel.this.tarpBody.get();
            if (sTarpConfig2 != null) {
                s = new Short(sTarpConfig2.tarpFu);
            }
            return s;
        }

        public Object outer() {
            return TarpModel.this;
        }
    }

    class TarpFUMediator
    extends TarpFU {
        short bitMask;

        public TarpFUMediator(NodeModelDelegate nodeModelDelegate, short s) {
            super(nodeModelDelegate);
            this.bitMask = s;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Boolean bl = (Boolean)object;
            Short s = (Short)super.getValue();
            if (s != null) {
                short s2 = s;
                s2 = bl != false ? (short)(s2 | this.bitMask) : (short)(s2 & ~this.bitMask);
                super.setValue(new Short(s2));
            }
        }

        @Override
        protected Object getValue() throws UserException {
            Short s = (Short)super.getValue();
            if (s != null) {
                return new Boolean((s & this.bitMask) == this.bitMask);
            }
            return null;
        }
    }

    class Type4PDU
    extends NonCachedValue {
        public Type4PDU(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            TarpModel.this.getTarpRef().setType4PduOnStartup((Short)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Short(TarpModel.this.getTarpRef().getType4PduOnStartup());
        }

        public Object outer() {
            return TarpModel.this;
        }
    }
}

