/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sIpTunnel;
import cerent.cms.idl.Node.eNodeUpdate;
import cerent.cms.idl.Node.xMaxTunnels;
import cerent.cms.idl.Node.xTunnelExists;
import cerent.cms.model.CachedValue;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class TunnelsModel
extends Model {
    private NodeModelDelegate _node;
    protected CachedValue _getTunnels;
    protected NonCachedValue _addTunnel;
    protected NonCachedValue _deleteTunnel;
    private eNodeUpdate _updateType;
    private EventDispatcher _dispatcher;

    protected TunnelsModel(NodeModelDelegate nodeModelDelegate, SDebug sDebug, eNodeUpdate eNodeUpdate2) {
        super(sDebug);
        this.index = 0;
        this._node = nodeModelDelegate;
        this._updateType = eNodeUpdate2;
        this._dispatcher = null;
    }

    @Override
    public INodeModel getNodeModel() {
        return this._node;
    }

    private NodeModelDelegate getNode() {
        return this._node;
    }

    public void init() {
        if (this._dispatcher == null) {
            this._dispatcher = this.getNode().getDispatcher();
        }
        if (this._dispatcher != null) {
            this._dispatcher.addObserver(ObjectType.ObjectSystem, this._updateType.value(), (Observer)this);
        }
        this._getTunnels.init();
        super.init0();
    }

    @Override
    protected void updateLocal() {
        this._getTunnels.update();
        this.setChanged();
        super.updateLocal();
    }

    @Override
    public void update(Observable observable, Object object) {
        IObjectMessageInfo iObjectMessageInfo = (IObjectMessageInfo)object;
        switch (iObjectMessageInfo.getUpdateType()) {
            case 0: 
            case 1: 
            case 2: {
                this.updateLocal();
                break;
            }
        }
    }

    @Override
    public void dispose() {
        if (this._dispatcher != null) {
            this._dispatcher.deleteObserver(ObjectType.ObjectSystem, this._updateType.value(), (Observer)this);
            this._dispatcher = null;
        }
        this._getTunnels.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public sIpTunnel[] getTunnels() {
        try {
            return (sIpTunnel[])this._getTunnels.get();
        }
        catch (UserException userException) {
            this.getNode();
            throw NodeModelDelegate.doUnknown(this.db, "getTunnels", userException);
        }
    }

    public void addTunnel(sIpTunnel sIpTunnel2) throws xTunnelExists, xMaxTunnels {
        try {
            this._addTunnel.set(sIpTunnel2);
            this._getTunnels.update();
        }
        catch (xTunnelExists xTunnelExists2) {
            throw xTunnelExists2;
        }
        catch (xMaxTunnels xMaxTunnels2) {
            throw xMaxTunnels2;
        }
        catch (UserException userException) {
            this.getNode();
            throw NodeModelDelegate.doUnknown(this.db, "addTunnels", userException);
        }
    }

    public void deleteTunnel(sIpTunnel sIpTunnel2) {
        try {
            this._deleteTunnel.set(sIpTunnel2);
            this._getTunnels.update();
        }
        catch (UserException userException) {
            this.getNode();
            throw NodeModelDelegate.doUnknown(this.db, "deleteTunnels", userException);
        }
    }
}

