/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Epos.eBridgePortState;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.EtherL2Media.EtherEOAM;
import cerent.cms.idl.EtherL2Media.General;
import cerent.cms.idl.EtherL2Media.dscp2Cos;
import cerent.cms.idl.EtherL2Media.dscp2CosInfo;
import cerent.cms.idl.EtherL2Media.eAISActionType;
import cerent.cms.idl.EtherL2Media.eEfmLoopback;
import cerent.cms.idl.EtherL2Media.eEfmState;
import cerent.cms.idl.EtherL2Media.eMRouter;
import cerent.cms.idl.EtherL2Media.eNiValue;
import cerent.cms.idl.EtherL2Media.eProtActionType;
import cerent.cms.idl.EtherL2Media.eQinQMode;
import cerent.cms.idl.EtherL2Media.eRepVlbOperation;
import cerent.cms.idl.EtherL2Media.sBasicL2Info;
import cerent.cms.idl.EtherL2Media.sEfmInfo;
import cerent.cms.idl.EtherL2Media.sEfmLinkMonitor;
import cerent.cms.idl.EtherL2Media.sEfmLinkMonitorInfo;
import cerent.cms.idl.EtherL2Media.sEgressInfo;
import cerent.cms.idl.EtherL2Media.sMEP;
import cerent.cms.idl.EtherL2Media.sMIP;
import cerent.cms.idl.EtherL2Media.sMacInfo;
import cerent.cms.idl.EtherL2Media.sQinQInfo;
import cerent.cms.idl.EtherL2Media.sRepPortConfig;
import cerent.cms.idl.EtherL2Media.sRepStcnConfig;
import cerent.cms.idl.EtherL2Media.sRepVlbConfig;
import cerent.cms.idl.EtherL2Media.sStormControlConfig;
import cerent.cms.idl.EtherL2Media.sStormControlInfo;
import cerent.cms.idl.EtherL2Media.sVlanCrossInfoData;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.IXPLLayer2LineModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.MEPInfo;
import cerent.cms.model.MEPInfoFactory;
import cerent.cms.model.MIPInfo;
import cerent.cms.model.MIPInfoFactory;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.QinQSettings;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.util.SDebug;
import java.util.ArrayList;
import org.omg.CORBA.UserException;

public class XPL2Layer2LineModel
extends EtherLineModel
implements IXPLLayer2LineModel {
    public static final short DSCP_IN_COS = 10;
    public static final short DSCP_MAX_VALUE = 64;
    private EgressQOS egressQOS;
    private StormControl stormControl;
    private EgressQOSInfo egressQOSInfoTable;
    private MacAddrInfo macAddrInfoTable;
    private BridgePortState bridgePortState;
    private ActualBridgePortState actualBridgePortState;
    private EtherBasicL2Info etherBasicL2Info;
    private QinQInfo qInQInfo;
    private VlanCrossInfoList vlanCrossInfoList;
    private VlanListOnNNIPort vlanListOnNNIPort;
    private IgmpMrouter igmpMrouter;
    private AisAction aisAction;
    private ProtectionAction protAction;
    private Bpdu bpdu;
    private EfmConfig efmConfig;
    private EfmLMConfig efmLMConfig;
    private EfmState efmState;
    private EfmLoopback efmLoopback;
    private DscpCosInfo dscpCosInfo;
    private TriggerVLB triggerVLB;
    private REPPortConfig repConfig;
    private REPStcnConfig repStcnConfig;
    private REPVlbConfig repVlbConfig;
    private REPPreemptDelay repPDelay;
    private CFMStat cfmStat;
    private MIPConfig mipConfig;
    private MEPConfig mepConfig;
    private ClearCrcAlarm clearCrcAlarm;

    public XPL2Layer2LineModel(NodeModelDelegate nodeModelDelegate, int n) {
        super(nodeModelDelegate, n);
        this.index = n;
        this.etherBasicL2Info = new EtherBasicL2Info(nodeModelDelegate, "XPL2Layer2LineModel.EtherBasicL2Info");
        this.qInQInfo = new QinQInfo(nodeModelDelegate, "XPL2Layer2LineModel.QinQInfo");
        this.vlanCrossInfoList = new VlanCrossInfoList(nodeModelDelegate, "XPL2Layer2LineModel.VlanCrossInfoList");
        this.egressQOS = new EgressQOS(nodeModelDelegate, "EXPL2Layer2LineModel.EgressQOS");
        this.egressQOSInfoTable = new EgressQOSInfo(nodeModelDelegate, "EXPL2Layer2LineModel.EgressQOS");
        this.macAddrInfoTable = new MacAddrInfo(nodeModelDelegate, "EXPL2Layer2LineModel.MacAddrInfo");
        this.bridgePortState = new BridgePortState(nodeModelDelegate, "XPL2Layer2LineModel.BridgePortState");
        this.actualBridgePortState = new ActualBridgePortState(nodeModelDelegate, "XPL2Layer2LineModel.ActualBridgePortState");
        this.vlanListOnNNIPort = new VlanListOnNNIPort(nodeModelDelegate, "XPL2Layer2LineModel.VlanListOnNNIPort");
        this.bpdu = new Bpdu(nodeModelDelegate, "XPL2Layer2LineModel.Bpdu");
        this.igmpMrouter = new IgmpMrouter(nodeModelDelegate, "XPL2Layer2LineModel.IgmpMrouter");
        this.aisAction = new AisAction(nodeModelDelegate, "XPL2Layer2LineModel.AisAction");
        this.protAction = new ProtectionAction(nodeModelDelegate, "XPL2Layer2LineModel.ProtectionAction");
        this.efmConfig = new EfmConfig(nodeModelDelegate, "XPL2Layer2LineModel.EfmConfig");
        this.efmLMConfig = new EfmLMConfig(nodeModelDelegate, "XPL2Layer2LineModel.EfmLMConfig");
        this.efmState = new EfmState(nodeModelDelegate, "XPL2Layer2LineModel.EfmState");
        this.efmLoopback = new EfmLoopback(nodeModelDelegate, "XPL2Layer2LimeModel.EfmLoopback");
        this.dscpCosInfo = new DscpCosInfo(nodeModelDelegate, "XPL2Layer2LineModel.DscpCosInfo");
        this.triggerVLB = new TriggerVLB(nodeModelDelegate, "XPL2Layer2LineModel.TriggerVLB");
        this.repConfig = new REPPortConfig(nodeModelDelegate, "XPL2Layer2LineModel.REPPortConfig");
        this.repStcnConfig = new REPStcnConfig(nodeModelDelegate, "XPL2Layer2LineModel.REPStcnConfig");
        this.repVlbConfig = new REPVlbConfig(nodeModelDelegate, "XPL2Layer2LineModel.REPVlbConfig");
        this.repPDelay = new REPPreemptDelay(nodeModelDelegate, "XPL2Layer2LineModel.REPPreemptDelay");
        this.cfmStat = new CFMStat(nodeModelDelegate, "XPL2Layer2LineModel.CFMStatus");
        this.mipConfig = new MIPConfig(nodeModelDelegate, "XPL2Layer2LineModel.MIPConfig");
        this.mepConfig = new MEPConfig(nodeModelDelegate, "XPL2Layer2LineModel.MEPConfig");
        this.stormControl = new StormControl(nodeModelDelegate, "XPL2Layer2LineModel.StromControl");
        this.clearCrcAlarm = new ClearCrcAlarm(nodeModelDelegate, "XPL2Layer2LineModel.clearCrcAlarm");
    }

    public sBasicL2Info getEtherBasicL2Info() throws NoSuchInterface, InvalidOperation {
        if (this.db.on()) {
            this.db.println("XPL2LineModel::getEtherBasicL2Info");
        }
        try {
            return (sBasicL2Info)this.etherBasicL2Info.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getEtherBasicL2Info", userException);
        }
    }

    public void setEtherBasicL2Info(sBasicL2Info sBasicL2Info2) throws NoSuchInterface, InvalidOperation, EMCProvisionError, WrongInterfaceType {
        if (this.db.on()) {
            this.db.println("XPL2LineModel.getEtherBasicL2Info");
        }
        try {
            this.etherBasicL2Info.set(sBasicL2Info2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setEtherBasicL2Info", userException);
        }
    }

    public sStormControlInfo getStromControlInfo() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sStormControlInfo)this.stormControl.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getStromControlInfo", userException);
        }
    }

    public void setStormControlInfo(sStormControlInfo sStormControlInfo2) throws NoSuchInterface, EMCProvisionError, WrongInterfaceType {
        try {
            this.stormControl.set(sStormControlInfo2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setStormControlInfo", userException);
        }
    }

    public short[] getVlanList() throws NoSuchInterface, WrongInterfaceType {
        try {
            return this.getEtherL2Ref().getVlanListOnNNIPort(this.index);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
    }

    public void setVlanList(short[] sArray) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        try {
            this.getEtherL2Ref().setSvlanListOnNNIPort(this.index, sArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
    }

    public void setVlanList(int[] nArray) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        short[] sArray = new short[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            sArray[i] = (short)nArray[i];
        }
        this.setVlanList(sArray);
    }

    public eBridgePortState getActualBridgePortState() throws NoSuchInterface, WrongInterfaceType, AbstractCmsNoSuchEntityException {
        if (this.getModuleModel().getState() == eEqState.NOT_PRESENT) {
            return eBridgePortState.PORT_STATE_UNKNOWN;
        }
        try {
            return (eBridgePortState)this.actualBridgePortState.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getActualBridgePortState", userException);
        }
    }

    public eBridgePortState getBridgePortState() throws NoSuchInterface, WrongInterfaceType, AbstractCmsNoSuchEntityException {
        try {
            return (eBridgePortState)this.bridgePortState.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getBridgePortState", userException);
        }
    }

    public eMRouter getIgmpMrouter() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eMRouter)this.igmpMrouter.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getIgmpMrouter", userException);
        }
    }

    public void setIgmpMrouter(eMRouter eMRouter2) throws NoSuchInterface, WrongInterfaceType {
        try {
            this.igmpMrouter.set(eMRouter2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setIgmpMrouter", userException);
        }
    }

    public eAISActionType getAisAction() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eAISActionType)this.aisAction.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAisAction", userException);
        }
    }

    public void setAisAction(eAISActionType eAISActionType2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.aisAction.set(eAISActionType2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setAisAction", userException);
        }
    }

    public eProtActionType getProtAction() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eProtActionType)this.protAction.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getProtAction", userException);
        }
    }

    public void setProtAction(eProtActionType eProtActionType2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.protAction.set(eProtActionType2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setProtAction", userException);
        }
    }

    public void setBridgePortState(eBridgePortState eBridgePortState2) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        try {
            this.bridgePortState.set(eBridgePortState2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setBridgePortState", userException);
        }
    }

    public sEgressInfo getEgressInfo() throws NoSuchInterface, InvalidOperation {
        if (this.db.on()) {
            this.db.println("XPL2LineModel::getEgressInfo");
        }
        try {
            return (sEgressInfo)this.egressQOSInfoTable.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getEgressInfo", userException);
        }
    }

    public void setEgressInfo(sEgressInfo sEgressInfo2) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        if (this.db.on()) {
            this.db.println("XPL2LineModel::setEgressInfo");
        }
        try {
            this.egressQOSInfoTable.set(sEgressInfo2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setEgressInfo", userException);
        }
    }

    public Boolean getEgressQOS() throws NoSuchInterface, InvalidOperation, WrongInterfaceType {
        try {
            return (Boolean)this.egressQOS.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getEgressQOS", userException);
        }
    }

    public void setEgressQOS(Boolean bl) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        try {
            this.egressQOS.set(bl);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setEgressQOS", userException);
        }
    }

    public sMacInfo getMacInfoFromModel() throws NoSuchInterface, WrongInterfaceType {
        if (this.db.on()) {
            this.db.println("XPL2LineModel::getMacInfoFromModel");
        }
        try {
            return (sMacInfo)this.macAddrInfoTable.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getMacInfoFromModel", userException);
        }
    }

    public void setMacInfoFromModel(sMacInfo sMacInfo2) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        if (this.db.on()) {
            this.db.println("XPL2LineModel::setMacInfoFromModel");
        }
        try {
            this.macAddrInfoTable.set(sMacInfo2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setMacInfoFromModel", userException);
        }
    }

    protected General getEtherL2Ref() {
        return this.getNodeModelDelegate().getIorRepository().getEtherL2Ref();
    }

    protected EtherEOAM getEtherEOAMRef() {
        return this.getNodeModelDelegate().getIorRepository().getEtherEOAMRef();
    }

    public sQinQInfo getQinQInfo() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sQinQInfo)this.qInQInfo.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getQinQInfo", userException);
        }
    }

    public void setQinQInfo(sQinQInfo sQinQInfo2) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        try {
            this.qInQInfo.set(sQinQInfo2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setQinQInfo", userException);
        }
    }

    public void setQinQInfoFromNet(QinQSettings qinQSettings) throws ProvisionError, NoSuchInterface, WrongInterfaceType, InvalidOperation, InvalidData {
        dscp2Cos[] dscp2CosArray;
        this.setBpdu(new Boolean(qinQSettings.getQinQBPDU()));
        sQinQInfo sQinQInfo2 = this.getQinQInfo();
        if (qinQSettings.getQinQMode() == 1) {
            sQinQInfo2.qinqMode = eQinQMode.TRASPARENT_MODE;
            sQinQInfo2.trasparentSvlanId = qinQSettings.getSvlan();
            this.setQinQInfo(sQinQInfo2);
        } else {
            sQinQInfo2.qinqMode = eQinQMode.SELECTIVE_MODE;
            sQinQInfo2.trasparentSvlanId = qinQSettings.getSvlan();
            this.setQinQInfo(sQinQInfo2);
            dscp2CosArray = (dscp2Cos[])qinQSettings.getQinQTable();
            this.setVlanCrossInfoList(dscp2CosArray.getVlanCrossInfoList());
            try {
                if (((XPL2ModuleModel)this.getModuleModel()).getMvrInfo().igmpEnabledOnCvlan) {
                    sQinQInfo2.igmpCvlan = dscp2CosArray.getIgmpCvlan();
                    this.setQinQInfo(sQinQInfo2);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (this.getEtherBasicL2Info().sIngressCOS == 10) {
            dscp2CosArray = new dscp2Cos[64];
            for (int i = 0; i < 64; ++i) {
                dscp2CosArray[i] = new dscp2Cos(qinQSettings.getDscpMapTable()[i][0], qinQSettings.getDscpMapTable()[i][1]);
            }
            this.setDscp2CosInfo(new dscp2CosInfo(dscp2CosArray));
        }
    }

    public sVlanCrossInfoData[] getVlanCrossInfoList() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sVlanCrossInfoData[])this.vlanCrossInfoList.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getVlanCrossInfoList", userException);
        }
    }

    public void setVlanCrossInfoList(sVlanCrossInfoData[] sVlanCrossInfoDataArray) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        try {
            this.vlanCrossInfoList.set(sVlanCrossInfoDataArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setVlanCrossInfoList", userException);
        }
    }

    public short[] getVlanListOnNNIPort() throws NoSuchInterface, InvalidOperation {
        try {
            return (short[])this.vlanListOnNNIPort.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getVlanListOnNNIPort", userException);
        }
    }

    public void setBpdu(Boolean bl) throws InvalidOperation, InvalidData, NoSuchInterface {
        try {
            this.bpdu.set(bl);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setBpdu", userException);
        }
    }

    public Boolean getBpdu() throws InvalidOperation, NoSuchInterface {
        try {
            return (Boolean)this.bpdu.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getBpdu", userException);
        }
    }

    public void setClearCrcAlarm(Boolean bl) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        try {
            this.clearCrcAlarm.set(bl);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setClearCrcAlarm", userException);
        }
    }

    public Boolean getClearCrcAlarm() throws NoSuchInterface, WrongInterfaceType, AbstractCmsNoSuchEntityException {
        try {
            return (Boolean)this.clearCrcAlarm.get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getClearCrcAlarm", userException);
        }
    }

    public eEfmState getEfmState() throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            return (eEfmState)this.efmState.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getMvrInfo", userException);
        }
    }

    public sEfmInfo getEfmConfig() throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            return (sEfmInfo)this.efmConfig.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getMvrInfo", userException);
        }
    }

    public void setEfmConfig(sEfmInfo sEfmInfo2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.efmConfig.set(sEfmInfo2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setMvrInfo", userException);
        }
    }

    public sEfmLinkMonitorInfo getEfmLMConfig() throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            return (sEfmLinkMonitorInfo)this.efmLMConfig.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getMvrInfo", userException);
        }
    }

    public void setEfmLMConfig(sEfmLinkMonitorInfo sEfmLinkMonitorInfo2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.efmLMConfig.set(sEfmLinkMonitorInfo2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setMvrInfo", userException);
        }
    }

    public eEfmLoopback getEfmLoopback() throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            return (eEfmLoopback)this.efmLoopback.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getMvrInfo", userException);
        }
    }

    public void setEfmLoopback(eEfmLoopback eEfmLoopback2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.efmLoopback.set(eEfmLoopback2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setMvrInfo", userException);
        }
    }

    public dscp2CosInfo getDscp2CosInfo() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (dscp2CosInfo)this.dscpCosInfo.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getDscp2CosInfo", userException);
        }
    }

    public void setDscp2CosInfo(dscp2CosInfo dscp2CosInfo2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.dscpCosInfo.set(dscp2CosInfo2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setDscp2CosInfo", userException);
        }
    }

    public void triggerVLB(eRepVlbOperation eRepVlbOperation2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.triggerVLB.set(eRepVlbOperation2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("triggerVLB", userException);
        }
    }

    public void setRepPortConfig(sRepPortConfig sRepPortConfig2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.repConfig.setValue(sRepPortConfig2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setRepPortConfig", userException);
        }
    }

    public void removeRepPortConfig() throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.repConfig.setValue();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("removeRepPortConfig", userException);
        }
    }

    public sRepPortConfig getRepPortConfig() throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            return (sRepPortConfig)this.repConfig.getValue();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getRepPortConfig", userException);
        }
    }

    public sRepStcnConfig getRepStcnConfig() throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            return (sRepStcnConfig)this.repStcnConfig.getValue();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getRepStcnConfig", userException);
        }
    }

    public void setRepStcnConfig(sRepStcnConfig sRepStcnConfig2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.repStcnConfig.setValue(sRepStcnConfig2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setRepStcnConfig", userException);
        }
    }

    public sRepVlbConfig getRepVlbConfig() throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            return (sRepVlbConfig)this.repVlbConfig.getValue();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getRepVlbConfig", userException);
        }
    }

    public void setRepVlbConfig(sRepVlbConfig sRepVlbConfig2) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.repVlbConfig.setValue(sRepVlbConfig2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setRepVlbConfig", userException);
        }
    }

    public int getRepVlbPreemptDelay() throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            return (Integer)this.repPDelay.getValue();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getRepVlbPreemptDelay", userException);
        }
    }

    public void setRepVlbPreemptDelay(int n) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.repPDelay.setValue(new Integer(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setRepVlbPreemptDelay", userException);
        }
    }

    public void setCFMStatus(Boolean bl) throws NoSuchInterface, WrongInterfaceType, EMCProvisionError {
        if (this.db.on()) {
            this.db.println("XPL2Layer2LineModel::setCFMStatus");
        }
        try {
            this.cfmStat.set(bl);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setCFMStatus", userException);
        }
    }

    public boolean getCFMStatus() throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        if (this.db.on()) {
            this.db.println("XPL2Layer2LineModel::getCFMStatus");
        }
        try {
            return (Boolean)this.cfmStat.get();
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getCFMStatus", userException);
        }
    }

    public void createMIP(MIPInfo mIPInfo) throws EMCProvisionError {
        try {
            sMIP sMIP2 = MIPInfoFactory.getMIPFromMIPModel(mIPInfo);
            Object[] objectArray = new Object[]{new String("createMIP"), sMIP2};
            this.mipConfig.set(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("createMIP", userException);
        }
    }

    public void createMIP(sMIP sMIP2) throws EMCProvisionError {
        try {
            Object[] objectArray = new Object[]{new String("createMIP"), sMIP2};
            this.mipConfig.set(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("createMIP", userException);
        }
    }

    public void removeMIP(MIPInfo mIPInfo) throws EMCProvisionError {
        try {
            sMIP sMIP2 = MIPInfoFactory.getMIPFromMIPModel(mIPInfo);
            Object[] objectArray = new Object[]{new String("removeMIP"), sMIP2};
            this.mipConfig.set(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("removeMIP", userException);
        }
    }

    public void clearMIP(sMIP sMIP2) throws EMCProvisionError {
        try {
            Object[] objectArray = new Object[]{new String("removeMIP"), sMIP2};
            this.mipConfig.set(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("removeMIP", userException);
        }
    }

    public void modifyMIP(MIPInfo mIPInfo) throws EMCProvisionError {
        try {
            sMIP sMIP2 = MIPInfoFactory.getMIPFromMIPModel(mIPInfo);
            Object[] objectArray = new Object[]{new String("modifyMIP"), sMIP2};
            this.mipConfig.set(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("modifyMIP", userException);
        }
    }

    public void changeMIP(sMIP sMIP2) throws EMCProvisionError {
        try {
            Object[] objectArray = new Object[]{new String("modifyMIP"), sMIP2};
            this.mipConfig.set(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("modifyMIP", userException);
        }
    }

    public void createMEP(MEPInfo mEPInfo) throws EMCProvisionError {
        try {
            sMEP sMEP2 = MEPInfoFactory.getMEPFromMEPModel(mEPInfo);
            Object[] objectArray = new Object[]{new String("createMEP"), sMEP2};
            this.mepConfig.set(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("createMEP", userException);
        }
    }

    public void createMEP(sMEP sMEP2) throws EMCProvisionError {
        try {
            Object[] objectArray = new Object[]{new String("createMEP"), sMEP2};
            this.mepConfig.set(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("createMEP", userException);
        }
    }

    public void removeMEP(MEPInfo mEPInfo) throws EMCProvisionError {
        try {
            sMEP sMEP2 = MEPInfoFactory.getMEPFromMEPModel(mEPInfo);
            Object[] objectArray = new Object[]{new String("removeMEP"), sMEP2};
            this.mepConfig.set(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("removeMEP", userException);
        }
    }

    public void clearMEP(sMEP sMEP2) throws EMCProvisionError {
        try {
            Object[] objectArray = new Object[]{new String("removeMEP"), sMEP2};
            this.mepConfig.set(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("removeMEP", userException);
        }
    }

    public sMEP[] getMEPSForPort() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sMEP[])this.mepConfig.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getMEPSForPort", userException);
        }
    }

    public sMIP[] getMIPSForPort() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sMIP[])this.mipConfig.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getMIPSForPort", userException);
        }
    }

    public boolean isNNI() throws NoSuchInterface, InvalidOperation {
        sBasicL2Info sBasicL2Info2 = this.getEtherBasicL2Info();
        return sBasicL2Info2.niMode == eNiValue.NNI_MODE;
    }

    public void removeSvlanFromQinQ(short s) throws ProvisionError, NoSuchInterface, WrongInterfaceType {
        sQinQInfo sQinQInfo2 = this.getQinQInfo();
        if (sQinQInfo2.qinqMode == eQinQMode.TRASPARENT_MODE) {
            if (sQinQInfo2.trasparentSvlanId == s) {
                if (this.db.on()) {
                    this.db.println("Removing QinQ transparent");
                }
                sQinQInfo2.qinqMode = eQinQMode.SELECTIVE_MODE;
                this.setQinQInfo(sQinQInfo2);
                if (this.db.on()) {
                    this.db.println("QinQ reset");
                }
            }
        } else {
            sVlanCrossInfoData[] sVlanCrossInfoDataArray = this.getVlanCrossInfoList();
            ArrayList<sVlanCrossInfoData> arrayList = new ArrayList<sVlanCrossInfoData>();
            for (int i = 0; i < sVlanCrossInfoDataArray.length; ++i) {
                if (sVlanCrossInfoDataArray[i].sVlan == s) continue;
                arrayList.add(sVlanCrossInfoDataArray[i]);
            }
            if (sVlanCrossInfoDataArray.length != arrayList.size()) {
                if (this.db.on()) {
                    this.db.println("Removing QinQ selective setting for SVLAN " + s);
                }
                sVlanCrossInfoData[] sVlanCrossInfoDataArray2 = arrayList.toArray(new sVlanCrossInfoData[0]);
                this.setVlanCrossInfoList(sVlanCrossInfoDataArray2);
                if (this.db.on()) {
                    this.db.println("QinQ setting removed");
                }
            } else if (this.db.on()) {
                this.db.println("No change in QinQ setting");
            }
        }
    }

    public int getCIR() throws NoSuchInterface, WrongInterfaceType, NotSupportedOnEquipment {
        XPL2LineModel xPL2LineModel = (XPL2LineModel)this.getLowerLayerModelsForNet()[0];
        return xPL2LineModel.getEtherL1Info().ingressQos.committedInfoRate;
    }

    @Override
    protected void updateLocal(long l) {
        this.etherBasicL2Info.update();
        this.egressQOS.update();
        this.egressQOSInfoTable.update();
        this.macAddrInfoTable.update();
        this.qInQInfo.update();
        this.vlanCrossInfoList.update();
        this.bridgePortState.update();
        this.actualBridgePortState.update();
        this.vlanListOnNNIPort.update();
        this.bpdu.update();
        this.efmConfig.update();
        this.efmLMConfig.update();
        this.efmState.update();
        this.efmLoopback.update();
        this.dscpCosInfo.update();
        this.cfmStat.update();
        this.stormControl.update();
        this.clearCrcAlarm.update();
        super.updateLocal(l);
    }

    @Override
    public void dispose() {
        this.etherBasicL2Info.dispose();
        this.egressQOS.dispose();
        this.egressQOSInfoTable.dispose();
        this.macAddrInfoTable.dispose();
        this.qInQInfo.dispose();
        this.vlanCrossInfoList.dispose();
        this.bridgePortState.dispose();
        this.actualBridgePortState.dispose();
        this.vlanListOnNNIPort.dispose();
        this.bpdu.dispose();
        this.efmConfig.dispose();
        this.efmLMConfig.dispose();
        this.efmState.dispose();
        this.efmLoopback.dispose();
        this.dscpCosInfo.dispose();
        this.cfmStat.dispose();
        this.stormControl.dispose();
        this.clearCrcAlarm.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public boolean isChannelGroup() {
        return false;
    }

    public boolean isTransparent() throws NoSuchInterface, WrongInterfaceType {
        return this.getQinQInfo().qinqMode == eQinQMode.TRASPARENT_MODE;
    }

    private class ActualBridgePortState
    extends NonCachedValue {
        public ActualBridgePortState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getActualBridgePortState(XPL2Layer2LineModel.this.getIndex());
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }
    }

    private class AisAction
    extends NonCachedValue {
        public AisAction(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            XPL2Layer2LineModel.this.getEtherL2Ref().setAISAction(XPL2Layer2LineModel.this.getIndex(), (eAISActionType)object);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getAISAction(XPL2Layer2LineModel.this.getIndex());
        }
    }

    private class Bpdu
    extends CachedValue {
        public Bpdu(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getBpdu(XPL2Layer2LineModel.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setBpdu(XPL2Layer2LineModel.this.getIndex(), (Boolean)object);
        }
    }

    private class BridgePortState
    extends CachedValue {
        public BridgePortState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setBridgePortState(XPL2Layer2LineModel.this.getIndex(), (eBridgePortState)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getBridgePortState(XPL2Layer2LineModel.this.getIndex());
        }

        @Override
        protected Object cloneValue() {
            eBridgePortState eBridgePortState2 = (eBridgePortState)this.value;
            eBridgePortState eBridgePortState3 = eBridgePortState.from_int(eBridgePortState2.value());
            return eBridgePortState3;
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }
    }

    private class CFMStat
    extends CachedValue {
        public CFMStat(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherEOAMRef().setCFMStatus(XPL2Layer2LineModel.this.getIndex(), (Boolean)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Boolean(XPL2Layer2LineModel.this.getEtherEOAMRef().getCFMStatus(XPL2Layer2LineModel.this.getIndex()));
        }

        @Override
        protected Object cloneValue() {
            Boolean bl = (Boolean)this.value;
            Boolean bl2 = new Boolean(bl);
            return bl2;
        }
    }

    private class ClearCrcAlarm
    extends CachedValue {
        public ClearCrcAlarm(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            if (this.node.getSwVersion().compareTo("09.21") > 0) {
                return XPL2Layer2LineModel.this.getEtherL2Ref().getCrcAlarmClear(XPL2Layer2LineModel.this.getIndex());
            }
            return false;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            if (this.node.getSwVersion().compareTo("09.21") > 0) {
                XPL2Layer2LineModel.this.getEtherL2Ref().setCrcAlarmClear(XPL2Layer2LineModel.this.getIndex(), (Boolean)object);
            }
        }
    }

    private class DscpCosInfo
    extends CachedValue {
        public DscpCosInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            XPL2Layer2LineModel.this.getEtherL2Ref().setDscpInfo(XPL2Layer2LineModel.this.getIndex(), (dscp2CosInfo)object);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getDscpInfo(XPL2Layer2LineModel.this.getIndex());
        }
    }

    private class EfmConfig
    extends CachedValue {
        public EfmConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            XPL2Layer2LineModel.this.getEtherEOAMRef().setEfmConfig(XPL2Layer2LineModel.this.getIndex(), (sEfmInfo)object);
        }

        @Override
        protected Object cloneValue() {
            sEfmInfo sEfmInfo2 = (sEfmInfo)this.value;
            sEfmInfo sEfmInfo3 = new sEfmInfo(sEfmInfo2.efmState, sEfmInfo2.efmOperMode, sEfmInfo2.linkFault, sEfmInfo2.sessionTimer);
            return sEfmInfo3;
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            return XPL2Layer2LineModel.this.getEtherEOAMRef().getEfmConfig(XPL2Layer2LineModel.this.getIndex());
        }
    }

    private class EfmLMConfig
    extends CachedValue {
        public EfmLMConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            XPL2Layer2LineModel.this.getEtherEOAMRef().setEfmLmConfig(XPL2Layer2LineModel.this.getIndex(), (sEfmLinkMonitorInfo)object);
        }

        @Override
        protected Object cloneValue() {
            sEfmLinkMonitorInfo sEfmLinkMonitorInfo2 = (sEfmLinkMonitorInfo)this.value;
            sEfmLinkMonitorInfo sEfmLinkMonitorInfo3 = new sEfmLinkMonitorInfo(new sEfmLinkMonitor(sEfmLinkMonitorInfo2.errFrame.action, sEfmLinkMonitorInfo2.errFrame.lowerThreshold, sEfmLinkMonitorInfo2.errFrame.upperThreshold, sEfmLinkMonitorInfo2.errFrame.window), new sEfmLinkMonitor(sEfmLinkMonitorInfo2.errPeriod.action, sEfmLinkMonitorInfo2.errPeriod.lowerThreshold, sEfmLinkMonitorInfo2.errPeriod.upperThreshold, sEfmLinkMonitorInfo2.errPeriod.window), new sEfmLinkMonitor(sEfmLinkMonitorInfo2.errFrameSecondSummary.action, sEfmLinkMonitorInfo2.errFrameSecondSummary.lowerThreshold, sEfmLinkMonitorInfo2.errFrameSecondSummary.upperThreshold, sEfmLinkMonitorInfo2.errFrameSecondSummary.window));
            return sEfmLinkMonitorInfo3;
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            return XPL2Layer2LineModel.this.getEtherEOAMRef().getEfmLmConfig(XPL2Layer2LineModel.this.getIndex());
        }
    }

    private class EfmLoopback
    extends CachedValue {
        public EfmLoopback(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            XPL2Layer2LineModel.this.getEtherEOAMRef().setEfmLoopback(XPL2Layer2LineModel.this.getIndex(), (eEfmLoopback)object);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            return XPL2Layer2LineModel.this.getEtherEOAMRef().getEfmLoopback(XPL2Layer2LineModel.this.getIndex());
        }
    }

    private class EfmState
    extends CachedValue {
        public EfmState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            return XPL2Layer2LineModel.this.getEtherEOAMRef().getEfmState(XPL2Layer2LineModel.this.getIndex());
        }
    }

    private class EgressQOS
    extends CachedValue {
        public EgressQOS(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setEgressQOSState(XPL2Layer2LineModel.this.getIndex(), (Boolean)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Boolean(XPL2Layer2LineModel.this.getEtherL2Ref().getEgressQOSState(XPL2Layer2LineModel.this.getIndex()));
        }

        @Override
        protected Object cloneValue() {
            Boolean bl = (Boolean)this.value;
            Boolean bl2 = new Boolean(bl);
            return bl2;
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }
    }

    private class EgressQOSInfo
    extends CachedValue {
        public EgressQOSInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setEgressInfo(XPL2Layer2LineModel.this.getIndex(), (sEgressInfo)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getEgressInfo(XPL2Layer2LineModel.this.getIndex());
        }

        @Override
        protected Object cloneValue() {
            sEgressInfo sEgressInfo2 = (sEgressInfo)this.value;
            sEgressInfo sEgressInfo3 = new sEgressInfo(sEgressInfo2.egressQOSState, sEgressInfo2.egressQOSInfoTable, sEgressInfo2.policyId);
            return sEgressInfo3;
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }
    }

    private class EtherBasicL2Info
    extends CachedValue {
        public EtherBasicL2Info(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setBasicL2Info(XPL2Layer2LineModel.this.getIndex(), (sBasicL2Info)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getBasicL2Info(XPL2Layer2LineModel.this.getIndex());
        }

        @Override
        protected Object cloneValue() {
            sBasicL2Info sBasicL2Info2 = (sBasicL2Info)this.value;
            sBasicL2Info sBasicL2Info3 = new sBasicL2Info(sBasicL2Info2.macLearningState, sBasicL2Info2.niMode, sBasicL2Info2.sIngressCOS, sBasicL2Info2.cEtherType, sBasicL2Info2.sEtherType, sBasicL2Info2.policyId);
            return sBasicL2Info3;
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }
    }

    private class IgmpMrouter
    extends NonCachedValue {
        public IgmpMrouter(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            XPL2Layer2LineModel.this.getEtherL2Ref().setIGMPMrouter(XPL2Layer2LineModel.this.getIndex(), (eMRouter)object);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getIGMPMRouter(XPL2Layer2LineModel.this.getIndex());
        }
    }

    private class MEPConfig
    extends NonCachedValue {
        public MEPConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            if (((String)objectArray[0]).equalsIgnoreCase("createMEP")) {
                XPL2Layer2LineModel.this.getEtherEOAMRef().createMEP((sMEP)objectArray[1]);
            } else if (((String)objectArray[0]).equalsIgnoreCase("removeMEP")) {
                XPL2Layer2LineModel.this.getEtherEOAMRef().removeMEP((sMEP)objectArray[1]);
            }
        }
    }

    private class MIPConfig
    extends NonCachedValue {
        public MIPConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            if (((String)objectArray[0]).equalsIgnoreCase("createMIP")) {
                XPL2Layer2LineModel.this.getEtherEOAMRef().createMIP((sMIP)objectArray[1]);
            } else if (((String)objectArray[0]).equalsIgnoreCase("modifyMIP")) {
                XPL2Layer2LineModel.this.getEtherEOAMRef().modifyMIP((sMIP)objectArray[1]);
            } else if (((String)objectArray[0]).equalsIgnoreCase("removeMIP")) {
                XPL2Layer2LineModel.this.getEtherEOAMRef().removeMIP((sMIP)objectArray[1]);
            }
        }
    }

    private class MacAddrInfo
    extends CachedValue {
        public MacAddrInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setMacInfo(XPL2Layer2LineModel.this.getIndex(), (sMacInfo)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getMacInfo(XPL2Layer2LineModel.this.getIndex());
        }

        @Override
        protected Object cloneValue() {
            sMacInfo sMacInfo2 = (sMacInfo)this.value;
            sMacInfo sMacInfo3 = new sMacInfo(sMacInfo2.macAddrFilterMode, sMacInfo2.macAddrFilterTable);
            return sMacInfo3;
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }
    }

    private class ProtectionAction
    extends NonCachedValue {
        public ProtectionAction(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            XPL2Layer2LineModel.this.getEtherL2Ref().setProtAction(XPL2Layer2LineModel.this.getIndex(), (eProtActionType)object);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getProtAction(XPL2Layer2LineModel.this.getIndex());
        }
    }

    private class QinQInfo
    extends CachedValue {
        public QinQInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getQinQInfo(XPL2Layer2LineModel.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xNoSuchInterface, xProvisionError {
            XPL2Layer2LineModel.this.getEtherL2Ref().setQinQInfo(XPL2Layer2LineModel.this.getIndex(), (sQinQInfo)object);
        }

        @Override
        protected Object cloneValue() {
            sQinQInfo sQinQInfo2 = (sQinQInfo)this.value;
            sQinQInfo sQinQInfo3 = new sQinQInfo(sQinQInfo2.qinqMode, sQinQInfo2.trasparentSvlanId, sQinQInfo2.igmpCvlan);
            return sQinQInfo3;
        }
    }

    private class REPPortConfig
    extends NonCachedValue {
        public REPPortConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setRepConfig(XPL2Layer2LineModel.this.getIndex(), (sRepPortConfig)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getRepConfig(XPL2Layer2LineModel.this.getIndex());
        }

        @Override
        protected void setValue() throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().removeRepConfig(XPL2Layer2LineModel.this.getIndex());
        }
    }

    private class REPPreemptDelay
    extends NonCachedValue {
        public REPPreemptDelay(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            XPL2Layer2LineModel.this.getEtherL2Ref().setRepVlbPreemptDelay(XPL2Layer2LineModel.this.getIndex(), (Integer)object);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            return new Integer(XPL2Layer2LineModel.this.getEtherL2Ref().getRepVlbPreemptDelay(XPL2Layer2LineModel.this.getIndex()));
        }
    }

    private class REPStcnConfig
    extends NonCachedValue {
        public REPStcnConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setRepStcnConfig(XPL2Layer2LineModel.this.getIndex(), (sRepStcnConfig)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getRepStcnConfig(XPL2Layer2LineModel.this.getIndex());
        }
    }

    private class REPVlbConfig
    extends NonCachedValue {
        public REPVlbConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object outer() {
            return XPL2Layer2LineModel.this;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setRepVlbConfig(XPL2Layer2LineModel.this.getIndex(), (sRepVlbConfig)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getRepVlbConfig(XPL2Layer2LineModel.this.getIndex());
        }
    }

    private class StormControl
    extends CachedValue {
        public StormControl(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xProvisionError {
            XPL2Layer2LineModel.this.getEtherL2Ref().setStormControlInfo(XPL2Layer2LineModel.this.getIndex(), (sStormControlInfo)object);
        }

        @Override
        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getStormControlInfo(XPL2Layer2LineModel.this.getIndex());
        }

        @Override
        protected Object cloneValue() {
            sStormControlInfo sStormControlInfo2 = (sStormControlInfo)this.value;
            sStormControlInfo sStormControlInfo3 = new sStormControlInfo(new sStormControlConfig(sStormControlInfo2.bcast.status, sStormControlInfo2.bcast.threshold), new sStormControlConfig(sStormControlInfo2.mcast.status, sStormControlInfo2.mcast.threshold), new sStormControlConfig(sStormControlInfo2.dlfbc.status, sStormControlInfo2.dlfbc.threshold));
            return sStormControlInfo3;
        }
    }

    private class TriggerVLB
    extends NonCachedValue {
        public TriggerVLB(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            XPL2Layer2LineModel.this.getEtherL2Ref().triggerVLB(XPL2Layer2LineModel.this.getIndex(), (eRepVlbOperation)object);
        }
    }

    private class VlanCrossInfoList
    extends CachedValue {
        public VlanCrossInfoList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getSelectiveQinQInfoData(XPL2Layer2LineModel.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws UserException {
            XPL2Layer2LineModel.this.getEtherL2Ref().setSelectiveQinQInfoData(XPL2Layer2LineModel.this.getIndex(), (sVlanCrossInfoData[])object);
        }
    }

    private class VlanListOnNNIPort
    extends CachedValue {
        public VlanListOnNNIPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return XPL2Layer2LineModel.this.getEtherL2Ref().getVlanListOnNNIPort(XPL2Layer2LineModel.this.getIndex());
        }
    }
}

