/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.SonetTopology.YCable;
import cerent.cms.idl.SonetTopology.YCableHelper;
import cerent.cms.idl.SonetTopology.eElementType;
import cerent.cms.idl.SonetTopology.eProtectionOp;
import cerent.cms.idl.SonetTopology.sYCableItem;
import cerent.cms.idl.SonetTopology.sYCableProvision;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.idl.SonetTopology.xInvalidProtectionOp;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IProtectedModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.IYCableModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PoolModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.model.UserValue;
import cerent.util.EnumStrings;
import org.omg.CORBA.UserException;

public class YCableModel
extends ElementModel
implements IProtectedModel,
IYCableModel {
    private ProtectionOp protectionOp;
    private Provision provision;
    private Reversion reversion;
    private Bidirectional bidirectional;
    private Delete delete;
    private YCable yCableRef = null;
    private ProtectEntityType protectEntityType;
    private MainEntityType mainEntityType;
    private String myString;

    public YCableModel(NodeModelDelegate nodeModelDelegate, int n, sYCableItem sYCableItem2) {
        super(nodeModelDelegate, n, sYCableItem2.element, nodeModelDelegate.getChildDebug(YCableModel.class));
        this.localInit();
        this.setAttributes(sYCableItem2);
        this.myString = null;
    }

    private void localInit() {
        NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
        this.provision = new Provision(nodeModelDelegate, "YCableModel.provision");
        this.protectionOp = new ProtectionOp(nodeModelDelegate, "YCableModel.protectionOp");
        this.reversion = new Reversion(nodeModelDelegate, "YCableModel.reversion");
        this.bidirectional = new Bidirectional(nodeModelDelegate, "YCableModel.bidirectional");
        this.delete = new Delete(nodeModelDelegate, "YCableModel.delete");
        this.protectEntityType = new ProtectEntityType(nodeModelDelegate, "YCableModel.protectEntityType");
        this.mainEntityType = new MainEntityType(nodeModelDelegate, "YCableModel.mainEntityType");
    }

    @Override
    public void init() {
        super.init();
        this.setIndex(this.getMainEntityIndex());
    }

    private YCable getYCableRef() {
        if (this.yCableRef == null) {
            this.yCableRef = YCableHelper.narrow(this.getElementRef());
        }
        return this.yCableRef;
    }

    public void setAttributes(sYCableItem sYCableItem2) {
        super.setAttributes(sYCableItem2.elementData);
        this.provision.setValueExternally(sYCableItem2.provision);
    }

    @Override
    boolean referencesEntityIndex(int n) {
        return n == this.getMainEntityIndex() || n == this.getProtectEntityIndex();
    }

    @Override
    int[] getIndices() {
        return new int[]{this.getMainEntityIndex(), this.getProtectEntityIndex()};
    }

    @Override
    public boolean supportsLockoutOfWorking() {
        return true;
    }

    @Override
    public eProtectionOp getProtectionOp() throws AbstractCmsIOException {
        try {
            return (eProtectionOp)this.protectionOp.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getProtectionOp", userException);
        }
    }

    @Override
    public int getProtection() {
        return this.getProtectionOp().value();
    }

    @Override
    public void setProtectionOp(eProtectionOp eProtectionOp2) throws InvalidProtectionOp, InternalCommError {
        try {
            this.protectionOp.set(eProtectionOp2);
        }
        catch (xInvalidProtectionOp xInvalidProtectionOp2) {
            throw new InvalidProtectionOp((UserException)xInvalidProtectionOp2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setProtectionOp", userException);
        }
    }

    @Override
    public void setProtection(int n) throws InvalidProtectionOp, InternalCommError {
        this.setProtectionOp(eProtectionOp.from_int(n));
    }

    public sYCableProvision getProvision() {
        try {
            return (sYCableProvision)this.provision.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getProvision", userException);
        }
    }

    @Override
    public int getProtectEntityIndex() {
        return this.getProvision().protect;
    }

    @Override
    public int getMainEntityIndex() throws AbstractCmsIOException {
        return this.getProvision().main;
    }

    @Override
    public IEntityModel getProtectEntityModel() throws AbstractCmsNoSuchEntityException {
        return this.node.getEntityTableModel().getEntityModelByIndex(this.getProtectEntityIndex());
    }

    @Override
    public IEntityModel getMainEntityModel() throws AbstractCmsNoSuchEntityException {
        return this.node.getEntityTableModel().getEntityModelByIndex(this.getMainEntityIndex());
    }

    public IRevertiveBehavior getReversion() {
        return RevertiveBehaviorFactory.getIRevertiveBehavior(this.getProvision().reversion);
    }

    public void setReversion1(RevertiveBehavior revertiveBehavior) {
        this.setReversion(revertiveBehavior);
    }

    public void setReversion(IRevertiveBehavior iRevertiveBehavior) {
        try {
            this.reversion.set(RevertiveBehaviorFactory.getRevertiveBehavior(iRevertiveBehavior));
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setReversion", userException);
        }
    }

    public boolean isBidirectional() {
        return this.getProvision().bidirectional;
    }

    public void setBidirectional(boolean bl) throws ProvisionError {
        try {
            this.bidirectional.set(new Boolean(bl));
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setBidirectional", userException);
        }
    }

    public int getWorkingEntityIndex() {
        return this.getMainEntityIndex();
    }

    public void setForceSwitchToWorking() throws InvalidProtectionOp, InternalCommError {
        this.setProtectionOp(eProtectionOp.FORCE_SWITCH_TO_WORKING);
    }

    public void setForceSwitchToProtect() throws InvalidProtectionOp, InternalCommError {
        this.setProtectionOp(eProtectionOp.FORCE_SWITCH_TO_PROTECT);
    }

    public void setClear() throws InvalidProtectionOp, InternalCommError {
        this.setProtectionOp(eProtectionOp.CLEAR);
    }

    public boolean isClear() {
        return this.getProtectionOp() == eProtectionOp.CLEAR;
    }

    @Override
    protected IPoolModel getPoolModel(int n) {
        return null;
    }

    @Override
    protected boolean containsPool(PoolModel poolModel) {
        return false;
    }

    public void delete() throws Busy, EMCProvisionError {
        try {
            this.delete.set();
        }
        catch (xBusy xBusy2) {
            String string = xBusy2.getMessage();
            string = string + "\nYCableModel.delete(); The Topology Element is in use,\nand can't be deleted as requested (#" + Integer.toHexString(this.getIndex()) + ").";
            if (this.db.on()) {
                this.db.println(this.node.dbName() + string);
            }
            throw new Busy((UserException)xBusy2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "delete", userException);
        }
    }

    @Override
    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println(this.node.dbName() + "updateLocal(): entry");
        }
        this.protectionOp.update();
        this.provision.update();
        this.setChanged();
        super.updateLocal();
        if (this.db.on()) {
            this.db.println(this.node.dbName() + "updateLocal(): exit");
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println(this.node.dbName() + "dispose(): entry");
        }
        this.protectionOp.dispose();
        this.provision.dispose();
        this.myString = null;
        super.dispose();
        if (this.db.on()) {
            this.db.println(this.node.dbName() + "dispose(): exit");
        }
    }

    @Override
    public String toString() {
        if (this.myString == null) {
            try {
                this.myString = "YCable[" + this.node.dbName() + " " + this.getName() + "/p" + Integer.toHexString(this.getProtectEntityIndex()) + "+m" + Integer.toHexString(this.getMainEntityIndex()) + "/" + EnumStrings.getStrings(eElementType.class)[this.getType()] + "]";
            }
            catch (Exception exception) {
                return "YCable[deleted/inaccessible]";
            }
        }
        return this.myString;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof YCableModel)) {
            return false;
        }
        return super.equals(object);
    }

    class Bidirectional
    extends NonCachedValue {
        public Bidirectional(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xProvisionError {
            YCableModel.this.getYCableRef().setBidirectional((Boolean)object);
        }

        public Object outer() {
            return YCableModel.this;
        }
    }

    class Delete
    extends NonCachedValue {
        public Delete(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue() throws xBusy, xProvisionError {
            YCableModel.this.getYCableRef().destroy();
        }

        public Object outer() {
            return YCableModel.this;
        }
    }

    class MainEntityType
    extends UserValue {
        public MainEntityType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        public Object get() throws CTCUserException {
            if (YCableModel.this.db.on()) {
                YCableModel.this.db.println(this.getClass().getName() + " Inside get()");
            }
            try {
                return YCableModel.this.getMainEntityModel().getEqTypeName();
            }
            catch (Exception exception) {
                throw new CTCUserException("The main entity type cannot be retrieved.\n" + exception.getMessage());
            }
        }

        public Object outer() {
            return YCableModel.this;
        }
    }

    class ProtectEntityType
    extends UserValue {
        public ProtectEntityType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        public Object get() throws CTCUserException {
            if (YCableModel.this.db.on()) {
                YCableModel.this.db.println(this.getClass().getName() + " Inside get()");
            }
            try {
                return YCableModel.this.getProtectEntityModel().getEqTypeName();
            }
            catch (Exception exception) {
                throw new CTCUserException("The protect entity type cannot be retrieved.\n" + exception.getMessage());
            }
        }

        public Object outer() {
            return YCableModel.this;
        }
    }

    class ProtectionOp
    extends CachedValue {
        public ProtectionOp(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xInvalidProtectionOp, xInternalCommError {
            YCableModel.this.getYCableRef().setProtectionOp((eProtectionOp)object);
        }

        @Override
        protected Object getValue() {
            return YCableModel.this.getYCableRef().protectionOp();
        }

        public Object outer() {
            return YCableModel.this;
        }
    }

    class Provision
    extends CachedValue {
        public Provision(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() {
            return YCableModel.this.getYCableRef().provision();
        }

        @Override
        protected Object cloneValue() {
            sYCableProvision sYCableProvision2 = (sYCableProvision)this.value;
            sRevertiveBehavior sRevertiveBehavior2 = new sRevertiveBehavior(sYCableProvision2.reversion.reversionMode, sYCableProvision2.reversion.reversionTime);
            sYCableProvision sYCableProvision3 = new sYCableProvision(sYCableProvision2.main, sYCableProvision2.protect, sRevertiveBehavior2, sYCableProvision2.bidirectional);
            return sYCableProvision3;
        }

        public Object outer() {
            return YCableModel.this;
        }
    }

    class Reversion
    extends NonCachedValue {
        public Reversion(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) {
            YCableModel.this.getYCableRef().setReversion((sRevertiveBehavior)object);
        }

        public Object outer() {
            return YCableModel.this;
        }
    }
}

